/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.geotiff;

import com.vividsolutions.jump.JUMPException;
import com.vividsolutions.jump.workbench.imagery.ReferencedImage;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageException;
import com.vividsolutions.jump.workbench.imagery.geoimg.GeoImage;
import com.vividsolutions.jump.workbench.imagery.geotiff.GeoTIFFRaster;
import org.locationtech.jts.geom.Envelope;

public class GeoTIFFImage
extends GeoImage
implements ReferencedImage {
    private GeoTIFFRaster gtr;

    public GeoTIFFImage(String location) throws JUMPException {
        super(location, null);
        this.init(location);
    }

    @Override
    public Envelope getEnvelope() {
        return this.gtr.getEnvelope();
    }

    private void init(String location) throws JUMPException {
        try {
            this.gtr = new GeoTIFFRaster(location);
            this.gtr.src.getData();
        }
        catch (Exception e) {
            this.gtr = null;
            throw new ReferencedImageException(e);
        }
    }

    @Override
    public String getType() {
        return "GeoTiff";
    }

    @Override
    public String getLoader() {
        return "JAI XTIFF";
    }
}

