/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.geotiff;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.SeekableStream;
import com.vividsolutions.jump.io.CompressedFile;
import com.vividsolutions.jump.util.FileUtil;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.renderable.ParameterBlock;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public abstract class GeoReferencedRaster {
    protected String imageFileLocation;
    protected RenderedOp src = null;
    Envelope envModel_image;
    double[] min;
    double[] max;
    Coordinate coorRasterTiff_tiepointLT;
    Coordinate coorModel_tiepointLT;
    private double dblModelUnitsPerRasterUnit_X;
    private double dblModelUnitsPerRasterUnit_Y;

    public GeoReferencedRaster(String imageFileLocation) throws Exception {
        this.imageFileLocation = imageFileLocation;
    }

    protected void fetchRaster() throws Exception {
        URI uri = new URI(this.imageFileLocation);
        this.createJAIRenderedOP(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createJAIRenderedOP(URI uri) throws IOException {
        SeekableStream is = SeekableStream.wrapInputStream((InputStream)CompressedFile.openFile(uri), (boolean)true);
        String[] decs = ImageCodec.getDecoderNames((SeekableStream)is);
        FileUtil.close((Closeable)is);
        ArrayList<ImageCodec> removed_codecs = new ArrayList<ImageCodec>();
        try {
            if (Arrays.asList(decs).contains("xtiff")) {
                for (String name : decs) {
                    ImageCodec candidate_codec = ImageCodec.getCodec((String)name);
                    if (name == "xtiff") continue;
                    ImageCodec.unregisterCodec((String)name);
                    removed_codecs.add(candidate_codec);
                }
            }
            SeekableStream is2 = SeekableStream.wrapInputStream((InputStream)CompressedFile.openFile(uri), (boolean)true);
            decs = ImageCodec.getDecoderNames((SeekableStream)is2);
            FileUtil.close((Closeable)is2);
            if (CompressedFile.isArchive(uri) || CompressedFile.isCompressed(uri)) {
                InputStream input = CompressedFile.openFile(uri);
                if (!(input instanceof SeekableStream)) {
                    input = SeekableStream.wrapInputStream((InputStream)input, (boolean)true);
                }
                this.src = JAI.create((String)"stream", (Object)input);
            } else {
                this.src = JAI.create((String)"fileload", (Object)uri.getPath());
            }
        }
        finally {
            for (ImageCodec imageCodec : removed_codecs) {
                ImageCodec.registerCodec((ImageCodec)imageCodec);
            }
        }
    }

    protected void readRasterfile() throws Exception {
        this.fetchRaster();
        this.normalize(this.src);
    }

    private Coordinate rasterToModelSpace(Coordinate coorRaster) {
        Coordinate coorModel = new Coordinate();
        coorModel.x = this.coorModel_tiepointLT.x + (coorRaster.x - this.coorRasterTiff_tiepointLT.x) * this.dblModelUnitsPerRasterUnit_X;
        coorModel.y = this.coorModel_tiepointLT.y - (coorRaster.y + this.coorRasterTiff_tiepointLT.y) * this.dblModelUnitsPerRasterUnit_Y;
        coorModel.z = 0.0;
        return coorModel;
    }

    protected void normalize(RenderedOp image) {
    }

    public Coordinate getCoorModel_tiepointLT() {
        return this.coorModel_tiepointLT;
    }

    public Coordinate getCoorRasterTiff_tiepointLT() {
        return this.coorRasterTiff_tiepointLT;
    }

    public double getDblModelUnitsPerRasterUnit_X() {
        return this.dblModelUnitsPerRasterUnit_X;
    }

    public double getDblModelUnitsPerRasterUnit_Y() {
        return this.dblModelUnitsPerRasterUnit_Y;
    }

    public RenderedOp getImage() throws Exception {
        if (this.src == null) {
            this.readRasterfile();
        }
        return this.src;
    }

    void setEnvelope() {
        Coordinate coorRaster_imageLB = new Coordinate(this.coorRasterTiff_tiepointLT.x - 0.5, (double)this.src.getHeight() - 0.5);
        Coordinate coorRaster_imageRT = new Coordinate((double)this.src.getWidth() - 0.5, -0.5);
        Coordinate coorModel_imageLB = this.rasterToModelSpace(coorRaster_imageLB);
        Coordinate coorModel_imageRT = this.rasterToModelSpace(coorRaster_imageRT);
        this.envModel_image = new Envelope(coorModel_imageLB, coorModel_imageRT);
    }

    public void setCoorModel_tiepointLT(Coordinate coordinate) {
        this.coorModel_tiepointLT = coordinate;
        this.setEnvelope();
    }

    public void setCoorRasterTiff_tiepointLT(Coordinate coordinate) {
        this.coorRasterTiff_tiepointLT = coordinate;
    }

    public void setDblModelUnitsPerRasterUnit_X(double d) {
        this.dblModelUnitsPerRasterUnit_X = d;
    }

    public void setDblModelUnitsPerRasterUnit_Y(double d) {
        this.dblModelUnitsPerRasterUnit_Y = d;
        this.setEnvelope();
    }

    public void setAffineTransformation(AffineTransform transform) {
        double scaleX = Math.abs(transform.getScaleX());
        double scaleY = Math.abs(transform.getScaleY());
        this.setDblModelUnitsPerRasterUnit_X(scaleX);
        this.setDblModelUnitsPerRasterUnit_Y(scaleY);
        Point2D.Double rasterLT = new Point2D.Double(this.src.getMinX(), this.src.getMinY());
        Point2D.Double modelLT = new Point2D.Double();
        transform.transform(rasterLT, modelLT);
        this.setCoorRasterTiff_tiepointLT(new Coordinate(((Point2D)rasterLT).getX(), ((Point2D)rasterLT).getY()));
        this.setCoorModel_tiepointLT(new Coordinate(((Point2D)modelLT).getX(), ((Point2D)modelLT).getY()));
    }

    public RenderedOp fullContrast() {
        int bands = this.src.getNumBands();
        double[] constants = new double[bands];
        double[] offsets = new double[bands];
        for (int i = 0; i < bands; ++i) {
            constants[i] = 306.0 / (this.max[i] - this.min[i]);
            offsets[i] = 255.0 * this.min[i] / (this.min[i] - this.max[i]);
        }
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(this.src);
        pb.add(constants);
        pb.add(offsets);
        return JAI.create((String)"rescale", (ParameterBlock)pb, null);
    }

    public Envelope getEnvelope() {
        return this.envModel_image;
    }

    public double[] getMinimumExtreme() {
        return this.min;
    }

    public double[] getMaximumExtreme() {
        return this.max;
    }
}

