/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench;

import com.vividsolutions.jump.workbench.WorkbenchProperties;
import com.vividsolutions.jump.workbench.ui.ErrorHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class WorkbenchPropertiesFile
implements WorkbenchProperties {
    private ErrorHandler errorHandler;
    private List<File> propertyFiles;
    private HashMap<String, HashMap<String, HashMap<String, Object>>> properties = new HashMap();

    public WorkbenchPropertiesFile(File file, ErrorHandler errorHandler) throws JDOMException, IOException {
        this(Arrays.asList(file), errorHandler);
    }

    public WorkbenchPropertiesFile(List<File> files, ErrorHandler errorHandler) throws JDOMException, IOException {
        this.propertyFiles = Collections.unmodifiableList(files);
        this.errorHandler = errorHandler;
        this.init();
    }

    private void init() {
        SAXBuilder builder = new SAXBuilder();
        this.properties = new LinkedHashMap<String, HashMap<String, HashMap<String, Object>>>();
        for (File file : this.propertyFiles) {
            Document document;
            try {
                document = builder.build(file);
            }
            catch (JDOMException e) {
                this.errorHandler.handleThrowable(e);
                continue;
            }
            catch (IOException e) {
                this.errorHandler.handleThrowable(e);
                continue;
            }
            Element root = document.getRootElement();
            if (root == null) continue;
            this.xmlAddToMap(root, this.properties, -1);
        }
    }

    private Integer xmlAddToMap(Element root_element, HashMap map, Integer i) {
        for (Element element : root_element.getChildren()) {
            Object existingEntry;
            boolean isList;
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
            String elementName = element.getName();
            String elementValue = element.getTextTrim();
            LinkedHashMap<String, String> elementAttribs = new LinkedHashMap<String, String>();
            List xmlAttribs = element.getAttributes();
            for (Attribute xmlAttrib : xmlAttribs) {
                elementAttribs.put(xmlAttrib.getName(), xmlAttrib.getValue());
            }
            int order_id = i;
            if (element.getChildren().size() > 0) {
                i = this.xmlAddToMap(element, elementAttribs, i);
            }
            boolean bl = isList = map.containsKey("type") && map.get("type").toString().toLowerCase().equals("list");
            if (isList) {
                ArrayList<String> existingList;
                Object existingEntry2 = map.get("list");
                if (existingEntry2 instanceof List) {
                    existingList = (ArrayList<String>)existingEntry2;
                } else {
                    existingList = new ArrayList<String>();
                    map.put("list", existingList);
                }
                existingList.add(!elementValue.isEmpty() ? elementValue : elementName);
                continue;
            }
            String key = "";
            if (!elementValue.isEmpty()) {
                key = elementValue;
            } else if (elementAttribs.containsKey("id")) {
                key = ((HashMap)elementAttribs).get("id").toString();
            } else if (elementName.equals("separator")) {
                Object sepMap = map.get(elementName);
                int id = sepMap instanceof Map ? ((Map)sepMap).size() : 0;
                key = Integer.toString(id);
            }
            if (!elementAttribs.containsKey("order_id")) {
                elementAttribs.put("order_id", Integer.toString(order_id));
            }
            if ((existingEntry = map.get(elementName)) instanceof Map) {
                LinkedHashMap existingEntryMap;
                LinkedHashMap map2fill = existingEntryMap = (LinkedHashMap)existingEntry;
                if (!key.isEmpty()) {
                    Object existingSubEntry = existingEntryMap.get(key);
                    if (existingSubEntry instanceof Map) {
                        map2fill = (Map)existingSubEntry;
                    } else {
                        map2fill = new LinkedHashMap();
                        existingEntryMap.put(key, map2fill);
                    }
                }
                map2fill = this.mergeMapsRecursively(map2fill, elementAttribs);
                continue;
            }
            if (key.isEmpty()) {
                map.put(elementName, elementAttribs);
                continue;
            }
            LinkedHashMap<String, LinkedHashMap<String, String>> map2fill = new LinkedHashMap<String, LinkedHashMap<String, String>>();
            map2fill.put(key, elementAttribs);
            map.put(elementName, map2fill);
        }
        return i;
    }

    private Map mergeMapsRecursively(Map map1, Map map2) {
        HashSet keySet = new HashSet(map1.keySet());
        keySet.addAll(map2.keySet());
        for (Object key : keySet) {
            Object val1 = map1.get(key);
            Object val2 = map2.get(key);
            if (val1 instanceof Map && val2 instanceof Map) {
                this.mergeMapsRecursively((Map)val1, (Map)val2);
                continue;
            }
            if (val1 != null && val2 != null) {
                if (key.equals("order_id")) continue;
                map1.put(key, val1 + ";" + val2);
                continue;
            }
            if (val1 != null) continue;
            map1.put(key, val2);
        }
        return map1;
    }

    @Override
    public List getSettingsList(String[] keys) {
        Object settings = this.getRawSetting(keys);
        return settings instanceof List ? (List)settings : new ArrayList();
    }

    @Override
    public Map getSettings(String[] keys) {
        Object settings = this.getRawSetting(keys);
        return settings instanceof Map ? (Map)settings : new HashMap();
    }

    @Override
    public String getSetting(String[] keys) {
        Object value = this.getRawSetting(keys);
        return value != null ? value.toString() : "";
    }

    private Object getRawSetting(String[] keys) {
        HashMap<String, HashMap<String, HashMap<String, Object>>> map = this.properties;
        for (String key : keys) {
            if (!(map instanceof Map)) {
                return null;
            }
            map = ((Map)map).get(key);
        }
        if (map instanceof LinkedHashMap) {
            return ((LinkedHashMap)map).clone();
        }
        return map;
    }

    private List<Class> getClasses(String key) throws ClassNotFoundException {
        ArrayList<Class> clazzes = new ArrayList<Class>();
        for (String className : this.getClassNames(key)) {
            clazzes.add(Class.forName(className));
        }
        return clazzes;
    }

    private List<String> getClassNames(String key) {
        return this.getIds(key);
    }

    private List<String> getIds(String key) {
        HashMap<String, HashMap<String, Object>> settings = this.properties.get(key);
        if (settings == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> classNames = new ArrayList<String>(settings.keySet());
        return Collections.unmodifiableList(classNames);
    }

    @Override
    public List<String> getPlugInClassNames() {
        return this.getClassNames("plug-in");
    }

    @Override
    public List<String> getConfigurationClassNames() {
        return this.getClassNames("extension");
    }

    @Override
    @Deprecated
    public List getInputDriverClasses() throws ClassNotFoundException {
        return this.getClasses("input-driver");
    }

    @Override
    @Deprecated
    public List getOutputDriverClasses() throws ClassNotFoundException {
        return this.getClasses("output-driver");
    }

    @Override
    @Deprecated
    public List getConfigurationClasses() throws ClassNotFoundException {
        return this.getClasses("extension");
    }

    public String toString() {
        return this.properties instanceof Map ? this.properties.toString() : "{no properties set}";
    }
}

