/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util.java2xml;

import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.util.LangUtil;
import com.vividsolutions.jump.util.StringUtil;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.util.Assert;

public class XMLBinder {
    private static final WKTReader WKT_READER = new WKTReader();
    private static final WKTWriter WKT_WRITER = new WKTWriter();
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private final HashMap<Class<?>, CustomConverter> classToCustomConverterMap = new HashMap();

    public XMLBinder() {
        this.classToCustomConverterMap.put(Class.class, new CustomConverter(){

            @Override
            public Object toJava(String value) {
                try {
                    return Class.forName(value);
                }
                catch (ClassNotFoundException e) {
                    Assert.shouldNeverReachHere();
                    return null;
                }
            }

            @Override
            public String toXML(Object object) {
                return ((Class)object).getName();
            }
        });
        this.classToCustomConverterMap.put(Color.class, new CustomConverter(){

            @Override
            public Object toJava(String value) {
                List<String> parameters = StringUtil.fromCommaDelimitedString(value);
                return new Color(Integer.parseInt(parameters.get(0)), Integer.parseInt(parameters.get(1)), Integer.parseInt(parameters.get(2)), Integer.parseInt(parameters.get(3)));
            }

            @Override
            public String toXML(Object object) {
                Color color = (Color)object;
                ArrayList<Integer> parameters = new ArrayList<Integer>();
                parameters.add(color.getRed());
                parameters.add(color.getGreen());
                parameters.add(color.getBlue());
                parameters.add(color.getAlpha());
                return StringUtil.toCommaDelimitedString(parameters);
            }
        });
        this.classToCustomConverterMap.put(Font.class, new CustomConverter(){

            @Override
            public Object toJava(String value) {
                List<String> parameters = StringUtil.fromCommaDelimitedString(value);
                return new Font(parameters.get(0), Integer.parseInt(parameters.get(1)), Integer.parseInt(parameters.get(2)));
            }

            @Override
            public String toXML(Object object) {
                Font font = (Font)object;
                ArrayList<Object> parameters = new ArrayList<Object>();
                parameters.add(font.getName());
                parameters.add(font.getStyle());
                parameters.add(font.getSize());
                return StringUtil.toCommaDelimitedString(parameters);
            }
        });
        this.classToCustomConverterMap.put(Double.TYPE, new CustomConverter(){

            @Override
            public Object toJava(String value) {
                return new Double(value);
            }

            @Override
            public String toXML(Object object) {
                return object.toString();
            }
        });
        this.classToCustomConverterMap.put(Double.class, new CustomConverter(){

            @Override
            public Object toJava(String value) {
                return new Double(value);
            }

            @Override
            public String toXML(Object object) {
                return object.toString();
            }
        });
        this.classToCustomConverterMap.put(Integer.TYPE, new CustomConverter(){

            @Override
            public Object toJava(String value) {
                return new Integer(value);
            }

            @Override
            public String toXML(Object object) {
                return object.toString();
            }
        });
        this.classToCustomConverterMap.put(Integer.class, new CustomConverter(){

            @Override
            public Object toJava(String value) {
                return new Integer(value);
            }

            @Override
            public String toXML(Object object) {
                return object.toString();
            }
        });
        this.classToCustomConverterMap.put(Long.class, new CustomConverter(){

            @Override
            public Object toJava(String value) {
                return new Long(value);
            }

            @Override
            public String toXML(Object object) {
                return object.toString();
            }
        });
        this.classToCustomConverterMap.put(String.class, new CustomConverter(){

            @Override
            public Object toJava(String value) {
                return value;
            }

            @Override
            public String toXML(Object object) {
                return object.toString();
            }
        });
        this.classToCustomConverterMap.put(Boolean.TYPE, new CustomConverter(){

            @Override
            public Object toJava(String value) {
                return Boolean.parseBoolean(value);
            }

            @Override
            public String toXML(Object object) {
                return object.toString();
            }
        });
        this.classToCustomConverterMap.put(Date.class, new CustomConverter(){

            @Override
            public Object toJava(String value) {
                try {
                    return DATE_FORMAT.parse(value);
                }
                catch (java.text.ParseException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            @Override
            public String toXML(Object object) {
                return DATE_FORMAT.format((Date)object);
            }
        });
        this.classToCustomConverterMap.put(Boolean.class, new CustomConverter(){

            @Override
            public Object toJava(String value) {
                return Boolean.parseBoolean(value);
            }

            @Override
            public String toXML(Object object) {
                return object.toString();
            }
        });
        this.classToCustomConverterMap.put(File.class, new CustomConverter(){

            @Override
            public Object toJava(String value) {
                return new File(value);
            }

            @Override
            public String toXML(Object object) {
                return object.toString();
            }
        });
        this.classToCustomConverterMap.put(Character.TYPE, new CustomConverter(){

            @Override
            public Object toJava(String value) {
                return Character.valueOf(value.length() > 0 ? value.charAt(0) : (char)'\u0000');
            }

            @Override
            public String toXML(Object object) {
                return object.toString();
            }
        });
        this.classToCustomConverterMap.put(Character.class, new CustomConverter(){

            @Override
            public Object toJava(String value) {
                return Character.valueOf(value.length() > 0 ? value.charAt(0) : (char)'\u0000');
            }

            @Override
            public String toXML(Object object) {
                return object.toString();
            }
        });
        this.classToCustomConverterMap.put(Charset.class, new CustomConverter(){

            @Override
            public Object toJava(String value) {
                return Charset.forName(value);
            }

            @Override
            public String toXML(Object object) {
                return ((Charset)object).name();
            }
        });
        this.classToCustomConverterMap.put(Pattern.class, new CustomConverter(){

            @Override
            public Object toJava(String value) {
                return Pattern.compile(value);
            }

            @Override
            public String toXML(Object object) {
                return object.toString();
            }
        });
        this.classToCustomConverterMap.put(AttributeType.class, new CustomConverter(){

            @Override
            public Object toJava(String value) {
                return AttributeType.toAttributeType(value);
            }

            @Override
            public String toXML(Object object) {
                return object.toString();
            }
        });
        this.classToCustomConverterMap.put(Geometry.class, new CustomConverter(){

            @Override
            public Object toJava(String value) {
                try {
                    return WKT_READER.read(value);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            @Override
            public String toXML(Object object) {
                return WKT_WRITER.write((Geometry)object);
            }
        });
    }

    private String specFilename(Class<?> c) {
        return StringUtil.classNameWithoutPackageQualifiers(c.getName()) + ".java2xml";
    }

    protected List<Element> specElements(Class<?> c) throws XMLBinderException, JDOMException, IOException {
        try (InputStream stream = this.specResourceStream(c);){
            if (stream == null) {
                throw new XMLBinderException("Could not find java2xml file for " + c.getName() + " or its interfaces or superclasses");
            }
            Element root = new SAXBuilder().build(stream).getRootElement();
            if (!root.getAttributes().isEmpty()) {
                throw new XMLBinderException("Root element of " + this.specFilename(c) + " should not have attributes");
            }
            if (!root.getName().equals("root")) {
                throw new XMLBinderException("Root element of " + this.specFilename(c) + " should be named 'root'");
            }
            List list = root.getChildren();
            return list;
        }
    }

    private InputStream specResourceStream(Class<?> c) {
        for (Class<?> clazz : LangUtil.classesAndInterfaces(c)) {
            Assert.isTrue((boolean)clazz.isAssignableFrom(c));
            InputStream stream = clazz.getResourceAsStream(this.specFilename(clazz));
            if (stream == null) continue;
            return stream;
        }
        return null;
    }

    public void addCustomConverter(Class<?> c, CustomConverter converter) {
        this.classToCustomConverterMap.put(c, converter);
    }

    protected void visit(List<Element> specElements, SpecVisitor visitor, Class<?> c) throws Exception {
        for (Element specElement : specElements) {
            boolean required;
            Attribute xmlName = specElement.getAttribute("xml-name");
            if (xmlName == null) {
                throw new XMLBinderException(StringUtil.classNameWithoutPackageQualifiers(c.getName()) + ": Expected 'xml-name' attribute in <" + specElement.getName() + "> but found none");
            }
            Attribute javaName = specElement.getAttribute("java-name");
            String attributeValue = javaName == null ? null : javaName.getValue();
            Attribute requiredAttribute = specElement.getAttribute("required");
            boolean bl = required = requiredAttribute == null || requiredAttribute.getValue().equals("true");
            if (specElement.getName().equals("element")) {
                visitor.tagSpecFound(xmlName.getValue(), attributeValue, specElement.getChildren());
            }
            if (!specElement.getName().equals("attribute")) continue;
            visitor.attributeSpecFound(xmlName.getValue(), attributeValue, required);
        }
    }

    public Object toJava(String text, Class<?> c) {
        return !text.equals("null") ? this.classToCustomConverterMap.get(this.customConvertableClass(c)).toJava(text) : null;
    }

    protected boolean specifyingTypeExplicitly(Class<?> c) {
        if (this.hasCustomConverter(c)) {
            return false;
        }
        return c == Object.class || Modifier.isAbstract(c.getModifiers()) || c.isInterface();
    }

    protected Class<?> fieldClass(Method setter) {
        Assert.isTrue((setter.getParameterTypes().length == 1 ? 1 : 0) != 0);
        return setter.getParameterTypes()[0];
    }

    public Method setter(Class<?> c, String field) throws XMLBinderException {
        Method[] methods;
        for (Method method : methods = c.getMethods()) {
            if (!method.getName().toUpperCase().equals("SET" + field.toUpperCase()) && !method.getName().toUpperCase().equals("ADD" + field.toUpperCase()) || method.getParameterTypes().length != 1) continue;
            return method;
        }
        for (Method method : methods) {
            if (!method.getName().toUpperCase().startsWith("SET" + field.toUpperCase()) && !method.getName().toUpperCase().startsWith("ADD" + field.toUpperCase()) || method.getParameterTypes().length != 1) continue;
            return method;
        }
        throw new XMLBinderException("Could not find setter named like '" + field + "' in class " + c);
    }

    protected String toXML(Object object) {
        return this.classToCustomConverterMap.get(this.customConvertableClass(object.getClass())).toXML(object);
    }

    protected boolean hasCustomConverter(Class<?> fieldClass) {
        return this.customConvertableClass(fieldClass) != null;
    }

    private Class<?> customConvertableClass(Class<?> c) {
        for (Class<?> customConvertableClass : this.classToCustomConverterMap.keySet()) {
            if (!customConvertableClass.isAssignableFrom(c)) continue;
            return customConvertableClass;
        }
        return null;
    }

    public static class XMLBinderException
    extends Exception {
        public XMLBinderException(String message) {
            super(message);
        }
    }

    public static interface CustomConverter {
        public Object toJava(String var1);

        public String toXML(Object var1);
    }

    protected static interface SpecVisitor {
        public void tagSpecFound(String var1, String var2, List<Element> var3) throws Exception;

        public void attributeSpecFound(String var1, String var2, boolean var3) throws Exception;
    }
}

