/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.qa.diff;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.util.CoordinateArrays;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.quadtree.Quadtree;

public class SegmentIndex {
    private SpatialIndex segIndex = new Quadtree();
    private Envelope itemEnv = new Envelope();

    public SegmentIndex(FeatureCollection fc) {
        for (Feature f : fc) {
            this.add(f.getGeometry());
        }
    }

    public void add(Geometry geom) {
        this.add(CoordinateArrays.toCoordinateArrays(geom, false));
    }

    public void add(LineString line) {
        this.add(line.getCoordinates());
    }

    public void add(List<Coordinate[]> coordArrays) {
        for (Coordinate[] coordArray : coordArrays) {
            this.add(coordArray);
        }
    }

    public void add(Coordinate[] coord) {
        for (int i = 0; i < coord.length - 1; ++i) {
            LineSegment lineseg = new LineSegment(coord[i], coord[i + 1]);
            lineseg.normalize();
            this.itemEnv.init(lineseg.p0, lineseg.p1);
            this.segIndex.insert(this.itemEnv, (Object)lineseg);
        }
    }

    public List query(Envelope env) {
        return this.segIndex.query(env);
    }
}

