/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.qa;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.geom.Angle;
import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.qa.BasicTopologyValidationError;
import com.vividsolutions.jump.qa.ValidationError;
import com.vividsolutions.jump.qa.ValidationErrorType;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.CoordinateArrays;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.IsSimpleOp;
import org.locationtech.jts.operation.valid.IsValidOp;
import org.locationtech.jts.operation.valid.RepeatedPointTester;
import org.locationtech.jts.operation.valid.TopologyValidationError;

public class Validator {
    private boolean checkingBasicTopology = true;
    private boolean checkingPolygonOrientation = false;
    private boolean checkingGeometriesSimple = false;
    private boolean checkingMinSegmentLength = false;
    private boolean checkingMinAngle = false;
    private boolean checkingMinPolygonArea = false;
    private boolean checkingNoRepeatedConsecutivePoints = false;
    private boolean checkingNoHoles = false;
    private double minSegmentLength = 0.0;
    private double minAngle = 0.0;
    private double minPolygonArea = 0.0;
    private Collection<String> disallowedGeometryClassNames = new ArrayList<String>();
    private RepeatedPointTester repeatedPointTester = new RepeatedPointTester();

    public void setCheckingBasicTopology(boolean checkingBasicTopology) {
        this.checkingBasicTopology = checkingBasicTopology;
    }

    public void setCheckingNoRepeatedConsecutivePoints(boolean checkingNoRepeatedConsecutivePoints) {
        this.checkingNoRepeatedConsecutivePoints = checkingNoRepeatedConsecutivePoints;
    }

    public void setCheckingNoHoles(boolean checkingNoHoles) {
        this.checkingNoHoles = checkingNoHoles;
    }

    public void setCheckingPolygonOrientation(boolean checkingPolygonOrientation) {
        this.checkingPolygonOrientation = checkingPolygonOrientation;
    }

    public void setMinSegmentLength(double minSegmentLength) {
        this.minSegmentLength = minSegmentLength;
    }

    public void setMinAngle(double minAngle) {
        this.minAngle = minAngle;
    }

    public void setMinPolygonArea(double minPolygonArea) {
        this.minPolygonArea = minPolygonArea;
    }

    public void setCheckingGeometriesSimple(boolean checkingGeometriesSimple) {
        this.checkingGeometriesSimple = checkingGeometriesSimple;
    }

    public void setCheckingMinSegmentLength(boolean checkingMinSegmentLength) {
        this.checkingMinSegmentLength = checkingMinSegmentLength;
    }

    public void setCheckingMinAngle(boolean checkingMinAngle) {
        this.checkingMinAngle = checkingMinAngle;
    }

    public void setCheckingMinPolygonArea(boolean checkingMinPolygonArea) {
        this.checkingMinPolygonArea = checkingMinPolygonArea;
    }

    public void setDisallowedGeometryClasses(Collection<Class> disallowedGeometryClasses) {
        this.disallowedGeometryClassNames.clear();
        for (Class clazz : disallowedGeometryClasses) {
            this.disallowedGeometryClassNames.add(clazz.getName());
        }
    }

    public List validate(Collection features, TaskMonitor monitor) {
        monitor.allowCancellationRequests();
        int validatedFeatureCount = 0;
        monitor.report(I18N.getInstance().get("qa.Validator.validating"));
        ArrayList<Object> validationErrors = new ArrayList<Object>();
        int totalFeatures = features.size();
        Iterator i = features.iterator();
        while (i.hasNext() && !monitor.isCancelRequested()) {
            Feature feature = (Feature)i.next();
            this.validate(feature, validationErrors);
            monitor.report(++validatedFeatureCount, totalFeatures, "features");
        }
        return validationErrors;
    }

    protected void addIfNotNull(Object item, Collection<Object> collection) {
        if (item == null) {
            return;
        }
        collection.add(item);
    }

    protected void validate(Feature feature, List<Object> validationErrors) {
        this.addIfNotNull(this.validateGeometryClass(feature), validationErrors);
        if (this.checkingBasicTopology) {
            this.addIfNotNull(this.validateBasicTopology(feature), validationErrors);
        }
        if (this.checkingPolygonOrientation) {
            this.addIfNotNull(this.validatePolygonOrientation(feature), validationErrors);
        }
        if (this.checkingGeometriesSimple) {
            this.addIfNotNull(this.validateGeometriesSimple(feature), validationErrors);
        }
        if (this.checkingMinSegmentLength) {
            this.addIfNotNull(this.validateMinSegmentLength(feature), validationErrors);
        }
        if (this.checkingMinAngle) {
            this.addIfNotNull(this.validateMinAngle(feature), validationErrors);
        }
        if (this.checkingMinPolygonArea) {
            this.addIfNotNull(this.validateMinPolygonArea(feature), validationErrors);
        }
        if (this.checkingNoHoles) {
            this.addIfNotNull(this.validateNoHoles(feature), validationErrors);
        }
        if (this.checkingNoRepeatedConsecutivePoints) {
            this.addIfNotNull(this.validateNoRepeatedConsecutivePoints(feature), validationErrors);
        }
    }

    protected ValidationError validateGeometryClass(Feature feature) {
        if (this.disallowedGeometryClassNames.contains(feature.getGeometry().getClass().getName())) {
            return new ValidationError(ValidationErrorType.GEOMETRY_CLASS_DISALLOWED, feature);
        }
        return null;
    }

    protected ValidationError validateBasicTopology(Feature feature) {
        TopologyValidationError error = new IsValidOp(feature.getGeometry()).getValidationError();
        if (error != null) {
            return new BasicTopologyValidationError(error, feature);
        }
        return null;
    }

    protected ValidationError validateNoRepeatedConsecutivePoints(Feature feature) {
        if (this.repeatedPointTester.hasRepeatedPoint(feature.getGeometry())) {
            return new ValidationError(ValidationErrorType.REPEATED_CONSECUTIVE_POINTS, feature, this.repeatedPointTester.getCoordinate());
        }
        return null;
    }

    protected ValidationError validateGeometriesSimple(Feature feature) {
        Geometry geometry = feature.getGeometry();
        IsSimpleOp simpleOp = new IsSimpleOp(geometry);
        if (!simpleOp.isSimple()) {
            return new ValidationError(ValidationErrorType.NONSIMPLE, feature, simpleOp.getNonSimpleLocation());
        }
        return null;
    }

    protected ValidationError validatePolygonOrientation(Feature feature) {
        return this.recursivelyValidate(feature.getGeometry(), feature, new RecursiveValidation(){

            @Override
            public ValidationError validate(Geometry g, Feature f) {
                Polygon polygon = (Polygon)g;
                if (Orientation.isCCW((Coordinate[])polygon.getExteriorRing().getCoordinates())) {
                    return new ValidationError(ValidationErrorType.EXTERIOR_RING_CCW, f, (Geometry)polygon);
                }
                for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                    if (Orientation.isCCW((Coordinate[])polygon.getInteriorRingN(i).getCoordinates())) continue;
                    return new ValidationError(ValidationErrorType.INTERIOR_RING_CW, f, (Geometry)polygon);
                }
                return null;
            }

            @Override
            public Class getTargetGeometryClass() {
                return Polygon.class;
            }
        });
    }

    protected ValidationError validateNoHoles(Feature feature) {
        return this.recursivelyValidate(feature.getGeometry(), feature, new RecursiveValidation(){

            @Override
            public ValidationError validate(Geometry g, Feature f) {
                Polygon polygon = (Polygon)g;
                if (polygon.getNumInteriorRing() > 0) {
                    return new ValidationError(ValidationErrorType.POLYGON_HAS_HOLES, f, polygon.getInteriorRingN(0).getCoordinate());
                }
                return null;
            }

            @Override
            public Class getTargetGeometryClass() {
                return Polygon.class;
            }
        });
    }

    private ValidationError recursivelyValidate(Geometry geometry, Feature feature, RecursiveValidation validation) {
        if (geometry.isEmpty()) {
            return null;
        }
        if (geometry instanceof GeometryCollection) {
            return this.recursivelyValidateGeometryCollection((GeometryCollection)geometry, feature, validation);
        }
        if (!validation.getTargetGeometryClass().isInstance(geometry)) {
            return null;
        }
        return validation.validate(geometry, feature);
    }

    private ValidationError recursivelyValidateGeometryCollection(GeometryCollection gc, Feature feature, RecursiveValidation validation) {
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            ValidationError error = this.recursivelyValidate(gc.getGeometryN(i), feature, validation);
            if (error == null) continue;
            return error;
        }
        return null;
    }

    protected ValidationError validateMinSegmentLength(Feature feature) {
        List<Coordinate[]> coordArrays = CoordinateArrays.toCoordinateArrays(feature.getGeometry(), false);
        for (Coordinate[] coordArray : coordArrays) {
            ValidationError error = this.validateMinSegmentLength(coordArray, feature);
            if (error == null) continue;
            return error;
        }
        return null;
    }

    protected ValidationError validateMinAngle(Feature feature) {
        List<Coordinate[]> coordArrays = CoordinateArrays.toCoordinateArrays(feature.getGeometry(), false);
        for (Coordinate[] coordArray : coordArrays) {
            ValidationError error = this.validateMinAngle(coordArray, feature);
            if (error == null) continue;
            return error;
        }
        return null;
    }

    protected ValidationError validateMinPolygonArea(Feature feature) {
        return this.recursivelyValidate(feature.getGeometry(), feature, new RecursiveValidation(){

            @Override
            public ValidationError validate(Geometry g, Feature f) {
                Polygon polygon = (Polygon)g;
                if (polygon.getArea() < Validator.this.minPolygonArea) {
                    return new ValidationError(ValidationErrorType.SMALL_AREA, f, (Geometry)polygon);
                }
                return null;
            }

            @Override
            public Class getTargetGeometryClass() {
                return Polygon.class;
            }
        });
    }

    private ValidationError validateMinSegmentLength(Coordinate[] coordinates, Feature feature) {
        if (coordinates.length < 2) {
            return null;
        }
        for (int i = 1; i < coordinates.length; ++i) {
            ValidationError error = this.validateMinSegmentLength(coordinates[i - 1], coordinates[i], feature);
            if (error == null) continue;
            return error;
        }
        return null;
    }

    private ValidationError validateMinAngle(Coordinate[] coordinates, Feature feature) {
        int i;
        if (coordinates.length < 3) {
            return null;
        }
        boolean closed = coordinates[0].equals((Object)coordinates[coordinates.length - 1]);
        int n = i = closed ? 1 : 2;
        while (i < coordinates.length) {
            ValidationError error = this.validateMinAngle(i == 1 ? coordinates[coordinates.length - 2] : coordinates[i - 2], coordinates[i - 1], coordinates[i], feature);
            if (error != null) {
                return error;
            }
            ++i;
        }
        return null;
    }

    private ValidationError validateMinSegmentLength(Coordinate c1, Coordinate c2, Feature feature) {
        if (c1.distance(c2) < this.minSegmentLength) {
            return new ValidationError(ValidationErrorType.SMALL_SEGMENT, feature, CoordUtil.average(c1, c2));
        }
        return null;
    }

    private ValidationError validateMinAngle(Coordinate c1, Coordinate c2, Coordinate c3, Feature feature) {
        if (Angle.angleBetween(c2, c1, c3) < Angle.toRadians(this.minAngle)) {
            return new ValidationError(ValidationErrorType.SMALL_ANGLE, feature, c2);
        }
        return null;
    }

    private static interface RecursiveValidation {
        public ValidationError validate(Geometry var1, Feature var2);

        public Class getTargetGeometryClass();
    }
}

