/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.plugin.edit;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureDatasetFactory;
import com.vividsolutions.jump.geom.precision.NumberPrecisionReducer;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.ColorUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerStyleUtil;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.precision.GeometryPrecisionReducer;
import org.openjump.core.ui.plugin.AbstractThreadedUiPlugIn;

public class PrecisionReducerPlugIn
extends AbstractThreadedUiPlugIn {
    private static final double EXAMPLE_VALUE = 1234567.123123123;
    private static final String LAYER = I18N.getInstance().get("ui.plugin.edit.PrecisionReducerPlugIn.Layer");
    private static final String DECIMAL_PLACES = I18N.getInstance().get("ui.plugin.edit.PrecisionReducerPlugIn.Decimal-Places");
    private static final String SCALE_FACTOR = I18N.getInstance().get("ui.plugin.edit.PrecisionReducerPlugIn.Scale-Factor");
    private static final String PRESERVE_POLYGONAL_TOPOLOGY = I18N.getInstance().get("ui.plugin.edit.PrecisionReducerPlugIn.Preserve-polygonal-topology");
    private static final String PRESERVE_POLYGONAL_TOPOLOGY_TT = I18N.getInstance().get("ui.plugin.edit.PrecisionReducerPlugIn.Preserve-polygonal-topology-TT");
    private static final String CHANGE_GEOMETRY_PM = I18N.getInstance().get("ui.plugin.edit.PrecisionReducerPlugIn.Change-geometry-precision-model");
    private static final String CHANGE_GEOMETRY_PM_TT = I18N.getInstance().get("ui.plugin.edit.PrecisionReducerPlugIn.Change-geometry-precision-model-TT");
    private static final String REMOVE_COLLAPSED_GEOMETRY = I18N.getInstance().get("ui.plugin.edit.PrecisionReducerPlugIn.Remove-collapsed-geometry");
    private static final String REMOVE_COLLAPSED_GEOMETRY_TT = I18N.getInstance().get("ui.plugin.edit.PrecisionReducerPlugIn.Remove-collapsed-geometry-TT");
    private JTextField decimalPlacesField;
    private JTextField scaleFactorField;
    private JLabel exampleLabel;
    private String layerName;
    private int decimalPlaces = 0;
    private int scaleFactor = 1;
    private boolean preservePolygonalTopology = false;
    private boolean changeGeometryPrecisionModel = false;
    private boolean removeCollapsedGeometry = true;

    @Override
    public String getName() {
        return I18N.getInstance().get("ui.plugin.edit.PrecisionReducerPlugIn.Precision-Reducer");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_GEOMETRY}, this.getName() + "...", false, null, this.createEnableCheck(context.getWorkbenchContext()), -1);
    }

    public EnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1)).add(checkFactory.createAtLeastNLayersMustBeEditableCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        monitor.report(I18N.getInstance().get("ui.plugin.edit.PrecisionReducerPlugIn.Reducing-Precision") + "...");
        Layer layer = context.getLayerManager().getLayer(this.layerName);
        FeatureCollectionWrapper fc = layer.getFeatureCollectionWrapper();
        EditTransaction transaction = new EditTransaction(new ArrayList<Feature>(), this.getName(), layer, this.isRollingBackInvalidEdits(context), true, context.getWorkbenchFrame());
        GeometryPrecisionReducer reducer = new GeometryPrecisionReducer(new PrecisionModel((double)this.scaleFactor));
        reducer.setChangePrecisionModel(this.changeGeometryPrecisionModel);
        reducer.setPointwise(!this.preservePolygonalTopology);
        reducer.setRemoveCollapsedComponents(this.removeCollapsedGeometry);
        int count = 0;
        ArrayList<Geometry> invalidOutput = new ArrayList<Geometry>();
        FeatureDataset invalidInput = new FeatureDataset(fc.getFeatureSchema());
        for (Feature feature : fc.getFeatures()) {
            Geometry g1 = feature.getGeometry();
            Geometry g2 = reducer.reduce(g1);
            if (g2.isValid()) {
                transaction.modifyFeatureGeometry(feature, g2);
                if (g2.isEmpty()) {
                    invalidInput.add(feature.clone(true));
                }
            } else {
                invalidInput.add(feature.clone(true));
                invalidOutput.add(g2);
            }
            monitor.report(++count, fc.size(), I18N.getInstance().get("jump.features-processed"));
        }
        transaction.commit();
        layer.fireAppearanceChanged();
        if (monitor.isCancelRequested()) {
            return;
        }
        if (invalidInput.size() > 0) {
            Layer lyr = context.getLayerManager().addLayer(StandardCategoryNames.QA, I18N.getInstance().get("ui.plugin.edit.PrecisionReducerPlugIn.Invalid-Input-Geometries"), invalidInput);
            LayerStyleUtil.setLinearStyle(lyr, Color.red, 2, 0);
            lyr.fireAppearanceChanged();
            Layer lyr2 = context.getLayerManager().addLayer(StandardCategoryNames.QA, I18N.getInstance().get("ui.plugin.edit.PrecisionReducerPlugIn.Invalid-Reduced-Geometries"), FeatureDatasetFactory.createFromGeometry(invalidOutput));
            lyr2.getBasicStyle().setFillColor(ColorUtil.GOLD);
            lyr2.getBasicStyle().setLineColor(Layer.defaultLineColor(ColorUtil.GOLD));
            lyr2.fireAppearanceChanged();
        }
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarImage(new ImageIcon(this.getClass().getResource("PrecisionReducer.png")));
        dialog.setSideBarDescription(I18N.getInstance().get("ui.plugin.edit.PrecisionReducerPlugIn.Reduces-the-precision-of-the-coordinates-in-a-layer"));
        dialog.addLayerComboBox(LAYER, context.getCandidateLayer(0), null, context.getLayerManager());
        this.scaleFactorField = dialog.addIntegerField(SCALE_FACTOR, this.scaleFactor, 8, I18N.getInstance().get("ui.plugin.edit.PrecisionReducerPlugIn.The-scale-factor-to-multiply-by-before-rounding-(-Negative-for-left-of-decimal-point-,-0-if-not-used-)"));
        this.scaleFactorField.getDocument().addDocumentListener(new ScaleFactorDocumentListener());
        this.decimalPlacesField = dialog.addIntegerField(DECIMAL_PLACES, this.decimalPlaces, 4, I18N.getInstance().get("ui.plugin.edit.PrecisionReducerPlugIn.The-number-of-decimal-places-to-round-to-(-Negative-for-left-of-decimal-point-)"));
        this.decimalPlacesField.getDocument().addDocumentListener(new DecimalPlacesDocumentListener());
        dialog.addCheckBox(PRESERVE_POLYGONAL_TOPOLOGY, this.preservePolygonalTopology, PRESERVE_POLYGONAL_TOPOLOGY_TT);
        dialog.addCheckBox(CHANGE_GEOMETRY_PM, this.changeGeometryPrecisionModel, CHANGE_GEOMETRY_PM_TT);
        dialog.addCheckBox(REMOVE_COLLAPSED_GEOMETRY, this.removeCollapsedGeometry, REMOVE_COLLAPSED_GEOMETRY_TT);
        dialog.addLabel("");
        dialog.addLabel(I18N.getInstance().get("ui.plugin.edit.PrecisionReducerPlugIn.Example") + "  " + 1234567.123123123);
        this.exampleLabel = dialog.addLabel("");
        this.updateExample();
    }

    private int parseValidInt(String text) {
        int i = 0;
        try {
            i = Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return i;
    }

    private void decimalPlacesChanged() {
        this.decimalPlaces = this.parseValidInt(this.decimalPlacesField.getText());
        double sf = NumberPrecisionReducer.scaleFactorForDecimalPlaces(this.decimalPlaces);
        this.scaleFactorField.setText("" + (int)sf);
        this.updateExample();
    }

    private void scaleFactorChanged() {
        this.scaleFactor = this.parseValidInt(this.scaleFactorField.getText());
        this.updateExample();
    }

    private void updateExample() {
        NumberPrecisionReducer cpr = new NumberPrecisionReducer(this.scaleFactor);
        double exampleOutput = cpr.reducePrecision(1234567.123123123);
        this.exampleLabel.setText("      ==>  " + exampleOutput);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        Layer layer = dialog.getLayer(LAYER);
        this.layerName = layer.getName();
        this.decimalPlaces = dialog.getInteger(DECIMAL_PLACES);
        this.scaleFactor = dialog.getInteger(SCALE_FACTOR);
        this.preservePolygonalTopology = dialog.getBoolean(PRESERVE_POLYGONAL_TOPOLOGY);
        this.changeGeometryPrecisionModel = dialog.getBoolean(CHANGE_GEOMETRY_PM);
        this.removeCollapsedGeometry = dialog.getBoolean(REMOVE_COLLAPSED_GEOMETRY);
    }

    private class ScaleFactorDocumentListener
    implements DocumentListener {
        private ScaleFactorDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            PrecisionReducerPlugIn.this.scaleFactorChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            PrecisionReducerPlugIn.this.scaleFactorChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            PrecisionReducerPlugIn.this.scaleFactorChanged();
        }
    }

    private class DecimalPlacesDocumentListener
    implements DocumentListener {
        private DecimalPlacesDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            PrecisionReducerPlugIn.this.decimalPlacesChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            PrecisionReducerPlugIn.this.decimalPlacesChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            PrecisionReducerPlugIn.this.decimalPlacesChanged();
        }
    }
}

