/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.plugin.edit;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureDatasetFactory;
import com.vividsolutions.jump.plugin.edit.Features2SegmentStringsWithData;
import com.vividsolutions.jump.plugin.edit.SegmentStringData;
import com.vividsolutions.jump.plugin.edit.SegmentStringsWithData2Features;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Lineal;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.noding.InteriorIntersectionFinderAdder;
import org.locationtech.jts.noding.IntersectionAdder;
import org.locationtech.jts.noding.MCIndexNoder;
import org.locationtech.jts.noding.Noder;
import org.locationtech.jts.noding.ScaledNoder;
import org.locationtech.jts.noding.SegmentIntersector;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.noding.snapround.SnapRoundingNoder;
import org.locationtech.jts.operation.polygonize.Polygonizer;
import org.locationtech.jts.precision.CoordinatePrecisionReducerFilter;
import org.openjump.core.ui.plugin.AbstractThreadedUiPlugIn;

public class NoderPlugIn
extends AbstractThreadedUiPlugIn {
    private static final String PROCESSED_DATA = I18N.getInstance().get("jump.plugin.edit.NoderPlugIn.processed-data");
    private static final String SRC_LAYER = GenericNames.SOURCE_LAYER;
    private static final String SELECTED_ONLY = GenericNames.USE_SELECTED_FEATURES_ONLY;
    private static final String PROCESSING = I18N.getInstance().get("jump.plugin.edit.NoderPlugIn.processing");
    private static final String FIND_INTERSECTIONS = I18N.getInstance().get("jump.plugin.edit.NoderPlugIn.find-intersections");
    private static final String FIND_DESCRIPTION = I18N.getInstance().get("jump.plugin.edit.NoderPlugIn.create-new-layer-with-missing-intersections");
    private static final String LINE_OPTIONS = I18N.getInstance().get("jump.plugin.edit.NoderPlugIn.line-options");
    private static final String POLYGON_OPTIONS = I18N.getInstance().get("jump.plugin.edit.NoderPlugIn.polygon-options");
    private static final String ADVANCED_OPTIONS = I18N.getInstance().get("jump.plugin.edit.NoderPlugIn.advanced-options");
    private static final String SNAP_ROUNDING = I18N.getInstance().get("jump.plugin.edit.NoderPlugIn.snap-rounding");
    private static final String SNAP_ROUNDING_TOOLTIP = I18N.getInstance().get("jump.plugin.edit.NoderPlugIn.snap-rounding-makes-noding-algorithm-fully-robust");
    private static final String SNAP_ROUNDING_DP = I18N.getInstance().get("jump.plugin.edit.NoderPlugIn.snap-rounding-decimal-places");
    private static final String DECIMAL_DIGITS_TOOLTIP = I18N.getInstance().get("jump.plugin.edit.NoderPlugIn.number-of-decimal-digits");
    private static final String INTERPOLATE_Z = I18N.getInstance().get("jump.plugin.edit.NoderPlugIn.interpolate-z");
    private static final String INTERPOLATED_Z_DP = I18N.getInstance().get("jump.plugin.edit.NoderPlugIn.interpolated-z-decimal-places");
    private static final String INTERSECTIONS = I18N.getInstance().get("jump.plugin.edit.NoderPlugIn.intersections");
    private static final String NODED = I18N.getInstance().get("jump.plugin.edit.NoderPlugIn.noded");
    private boolean use_selected = false;
    private String layerName;
    private GeometryFactory gf;
    private boolean find_intersections = true;
    private Processor line_processor = Processor.SPLIT;
    private Processor polygon_processor = Processor.NODE;
    private boolean snap_rounding = false;
    private int snap_rounding_dp = 6;
    private boolean interpolate_z = false;
    private int interpolated_z_dp = 3;
    private static final RobustLineIntersector ROBUST_INTERSECTOR = new RobustLineIntersector();

    @Override
    public void initialize(PlugInContext context) throws Exception {
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_GEOMETRY}, this.getName() + "...", false, null, this.createEnableCheck(context.getWorkbenchContext()), -1);
    }

    public EnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    public void setUseSelected(boolean use_selected) {
        this.use_selected = use_selected;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public void setSnapRounding(boolean snap_rounding) {
        this.snap_rounding = snap_rounding;
    }

    public void setSnapRoundingDp(int snap_rounding_dp) {
        this.snap_rounding_dp = snap_rounding_dp;
    }

    public void setFindIntersections(boolean find_intersections) {
        this.find_intersections = find_intersections;
    }

    public void setLineProcessor(Processor processor) {
        this.line_processor = processor;
    }

    public void setPolygonProcessor(Processor processor) {
        this.polygon_processor = processor;
    }

    public void setInterpolateZ(boolean interpolate_z) {
        this.interpolate_z = interpolate_z;
    }

    public void setInterpolatedZDp(int interpolated_z_dp) {
        this.interpolated_z_dp = interpolated_z_dp;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        monitor.report(I18N.getInstance().get("jump.plugin.edit.NoderPlugIn.noding-input"));
        int selectedFeaturesNb = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems().size();
        this.use_selected = selectedFeaturesNb > 0;
        Map<Layer, Collection<Feature>> inputFeatures = this.getFeaturesToProcess(context);
        HashMap<Layer, Collection<Feature>> outputFeatures = new HashMap<Layer, Collection<Feature>>();
        ArrayList<Feature> inputAll = new ArrayList<Feature>();
        HashMap<Feature, Layer> featureToLayer = new HashMap<Feature, Layer>();
        for (Layer layer : inputFeatures.keySet()) {
            outputFeatures.put(layer, new ArrayList());
            inputAll.addAll(inputFeatures.get(layer));
            for (Feature f : inputFeatures.get(layer)) {
                featureToLayer.put(f, layer);
            }
        }
        if (inputAll.isEmpty()) {
            context.getWorkbenchFrame().warnUser(I18N.getInstance().get("jump.plugin.edit.NoderPlugIn.no-data-to-process"));
            return;
        }
        this.gf = this.snap_rounding ? new GeometryFactory(new PrecisionModel(Math.pow(10.0, this.snap_rounding_dp))) : ((Feature)inputAll.iterator().next()).getGeometry().getFactory();
        monitor.report(I18N.getInstance().get("jump.plugin.edit.NoderPlugIn.noding"));
        List<SegmentString> segmentStrings = Features2SegmentStringsWithData.getSegmentStrings(inputAll);
        if (segmentStrings.isEmpty()) {
            context.getWorkbenchFrame().warnUser(I18N.getInstance().get("jump.plugin.edit.NoderPlugIn.no-data-to-process"));
            return;
        }
        if (this.find_intersections) {
            FeatureCollection nodes;
            IntersectionAdder intersector;
            if (this.line_processor != Processor.SPLIT && this.polygon_processor != Processor.SPLIT) {
                intersector = new InteriorIntersectionFinderAdder((LineIntersector)ROBUST_INTERSECTOR);
                nodes = this.findInteriorIntersections(segmentStrings, (InteriorIntersectionFinderAdder)intersector);
            } else {
                intersector = new IntersectionAdder((LineIntersector)ROBUST_INTERSECTOR);
                nodes = this.findIntersections(segmentStrings, intersector);
            }
            if (nodes != null) {
                context.addLayer(StandardCategoryNames.RESULT, this.layerName + " " + INTERSECTIONS, nodes);
            }
        }
        if (this.line_processor != Processor.DO_NOT_PROCESS || this.polygon_processor != Processor.DO_NOT_PROCESS) {
            Noder noder = this.snap_rounding ? this.getScaledNoder() : this.getMCIndexNoder((SegmentIntersector)new IntersectionAdder((LineIntersector)ROBUST_INTERSECTOR));
            noder.computeNodes(segmentStrings);
            Collection nodedSubstring = noder.getNodedSubstrings();
            Map<Feature, Map<Integer, Map<Integer, List<SegmentString>>>> geomStructureMap = SegmentStringsWithData2Features.getFeature2SegmentStringTreeMap(nodedSubstring);
            FeatureDataset fc = new FeatureDataset(inputFeatures.keySet().iterator().next().getFeatureCollectionWrapper().getFeatureSchema());
            if (this.line_processor == Processor.NODE || this.polygon_processor == Processor.NODE) {
                if (!this.use_selected) {
                    fc.addAll(this.nodeFeatures(geomStructureMap, this.interpolate_z, this.interpolated_z_dp));
                } else {
                    this.insertRemove(inputFeatures, geomStructureMap, outputFeatures);
                }
            }
            if (this.interpolate_z && (this.line_processor == Processor.SPLIT || this.polygon_processor == Processor.SPLIT)) {
                for (Map.Entry<Feature, Map<Integer, Map<Integer, List<SegmentString>>>> entry : geomStructureMap.entrySet()) {
                    Geometry g = entry.getKey().getGeometry();
                    int dim = g.getDimension();
                    if ((dim != 1 || this.line_processor != Processor.SPLIT) && (dim != 2 || this.polygon_processor != Processor.SPLIT)) continue;
                    SegmentStringsWithData2Features.buildGeometry(g, entry.getValue(), true, this.interpolated_z_dp, this.gf);
                }
            }
            if (this.line_processor == Processor.SPLIT || this.polygon_processor == Processor.SPLIT) {
                STRtree index;
                if (!this.use_selected) {
                    if (this.line_processor == Processor.SPLIT) {
                        fc.addAll(this.splitLines(monitor, nodedSubstring, featureToLayer, outputFeatures));
                    }
                    if (this.polygon_processor == Processor.SPLIT) {
                        index = NoderPlugIn.indexSegmentStrings(nodedSubstring);
                        fc.addAll(this.splitPolygons(monitor, geomStructureMap, index, featureToLayer, outputFeatures));
                    }
                } else {
                    this.insertRemove(inputFeatures, geomStructureMap, outputFeatures);
                    if (this.line_processor == Processor.SPLIT) {
                        this.splitLines(monitor, nodedSubstring, featureToLayer, outputFeatures);
                    }
                    if (this.polygon_processor == Processor.SPLIT) {
                        index = NoderPlugIn.indexSegmentStrings(nodedSubstring);
                        this.splitPolygons(monitor, geomStructureMap, index, featureToLayer, outputFeatures);
                    }
                }
            }
            if (this.use_selected) {
                for (Layer layer : inputFeatures.keySet()) {
                    if (!layer.isEditable()) continue;
                    this.commitUpdate(context, layer, inputFeatures.get(layer), (Collection)outputFeatures.get(layer));
                    context.getLayerViewPanel().getSelectionManager().getFeatureSelection().unselectItems(layer);
                    context.getLayerViewPanel().getSelectionManager().getFeatureSelection().selectItems(layer, (Collection)outputFeatures.get(layer));
                }
            } else if (fc.size() > 0) {
                context.addLayer(StandardCategoryNames.RESULT, this.layerName + " " + NODED, fc);
            } else {
                context.getWorkbenchFrame().warnUser(I18N.getInstance().get("jump.plugin.edit.NoderPlugIn.no-output-data"));
            }
        }
    }

    private Noder getScaledNoder() {
        PrecisionModel pm = this.gf.getPrecisionModel();
        return new ScaledNoder((Noder)new SnapRoundingNoder(pm), pm.getScale());
    }

    private Noder getMCIndexNoder(SegmentIntersector intersector) {
        MCIndexNoder noder = new MCIndexNoder();
        noder.setSegmentIntersector(intersector);
        return noder;
    }

    private Map<Layer, Collection<Feature>> getFeaturesToProcess(PlugInContext context) {
        HashMap<Layer, Collection<Feature>> map = new HashMap<Layer, Collection<Feature>>();
        if (this.use_selected) {
            Collection<Layer> layers = context.getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems();
            for (Layer layer : layers) {
                map.put(layer, context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(layer));
            }
            return map;
        }
        map.put(context.getLayerManager().getLayer(this.layerName), context.getLayerManager().getLayer(this.layerName).getFeatureCollectionWrapper().getFeatures());
        return map;
    }

    private FeatureCollection findInteriorIntersections(List<SegmentString> segmentStrings, InteriorIntersectionFinderAdder intersector) {
        Noder noder = this.getMCIndexNoder((SegmentIntersector)intersector);
        noder.computeNodes(segmentStrings);
        ArrayList<Point> nodes = new ArrayList<Point>();
        for (Object node : intersector.getInteriorIntersections()) {
            nodes.add(this.gf.createPoint((Coordinate)node));
        }
        return FeatureDatasetFactory.createFromGeometry(nodes);
    }

    private FeatureCollection findIntersections(List<SegmentString> segmentStrings, IntersectionAdder intersector) {
        Noder noder = this.getMCIndexNoder((SegmentIntersector)intersector);
        noder.computeNodes(segmentStrings);
        HashSet<Point> nodes = new HashSet<Point>();
        List sss = (List)noder.getNodedSubstrings();
        for (SegmentString ss : sss) {
            Coordinate[] ccgeom;
            SegmentStringData data = (SegmentStringData)ss.getData();
            LineString g = data.getSourceLineString();
            Coordinate[] ccss = ss.getCoordinates();
            if (!ccss[0].equals((Object)(ccgeom = g.getCoordinates())[0]) && !ccss[0].equals((Object)ccgeom[ccgeom.length - 1])) {
                nodes.add(this.gf.createPoint(ccss[0]));
            }
            if (ccss[ccss.length - 1].equals((Object)ccgeom[0]) || ccss[ccss.length - 1].equals((Object)ccgeom[ccgeom.length - 1])) continue;
            nodes.add(this.gf.createPoint(ccss[ccss.length - 1]));
        }
        return FeatureDatasetFactory.createFromGeometry(nodes);
    }

    private List<Feature> nodeFeatures(Map<Feature, Map<Integer, Map<Integer, List<SegmentString>>>> geomStructureMap, boolean interpolate, int interpolated_z_dp) {
        ArrayList<Feature> list = new ArrayList<Feature>();
        for (Map.Entry<Feature, Map<Integer, Map<Integer, List<SegmentString>>>> entry : geomStructureMap.entrySet()) {
            int dim = entry.getKey().getGeometry().getDimension();
            if ((dim != 1 || this.line_processor != Processor.NODE) && (dim != 2 || this.polygon_processor != Processor.NODE)) continue;
            list.add(this.nodeFeature(entry.getKey(), entry.getValue(), interpolate, interpolated_z_dp));
        }
        return list;
    }

    private Feature nodeFeature(Feature feature, Map<Integer, Map<Integer, List<SegmentString>>> map, boolean interpolate_z, int interpolated_z_dp) {
        if (map == null) {
            return null;
        }
        Geometry g = SegmentStringsWithData2Features.buildGeometry(feature.getGeometry(), map, interpolate_z, interpolated_z_dp, this.gf);
        Feature newFeature = feature.clone(false);
        newFeature.setGeometry(g);
        return newFeature;
    }

    private List<Feature> splitLines(TaskMonitor monitor, Collection nodedSubstring, Map<Feature, Layer> featureToLayer, Map<Layer, Collection<Feature>> outputFeatures) {
        monitor.report(I18N.getInstance().get("jump.plugin.edit.NoderPlugIn.split-lines"));
        int count = 0;
        int total = nodedSubstring.size();
        ArrayList<Feature> list = new ArrayList<Feature>();
        for (Object line : nodedSubstring) {
            SegmentString ss = (SegmentString)line;
            Coordinate[] cc = ss.getCoordinates();
            SegmentStringData metadata = (SegmentStringData)ss.getData();
            if (metadata.getFeature().getGeometry() instanceof Lineal && (cc = CoordinateArrays.atLeastNCoordinatesOrNothing((int)2, (Coordinate[])cc)).length > 1) {
                Feature feature = metadata.getFeature().clone(false);
                feature.setGeometry((Geometry)this.gf.createLineString(cc));
                list.add(feature);
                outputFeatures.get(featureToLayer.get(metadata.getFeature())).add(feature);
            }
            monitor.report(++count, total, "");
        }
        return list;
    }

    private static STRtree indexSegmentStrings(Collection segmentStrings) {
        STRtree index = new STRtree();
        for (Object o : segmentStrings) {
            SegmentString ss = (SegmentString)o;
            index.insert(NoderPlugIn.getEnvelope(ss), (Object)ss);
        }
        return index;
    }

    private static Envelope getEnvelope(SegmentString segmentString) {
        Envelope env = new Envelope();
        for (Coordinate c : segmentString.getCoordinates()) {
            env.expandToInclude(c);
        }
        return env;
    }

    private List<Feature> splitPolygons(TaskMonitor monitor, Map<Feature, Map<Integer, Map<Integer, List<SegmentString>>>> geomStructureMap, STRtree index, Map<Feature, Layer> featureToLayer, Map<Layer, Collection<Feature>> outputFeatures) {
        monitor.report(I18N.getInstance().get("jump.plugin.edit.NoderPlugIn.split-polygons"));
        int count = 0;
        int total = geomStructureMap.size();
        ArrayList<Feature> list = new ArrayList<Feature>();
        for (Map.Entry<Feature, Map<Integer, Map<Integer, List<SegmentString>>>> entry : geomStructureMap.entrySet()) {
            Geometry geometry = entry.getKey().getGeometry();
            if (geometry.getDimension() == 2) {
                LineString g;
                if (this.snap_rounding) {
                    CoordinatePrecisionReducerFilter filter = new CoordinatePrecisionReducerFilter(this.gf.getPrecisionModel());
                    geometry = (Geometry)geometry.clone();
                    geometry.apply((CoordinateSequenceFilter)filter);
                    geometry.geometryChanged();
                }
                Polygonizer polygonizer = new Polygonizer();
                HashSet<Geometry> uniqueCandidates = new HashSet<Geometry>();
                ArrayList<SegmentString> sourceSegmentStrings = new ArrayList<SegmentString>();
                for (Map<Integer, List<SegmentString>> map : entry.getValue().values()) {
                    for (List<SegmentString> ssList : map.values()) {
                        for (SegmentString ss : ssList) {
                            sourceSegmentStrings.add(ss);
                            LineString g2 = this.gf.createLineString(ss.getCoordinates());
                            uniqueCandidates.add(g2.norm());
                        }
                    }
                }
                List candidates = index.query(geometry.getEnvelopeInternal());
                for (Object o : candidates) {
                    SegmentString ss = (SegmentString)o;
                    g = this.gf.createLineString(ss.getCoordinates());
                    uniqueCandidates.add(g.norm());
                }
                polygonizer.add(uniqueCandidates);
                Collection collection = polygonizer.getPolygons();
                for (List<Object> o : collection) {
                    g = (Geometry)o;
                    if (!geometry.getEnvelopeInternal().contains(g.getEnvelopeInternal())) continue;
                    Point interiorPoint = g.getInteriorPoint();
                    if (interiorPoint.intersects(g.getBoundary())) {
                        interiorPoint = g.intersection(interiorPoint.buffer(g.getLength() / 100.0)).getInteriorPoint();
                    }
                    if (!interiorPoint.intersects(geometry)) continue;
                    Feature newFeature = entry.getKey().clone(false);
                    NoderPlugIn.resetZpoly((Geometry)g, sourceSegmentStrings);
                    newFeature.setGeometry((Geometry)g);
                    list.add(newFeature);
                    outputFeatures.get(featureToLayer.get(entry.getKey())).add(newFeature);
                }
            }
            monitor.report(++count, total, "");
        }
        return list;
    }

    private static void resetZpoly(Geometry geometry, Collection edges) {
        for (Object o : edges) {
            Coordinate[] cc_g;
            SegmentString edge = (SegmentString)o;
            int dim = ((SegmentStringData)edge.getData()).getFeature().getGeometry().getDimension();
            if (dim != 2) continue;
            Coordinate[] cc_edge = edge.getCoordinates();
            Coordinate ci = cc_edge[0];
            Coordinate cf = cc_edge[cc_edge.length - 1];
            for (Coordinate c : cc_g = geometry.getCoordinates()) {
                if (c.equals((Object)ci)) {
                    c.z = ci.z;
                }
                if (!c.equals((Object)cf)) continue;
                c.z = cf.z;
            }
        }
    }

    private Map<Layer, Collection<Feature>> insertRemove(Map<Layer, Collection<Feature>> inputFeatures, Map<Feature, Map<Integer, Map<Integer, List<SegmentString>>>> geomStructureMap, Map<Layer, Collection<Feature>> outputFeatures) {
        for (Layer layer : inputFeatures.keySet()) {
            if (!layer.isEditable()) continue;
            outputFeatures.put(layer, new ArrayList());
            for (Feature oldFeature : inputFeatures.get(layer)) {
                int dim = oldFeature.getGeometry().getDimension();
                if (dim == 1 && this.line_processor == Processor.NODE || dim == 2 && this.polygon_processor == Processor.NODE) {
                    Feature newFeature = this.nodeFeature(oldFeature, geomStructureMap.get(oldFeature), this.interpolate_z, this.interpolated_z_dp);
                    outputFeatures.get(layer).add(newFeature);
                }
                if ((dim != 1 || this.line_processor != Processor.DO_NOT_PROCESS) && (dim != 2 || this.polygon_processor != Processor.DO_NOT_PROCESS)) continue;
                outputFeatures.get(layer).add(oldFeature);
            }
        }
        return outputFeatures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitUpdate(PlugInContext context, final Layer layer, final Collection<Feature> inputFeatures, final Collection<Feature> newFeatures) {
        context.getLayerManager().getUndoableEditReceiver().reportNothingToUndoYet();
        UndoableCommand cmd = new UndoableCommand(this.getName()){

            @Override
            public void execute() {
                layer.getFeatureCollectionWrapper().removeAll(inputFeatures);
                layer.getFeatureCollectionWrapper().addAll(newFeatures);
            }

            @Override
            public void unexecute() {
                layer.getFeatureCollectionWrapper().removeAll(newFeatures);
                layer.getFeatureCollectionWrapper().addAll(inputFeatures);
            }
        };
        boolean exceptionOccurred = true;
        try {
            cmd.execute();
            exceptionOccurred = false;
        }
        finally {
            if (exceptionOccurred) {
                context.getLayerManager().getUndoableEditReceiver().getUndoManager().discardAllEdits();
            }
        }
        context.getLayerManager().getUndoableEditReceiver().receive(cmd.toUndoableEdit());
    }

    private void setDialogValues(final MultiInputDialog dialog, PlugInContext context) {
        int n = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems().size();
        dialog.setSideBarImage(IconLoader.icon("Noder.png"));
        dialog.setSideBarDescription(I18N.getInstance().get("jump.plugin.edit.NoderPlugIn.sidebar-description"));
        dialog.addSubTitle(PROCESSED_DATA);
        JComboBox<Layer> addLayerComboBox = dialog.addLayerComboBox(SRC_LAYER, context.getCandidateLayer(0), null, context.getLayerManager());
        addLayerComboBox.setVisible(n == 0);
        dialog.getLabel(SRC_LAYER).setVisible(n == 0);
        JLabel selectionLabel = dialog.addLabel(SELECTED_ONLY);
        selectionLabel.setVisible(n > 0);
        dialog.addSeparator();
        dialog.addSubTitle(PROCESSING);
        dialog.addCheckBox(FIND_INTERSECTIONS, this.find_intersections, FIND_DESCRIPTION);
        dialog.addComboBox(LINE_OPTIONS, this.line_processor, Arrays.asList(Processor.DO_NOT_PROCESS, Processor.NODE, Processor.SPLIT), "");
        dialog.addComboBox(POLYGON_OPTIONS, this.polygon_processor, Arrays.asList(Processor.DO_NOT_PROCESS, Processor.NODE, Processor.SPLIT), "");
        dialog.addSeparator();
        dialog.addSubTitle(ADVANCED_OPTIONS);
        final JCheckBox snapRoundingCB = dialog.addCheckBox(SNAP_ROUNDING, this.snap_rounding, SNAP_ROUNDING_TOOLTIP);
        JTextField snapRoundingDPTF = dialog.addIntegerField(SNAP_ROUNDING_DP, this.snap_rounding_dp, 6, DECIMAL_DIGITS_TOOLTIP);
        final JCheckBox interpolateZCB = dialog.addCheckBox(INTERPOLATE_Z, this.interpolate_z);
        JTextField interpolateZDPTF = dialog.addIntegerField(INTERPOLATED_Z_DP, this.interpolated_z_dp, 6, DECIMAL_DIGITS_TOOLTIP);
        snapRoundingDPTF.setEnabled(this.snap_rounding);
        snapRoundingCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setFieldEnabled(SNAP_ROUNDING_DP, snapRoundingCB.isSelected());
            }
        });
        interpolateZDPTF.setEnabled(this.interpolate_z);
        interpolateZCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setFieldEnabled(INTERPOLATED_Z_DP, interpolateZCB.isSelected());
            }
        });
    }

    private void getDialogValues(MultiInputDialog dialog) {
        Layer layer = dialog.getLayer(SRC_LAYER);
        this.layerName = layer.getName();
        this.find_intersections = dialog.getBoolean(FIND_INTERSECTIONS);
        this.line_processor = (Processor)((Object)dialog.getComboBox(LINE_OPTIONS).getSelectedItem());
        this.polygon_processor = (Processor)((Object)dialog.getComboBox(POLYGON_OPTIONS).getSelectedItem());
        this.snap_rounding = dialog.getBoolean(SNAP_ROUNDING);
        this.snap_rounding_dp = dialog.getInteger(SNAP_ROUNDING_DP);
        this.interpolate_z = dialog.getBoolean(INTERPOLATE_Z);
        this.interpolated_z_dp = dialog.getInteger(INTERPOLATED_Z_DP);
    }

    public static enum Processor {
        DO_NOT_PROCESS,
        NODE,
        SPLIT;


        public String toString() {
            return I18N.getInstance().get("jump.plugin.edit.NoderPlugIn." + this.name().toLowerCase().replaceAll("_", "-"));
        }
    }
}

