/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.geom.precision;

import com.vividsolutions.jump.geom.precision.CoordinatePrecisionReducer;
import com.vividsolutions.jump.geom.precision.NumberPrecisionReducer;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.util.GeometryEditor;

public class GeometryPrecisionReducer {
    private final CoordinatePrecisionReducer coordPrecReducer;
    private final GeometryEditor geomEdit = new GeometryEditor();

    public GeometryPrecisionReducer(NumberPrecisionReducer numberPrecReducer) {
        this.coordPrecReducer = new CoordinatePrecisionReducer(numberPrecReducer);
    }

    public Geometry reduce(Geometry geom) {
        return this.geomEdit.edit(geom, (GeometryEditor.GeometryEditorOperation)new PrecisionReducerCoordinateOperation());
    }

    private class PrecisionReducerCoordinateOperation
    extends GeometryEditor.CoordinateOperation {
        private PrecisionReducerCoordinateOperation() {
        }

        public Coordinate[] edit(Coordinate[] coordinates, Geometry geom) {
            for (Coordinate coordinate : coordinates) {
                GeometryPrecisionReducer.this.coordPrecReducer.reducePrecision(coordinate);
            }
            CoordinateList noRepeatedCoordList = new CoordinateList(coordinates, false);
            Coordinate[] noRepeatedCoord = noRepeatedCoordList.toCoordinateArray();
            if (geom instanceof LinearRing && noRepeatedCoord.length <= 3) {
                return coordinates;
            }
            if (geom instanceof LineString && noRepeatedCoord.length <= 1) {
                return coordinates;
            }
            return noRepeatedCoord;
        }
    }
}

