/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.geom;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class AbstractGeometryProcessor {
    public Geometry process(Geometry geometry) {
        ArrayList<Geometry> list = new ArrayList<Geometry>();
        this.process(geometry, list);
        return geometry.getFactory().buildGeometry(list);
    }

    private void process(Geometry geometry, List<Geometry> list) {
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            Geometry g = geometry.getGeometryN(i);
            if (g instanceof Point) {
                this.process((Point)geometry.getGeometryN(i), list);
                continue;
            }
            if (g instanceof LineString) {
                this.process((LineString)geometry.getGeometryN(i), list);
                continue;
            }
            if (g instanceof Polygon) {
                this.process((Polygon)geometry.getGeometryN(i), list);
                continue;
            }
            this.process(geometry.getGeometryN(i), list);
        }
    }

    public void process(Point point, List<Geometry> list) {
        Point clone = (Point)point.copy();
        this.process(clone.getCoordinateSequence());
        list.add((Geometry)clone);
    }

    public void process(LineString lineString, List<Geometry> list) {
        LineString clone = (LineString)lineString.copy();
        this.process(clone.getCoordinateSequence());
        list.add((Geometry)clone);
    }

    public LinearRing process(LinearRing linearRing) {
        LinearRing clone = (LinearRing)linearRing.copy();
        this.process(clone.getCoordinateSequence());
        return clone;
    }

    public void process(Polygon polygon, List<Geometry> list) {
        LinearRing ext = this.process(polygon.getExteriorRing());
        LinearRing[] holes = new LinearRing[polygon.getNumInteriorRing()];
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            holes[i] = this.process(polygon.getInteriorRingN(i));
        }
        list.add((Geometry)polygon.getFactory().createPolygon(ext, holes));
    }

    public void process(CoordinateSequence sequence) {
        int d = sequence.getDimension();
        for (int i = 0; i < sequence.size(); ++i) {
            int j;
            double[] dd = new double[d];
            for (j = 0; j < d; ++j) {
                dd[j] = sequence.getOrdinate(i, j);
            }
            dd = this.process(dd);
            for (j = 0; j < d; ++j) {
                sequence.setOrdinate(i, j, dd[j]);
            }
        }
    }

    public double[] process(double[] dd) {
        return dd;
    }
}

