/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.feature;

import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.util.FlexibleDateParser;
import java.security.InvalidParameterException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.openjump.core.ui.util.GeometryUtils;

public class FlexibleFeature
extends BasicFeature {
    private static HashMap<FeatureSchema, FlexibleDateParser> schemaToFlexDateParser = new HashMap();

    public FlexibleFeature(FeatureSchema featureSchema) {
        super(featureSchema);
    }

    @Override
    public Object getAttribute(int i) {
        FeatureSchema featureSchema = this.getSchema();
        if (i < 0) {
            throw new InvalidParameterException("index must be greater or equal zero");
        }
        Object attrib = null;
        Object[] attributes = super.getAttributes();
        if (i < attributes.length) {
            attrib = attributes[i];
        }
        if (i == featureSchema.getGeometryIndex()) {
            if (attrib == null) {
                attrib = GeometryUtils.createEmptyGeometry(GeometryCollection.class, null);
                this.setGeometry((Geometry)attrib);
            }
        } else if (this.getSchema().getAttributeType(i).equals(AttributeType.STRING) && attrib != null && !(attrib instanceof String)) {
            attrib = String.valueOf(attrib);
        } else if (featureSchema.getAttributeType(i).equals(AttributeType.DATE) && attrib != null && !AttributeType.DATE.toJavaClass().isInstance(attrib)) {
            Date d = this.parse(attrib);
            if (d != null) {
                attrib = new java.sql.Date(d.getTime());
                this.setAttribute(i, attrib);
            } else {
                attrib = null;
            }
        } else if (featureSchema.getAttributeType(i).equals(AttributeType.TIME) && attrib != null && !AttributeType.TIME.toJavaClass().isInstance(attrib)) {
            Date d = this.parse(attrib);
            if (d != null) {
                attrib = new Time(d.getTime());
                this.setAttribute(i, attrib);
            } else {
                attrib = null;
            }
        } else if (featureSchema.getAttributeType(i).equals(AttributeType.TIMESTAMP) && attrib != null && !AttributeType.TIMESTAMP.toJavaClass().isInstance(attrib)) {
            Date d = this.parse(attrib);
            if (d != null) {
                attrib = new Timestamp(d.getTime());
                this.setAttribute(i, attrib);
            } else {
                attrib = null;
            }
        }
        return attrib;
    }

    private Date parse(Object dateObject) {
        Date d = null;
        if (Date.class.isInstance(dateObject)) {
            d = (Date)dateObject;
        } else {
            try {
                if (!schemaToFlexDateParser.containsKey(this.getSchema())) {
                    FlexibleDateParser fdp = new FlexibleDateParser();
                    fdp.cachingEnabled(true);
                    schemaToFlexDateParser.put(this.getSchema(), fdp);
                }
                d = schemaToFlexDateParser.get(this.getSchema()).parse(dateObject.toString(), false);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return d;
    }

    @Override
    public Object[] getAttributes() {
        int length = this.getSchema().getAttributeCount();
        Object[] copy = new Object[length];
        for (int i = 0; i < length; ++i) {
            copy[i] = this.getAttribute(i);
        }
        return copy;
    }

    @Override
    public void setAttribute(int attributeIndex, Object newAttribute) {
        FeatureSchema schema = super.getSchema();
        Object[] oldAttribs = super.getAttributes();
        int diffCount = schema.getAttributeCount() - oldAttribs.length;
        if (diffCount > 0) {
            ArrayList<Object> attributes = new ArrayList<Object>(Arrays.asList(oldAttribs));
            attributes.addAll(Arrays.asList(new Object[diffCount]));
            super.setAttributes(attributes.toArray());
        }
        super.setAttribute(attributeIndex, newAttribute);
    }

    @Override
    public void setGeometry(Geometry geometry) {
        this.setAttribute(this.getSchema().getGeometryIndex(), (Object)geometry);
    }

    @Override
    public Geometry getGeometry() {
        return (Geometry)this.getAttribute(this.getSchema().getGeometryIndex());
    }
}

