/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.spatialite;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.datastore.DataStoreConnection;
import com.vividsolutions.jump.datastore.spatialdatabases.AbstractSpatialDatabasesDSDriver;
import com.vividsolutions.jump.datastore.spatialite.SpatialiteDSConnection;
import com.vividsolutions.jump.datastore.spatialite.SpatialiteDSMetadata;
import com.vividsolutions.jump.parameter.ParameterList;
import com.vividsolutions.jump.parameter.ParameterListSchema;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.io.File;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class SpatialiteDataStoreDriver
extends AbstractSpatialDatabasesDSDriver {
    public static final String JDBC_CLASS = "org.sqlite.JDBC";
    private String spatialiteVersion = "not connected";

    public SpatialiteDataStoreDriver() {
        this.driverName = "Spatialite";
        this.jdbcClass = JDBC_CLASS;
        this.urlPrefix = "jdbc:sqlite:";
        this.paramNames = new String[]{"DB file"};
        this.paramClasses = new Class[]{File.class};
        this.schema = new ParameterListSchema(this.paramNames, this.paramClasses);
    }

    @Override
    public String getVersion() {
        return super.getVersion() + " (Spatialite " + this.spatialiteVersion + ")";
    }

    @Override
    public DataStoreConnection createConnection(ParameterList params) throws Exception {
        String database = params.getParameter("DB file").toString();
        File sqliteFile = new File(database);
        if (!sqliteFile.exists() || !sqliteFile.canRead()) {
            throw new Exception(I18N.getInstance().get("com.vividsolutions.jump.datastore.spatialite.SpatialiteDataStoreDriver.file-does-not-exist", database));
        }
        Class<?> configClazz = Class.forName("org.sqlite.SQLiteConfig");
        Method enableMethod = configClazz.getMethod("enableLoadExtension", Boolean.TYPE);
        Object config = configClazz.newInstance();
        enableMethod.invoke(config, true);
        Method getPropsMethod = configClazz.getMethod("toProperties", new Class[0]);
        Properties props = (Properties)getPropsMethod.invoke(config, new Object[0]);
        Connection conn = super.createJdbcConnection(params, props);
        SpatialiteDSConnection dsConn = new SpatialiteDSConnection(conn);
        this.spatialiteVersion = ((SpatialiteDSMetadata)dsConn.getMetadata()).getSpatialiteVersion();
        if (this.spatialiteVersion.isEmpty()) {
            this.spatialiteVersion = "unavailable";
        }
        return dsConn;
    }

    @Override
    public Icon getConnectedIcon() {
        return IconLoader.icon("ok_spatialite.png");
    }

    @Override
    public Icon getDisconnectedIcon() {
        return GUIUtil.toGrayScale((ImageIcon)this.getConnectedIcon());
    }
}

