/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.spatialite;

import com.vividsolutions.jump.datastore.DataStoreConnection;
import com.vividsolutions.jump.datastore.DataStoreLayer;
import com.vividsolutions.jump.datastore.GeometryColumn;
import com.vividsolutions.jump.datastore.SQLUtil;
import com.vividsolutions.jump.datastore.jdbc.JDBCUtil;
import com.vividsolutions.jump.datastore.jdbc.ResultSetBlock;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesDSMetadata;
import com.vividsolutions.jump.datastore.spatialite.GeometricColumnType;
import com.vividsolutions.jump.datastore.spatialite.GeometryColumnsLayout;
import com.vividsolutions.jump.workbench.Logger;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SpatialiteDSMetadata
extends SpatialDatabasesDSMetadata {
    public static String GC_COLUMN_NAME = "geometry_columns";
    public static String GPKG_GC_COLUMN_NAME = "gpkg_geometry_columns";
    private boolean spatialiteLoaded;
    private String spatialiteVersion;
    private GeometryColumnsLayout geometryColumnsLayout;
    private Map<String, GeometricColumnType> geoColTypesdMap = null;
    private String geoColumnTypesQuery = null;
    private String spatialIndexQuery = null;
    private Map<String, List<GeometryColumn>> geometryColumnListMap = null;

    public SpatialiteDSMetadata(DataStoreConnection con) {
        this.conn = con;
        this.spatialiteLoaded = false;
        this.spatialiteVersion = "";
        this.geometryColumnsLayout = GeometryColumnsLayout.NO_LAYOUT;
        this.geoColTypesdMap = new HashMap<String, GeometricColumnType>();
        this.geometryColumnListMap = new HashMap<String, List<GeometryColumn>>();
        this.checkSpatialiteLoaded();
        this.setGeoColLayout();
        this.geoColumnTypesQuery = "select f_table_name, f_geometry_column, \"SPATIALITE\" as geometry_format from geometry_columns";
        if (this.getGeometryColumnsLayout() == GeometryColumnsLayout.FDO_LAYOUT) {
            this.geoColumnTypesQuery = "select f_table_name, f_geometry_column, geometry_format from geometry_columns";
        } else if (this.getGeometryColumnsLayout() == GeometryColumnsLayout.OGC_GEOPACKAGE_LAYOUT) {
            this.geoColumnTypesQuery = "select table_name as f_table_name, column_name as f_geometry_columns, \"SPATIALITE\" as geometry_format  from gpkg_geometry_columns";
        }
        this.getGeoColumnType();
        this.datasetNameQuery = "SELECT DISTINCT '' as f_table_schema, f_table_name FROM geometry_columns";
        if (this.getGeometryColumnsLayout() == GeometryColumnsLayout.OGC_GEOPACKAGE_LAYOUT) {
            this.datasetNameQuery = "SELECT DISTINCT '' as f_table_schema, table_name as f_table_name FROM gpkg_geometry_columns";
        }
        this.defaultSchemaName = "";
        this.spatialDbName = this.isSpatialiteLoaded() ? "Spatialite" : "SQLite";
        this.spatialExtentQuery1 = "SELECT %s from \"%s\"";
        this.spatialExtentQuery2 = null;
        this.sridQuery = this.geometryColumnsLayout == GeometryColumnsLayout.OGC_GEOPACKAGE_LAYOUT ? "SELECT srs_id FROM gpkg_geometry_columns where table_name = '%s' and column_name = '%s'" : "SELECT srid FROM geometry_columns where f_table_name = '%s' and f_geometry_column = '%s'";
        this.geoColumnsQuery = this.geometryColumnsLayout == GeometryColumnsLayout.FDO_LAYOUT || this.geometryColumnsLayout == GeometryColumnsLayout.OGC_OGR_LAYOUT ? "SELECT f_geometry_column, coord_dimension, srid,\n  case\n    when geometry_type = 1 then 'POINT'\n    when geometry_type = 2 then 'LINESTRING'\n    when geometry_type = 3 then 'POLYGON'\n    when geometry_type = 4 then 'MULTIPOINT'\n    when geometry_type = 5 then 'MULTILINESTRING'\n    when geometry_type = 6 then 'MULTIPOLYGON'\n    when geometry_type = 7 then 'GEOMETRY COLLECTION'\n    else geometry_type end as geometry_type\nFROM geometry_columns where f_table_name = '%s'" : (this.geometryColumnsLayout == GeometryColumnsLayout.OGC_SPATIALITE_LAYOUT ? "SELECT f_geometry_column, coord_dimension, srid, type FROM geometry_columns where f_table_name = '%s'" : (this.geometryColumnsLayout == GeometryColumnsLayout.OGC_GEOPACKAGE_LAYOUT ? "SELECT column_name, case when z+m = 0 then 2 when z = 1 and m = 1 then 4 else 3 end as coord_dimension, srs_id, geometry_type_name FROM gpkg_geometry_columns where table_name = '%s'" : "SELECT '' "));
        this.coordDimQuery = this.geometryColumnsLayout == GeometryColumnsLayout.OGC_GEOPACKAGE_LAYOUT ? "SELECT case when z+m = 0 then 2 when z = 1 and m = 1 then 4 else 3 end as coord_dimension FROM gpkg_geometry_columns where table_name = '%s' and column_name = '%s'" : "SELECT coord_dimension FROM geometry_columns where f_table_name = '%s' and f_geometry_column = '%s'";
        this.spatialIndexQuery = this.geometryColumnsLayout == GeometryColumnsLayout.OGC_GEOPACKAGE_LAYOUT ? "select exists(SELECT name FROM sqlite_master WHERE type = 'table' AND name = 'rtree_%s_%s')" : (this.spatialiteLoaded ? "SELECT CASE WHEN CheckSpatialIndex('%s', '%s') = 1 then 1 else 0 end as isindexed" : (this.geometryColumnsLayout == GeometryColumnsLayout.OGC_SPATIALITE_LAYOUT ? "select spatial_index_enabled from geometry_columns where f_table_name = '%s' and f_geometry_column = '%s'" : (this.geometryColumnsLayout == GeometryColumnsLayout.OGC_OGR_LAYOUT ? "select spatial_index_enabled from geometry_columns where f_table_name = '%s' and f_geometry_column = '%s'" : "")));
        this.datasetInfoQuery = this.geometryColumnsLayout == GeometryColumnsLayout.FDO_LAYOUT || this.geometryColumnsLayout == GeometryColumnsLayout.OGC_OGR_LAYOUT ? "SELECT '' as f_table_schema, f_table_name, f_geometry_column, coord_dimension, srid,\n  case\n    when geometry_type = 1 then 'POINT'\n    when geometry_type = 2 then 'LINESTRING'\n    when geometry_type = 3 then 'POLYGON'\n    when geometry_type = 4 then 'MULTIPOINT'\n    when geometry_type = 5 then 'MULTILINESTRING'\n    when geometry_type = 6 then 'MULTIPOLYGON'\n    when geometry_type = 7 then 'GEOMETRY COLLECTION'\n    else geometry_type end as geometry_type\nFROM geometry_columns" : (this.geometryColumnsLayout == GeometryColumnsLayout.OGC_SPATIALITE_LAYOUT ? "SELECT '' as f_table_schema, f_table_name, f_geometry_column, coord_dimension, srid, type FROM geometry_columns" : (this.geometryColumnsLayout == GeometryColumnsLayout.OGC_GEOPACKAGE_LAYOUT ? "SELECT '' as table_schema, table_name, column_name, case when z+m = 0 then 2 when z = 1 and m = 1 then 4 else 3 end as coord_dimension, srs_id, geometry_type_name FROM gpkg_geometry_columns" : "SELECT '' "));
    }

    @Override
    protected List<GeometryColumn> getGeometryAttributes(String sql, String datasetName) {
        if (this.geometryColumnListMap.get(datasetName) == null) {
            final ArrayList geometryAttributes = new ArrayList();
            JDBCUtil.execute(this.conn.getJdbcConnection(), sql, new ResultSetBlock(){

                @Override
                public void yield(ResultSet resultSet) throws SQLException {
                    while (resultSet.next()) {
                        geometryAttributes.add(new GeometryColumn(resultSet.getString(1), resultSet.getInt(2), resultSet.getInt(3), resultSet.getString(4)));
                    }
                }
            });
            for (GeometryColumn gc : geometryAttributes) {
                this.setIndexInfo(datasetName, gc);
            }
            this.geometryColumnListMap.put(datasetName, geometryAttributes);
        }
        return this.geometryColumnListMap.get(datasetName);
    }

    @Override
    public String getSpatialExtentQuery1(String schema, String table, String attributeName) {
        String ret = "select 1";
        GeometricColumnType gcType = this.geoColTypesdMap.get(table.toLowerCase() + "." + attributeName.toLowerCase());
        if (gcType == null) {
            return "select 1";
        }
        if (this.isSpatialiteLoaded()) {
            if (gcType == GeometricColumnType.WKB) {
                ret = String.format("select st_asBinary(extent(st_geomFromWkb(%s))) from \"%s\"", attributeName, table);
            } else if (gcType == GeometricColumnType.WKT) {
                ret = String.format("select st_asBinary(extent(st_geomFromText(%s))) from \"%s\"", attributeName, table);
            } else if (gcType == GeometricColumnType.SPATIALITE) {
                ret = String.format("select st_asBinary(extent(CastAutomagic(%s))) from \"%s\"", attributeName, table);
            } else {
                Logger.warn("Unknown geo column type for: " + table + "." + attributeName + " : " + (Object)((Object)gcType));
                ret = "select 1";
            }
        } else {
            ret = "select 1";
        }
        return ret;
    }

    @Override
    public String getSpatialExtentQuery2(String schema, String table, String attributeName) {
        return this.spatialExtentQuery2;
    }

    @Override
    public String getGeoColumnsQuery(String datasetName) {
        return String.format(this.geoColumnsQuery, SQLUtil.escapeSingleQuote(this.getTableName(datasetName)));
    }

    @Override
    public String getSridQuery(String schemaName, String tableName, String colName) {
        return String.format(this.sridQuery, SQLUtil.escapeSingleQuote(tableName), SQLUtil.escapeSingleQuote(colName));
    }

    private void checkSpatialiteLoaded() {
        Logger.trace("PATH -> " + System.getenv("PATH"));
        Statement stmt = null;
        try {
            stmt = this.conn.getJdbcConnection().createStatement();
            stmt.executeUpdate("SELECT load_extension('mod_spatialite')");
            this.spatialiteLoaded = true;
            ResultSet rs = stmt.executeQuery("select spatialite_version()");
            rs.next();
            this.setSpatialiteVersion(rs.getString(1));
            Logger.info("sqlite mod_spatialite version " + this.getSpatialiteVersion() + " loaded successfully.");
        }
        catch (Exception e) {
            Logger.warn("FAILED to load sqlite extension mod_spatialite.", e);
        }
        finally {
            try {
                stmt.close();
            }
            catch (Throwable th) {
                Logger.error(th);
            }
        }
    }

    private void setGeoColLayout() {
        DatabaseMetaData dbMd = null;
        try {
            dbMd = this.conn.getJdbcConnection().getMetaData();
            ResultSet rs = dbMd.getTables(null, null, GPKG_GC_COLUMN_NAME, null);
            if (rs.next()) {
                this.geometryColumnsLayout = GeometryColumnsLayout.OGC_GEOPACKAGE_LAYOUT;
                rs.close();
            } else {
                rs = dbMd.getTables(null, null, GC_COLUMN_NAME, null);
                if (rs.next()) {
                    boolean isGC;
                    String col = rs.getString(3);
                    boolean bl = isGC = GC_COLUMN_NAME.equalsIgnoreCase(col) || GPKG_GC_COLUMN_NAME.equalsIgnoreCase(col);
                    if (isGC) {
                        rs = dbMd.getColumns(null, null, GC_COLUMN_NAME, null);
                        int i = 0;
                        String geoTypeCol = "";
                        String extraInfoCol = "";
                        while (rs.next()) {
                            if (i == 2) {
                                geoTypeCol = rs.getString(4);
                            }
                            if (i == 5) {
                                extraInfoCol = rs.getString(4);
                            }
                            ++i;
                        }
                        this.geometryColumnsLayout = "geometry_type".equalsIgnoreCase(geoTypeCol) && "geometry_format".equalsIgnoreCase(extraInfoCol) ? GeometryColumnsLayout.FDO_LAYOUT : ("type".equalsIgnoreCase(geoTypeCol) && "spatial_index_enabled".equalsIgnoreCase(extraInfoCol) ? GeometryColumnsLayout.OGC_SPATIALITE_LAYOUT : ("geometry_type".equalsIgnoreCase(geoTypeCol) && "spatial_index_enabled".equalsIgnoreCase(extraInfoCol) ? GeometryColumnsLayout.OGC_OGR_LAYOUT : GeometryColumnsLayout.NO_LAYOUT));
                        rs.close();
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.error("Error getting geometry_column layout.", e);
        }
    }

    private void getGeoColumnType() {
        try {
            JDBCUtil.execute(this.conn.getJdbcConnection(), this.geoColumnTypesQuery, new ResultSetBlock(){

                @Override
                public void yield(ResultSet resultSet) throws SQLException {
                    while (resultSet.next()) {
                        String table = resultSet.getString(1).toLowerCase();
                        String col = resultSet.getString(2).toLowerCase();
                        GeometricColumnType gcType = GeometricColumnType.valueOf(resultSet.getString(3));
                        SpatialiteDSMetadata.this.geoColTypesdMap.put(table + "." + col, gcType);
                    }
                }
            });
        }
        catch (Exception e) {
            Logger.error("Cannot get geometric column type!", e);
        }
    }

    public boolean isSpatialiteLoaded() {
        return this.spatialiteLoaded;
    }

    public String getSpatialiteVersion() {
        return this.spatialiteVersion;
    }

    public void setSpatialiteVersion(String spatialiteVersion) {
        this.spatialiteVersion = spatialiteVersion;
    }

    public GeometryColumnsLayout getGeometryColumnsLayout() {
        return this.geometryColumnsLayout;
    }

    public Map<String, GeometricColumnType> getGeoColTypesdMap() {
        return this.geoColTypesdMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setIndexInfo(String datasetName, final GeometryColumn gc) {
        String q = String.format(Locale.US, this.spatialIndexQuery, datasetName, gc.getName());
        try {
            JDBCUtil.execute(this.conn.getJdbcConnection(), q, new ResultSetBlock(){

                @Override
                public void yield(ResultSet resultSet) throws SQLException {
                    while (resultSet.next()) {
                        gc.setIndexed(resultSet.getBoolean(1));
                    }
                }
            });
        }
        catch (Exception e) {
            Logger.error("Error setting index information!", e);
        }
        finally {
            if (gc.isIndexed() == null) {
                gc.setIndexed(false);
            }
        }
    }

    public GeometryColumn getGeometryColumn(String datasetName, String geoCol) {
        List<GeometryColumn> l = this.geometryColumnListMap.get(datasetName);
        if (l == null) {
            if (this.dataStoreLayers != null) {
                for (DataStoreLayer dsl : this.dataStoreLayers) {
                    if (!datasetName.equals(dsl.getFullName()) || !geoCol.equals(dsl.getGeoCol().getName())) continue;
                    return dsl.getGeoCol();
                }
            }
            return null;
        }
        for (GeometryColumn gc : l) {
            if (!gc.getName().equals(geoCol)) continue;
            return gc;
        }
        return null;
    }
}

