/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.spatialdatabases;

import com.vividsolutions.jump.datastore.jdbc.ValueConverter;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesValueConverterFactory;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.FlexibleFeature;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class SpatialDatabasesResultSetConverter {
    protected ResultSet rs;
    protected FeatureSchema featureSchema;
    protected ValueConverter[] mapper;
    protected SpatialDatabasesValueConverterFactory odm;
    protected boolean isInitialized = false;

    public SpatialDatabasesResultSetConverter() {
    }

    public SpatialDatabasesResultSetConverter(Connection conn, ResultSet rs) {
        this.rs = rs;
        this.odm = new SpatialDatabasesValueConverterFactory(conn);
    }

    public FeatureSchema getFeatureSchema() throws SQLException {
        this.init();
        return this.featureSchema;
    }

    public Feature getFeature() throws Exception {
        this.init();
        FlexibleFeature f = new FlexibleFeature(this.featureSchema);
        for (int i = 0; i < this.mapper.length; ++i) {
            f.setAttribute(i, this.mapper[i].getValue(this.rs, i + 1));
        }
        return f;
    }

    private void init() throws SQLException {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        ResultSetMetaData rsmd = this.rs.getMetaData();
        int numberOfColumns = rsmd.getColumnCount();
        this.mapper = new ValueConverter[numberOfColumns];
        this.featureSchema = new FeatureSchema();
        for (int i = 0; i < numberOfColumns; ++i) {
            this.mapper[i] = this.odm.getConverter(rsmd, i + 1);
            String colName = rsmd.getColumnName(i + 1);
            if (this.mapper[i].getType() == AttributeType.GEOMETRY) {
                if (this.featureSchema.getGeometryIndex() == -1) {
                    this.featureSchema.addAttribute(colName, this.mapper[i].getType());
                    continue;
                }
                this.featureSchema.addAttribute(colName, AttributeType.OBJECT);
                this.featureSchema.setAttributeReadOnly(i, true);
                continue;
            }
            this.featureSchema.addAttribute(colName, this.mapper[i].getType());
            if (!rsmd.isReadOnly(i + 1)) continue;
            this.featureSchema.setAttributeReadOnly(i, true);
        }
    }
}

