/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.oracle;

import com.vividsolutions.jump.datastore.jdbc.ValueConverter;
import com.vividsolutions.jump.datastore.jdbc.ValueConverterFactory;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesValueConverterFactory;
import com.vividsolutions.jump.feature.AttributeType;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.locationtech.jts.io.ParseException;

public class OracleValueConverterFactory
extends SpatialDatabasesValueConverterFactory {
    protected final ValueConverter ORA_STRUCT_GEOMETRY_MAPPER = new OracleStructGeometryValueConverter();

    public OracleValueConverterFactory(Connection conn) {
        super(conn);
    }

    @Override
    public ValueConverter getConverter(ResultSetMetaData rsm, int columnIndex) throws SQLException {
        String dbTypeName = rsm.getColumnTypeName(columnIndex);
        if (dbTypeName.equalsIgnoreCase("MDSYS.SDO_GEOMETRY")) {
            return this.ORA_STRUCT_GEOMETRY_MAPPER;
        }
        ValueConverter stdConverter = ValueConverterFactory.getConverter(rsm, columnIndex);
        if (stdConverter != null) {
            return stdConverter;
        }
        return ValueConverterFactory.STRING_MAPPER;
    }

    class OracleStructGeometryValueConverter
    implements ValueConverter {
        OracleStructGeometryValueConverter() {
        }

        @Override
        public AttributeType getType() {
            return AttributeType.GEOMETRY;
        }

        @Override
        public Object getValue(ResultSet rs, int columnIndex) throws IOException, SQLException, ParseException, ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Object geometryObject = rs.getObject(columnIndex);
            ClassLoader cl = this.getClass().getClassLoader();
            Class<?> converterClazz = Class.forName("org.geotools.data.oracle.sdo.GeometryConverter", true, cl);
            Class<?> connectionClazz = Class.forName("oracle.jdbc.OracleConnection", true, cl);
            Class<?> structClazz = Class.forName("oracle.sql.STRUCT", true, cl);
            Method converterMethod = converterClazz.getMethod("asGeometry", structClazz);
            Constructor<?> constructor = converterClazz.getDeclaredConstructor(connectionClazz);
            Object converter = constructor.newInstance(connectionClazz.cast(rs.getStatement().getConnection()));
            return converterMethod.invoke(converter, structClazz.cast(geometryObject));
        }
    }
}

