/*
 * Decompiled with CFR 0.152.
 */
package org.saig.jump.widgets.config;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.ui.OptionsPanelV2;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.saig.core.gui.swing.sldeditor.util.FormUtils;

public class ConfigTooltipPanel
extends OptionsPanelV2 {
    private Blackboard blackboard;
    private JPanel tooltipPanel;
    private JCheckBox tooltipCheck;
    public static final String NAME = "Configure Tooltip";
    public static final Icon ICON = null;
    public static final String LAYER_TOOLTIPS_ON = ConfigTooltipPanel.class.getName() + " - LAYER_TOOLTIPS";

    public ConfigTooltipPanel(Blackboard blackboard) {
        this.blackboard = blackboard;
        this.setLayout(new GridBagLayout());
        FormUtils.addRowInGBL(this, 1, 0, this.getTooltipPanel());
        FormUtils.addFiller(this, 2, 0);
    }

    private JPanel getTooltipPanel() {
        if (this.tooltipPanel == null) {
            this.tooltipPanel = new JPanel(new GridBagLayout());
            this.tooltipPanel.setBorder(BorderFactory.createTitledBorder(I18N.getInstance().get("Configure layer tree tooltip")));
            this.tooltipCheck = new JCheckBox("Enable JUMP basic tooltips");
            FormUtils.addRowInGBL(this.tooltipPanel, 0, 0, this.tooltipCheck);
        }
        return this.tooltipPanel;
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void init() {
        boolean layerTooltipsOn = PersistentBlackboardPlugIn.get(this.blackboard).get(LAYER_TOOLTIPS_ON, false);
        if (layerTooltipsOn) {
            this.tooltipCheck.setSelected(true);
        }
    }

    @Override
    public void okPressed() {
        PersistentBlackboardPlugIn.get(this.blackboard).put(LAYER_TOOLTIPS_ON, this.tooltipCheck.isSelected());
    }

    @Override
    public String validateInput() {
        return null;
    }
}

