/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.sextante.gui.additionalResults;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.FeatureCollectionPanel;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.HTMLPanel;
import it.betastudio.adbtoolbox.libs.DxfExport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.namespace.QName;
import org.math.plot.PlotPanel;
import org.math.plot.plots.Plot;
import org.openjump.core.apitools.IOTools;
import org.openjump.core.ui.io.file.FileNameExtensionFilter;
import org.openjump.core.ui.swing.DetachableInternalFrame;
import org.openjump.core.ui.util.LayerableUtil;
import org.openjump.sextante.core.ObjectAndDescription;
import org.openjump.sextante.gui.additionalResults.AdditionalResults;
import org.openjump.sextante.gui.additionalResults.AdditionalResultsTreeCellRenderer;

public class AdditionalResultsFrame
extends DetachableInternalFrame {
    private final String name = I18N.getInstance().get("org.openjump.sextante.gui.additionalResults.AdditionalResultsPlugIn.Result-viewer");
    private final String sMenu = I18N.getInstance().get("org.openjump.sextante.gui.additionalResults.AdditionalResultsPlugIn.Menu");
    private final String sRemove = I18N.getInstance().get("org.openjump.sextante.gui.additionalResults.AdditionalResultsPlugIn.Remove");
    private final String sRename = I18N.getInstance().get("org.openjump.sextante.gui.additionalResults.AdditionalResultsPlugIn.Rename");
    private final String sSave = I18N.getInstance().get("deejump.plugin.SaveLegendPlugIn.Save");
    private final String sWriteName = I18N.getInstance().get("org.openjump.sextante.gui.additionalResults.AdditionalResultsPlugIn.Write-name");
    private final String sChangeName = I18N.getInstance().get("org.openjump.sextante.gui.additionalResults.AdditionalResultsPlugIn.Change-name");
    private final String sSaved = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.file.saved");
    private final String SCouldNotSave = I18N.getInstance().get("org.openjump.sextante.gui.additionalResults.AdditionalResultsPlugIn.Could-not-save-selected-result");
    private final String sProcessing = I18N.getInstance().get("org.openjump.sextante.gui.additionalResults.AdditionalResultsPlugIn.Processing");
    private final String sResult = I18N.getInstance().get("org.openjump.sextante.gui.additionalResults.AdditionalResultsPlugIn.Result");
    private final String SAVE = I18N.getInstance().get("deejump.plugin.SaveLegendPlugIn.Save");
    private final String CLOSE = I18N.getInstance().get("ui.plugin.imagery.ImageLayerManagerDialog.Close");
    public static final String HEIGHT = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.values");
    public static final String WIDTH = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.2d-distance");
    private static final long serialVersionUID = 1L;
    private JSplitPane jSplitPane;
    private JTree jTree;
    private TreePath m_Path;
    private JScrollPane jScrollPane;
    private JMenuItem menuItemSave;
    private JPopupMenu popupMenu;
    private JMenuItem menuItemRemove;
    private JMenuItem menuItemRename;
    public static WorkbenchContext workbenchContext = JUMPWorkbench.getInstance().getContext();

    public JSplitPane getSplitPanel() {
        return this.jSplitPane;
    }

    public AdditionalResultsFrame(ArrayList<?> components) {
        this.initGUI(components);
        this.setTitle(this.name);
        this.setResizable(true);
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setPreferredSize(new Dimension(900, 700));
        this.setSize(900, 700);
        this.setLayer(JLayeredPane.MODAL_LAYER);
    }

    public Icon getColorIcon() {
        ImageIcon icon = new ImageIcon(this.getClass().getResource("application_view.png"));
        return GUIUtil.toSmallIcon(icon);
    }

    private boolean initGUI(ArrayList<?> components) {
        JPanel panel = new JPanel();
        BorderLayout thisLayout = new BorderLayout();
        panel.setLayout(thisLayout);
        this.setContentPane(panel);
        if (components.size() == 0) {
            return false;
        }
        try {
            this.setPreferredSize(new Dimension(900, 450));
            this.setSize(new Dimension(900, 450));
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setDividerSize(9);
            this.jSplitPane.setContinuousLayout(true);
            this.jSplitPane.setOneTouchExpandable(true);
            this.jSplitPane.setDividerLocation(200);
            panel.add((Component)this.jSplitPane, "Center");
            panel.add((Component)this.getOKSavePanel(), "South");
            this.jTree = new JTree();
            this.jTree.setCellRenderer(new AdditionalResultsTreeCellRenderer());
            MouseAdapter ml = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    AdditionalResultsFrame.this.m_Path = AdditionalResultsFrame.this.jTree.getPathForLocation(e.getX(), e.getY());
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)AdditionalResultsFrame.this.m_Path.getLastPathComponent();
                    if (node.getUserObject() instanceof ObjectAndDescription) {
                        AdditionalResultsFrame.this.showComponent();
                        if (e.getButton() == 3 && AdditionalResultsFrame.this.m_Path != null) {
                            AdditionalResultsFrame.this.showPopupMenu(e);
                        }
                    }
                }
            };
            this.jTree.addMouseListener(ml);
            this.fillTree(components);
            if (components.size() > 0) {
                DefaultMutableTreeNode node = this.findNode((ObjectAndDescription)components.get(components.size() - 1));
                DefaultTreeModel model = (DefaultTreeModel)this.jTree.getModel();
                TreePath path = new TreePath(model.getPathToRoot(node));
                this.jTree.setSelectionPath(path);
                this.jTree.scrollPathToVisible(path);
                this.m_Path = path;
                this.showComponent();
            }
            this.jScrollPane = new JScrollPane(this.jTree, 22, 30);
            this.jScrollPane.setPreferredSize(new Dimension(200, 450));
            this.jScrollPane.setMaximumSize(new Dimension(200, 450));
            this.jSplitPane.add((Component)this.jScrollPane, "left");
            this.popupMenu = new JPopupMenu(this.sMenu);
            this.menuItemSave = new JMenuItem(this.sSave);
            this.menuItemSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (AdditionalResultsFrame.this.m_Path != null) {
                        try {
                            DefaultMutableTreeNode node = (DefaultMutableTreeNode)AdditionalResultsFrame.this.m_Path.getLastPathComponent();
                            if (node.getUserObject() instanceof ObjectAndDescription) {
                                AdditionalResultsFrame.this.save();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            this.popupMenu.add(this.menuItemSave);
            this.menuItemRemove = new JMenuItem(this.sRemove);
            this.menuItemRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (AdditionalResultsFrame.this.m_Path != null) {
                        try {
                            DefaultMutableTreeNode node = (DefaultMutableTreeNode)AdditionalResultsFrame.this.m_Path.getLastPathComponent();
                            if (node.getUserObject() instanceof ObjectAndDescription) {
                                AdditionalResultsFrame.this.remove();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            this.popupMenu.add(this.menuItemRemove);
            this.menuItemRename = new JMenuItem(this.sRename);
            this.menuItemRename.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (AdditionalResultsFrame.this.m_Path != null) {
                        try {
                            DefaultMutableTreeNode node = (DefaultMutableTreeNode)AdditionalResultsFrame.this.m_Path.getLastPathComponent();
                            if (node.getUserObject() instanceof ObjectAndDescription) {
                                AdditionalResultsFrame.this.rename();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            this.popupMenu.add(this.menuItemRename);
            panel.updateUI();
            return true;
        }
        catch (Exception e) {
            AdditionalResultsFrame.Logger(this.getClass(), e);
            return false;
        }
    }

    public Component getLeftPanel() {
        return this.jSplitPane.getLeftComponent();
    }

    public Component getRightPanel() {
        return this.jSplitPane.getRightComponent();
    }

    public JPopupMenu getPopupMen() {
        return this.popupMenu;
    }

    protected void showPopupMenu(MouseEvent e) {
        this.jTree.setSelectionPath(this.m_Path);
        this.menuItemSave.setEnabled(true);
        this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    private void rename() {
        if (this.m_Path != null) {
            try {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_Path.getLastPathComponent();
                ObjectAndDescription oad = (ObjectAndDescription)node.getUserObject();
                String sName = oad.getDescription();
                JOptionPane pane = new JOptionPane();
                pane.setMessage(this.sWriteName);
                pane.setMessageType(3);
                pane.setWantsInput(true);
                pane.setInitialSelectionValue(sName);
                pane.setInputValue(sName);
                JDialog dlg = pane.createDialog(null, this.sChangeName);
                dlg.setModal(true);
                dlg.setVisible(true);
                String sNewName = pane.getInputValue().toString().trim();
                if (sNewName != null && sNewName.length() != 0) {
                    oad.setDescription(sNewName);
                }
                this.update();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void remove() {
        if (this.m_Path != null) {
            try {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_Path.getLastPathComponent();
                ObjectAndDescription oad = (ObjectAndDescription)node.getUserObject();
                AdditionalResults.removeComponent(oad);
                this.update();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void save() {
        if (this.m_Path != null) {
            try {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_Path.getLastPathComponent();
                ObjectAndDescription oad = (ObjectAndDescription)node.getUserObject();
                Component c = (Component)oad.getObject();
                if (c instanceof FeatureCollectionPanel) {
                    FeatureCollectionPanel panel = (FeatureCollectionPanel)c;
                    FeatureCollection fcoll = panel.getFeatureCollection();
                    FileNameExtensionFilter filter2 = new FileNameExtensionFilter("Comma-Separated Values (csv)", "csv");
                    FileNameExtensionFilter filter3 = new FileNameExtensionFilter("JUMP Markup Language (JML)", "jml");
                    FileNameExtensionFilter filter = new FileNameExtensionFilter("ESRI Shapefile (SHP)", "shp");
                    GUIUtil.FileChooserWithOverwritePrompting fc = new GUIUtil.FileChooserWithOverwritePrompting();
                    if (!LayerableUtil.isMixedGeometryType(fcoll)) {
                        fc.setFileFilter(filter);
                    }
                    fc.setFileFilter(filter3);
                    fc.setFileFilter(filter2);
                    fc.addChoosableFileFilter(filter2);
                    int returnVal = fc.showSaveDialog(this);
                    if (returnVal == 0) {
                        if (fc.getFileFilter().equals(filter3)) {
                            File file = new File(((JFileChooser)fc).getSelectedFile() + ".jml");
                            IOTools.saveJMLFile(fcoll, file.getAbsolutePath());
                            this.saved(file);
                        } else if (fc.getFileFilter().equals(filter)) {
                            File file = new File(((JFileChooser)fc).getSelectedFile() + ".shp");
                            IOTools.saveShapefile(fcoll, file.getAbsolutePath());
                            this.saved(file);
                        } else if (fc.getFileFilter().equals(filter2)) {
                            JTable table = panel.getTable();
                            File file = new File(((JFileChooser)fc).getSelectedFile() + ".csv");
                            IOTools.saveCSV(table, file.getAbsolutePath());
                            this.saved(file);
                        }
                    }
                } else if (c instanceof JScrollPane) {
                    JScrollPane pane = (JScrollPane)c;
                    Component view = pane.getViewport().getView();
                    if (view instanceof JTextPane || view instanceof JLabel || view instanceof JTextArea) {
                        JTextPane text = (JTextPane)pane.getViewport().getView();
                        GUIUtil.FileChooserWithOverwritePrompting fc = new GUIUtil.FileChooserWithOverwritePrompting("html");
                        FileNameExtensionFilter filter = new FileNameExtensionFilter("HTML", "html");
                        fc.setFileFilter(filter);
                        fc.addChoosableFileFilter(filter);
                        int returnVal = fc.showSaveDialog(this);
                        fc.getWidth();
                        fc.getHeight();
                        if (returnVal == 0) {
                            try {
                                File file = new File(((JFileChooser)fc).getSelectedFile() + ".html");
                                file.getParent();
                                FileWriter fileWriter = new FileWriter(file);
                                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                                bufferedWriter.write(text.getText());
                                bufferedWriter.close();
                                this.saved(file);
                            }
                            catch (Exception e) {
                                this.notsaved();
                                AdditionalResultsFrame.Logger(this.getClass(), e);
                            }
                        }
                    } else if (view instanceof JTable) {
                        JTable table = (JTable)pane.getViewport().getView();
                        FileNameExtensionFilter filter = new FileNameExtensionFilter("Comma-Separated Values (csv)", "csv");
                        GUIUtil.FileChooserWithOverwritePrompting fc = new GUIUtil.FileChooserWithOverwritePrompting("csv");
                        fc.setFileFilter(filter);
                        fc.addChoosableFileFilter(filter);
                        int returnVal = fc.showSaveDialog(this);
                        fc.getWidth();
                        fc.getHeight();
                        if (returnVal == 0) {
                            File file = new File(((JFileChooser)fc).getSelectedFile() + ".csv");
                            IOTools.saveCSV(table, file.getAbsolutePath());
                        } else if (returnVal == 1) {
                            return;
                        }
                    } else if (view instanceof JPanel) {
                        JPanel panel = (JPanel)pane.getViewport().getView();
                        int w = panel.getWidth();
                        int h = panel.getHeight();
                        BufferedImage bi = new BufferedImage(w, h, 1);
                        Graphics2D g = bi.createGraphics();
                        panel.paint(g);
                        FileNameExtensionFilter filter = new FileNameExtensionFilter("Portable Network Graphics (png)", "png");
                        GUIUtil.FileChooserWithOverwritePrompting fc = new GUIUtil.FileChooserWithOverwritePrompting("png");
                        fc.setFileFilter(filter);
                        fc.addChoosableFileFilter(filter);
                        int returnVal = fc.showSaveDialog(this);
                        fc.getWidth();
                        fc.getHeight();
                        if (returnVal == 0) {
                            try {
                                File file = new File(((JFileChooser)fc).getSelectedFile() + ".png");
                                ImageIO.write((RenderedImage)bi, "png", file);
                                this.saved(file);
                            }
                            catch (Exception e) {
                                this.notsaved();
                                AdditionalResultsFrame.Logger(this.getClass(), e);
                            }
                        }
                    }
                } else if (c instanceof PlotPanel) {
                    PlotPanel panel = (PlotPanel)c;
                    FileNameExtensionFilter filter = new FileNameExtensionFilter("Portable Network Graphics (png)", "png");
                    FileNameExtensionFilter filter2 = new FileNameExtensionFilter("Drawing Interchange Format(dxf)", "dxf");
                    GUIUtil.FileChooserWithOverwritePrompting fc = new GUIUtil.FileChooserWithOverwritePrompting();
                    if (oad.getDescription().contains(I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.Profile-Plot"))) {
                        fc.setFileFilter(filter2);
                    }
                    fc.setFileFilter(filter);
                    fc.addChoosableFileFilter(filter);
                    int returnVal = fc.showSaveDialog(this);
                    fc.getWidth();
                    fc.getHeight();
                    if (returnVal == 0) {
                        if (fc.getFileFilter().equals(filter)) {
                            File file = new File(((JFileChooser)fc).getSelectedFile() + ".png");
                            file.getParent();
                            panel.toGraphicFile(file);
                            this.saved(file);
                        } else if (fc.getFileFilter().equals(filter2)) {
                            File file = new File(((JFileChooser)fc).getSelectedFile() + ".dxf");
                            file.getParent();
                            double[][] pointsOfProfile = null;
                            for (Plot plot : panel.getPlots()) {
                                pointsOfProfile = plot.getData();
                            }
                            this.setCursor(new Cursor(3));
                            AdditionalResultsFrame.exportToDxf(file.getAbsolutePath(), pointsOfProfile);
                            this.setCursor(new Cursor(0));
                            this.saved(file);
                        }
                    }
                } else if (c instanceof JTable) {
                    JTable table = (JTable)c;
                    FileNameExtensionFilter filter = new FileNameExtensionFilter("Comma-Separated Values (csv)", "csv");
                    GUIUtil.FileChooserWithOverwritePrompting fc = new GUIUtil.FileChooserWithOverwritePrompting("csv");
                    fc.setFileFilter(filter);
                    fc.addChoosableFileFilter(filter);
                    int returnVal = fc.showSaveDialog(this);
                    fc.getWidth();
                    fc.getHeight();
                    if (returnVal == 0) {
                        File file = new File(((JFileChooser)fc).getSelectedFile() + ".csv");
                        IOTools.saveCSV(table, file.getAbsolutePath());
                    } else if (returnVal == 1) {
                        return;
                    }
                } else if (c instanceof HTMLPanel) {
                    HTMLPanel panel = (HTMLPanel)c;
                    String text = panel.lastString();
                    FileNameExtensionFilter filter = new FileNameExtensionFilter("HTML", "html");
                    GUIUtil.FileChooserWithOverwritePrompting fc = new GUIUtil.FileChooserWithOverwritePrompting("html");
                    fc.setFileFilter(filter);
                    fc.addChoosableFileFilter(filter);
                    int returnVal = fc.showSaveDialog(this);
                    fc.getWidth();
                    fc.getHeight();
                    if (returnVal == 0) {
                        try {
                            File file = new File(((JFileChooser)fc).getSelectedFile() + ".html");
                            file.getParent();
                            FileWriter fileWriter = new FileWriter(file);
                            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                            bufferedWriter.write(text);
                            bufferedWriter.close();
                            this.saved(file);
                        }
                        catch (Exception e) {
                            this.notsaved();
                            AdditionalResultsFrame.Logger(this.getClass(), e);
                        }
                    }
                } else if (c instanceof JPanel) {
                    JPanel panel = (JPanel)c;
                    int w = panel.getWidth();
                    int h = panel.getHeight();
                    BufferedImage bi = new BufferedImage(w, h, 1);
                    Graphics2D g = bi.createGraphics();
                    panel.paint(g);
                    FileNameExtensionFilter filter = new FileNameExtensionFilter("Portable Network Graphics (png)", "png");
                    GUIUtil.FileChooserWithOverwritePrompting fc = new GUIUtil.FileChooserWithOverwritePrompting("png");
                    fc.setFileFilter(filter);
                    fc.addChoosableFileFilter(filter);
                    int returnVal = fc.showSaveDialog(this);
                    fc.getWidth();
                    fc.getHeight();
                    if (returnVal == 0) {
                        try {
                            File file = new File(((JFileChooser)fc).getSelectedFile() + ".png");
                            ImageIO.write((RenderedImage)bi, "png", file);
                            this.saved(file);
                        }
                        catch (Exception e) {
                            this.notsaved();
                            AdditionalResultsFrame.Logger(this.getClass(), e);
                        }
                    }
                }
            }
            catch (Exception e) {
                AdditionalResultsFrame.Logger(this.getClass(), e);
            }
        }
    }

    protected void saved(File file) {
        JUMPWorkbench.getInstance().getFrame().setStatusMessage(this.sSaved + " :" + file.getAbsolutePath());
    }

    protected void notsaved() {
        JOptionPane.showMessageDialog(null, this.SCouldNotSave, I18N.getInstance().get(this.name), 2);
    }

    protected void showComponent() {
        if (this.m_Path != null) {
            try {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_Path.getLastPathComponent();
                ObjectAndDescription oad = (ObjectAndDescription)node.getUserObject();
                Component c = (Component)oad.getObject();
                c.setMinimumSize(new Dimension(300, 200));
                this.jSplitPane.setRightComponent(c);
            }
            catch (Exception e) {
                AdditionalResultsFrame.Logger(this.getClass(), e);
            }
        }
    }

    public void fillTree(ArrayList<?> components) {
        DefaultMutableTreeNode mainNode = new DefaultMutableTreeNode(this.sProcessing);
        DefaultMutableTreeNode componentsNode = new DefaultMutableTreeNode(this.sResult);
        for (int i = 0; i < components.size(); ++i) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(components.get(i));
            componentsNode.add(node);
        }
        mainNode.add(componentsNode);
        this.jTree.setModel(new DefaultTreeModel(mainNode));
    }

    public void update() {
        if (!this.initGUI(AdditionalResults.getComponents())) {
            this.dispose();
            this.setVisible(false);
        }
    }

    private DefaultMutableTreeNode findNode(ObjectAndDescription oad) {
        DefaultTreeModel data = (DefaultTreeModel)this.jTree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)data.getRoot();
        DefaultMutableTreeNode node = null;
        if (root != null) {
            Enumeration<TreeNode> e = root.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode current = (DefaultMutableTreeNode)e.nextElement();
                Object ob = current.getUserObject();
                if (!(ob instanceof ObjectAndDescription) || ob != oad) continue;
                node = current;
                break;
            }
        }
        return node;
    }

    public static void Logger(Class<?> plugin, Exception e) {
        JUMPWorkbench.getInstance().getFrame().warnUser(plugin.getSimpleName() + " Exception: " + e.toString());
        Logger.error(plugin.getName() + " Exception: ", e);
    }

    protected JPanel getOKSavePanel() {
        JPanel okPanel = new JPanel();
        JButton saveButton = new JButton(this.SAVE){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(100, 25);
            }
        };
        JButton closeButton = new JButton(this.CLOSE){
            private static final long serialVersionUID = 2L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(100, 25);
            }
        };
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdditionalResultsFrame.this.save();
            }
        });
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdditionalResultsFrame.this.dispose();
            }
        });
        okPanel.add((Component)saveButton, "West");
        okPanel.add((Component)closeButton, "East");
        return okPanel;
    }

    public static Integer round100(Integer b) {
        return b - b % 100;
    }

    public static void exportToDxf(String fileName, double[][] points) {
        try {
            int ip;
            int p;
            double minX = Double.MAX_VALUE;
            double maxX = -minX;
            double minY = Double.MAX_VALUE;
            double maxY = -minY;
            for (double[] point : points) {
                if (point[0] < minX) {
                    minX = point[0];
                }
                if (point[0] > maxX) {
                    maxX = point[0];
                }
                if (point[1] < minY) {
                    minY = point[1];
                }
                if (!(point[1] > maxY)) continue;
                maxY = point[1];
            }
            DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.ENGLISH);
            DecimalFormat twoPlaces = null;
            String twoPlacesS = "0.00";
            twoPlaces = new DecimalFormat("0.00", dfs);
            int pointsCount = points.length;
            int txtHight = 14;
            int txtHight2 = 22;
            int b = ((int)minY - 99) / 100 * 100;
            double baseElev = b - 100;
            int a = ((int)maxY + 99) / 100 * 100;
            double topElev = a + 200;
            int sepSpacing = 140;
            String layNameProf = "PROFILE";
            String baseSectionLayer = "BASE";
            String partialValuesLayer = "PARTIAL_VALUES";
            String gridLayer = "GRID";
            String layNameText = "GRID_TEXT";
            double sep1Y = baseElev - 28.0;
            double sep2Y = sep1Y - 140.0;
            double sep3Y = topElev;
            double leg5Y = sep3Y + 140.0;
            double legX = minX - 420.0;
            DxfExport dxfExp = new DxfExport();
            dxfExp.writeHeader(legX, sep3Y, maxX, maxY);
            dxfExp.writeStartSec();
            dxfExp.writeTablesStart();
            dxfExp.writeTableStart();
            dxfExp.writeVPort((maxX + legX) / 2.0, (maxY + sep3Y) / 2.0, 0.0, 0.0, 1.0, 1.0);
            dxfExp.writeTableEnd();
            dxfExp.writeTableStart();
            dxfExp.writeAppId();
            dxfExp.writeTableEnd();
            dxfExp.writeTableStart();
            dxfExp.writeLayersStart();
            dxfExp.writeLayer("PROFILE", 5);
            dxfExp.writeLayer("BASE", 0);
            dxfExp.writeLayer("PARTIAL_VALUES", 8);
            dxfExp.writeLayer("GRID", 9);
            dxfExp.writeLayer("GRID_TEXT", 7);
            dxfExp.writeTableEnd();
            dxfExp.writeEndSec();
            dxfExp.writeStartSec();
            dxfExp.writeEntStart();
            dxfExp.writePolyline("PROFILE", points);
            Task selectedTask = workbenchContext.getTask();
            String unitsDistLabel = "";
            unitsDistLabel = selectedTask.getProperties().containsKey(new QName("Project Unit")) ? " [" + selectedTask.getProperty(new QName("Project Unit")).toString() + "]" : "";
            dxfExp.writeText("GRID_TEXT", 0.0, 0.0, 0.0, (maxX - minX) / 2.0, sep2Y, 0.0, 22, 0.0, 0, 2, WIDTH + unitsDistLabel);
            dxfExp.writeText("PARTIAL_VALUES", 0.0, 0.0, 0.0, (maxX - minX) / 2.0, leg5Y, 0.0, 22, 0.0, 0, 2, HEIGHT + unitsDistLabel);
            dxfExp.writeText("GRID_TEXT", 0.0, 0.0, 0.0, minX - 200.0, (topElev + baseElev) / 2.0, 0.0, 22, 90.0, 0, 2, HEIGHT + unitsDistLabel);
            dxfExp.writeText("GRID_TEXT", 0.0, 0.0, 0.0, maxX + 200.0, (topElev + baseElev) / 2.0, 0.0, 22, 270.0, 0, 2, HEIGHT + unitsDistLabel);
            double p1x = 0.0;
            double p1y = 0.0;
            double p2x = 0.0;
            double p2y = 0.0;
            double alPt1x = 0.0;
            double alPt1y = 0.0;
            double alPt2y = 0.0;
            String labelText = null;
            int interPointsCount = 0;
            double[] interStepD = null;
            interStepD = new double[]{100.0};
            interPointsCount = (int)((maxX - minX) / interStepD[0]) + 2;
            double[] interPointsDists = new double[interPointsCount];
            double[] interPointsElev = new double[interPointsCount];
            for (int ip2 = 0; ip2 < interPointsCount; ++ip2) {
                interPointsDists[ip2] = ip2 < interPointsCount - 1 ? interStepD[0] * (double)ip2 : maxX;
            }
            int[] interPointsIds = new int[interPointsCount];
            int ipId = 0;
            for (p = 1; p < pointsCount; ++p) {
                if (!(points[p][0] >= interPointsDists[ipId])) continue;
                interPointsIds[ipId] = Math.abs(points[p][0] - interPointsDists[ipId]) <= Math.abs(interPointsDists[ipId] - points[p - 1][0]) ? p : p - 1;
                ++ipId;
            }
            if (interPointsIds[interPointsCount - 1] == 0) {
                interPointsIds[interPointsCount - 1] = pointsCount - 1;
            }
            ipId = 0;
            for (p = 1; p < pointsCount; ++p) {
                if (!(points[p][0] >= interPointsDists[ipId])) continue;
                interPointsIds[ipId] = Math.abs(points[p][0] - interPointsDists[ipId]) <= Math.abs(interPointsDists[ipId] - points[p - 1][0]) ? p : p - 1;
                interPointsElev[ipId] = (interPointsDists[ipId] - points[p - 1][0]) / (points[p][0] - points[p - 1][0]) * (points[p][1] - points[p - 1][1]) + points[p - 1][1];
                ++ipId;
            }
            for (ip = 0; ip < interPointsCount; ++ip) {
                if (!(baseElev + interPointsDists[ip] < topElev) && baseElev + interPointsDists[ip] != topElev) continue;
                p1x = maxX;
                p1y = interPointsDists[ip] + baseElev;
                p2x = minX;
                p2y = interPointsDists[ip] + baseElev;
                dxfExp.writeLineType("GRID", "DOTTINY", p1x, p1y, p2x, p2y);
                alPt1x = minX - 100.0;
                double alPt1ax = maxX + 14.0;
                alPt1y = interPointsDists[ip] + baseElev;
                labelText = twoPlaces.format(interPointsDists[ip] + baseElev);
                dxfExp.writeText("GRID_TEXT", 0.0, 0.0, 0.0, alPt1x, alPt1y, 0.0, 14, 0.0, 0, 2, labelText);
                dxfExp.writeText("GRID_TEXT", 0.0, 0.0, 0.0, alPt1ax, alPt1y, 0.0, 14, 0.0, 0, 2, labelText);
                alPt1x = minX;
                alPt1y = interPointsDists[ip] + baseElev;
                double alPt2x = minX - 7.0;
                dxfExp.writeLine("BASE", alPt1x, alPt1y, alPt2x, alPt1y);
                double alPt2x2 = maxX + 7.0;
                dxfExp.writeLine("BASE", maxX, alPt1y, alPt2x2, alPt1y);
            }
            for (ip = 0; ip < interPointsCount; ++ip) {
                p1x = interPointsDists[ip];
                p1y = topElev;
                p2x = interPointsDists[ip];
                p2y = baseElev;
                dxfExp.writeLineType("GRID", "DOTTINY", p1x, p1y, p2x, p2y);
                alPt1x = interPointsDists[ip];
                alPt1y = sep1Y - 56.0;
                labelText = twoPlaces.format(interPointsDists[ip]);
                dxfExp.writeText("GRID_TEXT", 0.0, 0.0, 0.0, alPt1x, alPt1y, 0.0, 14, 90.0, 0, 2, labelText);
                alPt1x = interPointsDists[ip];
                alPt1y = baseElev;
                alPt2y = baseElev - 7.0;
                dxfExp.writeLine("BASE", alPt1x, alPt1y, alPt1x, alPt2y);
                alPt1x = interPointsDists[ip];
                alPt1y = sep3Y + 14.0;
                labelText = twoPlaces.format(points[interPointsIds[ip]][1]);
                dxfExp.writeText("PARTIAL_VALUES", 0.0, 0.0, 0.0, alPt1x, alPt1y, 0.0, 14, 90.0, 0, 2, labelText);
                alPt1y = sep3Y;
                alPt2y = sep3Y + 7.0;
                dxfExp.writeLine("PARTIAL_VALUES", alPt1x, alPt1y, alPt1x, alPt2y);
            }
            dxfExp.writeLine("BASE", minX, baseElev, maxX, baseElev);
            dxfExp.writeLine("BASE", minX, baseElev, minX, topElev);
            dxfExp.writeLine("BASE", maxX, baseElev, maxX, topElev);
            dxfExp.writeLine("PARTIAL_VALUES", minX, sep3Y, maxX, sep3Y);
            dxfExp.writeEnding();
            int ret = dxfExp.exportDxf(fileName);
            if (ret == 0) {
                return;
            }
            return;
        }
        catch (Exception ex) {
            workbenchContext.getWorkbench().getFrame().warnUser("Errore durante l'esportazione: ");
            return;
        }
    }
}

