/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.util;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.util.java2xml.Java2XML;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.imagery.ImageryLayerDataset;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageStyle;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.DataStoreQueryDataSource;
import de.latlon.deejump.plugin.style.LayerStyle2SLDPlugIn;
import java.awt.image.Raster;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.openjump.core.apitools.IOTools;
import org.openjump.core.rasterimage.RasterImageIOUtils;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.WorldFileHandler;
import org.openjump.core.rasterimage.styler.SLDHandler;
import org.openjump.core.ui.util.ScreenScale;
import org.openjump.sigle.utilities.geom.FeatureCollectionUtil;

public abstract class LayerableUtil {
    private static final String NO_FEATURES = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.No-Features");
    private static final String NULL_GEOMETRIES = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Null-Geometries");
    private static final String MULTIPLE_GEOMETRY_TYPES = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Multiple-geometry-types");
    private static final String NODATASOURCELAYER = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.nodatasourcelayer.message");
    public static String filetype;
    static final String charSet = "UTF-8";

    public static boolean isSpatiallyEqualTo(RasterImageLayer rLayer1, RasterImageLayer rLayer2) throws IOException {
        boolean isEqual = true;
        Raster raster1 = rLayer1.getRasterData(null);
        Raster raster2 = rLayer2.getRasterData(null);
        if (raster1.getHeight() != raster2.getHeight()) {
            isEqual = false;
        }
        if (raster1.getWidth() != raster2.getWidth()) {
            isEqual = false;
        }
        if (rLayer1.getMetadata().getActualLowerLeftCoord() != rLayer2.getMetadata().getActualLowerLeftCoord()) {
            isEqual = false;
        }
        if (rLayer1.getMetadata().getActualCellSize() != rLayer2.getMetadata().getActualCellSize()) {
            isEqual = false;
        }
        if (rLayer1.getNoDataValue() != rLayer2.getNoDataValue()) {
            isEqual = false;
        }
        return isEqual;
    }

    public static boolean isTemporary(RasterImageLayer layer) {
        return layer.getImageFileName().contains(System.getProperty("java.io.tmpdir"));
    }

    public static boolean isModified(RasterImageLayer layer) {
        return layer.isRasterDataChanged();
    }

    public static boolean isMonoband(RasterImageLayer layer) {
        return layer.getNumBands() == 1;
    }

    public static String getFilePath(RasterImageLayer layer) {
        String fileName = !layer.getImageFileName().contains(System.getProperty("java.io.tmpdir")) ? layer.getImageFileName() : NODATASOURCELAYER;
        return fileName;
    }

    public static boolean isTemporary(Layer layer) {
        return !layer.hasReadableDataSource() || layer.getName().contains(System.getProperty("java.io.tmpdir"));
    }

    public static boolean isModified(Layer layer) {
        return layer.isFeatureCollectionModified();
    }

    public boolean isVector(Layer layer) {
        return !(layer.getDataSourceQuery().getDataSource() instanceof DataStoreQueryDataSource) && layer.getStyle(ReferencedImageStyle.class) == null;
    }

    public static boolean isImage(Layer layer) {
        return layer.getStyle(ReferencedImageStyle.class) != null;
    }

    public static boolean isMultipleImages(Layer layer) {
        return layer.getStyle(ReferencedImageStyle.class) != null && layer.getFeatureCollectionWrapper().getFeatures().size() > 1;
    }

    public static boolean isDataStore(Layer layer) {
        return layer.getDataSourceQuery().getDataSource() instanceof DataStoreQueryDataSource;
    }

    public static boolean isCad(Layer layer) {
        FeatureSchema schema = layer.getFeatureCollectionWrapper().getFeatureSchema();
        return schema.hasAttribute("COLOR") && schema.hasAttribute("TEXT");
    }

    public static boolean isEmpty(Layer layer) {
        return layer.getFeatureCollectionWrapper().isEmpty();
    }

    public static boolean isPolygonalLayer(Layer layer) {
        FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
        return FeatureCollectionUtil.getFeatureCollectionDimension(featureCollection) == 2;
    }

    public static boolean isPolygonalLayer(FeatureCollection featureCollection) {
        return FeatureCollectionUtil.getFeatureCollectionDimension(featureCollection) == 2;
    }

    public static boolean isPointLayer(Layer layer) {
        FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
        return FeatureCollectionUtil.getFeatureCollectionDimension(featureCollection) == 0;
    }

    public static boolean isPointLayer(FeatureCollection featureCollection) {
        return FeatureCollectionUtil.getFeatureCollectionDimension(featureCollection) == 0;
    }

    public static boolean isLinealLayer(Layer layer) {
        FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
        return FeatureCollectionUtil.getFeatureCollectionDimension(featureCollection) == 1;
    }

    public static boolean isLinealLayer(FeatureCollection featureCollection) {
        return FeatureCollectionUtil.getFeatureCollectionDimension(featureCollection) == 1;
    }

    public static boolean isMixedGeometryType(Layer layer) {
        FeatureCollectionWrapper fc = layer.getFeatureCollectionWrapper();
        return LayerableUtil.isMixedGeometryType(fc);
    }

    public static boolean isMixedGeometryType(FeatureCollection featureCollection) {
        return FeatureCollectionUtil.getFeatureCollectionDimension(featureCollection) == -1 && featureCollection.size() > 0;
    }

    public static String getGeometryType(Layer layer) {
        String geoClass = "";
        FeatureCollectionWrapper fcw = layer.getFeatureCollectionWrapper();
        int numFeatures = fcw.size();
        boolean multipleGeoTypes = false;
        for (Feature feature : fcw.getFeatures()) {
            Geometry geo = feature.getGeometry();
            if (geo == null) continue;
            if (geoClass.equals("")) {
                geoClass = geo.getClass().getName();
                continue;
            }
            if (geo.getClass().getName().equals(geoClass)) continue;
            multipleGeoTypes = true;
        }
        if (geoClass.equals("")) {
            geoClass = NULL_GEOMETRIES;
        }
        if (numFeatures == 0) {
            geoClass = NO_FEATURES;
        } else if (multipleGeoTypes) {
            geoClass = MULTIPLE_GEOMETRY_TYPES;
        } else {
            int dotPos = geoClass.lastIndexOf(".");
            if (dotPos > 0) {
                geoClass = geoClass.substring(dotPos + 1);
            }
        }
        return geoClass;
    }

    public static String getFilePath(Layer layer) {
        DataSourceQuery dsq = layer.getDataSourceQuery();
        String fileName = null;
        if (dsq != null || !layer.getName().contains(System.getProperty("java.io.tmpdir"))) {
            Object fnameObj = dsq.getDataSource().getProperties().get("File");
            if (fnameObj == null) {
                fnameObj = dsq.getDataSource().getProperties().get("Connection Descriptor");
            }
            if (fnameObj != null) {
                fileName = fnameObj.toString();
            }
        } else {
            fileName = NODATASOURCELAYER;
        }
        return fileName;
    }

    public static String getLayerSourceClass(Layer layer) {
        String sourceClass = "";
        DataSourceQuery dsq = layer.getDataSourceQuery();
        if (dsq != null) {
            int dotPos;
            String dsqSourceClass = dsq.getDataSource().getClass().getName();
            if (sourceClass.equals("")) {
                sourceClass = dsqSourceClass;
            }
            if ((dotPos = sourceClass.lastIndexOf(".")) > 0) {
                sourceClass = sourceClass.substring(dotPos + 1);
            }
            if ((dotPos = sourceClass.lastIndexOf("$")) > 0) {
                sourceClass = sourceClass.substring(dotPos + 1);
            }
        } else {
            sourceClass = "In memory";
        }
        return sourceClass;
    }

    public static String getFileType(File file) {
        String extUC;
        switch (extUC = FileUtil.getExtension(file).toUpperCase()) {
            case "ASC": {
                return "ASC - ESRI ASCII grid";
            }
            case "CSV": {
                return "CSV - Comma-separated values";
            }
            case "DXF": {
                return "Autocad DXF - Drawing Exchange Format";
            }
            case "FLT": {
                return "FLT - ESRI Binary grid";
            }
            case "TIF": 
            case "TIFF": {
                return "GEOTIF/TIFF -  Tagged Image File Format";
            }
            case "JPG": 
            case "JPEG": {
                return "JPEG/JPG - Joint Photographic Experts Group";
            }
            case "PNG": {
                return "PNG - Portable Network Graphics";
            }
            case "GIF": {
                return "GIF - Graphics Interchange Format";
            }
            case "GRD": {
                return "GRD - Surfer ASCII Grid";
            }
            case "JP2": {
                return "JPEG 2000 - Joint Photographic Experts Group";
            }
            case "BMP": {
                return "BMP - Windows Bitmap";
            }
            case "ECW": {
                return "ECW - Enhanced Compression Wavelet";
            }
            case "MrSID": {
                return "MrSID - Multiresolution seamless image database";
            }
            case "TXT": {
                return "TXT - Text file";
            }
            case "SHP": {
                return "SHP - Esri Shapefile";
            }
            case "JML": {
                return "JML - OpenJUMP JML format";
            }
            case "GML": {
                return "GML - Geography Markup Language";
            }
            case "KML": {
                return "KML - Keyhole Markup Language";
            }
            case "OSM": {
                return "OSM - OpenStreetMap XML";
            }
        }
        return extUC;
    }

    public static String getVectorImageFileDescription(Layer layer) {
        String name = null;
        DataSourceQuery dsq = layer.getDataSourceQuery();
        Object fnameObj = dsq.getDataSource().getProperties().get("File");
        String sourcePath = fnameObj.toString();
        File file = new File(sourcePath);
        name = LayerableUtil.getFileType(file);
        return name;
    }

    public static String getRasterFileDescription(RasterImageLayer layer) {
        File file = new File(layer.getImageFileName());
        String name = LayerableUtil.getFileType(file);
        return name;
    }

    public static void ExportVector(PlugInContext context, Layer layer, String path) {
        FeatureCollectionWrapper features = layer.getFeatureCollectionWrapper();
        String vector_name = context.getLayerManager().uniqueLayerName(FileUtil.getFileNameFromLayerName(layer.getName()));
        int dotPos = vector_name.indexOf(".");
        if (dotPos > 0) {
            vector_name = vector_name.substring(0, dotPos);
        }
        if (LayerableUtil.isMixedGeometryType(layer)) {
            File vfileName = FileUtil.addExtensionIfNone(new File(vector_name), "jml");
            String vpath = new File(path, vfileName.getName()).getAbsolutePath();
            try {
                IOTools.saveJMLFile(features, vpath);
            }
            catch (Exception te) {
                Logger.warn("Error while saving layer " + layer.getName() + " to " + path + " as JML", te);
            }
        } else {
            File vfileName = FileUtil.addExtensionIfNone(new File(vector_name), "shp");
            String vpath = new File(path, vfileName.getName()).getAbsolutePath();
            try {
                IOTools.saveShapefile(features, vpath);
            }
            catch (Exception te) {
                Logger.warn("Error while saving layer " + layer.getName() + " to " + path + " as Shapefile", te);
            }
        }
    }

    public static void ExportSextanteRaster(PlugInContext context, RasterImageLayer layer, String path) {
        Envelope envelope = layer.getWholeImageEnvelope();
        String outTIF_name = context.getLayerManager().uniqueLayerName(layer.getName() + ".tif");
        File outTIF_File = new File(path.concat(File.separator).concat(outTIF_name));
        try {
            RasterImageIOUtils.saveTIF(outTIF_File, layer, envelope);
        }
        catch (Exception te) {
            Logger.warn("Error while saving RasterImageLayer '" + layer.getName() + "' to " + outTIF_name, te);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ExportImage(PlugInContext context, Layer layer, String path) throws IOException {
        String filepath = LayerableUtil.filepath(layer);
        File inputFile = new File(filepath);
        String outImage_name = context.getLayerManager().uniqueLayerName(layer.getName() + ".tif");
        File outFile = new File(path.concat(File.separator).concat(outImage_name));
        FileChannel inputChannel = null;
        AbstractInterruptibleChannel outputChannel = null;
        try {
            inputChannel = new FileInputStream(inputFile).getChannel();
            outputChannel = new FileOutputStream(outFile).getChannel();
            ((FileChannel)outputChannel).transferFrom(inputChannel, 0L, inputChannel.size());
        }
        finally {
            if (inputChannel != null) {
                inputChannel.close();
            }
            if (outputChannel != null) {
                outputChannel.close();
            }
        }
        WorldFileHandler worldFileHandler = new WorldFileHandler(filepath, false);
        if (worldFileHandler.isWorldFileExistentForImage() != null) {
            LayerableUtil.copyWorldFile(layer, filepath);
        }
    }

    public static void ExportVectorStyleToSLD(PlugInContext context, Layer layer, String path) throws Exception {
        double internalScale = 1.0 / context.getLayerViewPanel().getViewport().getScale();
        double realScale = ScreenScale.getHorizontalMapScale(context.getLayerViewPanel().getViewport());
        double scaleFactor = internalScale / realScale;
        String outSLD = context.getLayerManager().uniqueLayerName(layer.getName() + ".sld");
        File sld_outFile = new File(path.concat(File.separator).concat(outSLD));
        File inputXML = File.createTempFile("temptask", ".xml");
        inputXML.deleteOnExit();
        String name = layer.getName();
        if (layer.getFeatureCollectionWrapper().getFeatures().size() == 0) {
            throw new Exception(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.StatisticOverViewPlugIn.Selected-layer-is-empty"));
        }
        BasicFeature bf = (BasicFeature)layer.getFeatureCollectionWrapper().getFeatures().get(0);
        Geometry geo = bf.getGeometry();
        String geoType = geo.getGeometryType();
        Java2XML java2Xml = new Java2XML();
        java2Xml.write((Object)layer, "layer", inputXML);
        FileInputStream input = new FileInputStream(inputXML);
        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(sld_outFile), StandardCharsets.UTF_8);
        HashMap<String, String> map = new HashMap<String, String>(9);
        map.put("wmsLayerName", name);
        map.put("featureTypeStyle", name);
        map.put("styleName", name);
        map.put("styleTitle", name);
        map.put("geoType", geoType);
        map.put("geomProperty", I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.geomProperty"));
        map.put("Namespace", "http://www.deegree.org/app");
        Double d = layer.getMinScale();
        d = d != null ? d : 0.0;
        map.put("minScale", "" + LayerStyle2SLDPlugIn.toRealWorldScale(scaleFactor, d));
        double largeNumber = 9.9999999999E10;
        d = layer.getMaxScale();
        d = d != null ? d : new Double(9.9999999999E10);
        map.put("maxScale", "" + LayerStyle2SLDPlugIn.toRealWorldScale(scaleFactor, d));
        fw.write(LayerStyle2SLDPlugIn.transformContext(input, map));
        fw.close();
    }

    public static void ExportRasterStyleToSLD(PlugInContext context, RasterImageLayer rLayer, String path) {
        String outSLD = context.getLayerManager().uniqueLayerName(rLayer.getName() + ".sld");
        File sld_outFile = new File(path.concat(File.separator).concat(outSLD));
        try {
            SLDHandler.write(rLayer.getSymbology(), null, sld_outFile);
        }
        catch (Exception te) {
            Logger.warn("Error while saving layer " + rLayer.getName() + " to " + path + " as SLD", te);
        }
    }

    public static void ExportVectorProjection(PlugInContext context, Layer layer, String proj, String path) throws IOException {
        String outPRJ = context.getLayerManager().uniqueLayerName(layer.getName() + ".prj");
        File outFile = new File(path.concat(File.separator).concat(outPRJ));
        FileUtils.writeStringToFile((File)outFile, (String)proj, (String)charSet);
    }

    public static void ExportRasterProjection(PlugInContext context, RasterImageLayer layer, String proj, String path) throws IOException {
        String outPRJ = context.getLayerManager().uniqueLayerName(layer.getName() + ".prj");
        File outFile = new File(path.concat(File.separator).concat(outPRJ));
        FileUtils.writeStringToFile((File)outFile, (String)proj, (String)charSet);
    }

    public static void copyWorldFile(Layer layer, String path) throws IOException {
        String wfilepath = LayerableUtil.worldFilepath(layer);
        File inputFile = new File(wfilepath);
        File outFile = new File(path.concat(File.separator).concat(inputFile.getName()));
        try (FileChannel inputChannel = new FileInputStream(inputFile).getChannel();
             FileChannel outputChannel = new FileOutputStream(outFile).getChannel();){
            outputChannel.transferFrom(inputChannel, 0L, inputChannel.size());
        }
    }

    public static String filepath(Layer layer) {
        FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
        String filePath1 = null;
        for (Feature feature : featureCollection) {
            String sourcePathImage = feature.getString(ImageryLayerDataset.ATTR_URI);
            sourcePathImage = sourcePathImage.substring(5);
            File f = new File(sourcePathImage);
            String filePath = f.getAbsolutePath();
            filePath1 = filePath.replace("%20", " ");
        }
        return filePath1;
    }

    public static String worldFilepath(Layer layer) {
        FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
        String worldPath = null;
        for (Feature feature : featureCollection) {
            String sourcePathImage = feature.getString(ImageryLayerDataset.ATTR_URI);
            sourcePathImage = sourcePathImage.substring(5);
            File f = new File(sourcePathImage);
            String filePath = f.getAbsolutePath();
            String filePath1 = filePath.replace("%20", " ");
            String worldFileName = filePath1.substring(0, filePath1.lastIndexOf("."));
            String imageExtension = filePath1.substring(filePath1.lastIndexOf(".") + 1).toLowerCase();
            worldPath = worldFileName + "." + imageExtension.charAt(0) + imageExtension.substring(imageExtension.length() - 1) + "w";
        }
        return worldPath;
    }

    public static double getValidArea(Layer layer) {
        double area = 0.0;
        FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
        for (Feature feature : featureCollection) {
            area += feature.getGeometry().getArea();
        }
        return area;
    }

    public static double getValidArea(RasterImageLayer layer) throws IOException {
        Raster ras = layer.getRasterData(null);
        double noData = layer.getNoDataValue();
        double cellSize = layer.getMetadata().getOriginalCellSize();
        int counter = 0;
        int nx = ras.getWidth();
        int ny = ras.getHeight();
        for (int y = 0; y < ny; ++y) {
            for (int x = 0; x < nx; ++x) {
                double value = ras.getSampleDouble(x, y, 0);
                if (value == noData) continue;
                ++counter;
            }
        }
        return cellSize * cellSize * (double)counter;
    }

    public static void main(String[] args) {
        System.out.println(LayerableUtil.getFileType(new File("Test.tif")));
        System.out.println(LayerableUtil.getFileType(new File("Test.unknown")));
    }

    public static enum TypeFile {
        ASC,
        CSV,
        DXF,
        FLT,
        TIF,
        TIFF,
        JPG,
        JPEG,
        PNG,
        GIF,
        GRD,
        JP2,
        BMP,
        ECW,
        MrSID,
        TXT,
        SHP,
        JML,
        GML,
        KML,
        OSM;

    }
}

