/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.wms.panels;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.MathUtil;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.ValidatingTextField;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.style.StylePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.openjump.core.ui.util.ScreenScale;

public class WMSScaleStylePanel
extends JPanel
implements StylePanel {
    private static final ImageIcon MAX_SCALE_ICON = IconLoader.icon("Atom.gif");
    private static final ImageIcon MIN_SCALE_ICON = IconLoader.icon("globe3_32.png");
    private JCheckBox enableScaleDependentRenderingCheckBox = null;
    private JLabel smallestScaleLabel = null;
    private JLabel largestScaleLabel = null;
    private JLabel smallestScale1Label = null;
    private JLabel largestScale1Label = null;
    private JLabel currentScale1Label = null;
    private ValidatingTextField smallestScaleTextField = null;
    private ValidatingTextField largestScaleTextField = null;
    private ValidatingTextField currentScaleTextField = null;
    private WMSLayer layer;
    private LayerViewPanel panel;
    private JLabel currentScaleLabel = null;
    private JPanel fillerPanel = null;
    private JPanel spacerPanelInTopLeftCorner = null;
    private JLabel unitsPerPixelLabel = null;
    private JButton hideAboveCurrentScaleButton = null;
    private JButton hideBelowCurrentScaleButton = null;
    private static final Color TEXT_FIELD_BACKGROUND_COLOUR = new JTextField().getBackground();
    private JLabel smallestScaleIconLabel = null;
    private JLabel largestScaleIconLabel = null;
    private JPanel spacerPanelBelowCurrentScale = null;
    private JButton showAtThisScaleButton = null;
    private double scaleFactor = 0.0;

    private JPanel getFillerPanel() {
        if (this.fillerPanel == null) {
            this.fillerPanel = new JPanel();
        }
        return this.fillerPanel;
    }

    public WMSScaleStylePanel(WMSLayer layer, LayerViewPanel panel) {
        this.initialize();
        this.layer = layer;
        this.panel = panel;
        double internalScale = this.currentScale();
        double realScale = ScreenScale.getHorizontalMapScale(panel.getViewport());
        this.scaleFactor = internalScale / realScale;
        Double internalMinScale = layer.getMinScale();
        Double realMinScale = null;
        if (internalMinScale != null) {
            realMinScale = new Double(Math.floor(internalMinScale / this.scaleFactor));
        }
        Double internalMaxScale = layer.getMaxScale();
        Double realMaxScale = null;
        if (internalMaxScale != null) {
            realMaxScale = new Double(Math.floor(internalMaxScale / this.scaleFactor));
        }
        this.smallestScaleTextField.setText(this.formatScaleLosslessly(realMinScale));
        this.largestScaleTextField.setText(this.formatScaleLosslessly(realMaxScale));
        this.currentScaleTextField.setText(this.formatScaleLossily(realScale));
        this.enableScaleDependentRenderingCheckBox.setSelected(layer.isScaleDependentRenderingEnabled());
        this.updateComponents();
    }

    protected double currentScale() {
        return 1.0 / this.panel.getViewport().getScale();
    }

    private String formatScaleLosslessly(Double scale) {
        return scale != null ? this.formatScaleLosslessly((double)scale) : "";
    }

    private String formatScaleLosslessly(double scale) {
        return scale == (double)((int)scale) ? "" + (int)scale : "" + scale;
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
        this.smallestScaleIconLabel = new JLabel();
        this.largestScaleIconLabel = new JLabel();
        this.unitsPerPixelLabel = new JLabel();
        GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        this.largestScaleLabel = new JLabel();
        this.smallestScaleLabel = new JLabel();
        this.largestScale1Label = new JLabel();
        this.currentScale1Label = new JLabel();
        this.smallestScale1Label = new JLabel();
        this.currentScaleLabel = new JLabel();
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 4;
        this.smallestScaleLabel.setText(I18N.getInstance().get("ui.style.ScaleStylePanel.smallest-scale"));
        this.smallestScaleIconLabel.setIcon(MIN_SCALE_ICON);
        this.largestScaleIconLabel.setIcon(MAX_SCALE_ICON);
        gridBagConstraints5.gridx = 3;
        gridBagConstraints5.gridy = 6;
        this.smallestScale1Label.setText("1:");
        this.currentScaleLabel.setText(I18N.getInstance().get("ui.style.ScaleStylePanel.current-scale"));
        gridBagConstraints6.gridx = 3;
        gridBagConstraints6.gridy = 8;
        gridBagConstraints16.gridx = 3;
        gridBagConstraints16.gridy = 2;
        this.largestScale1Label.setText("1:");
        this.currentScale1Label.setText("1:");
        gridBagConstraints7.gridx = 4;
        gridBagConstraints7.gridy = 6;
        gridBagConstraints7.fill = 2;
        gridBagConstraints7.insets = new Insets(0, 2, 0, 0);
        gridBagConstraints17.gridx = 4;
        gridBagConstraints17.gridy = 2;
        gridBagConstraints17.fill = 2;
        gridBagConstraints17.insets = new Insets(0, 2, 0, 0);
        gridBagConstraints9.gridx = 4;
        gridBagConstraints9.gridy = 8;
        gridBagConstraints9.fill = 2;
        gridBagConstraints9.insets = new Insets(0, 2, 0, 0);
        gridBagConstraints1.gridwidth = 5;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints5.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints6.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints16.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints16.anchor = 17;
        gridBagConstraints10.gridx = 2;
        gridBagConstraints10.gridy = 2;
        gridBagConstraints10.anchor = 17;
        gridBagConstraints10.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints10.gridwidth = 1;
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 6;
        gridBagConstraints4.gridx = 2;
        gridBagConstraints4.gridy = 8;
        gridBagConstraints11.gridx = 7;
        gridBagConstraints11.gridy = 16;
        gridBagConstraints11.fill = 1;
        gridBagConstraints11.weightx = 1.0;
        gridBagConstraints11.weighty = 1.0;
        gridBagConstraints12.gridx = 0;
        gridBagConstraints12.gridy = 0;
        gridBagConstraints12.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints13.gridx = 4;
        gridBagConstraints13.gridy = 5;
        gridBagConstraints14.gridx = 7;
        gridBagConstraints14.gridy = 6;
        gridBagConstraints14.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints14.fill = 2;
        gridBagConstraints15.gridx = 7;
        gridBagConstraints15.gridy = 8;
        gridBagConstraints15.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints15.fill = 2;
        this.getShowAtThisScaleButton().setMargin(new Insets(0, 0, 0, 0));
        this.getHideAboveCurrentScaleButton().setMargin(new Insets(0, 0, 0, 0));
        this.getHideBelowCurrentScaleButton().setMargin(new Insets(0, 0, 0, 0));
        this.getShowAtThisScaleButton().setMargin(new Insets(0, 0, 0, 0));
        GUIUtil.shrinkFont(this.getHideAboveCurrentScaleButton());
        GUIUtil.shrinkFont(this.getHideBelowCurrentScaleButton());
        GUIUtil.shrinkFont(this.getShowAtThisScaleButton());
        GUIUtil.shrinkFont(this.unitsPerPixelLabel);
        this.largestScaleLabel.setText(I18N.getInstance().get("ui.style.ScaleStylePanel.largest-scale"));
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 6;
        gridBagConstraints31.gridx = 1;
        gridBagConstraints31.gridy = 8;
        gridBagConstraints2.insets = new Insets(5, 10, 5, 0);
        gridBagConstraints31.insets = new Insets(5, 10, 5, 0);
        gridBagConstraints18.gridx = 2;
        gridBagConstraints18.gridy = 3;
        gridBagConstraints21.gridx = 7;
        gridBagConstraints21.gridy = 2;
        gridBagConstraints21.fill = 2;
        gridBagConstraints21.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.getSpacerPanelInTopLeftCorner(), gridBagConstraints12);
        this.add((Component)this.getShowAtThisScaleButton(), gridBagConstraints21);
        this.add((Component)this.getEnableScaleDependentRenderingCheckBox(), gridBagConstraints1);
        this.add((Component)this.currentScaleLabel, gridBagConstraints10);
        this.add((Component)this.smallestScaleLabel, gridBagConstraints3);
        this.add((Component)this.largestScaleLabel, gridBagConstraints4);
        this.add((Component)this.getFillerPanel(), gridBagConstraints11);
        this.add((Component)this.smallestScale1Label, gridBagConstraints5);
        this.add((Component)this.largestScale1Label, gridBagConstraints6);
        this.add((Component)this.unitsPerPixelLabel, gridBagConstraints13);
        this.add((Component)this.getHideAboveCurrentScaleButton(), gridBagConstraints14);
        this.add((Component)this.getHideBelowCurrentScaleButton(), gridBagConstraints15);
        this.add((Component)this.currentScale1Label, gridBagConstraints16);
        this.add((Component)this.smallestScaleIconLabel, gridBagConstraints2);
        this.add((Component)this.largestScaleIconLabel, gridBagConstraints31);
        this.add((Component)this.getSpacerPanelBelowCurrentScale(), gridBagConstraints18);
        this.add((Component)this.getSmallestScaleTextField(), gridBagConstraints7);
        this.add((Component)this.getLargestScaleTextField(), gridBagConstraints9);
        this.add((Component)this.getCurrentScaleTextField(), gridBagConstraints17);
    }

    @Override
    public String getTitle() {
        return I18N.getInstance().get("ui.style.ScaleStylePanel.scale");
    }

    @Override
    public void updateStyles() {
        this.layer.getLayerManager().deferFiringEvents(new Runnable(){

            @Override
            public void run() {
                WMSScaleStylePanel.this.layer.setMinScale(WMSScaleStylePanel.this.getSmallestScale());
                WMSScaleStylePanel.this.layer.setMaxScale(WMSScaleStylePanel.this.getLargestScale());
                WMSScaleStylePanel.this.layer.setScaleDependentRenderingEnabled(WMSScaleStylePanel.this.enableScaleDependentRenderingCheckBox.isSelected());
            }
        });
        this.layer.fireAppearanceChanged();
    }

    @Override
    public String validateInput() {
        if (this.getSmallestScale() != null && this.getLargestScale() != null && this.getLargestScale() > this.getSmallestScale()) {
            return I18N.getInstance().get("ui.style.ScaleStylePanel.units-pixel-at-smallest-scale-must-be-larger-than-units-pixel-at-largest-scale");
        }
        if (this.getLargestScale() != null && this.getLargestScale() == 0.0) {
            return I18N.getInstance().get("ui.style.ScaleStylePanel.units-pixel-at-largest-scale-must-be-greater-than-0");
        }
        if (this.getSmallestScale() != null && this.getSmallestScale() == 0.0) {
            return I18N.getInstance().get("ui.style.ScaleStylePanel.units-pixel-at-smallest-scale-must-be-greater-than-0");
        }
        return null;
    }

    public Double LSCale() {
        return this.getLargestScale();
    }

    public Double SSCale() {
        return this.getSmallestScale();
    }

    private Double getLargestScale() {
        return this.largestScaleTextField.getText().trim().length() > 0 ? new Double(this.largestScaleTextField.getDouble() * this.scaleFactor) : null;
    }

    private Double getSmallestScale() {
        return this.smallestScaleTextField.getText().trim().length() > 0 ? new Double(this.smallestScaleTextField.getDouble() * this.scaleFactor) : null;
    }

    private JCheckBox getEnableScaleDependentRenderingCheckBox() {
        if (this.enableScaleDependentRenderingCheckBox == null) {
            this.enableScaleDependentRenderingCheckBox = new JCheckBox();
            this.enableScaleDependentRenderingCheckBox.setText(I18N.getInstance().get("ui.style.ScaleStylePanel.only-show-layer-when-scale-is-between"));
            this.enableScaleDependentRenderingCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WMSScaleStylePanel.this.updateComponents();
                }
            });
        }
        return this.enableScaleDependentRenderingCheckBox;
    }

    private void updateComponents() {
        this.smallestScaleTextField.setBackground(this.enableScaleDependentRenderingCheckBox.isSelected() ? TEXT_FIELD_BACKGROUND_COLOUR : this.getBackground());
        this.largestScaleTextField.setBackground(this.enableScaleDependentRenderingCheckBox.isSelected() ? TEXT_FIELD_BACKGROUND_COLOUR : this.getBackground());
        this.unitsPerPixelLabel.setEnabled(this.enableScaleDependentRenderingCheckBox.isSelected());
        this.hideAboveCurrentScaleButton.setEnabled(this.enableScaleDependentRenderingCheckBox.isSelected());
        this.smallestScaleLabel.setEnabled(this.enableScaleDependentRenderingCheckBox.isSelected());
        this.smallestScale1Label.setEnabled(this.enableScaleDependentRenderingCheckBox.isSelected());
        this.smallestScaleTextField.setEnabled(this.enableScaleDependentRenderingCheckBox.isSelected());
        this.hideBelowCurrentScaleButton.setEnabled(this.enableScaleDependentRenderingCheckBox.isSelected());
        this.largestScaleLabel.setEnabled(this.enableScaleDependentRenderingCheckBox.isSelected());
        this.largestScale1Label.setEnabled(this.enableScaleDependentRenderingCheckBox.isSelected());
        this.largestScaleTextField.setEnabled(this.enableScaleDependentRenderingCheckBox.isSelected());
    }

    private ValidatingTextField getSmallestScaleTextField() {
        if (this.smallestScaleTextField == null) {
            this.smallestScaleTextField = this.createValidatingTextField();
        }
        return this.smallestScaleTextField;
    }

    private ValidatingTextField getLargestScaleTextField() {
        if (this.largestScaleTextField == null) {
            this.largestScaleTextField = this.createValidatingTextField();
        }
        return this.largestScaleTextField;
    }

    private ValidatingTextField getCurrentScaleTextField() {
        if (this.currentScaleTextField == null) {
            this.currentScaleTextField = this.createValidatingTextField();
            this.currentScaleTextField.setEditable(false);
            this.currentScaleTextField.setBackground(this.getBackground());
        }
        return this.currentScaleTextField;
    }

    private ValidatingTextField createValidatingTextField() {
        return new ValidatingTextField("", 7, 2, new ValidatingTextField.CompositeValidator(new ValidatingTextField.Validator[]{ValidatingTextField.DOUBLE_VALIDATOR, new ValidatingTextField.GreaterThanOrEqualValidator(0.0)}), ValidatingTextField.DUMMY_CLEANER);
    }

    private String formatScaleLossily(double x) {
        if (1.0 <= x && x <= 1000000.0) {
            return new DecimalFormat("#").format(x);
        }
        if (1.0E-6 <= x && x <= 1.0) {
            return new DecimalFormat("0.000000").format(x);
        }
        return new DecimalFormat("0.#E0").format(x);
    }

    private JPanel getSpacerPanelInTopLeftCorner() {
        if (this.spacerPanelInTopLeftCorner == null) {
            this.spacerPanelInTopLeftCorner = new JPanel();
            this.spacerPanelInTopLeftCorner.setLayout(new GridBagLayout());
        }
        return this.spacerPanelInTopLeftCorner;
    }

    private JButton getHideAboveCurrentScaleButton() {
        if (this.hideAboveCurrentScaleButton == null) {
            this.hideAboveCurrentScaleButton = new JButton();
            this.hideAboveCurrentScaleButton.setText(I18N.getInstance().get("ui.style.ScaleStylePanel.hide-above-current-scale"));
            this.hideAboveCurrentScaleButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    double realScale = 1.0 / WMSScaleStylePanel.this.scaleFactor * WMSScaleStylePanel.this.currentScale();
                    WMSScaleStylePanel.this.smallestScaleTextField.setText(WMSScaleStylePanel.this.formatScaleLossily(WMSScaleStylePanel.this.roundFirstSignificantFigureUp(realScale)));
                }
            });
        }
        return this.hideAboveCurrentScaleButton;
    }

    private double roundFirstSignificantFigureUp(double x) {
        return WMSScaleStylePanel.roundFirstSignificantFigure(x, 1);
    }

    private double roundFirstSignificantFigureDown(double x) {
        return WMSScaleStylePanel.roundFirstSignificantFigure(x, 0);
    }

    private static double roundFirstSignificantFigure(double x, int i) {
        double scale = Math.pow(10.0, Math.floor(MathUtil.base10Log(x)));
        int firstSignificantFigure = (int)Math.floor(x / scale);
        return (double)(firstSignificantFigure + i) * scale;
    }

    private JButton getHideBelowCurrentScaleButton() {
        if (this.hideBelowCurrentScaleButton == null) {
            this.hideBelowCurrentScaleButton = new JButton();
            this.hideBelowCurrentScaleButton.setText(I18N.getInstance().get("ui.style.ScaleStylePanel.hide-below-current-scale"));
            this.hideBelowCurrentScaleButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    double realScale = 1.0 / WMSScaleStylePanel.this.scaleFactor * WMSScaleStylePanel.this.currentScale();
                    WMSScaleStylePanel.this.largestScaleTextField.setText(WMSScaleStylePanel.this.formatScaleLossily(WMSScaleStylePanel.this.roundFirstSignificantFigureDown(realScale)));
                }
            });
        }
        return this.hideBelowCurrentScaleButton;
    }

    private JPanel getSpacerPanelBelowCurrentScale() {
        if (this.spacerPanelBelowCurrentScale == null) {
            this.spacerPanelBelowCurrentScale = new JPanel();
            this.spacerPanelBelowCurrentScale.setLayout(new GridBagLayout());
            this.spacerPanelBelowCurrentScale.setPreferredSize(new Dimension(0, 20));
        }
        return this.spacerPanelBelowCurrentScale;
    }

    private JButton getShowAtThisScaleButton() {
        if (this.showAtThisScaleButton == null) {
            this.showAtThisScaleButton = new JButton();
            this.showAtThisScaleButton.setText(I18N.getInstance().get("ui.style.ScaleStylePanel.show-at-this-scale"));
            this.showAtThisScaleButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!WMSScaleStylePanel.this.enableScaleDependentRenderingCheckBox.isSelected()) {
                        WMSScaleStylePanel.this.enableScaleDependentRenderingCheckBox.doClick();
                    }
                    if (WMSScaleStylePanel.this.getSmallestScale() != null && WMSScaleStylePanel.this.currentScale() > WMSScaleStylePanel.this.getSmallestScale()) {
                        WMSScaleStylePanel.this.getHideAboveCurrentScaleButton().doClick();
                    }
                    if (WMSScaleStylePanel.this.getLargestScale() != null && WMSScaleStylePanel.this.currentScale() < WMSScaleStylePanel.this.getLargestScale()) {
                        WMSScaleStylePanel.this.getHideBelowCurrentScaleButton().doClick();
                    }
                }
            });
        }
        return this.showAtThisScaleButton;
    }

    public static void main(String[] args) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        JDialog dialog = new JDialog();
        dialog.getContentPane().add(new WMSScaleStylePanel(new WMSLayer(){
            {
                this.setMinScale(new Double(2.0));
                this.setMaxScale(new Double(1.0));
            }
        }, null){

            @Override
            protected double currentScale() {
                return 1.23E-7;
            }
        });
        dialog.pack();
        dialog.setVisible(true);
    }
}

