/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.wms;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.ui.plugin.wms.panels.WMSScaleStylePanel;
import org.openjump.core.ui.plugin.wms.panels.WMSTransparencyPanel;

public class WMSStylePlugIn
extends AbstractPlugIn {
    @Override
    public boolean execute(PlugInContext context) throws Exception {
        WMSLayer layer = (WMSLayer)LayerTools.getSelectedLayerable(context, WMSLayer.class);
        final MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), I18N.getInstance().get("ui.style.ChangeStylesPlugIn.change-styles") + " - " + layer.getName() + " (WMS)", true);
        dialog.setSize(500, 400);
        dialog.setSideBarImage(IconLoader.icon("Symbology.gif"));
        dialog.setApplyVisible(true);
        final WMSScaleStylePanel panel = new WMSScaleStylePanel(layer, context.getLayerViewPanel());
        JTabbedPane tabbedPane = new JTabbedPane();
        final WMSTransparencyPanel trppanel = new WMSTransparencyPanel(layer, context.getLayerViewPanel());
        tabbedPane.add(I18N.getInstance().get("ui.renderer.style.ColorThemingPanel.transparency"), trppanel);
        tabbedPane.add(I18N.getInstance().get("ui.style.ScaleStylePanel.scale"), panel);
        dialog.addRow(tabbedPane);
        dialog.setApplyVisible(true);
        dialog.addEnableChecks(panel.getTitle(), new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return panel.validateInput();
            }
        });
        dialog.addOKCancelApplyPanelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (dialog.wasApplyPressed()) {
                    if (panel.LSCale() > panel.SSCale()) {
                        JOptionPane.showMessageDialog(null, I18N.getInstance().get("ui.style.ScaleStylePanel.units-pixel-at-smallest-scale-must-be-larger-than-units-pixel-at-largest-scale"), "Jump", 0);
                    } else {
                        trppanel.updateStyles();
                        panel.updateStyles();
                    }
                }
            }
        });
        dialog.pack();
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (dialog.wasOKPressed()) {
            panel.updateStyles();
            trppanel.updateStyles();
            return true;
        }
        return false;
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.icon("Palette.png");
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("ui.style.ChangeStylesPlugIn.change-styles");
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayerablesMustBeSelectedCheck(1, WMSLayer.class));
    }
}

