/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.view;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import org.openjump.core.ui.plugin.view.NorthArrowInstallRenderer;
import org.openjump.core.ui.plugin.view.NorthArrowRenderer;

public class NorthArrowPlugIn
extends AbstractPlugIn {
    private static final String NORTH_ARROW = I18N.getInstance().get("org.openjump.core.ui.plugin.view.NorthArrowPlugIn.North-Arrow");

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        final WorkbenchContext workbenchContext = context.getWorkbenchContext();
        NorthArrowInstallRenderer northArrowInstallRenderer = new NorthArrowInstallRenderer();
        northArrowInstallRenderer.initialize(new PlugInContext(workbenchContext, null, null, null, null));
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        featureInstaller.addMainMenuItem(this, new String[]{MenuNames.VIEW, MenuNames.MAP_DECORATIONS}, this.getName(), true, IconLoader.icon("show_nord.png"), new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                ((JCheckBoxMenuItem)component).setSelected(NorthArrowRenderer.isEnabled(workbenchContext.getLayerViewPanel()));
                return null;
            }
        }));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        NorthArrowRenderer.setEnabled(!NorthArrowRenderer.isEnabled(context.getLayerViewPanel()), context.getLayerViewPanel());
        context.getLayerViewPanel().getRenderingManager().render("NORTH_ARROW");
        return true;
    }

    @Override
    public String getName() {
        return NORTH_ARROW;
    }
}

