/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools.statistics;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import de.fho.jump.pirol.utilities.attributes.AttributeInfo;
import org.openjump.core.apitools.FeatureCollectionTools;
import org.openjump.core.apitools.comparisonandsorting.ObjectComparator;
import org.openjump.core.apitools.tables.StandardPirolTableModel;
import org.openjump.core.attributeoperations.AttributeOp;
import org.openjump.core.attributeoperations.statistics.CorrelationCoefficients;

public class StatisticOverViewTableModel
extends StandardPirolTableModel {
    private static final long serialVersionUID = -4961732734422876267L;
    protected Class[] colClasses = new Class[]{String.class, String.class, Double.class, String.class, Double.class, Double.class, Double.class};
    protected Feature[] features = null;

    public StatisticOverViewTableModel(Feature[] features) {
        super(new String[]{I18N.getInstance().get("org.openjump.core.ui.plugin.queries.SimpleQuery.attribute"), I18N.getInstance().get("org.openjump.sigle.plugin.ReplaceValuePlugIn.Attribute-type"), I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.minimum"), I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.StatisticOverViewTableModel.mean-mode"), I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.maximum"), I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.standard-dev"), I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.sum")});
        this.features = features;
        this.setupTable();
    }

    protected void setupTable() {
        Feature feat = this.features[0];
        FeatureSchema fs = feat.getSchema();
        AttributeInfo[] attrInfos = AttributeInfo.schema2AttributeInfoArray(fs);
        String[] attrToWorkWith = new String[attrInfos.length - 1];
        int saveAttrIndex = 0;
        for (int i = 0; i < attrInfos.length; ++i) {
            if (attrInfos[i].getAttributeType().equals(AttributeType.GEOMETRY)) continue;
            attrToWorkWith[saveAttrIndex] = attrInfos[i].getAttributeName();
            ++saveAttrIndex;
        }
        Object[] meansModes = FeatureCollectionTools.getMeanOrModeForAttributes(this.features, attrToWorkWith);
        saveAttrIndex = 0;
        for (int i = 0; i < attrInfos.length; ++i) {
            if (attrInfos[i].getAttributeType().equals(AttributeType.GEOMETRY)) continue;
            if (FeatureCollectionTools.isAttributeTypeNumeric(attrInfos[i].getAttributeType())) {
                double[] minMax = FeatureCollectionTools.getMinMaxAttributeValue(this.features, fs, attrInfos[i].getAttributeName());
                double deviation = CorrelationCoefficients.getDeviation(this.features, attrInfos[i].getAttributeName(), ObjectComparator.getDoubleValue(meansModes[saveAttrIndex]));
                double sum = AttributeOp.evaluateAttributes(7, this.features, attrInfos[i].getAttributeName());
                this.addRow(attrInfos[i].getAttributeName(), attrInfos[i].getAttributeType(), new Double(minMax[0]), meansModes[saveAttrIndex], new Double(minMax[1]), new Double(deviation), new Double(sum));
            } else {
                this.addRow(attrInfos[i].getAttributeName(), attrInfos[i].getAttributeType(), null, meansModes[saveAttrIndex], null, null, null);
            }
            ++saveAttrIndex;
        }
    }

    protected void addRow(String attrName, AttributeType type, Double minVal, Object mean, Double maxVal, Double deviation, Double sum) {
        if (minVal != null && minVal == Double.MAX_VALUE && maxVal != null && maxVal == -1.7976931348623157E308) {
            minVal = null;
            maxVal = null;
            sum = null;
            deviation = null;
            mean = null;
        }
        this.addRow(new Object[]{attrName, type, minVal, mean, maxVal, deviation, sum});
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Class getColumnClass(int columnIndex) {
        return this.colClasses[columnIndex];
    }
}

