/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools.statistics;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.util.StatisticIndices;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import de.fho.jump.pirol.utilities.attributes.AttributeInfo;
import java.awt.Color;
import java.awt.Component;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.openjump.core.apitools.FeatureCollectionTools;
import org.openjump.sextante.gui.additionalResults.AdditionalResults;

public class StatisticOverViewPlugIn
extends AbstractPlugIn {
    private static final String sStatisticsOverview = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.StatisticOverViewPlugIn.Attribute-Statistics-Overview");

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        WorkbenchContext workbenchContext = context.getWorkbenchContext();
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.STATISTICS}, this.getName() + "...", false, null, this.createEnableCheck(workbenchContext));
    }

    @Override
    public String getName() {
        return sStatisticsOverview;
    }

    public String getIconString() {
        return "statsOverview.png";
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Layer layer = context.getSelectedLayer(0);
        FeatureCollection featureColl = layer.getFeatureCollectionWrapper().getWrappee();
        Feature[] features = FeatureCollectionTools.FeatureCollection2FeatureArray(featureColl);
        if (features.length == 0) {
            context.getWorkbenchFrame().warnUser(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.StatisticOverViewPlugIn.Selected-layer-is-empty"));
            return false;
        }
        AdditionalResults.addAdditionalResultAndShow(this.getName(), StatisticOverViewPlugIn.pan(features, 3));
        return true;
    }

    private static JScrollPane pan(Feature[] features, int scale) {
        DefaultTableModel dtm = new DefaultTableModel();
        JTable jTable = new JTable();
        jTable.setGridColor(Color.WHITE);
        jTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                c.setBackground(row % 2 == 0 ? Color.white : new Color(230, 230, 230));
                if (isSelected) {
                    c.setBackground(Color.black);
                }
                return c;
            }
        });
        jTable.setModel(dtm);
        jTable.setEnabled(true);
        Feature feat = features[0];
        FeatureSchema fs = feat.getSchema();
        AttributeInfo[] attrInfos = AttributeInfo.schema2AttributeInfoArray(fs);
        String[] attrToWorkWith = new String[attrInfos.length - 1];
        int saveAttrIndex = 0;
        for (int i = 0; i < attrInfos.length; ++i) {
            if (attrInfos[i].getAttributeType().equals(AttributeType.GEOMETRY)) continue;
            attrToWorkWith[saveAttrIndex] = attrInfos[i].getAttributeName();
            ++saveAttrIndex;
        }
        saveAttrIndex = 0;
        dtm.addColumn(I18N.getInstance().get("org.openjump.core.ui.plugin.queries.SimpleQuery.attribute"));
        dtm.addColumn(I18N.getInstance().get("org.openjump.sigle.plugin.ReplaceValuePlugIn.Attribute-type"));
        dtm.addColumn(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.minimum"));
        dtm.addColumn(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.StatisticOverViewTableModel.mean-mode"));
        dtm.addColumn(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.maximum"));
        dtm.addColumn(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.standard-dev"));
        dtm.addColumn(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.sum"));
        for (AttributeInfo attrInfo : attrInfos) {
            if (attrInfo.getAttributeType().equals(AttributeType.GEOMETRY)) continue;
            if (FeatureCollectionTools.isAttributeTypeNumeric(attrInfo.getAttributeType())) {
                StatisticIndices stat = FeatureCollectionTools.getStatistics(features, fs, attrInfo.getAttributeName());
                dtm.addRow(new Object[]{attrInfo.getAttributeName(), attrInfo.getAttributeType(), new BigDecimal(stat.getMin()).setScale(scale, RoundingMode.CEILING), new BigDecimal(stat.getMean()).setScale(scale, RoundingMode.CEILING), new BigDecimal(stat.getMax()).setScale(scale, RoundingMode.CEILING), new BigDecimal(stat.getStdDev()).setScale(scale, RoundingMode.CEILING), new BigDecimal(stat.getSum()).setScale(scale, RoundingMode.CEILING)});
            } else {
                Object[] meansModes = FeatureCollectionTools.getMeanOrModeForAttributes(features, attrToWorkWith);
                dtm.addRow(new Object[]{attrInfo.getAttributeName(), attrInfo.getAttributeType(), null, meansModes[saveAttrIndex], null, null, null});
            }
            ++saveAttrIndex;
        }
        JScrollPane pane = new JScrollPane(jTable, 20, 30);
        return pane;
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1));
    }
}

