/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools.statistics;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.AttributeTypeFilter;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.openjump.core.ui.plot.Plot2DPanelOJ;
import org.openjump.sextante.gui.additionalResults.AdditionalResults;

public class CreateScatterPlotPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private String sScatterPlot = "Scatter-Plot";
    private String CLAYER = "select layer";
    private String ATTRIBUTEA = "Select-attribute-for-east-axis";
    private String ATTRIBUTEB = "Select-attribute-for-north-axis";
    private Layer selLayer = null;
    private FeatureCollection fc = null;
    private String selAttributeA = null;
    private String selAttributeB = null;
    private String sName = "Create Scatter Plot";
    private String sWrongDataType = "Wrong datatype of chosen attribute";

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.ATTRIBUTEA = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.CreateScatterPlotPlugIn.Select-attribute-for-east-axis");
        this.ATTRIBUTEB = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.CreateScatterPlotPlugIn.Select-attribute-for-north-axis");
        this.CLAYER = GenericNames.SELECT_LAYER;
        this.sScatterPlot = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.CreateScatterPlotPlugIn.Scatter-Plot");
        this.sName = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.CreateScatterPlotPlugIn");
        this.sWrongDataType = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.CreateBarPlotPlugIn.Wrong-datatype-of-chosen-attribute");
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.STATISTICS, MenuNames.PLOT}, this.sName + "...", false, null, CreateScatterPlotPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayersMustExistCheck(1)).add(checkFactory.createWindowWithAssociatedTaskFrameMustBeActiveCheck());
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.sName, true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        this.createPlot(context, this.selLayer);
    }

    private void setDialogValues(final MultiInputDialog dialog, PlugInContext context) {
        dialog.addLayerComboBox(this.CLAYER, context.getCandidateLayer(0), context.getLayerManager());
        List<String> attributes = AttributeTypeFilter.NUMERIC_FILTER.filter(context.getCandidateLayer(0));
        String attA = attributes.size() > 0 ? attributes.get(0) : null;
        String attB = attributes.size() > 0 ? attributes.get(0) : null;
        final JComboBox<String> jcb_attributeA = dialog.addComboBox(this.ATTRIBUTEA, attA, attributes, this.ATTRIBUTEA);
        if (attributes.size() == 0) {
            jcb_attributeA.setEnabled(false);
        }
        final JComboBox<String> jcb_attributeB = dialog.addComboBox(this.ATTRIBUTEB, attB, attributes, this.ATTRIBUTEB);
        if (attributes.size() == 0) {
            jcb_attributeB.setEnabled(false);
        }
        dialog.getComboBox(this.CLAYER).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<String> list = AttributeTypeFilter.NUMERIC_FILTER.filter(dialog.getLayer(CreateScatterPlotPlugIn.this.CLAYER));
                if (list.size() == 0) {
                    jcb_attributeA.setModel(new DefaultComboBoxModel<String>(new String[0]));
                    jcb_attributeA.setEnabled(false);
                }
                jcb_attributeA.setModel(new DefaultComboBoxModel<String>(list.toArray(new String[0])));
            }
        });
        dialog.getComboBox(this.CLAYER).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<String> list = AttributeTypeFilter.NUMERIC_FILTER.filter(dialog.getLayer(CreateScatterPlotPlugIn.this.CLAYER));
                if (list.size() == 0) {
                    jcb_attributeB.setModel(new DefaultComboBoxModel<String>(new String[0]));
                    jcb_attributeB.setEnabled(false);
                }
                jcb_attributeB.setModel(new DefaultComboBoxModel<String>(list.toArray(new String[0])));
            }
        });
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.selLayer = dialog.getLayer(this.CLAYER);
        this.fc = this.selLayer.getFeatureCollectionWrapper();
        this.selAttributeA = dialog.getText(this.ATTRIBUTEA);
        this.selAttributeB = dialog.getText(this.ATTRIBUTEB);
    }

    private boolean createPlot(PlugInContext context, Layer selLayer) throws Exception {
        FeatureSchema fs = this.fc.getFeatureSchema();
        AttributeType typeA = fs.getAttributeType(this.selAttributeA);
        AttributeType typeB = fs.getAttributeType(this.selAttributeB);
        if (typeA != AttributeType.DOUBLE && typeA != AttributeType.INTEGER && typeA != AttributeType.LONG || typeB != AttributeType.DOUBLE && typeB != AttributeType.INTEGER && typeB != AttributeType.LONG) {
            context.getWorkbenchFrame().warnUser(this.sWrongDataType);
            return false;
        }
        double[][] data = new double[2][this.fc.size()];
        int[] fID = new int[this.fc.size()];
        int i = 0;
        for (Feature f : this.fc.getFeatures()) {
            fID[i] = f.getID();
            Object valA = f.getAttribute(this.selAttributeA);
            Object valB = f.getAttribute(this.selAttributeB);
            if (valA instanceof Number) {
                data[0][i] = ((Number)valA).doubleValue();
            }
            if (valB instanceof Number) {
                data[1][i] = ((Number)valB).doubleValue();
            }
            ++i;
        }
        Plot2DPanelOJ plot = new Plot2DPanelOJ();
        plot.addScatterPlotOJ(this.sScatterPlot, data, fID, context, selLayer);
        plot.plotToolBar.setVisible(true);
        plot.setAxisLabel(0, this.selAttributeA);
        plot.setAxisLabel(1, this.selAttributeB);
        AdditionalResults.addAdditionalResultAndShow(this.sScatterPlot, (Object)plot);
        return true;
    }
}

