/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools.generate;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.AttributeTypeFilter;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.LayerNameRenderer;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import it.betastudio.adbtoolbox.libs.FileOperations;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.locationtech.jts.geom.Envelope;
import org.openjump.core.rasterimage.ImageAndMetadata;
import org.openjump.core.rasterimage.RasterImageIO;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.Resolution;
import org.openjump.core.rasterimage.algorithms.RasterizeAlgorithm;
import org.openjump.core.ui.io.file.FileNameExtensionFilter;
import org.saig.core.gui.swing.sldeditor.util.FormUtils;

public class RasterizePlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private Layer sourceLayer;
    private JTextField cellYextFiels;
    private JCheckBox externalLayerCheck;
    private JCheckBox expandCheck;
    private JCheckBox loadCheck;
    private JComboBox<Layer> selectLayerComboBox;
    private JComboBox<Layerable> layerableExtentComboBox;
    private JComboBox<String> jcb_attribute;
    private LayerNameRenderer layerListCellRenderer = new LayerNameRenderer();
    private static String selAttribute = null;
    private final String ATTRIBUTE = GenericNames.SELECT_ATTRIBUTE;
    private String path;
    double cellValue;
    private final ImageIcon icon16 = IconLoader.icon("fugue/folder-horizontal-open_16.png");
    JTextField jTextField_RasterOut = new JTextField();
    private final String OUTPUT_FILE = I18N.getInstance().get("driver.DriverManager.file-to-save");
    private final String CHECK = I18N.getInstance().get("ui.GenericNames.check-field");
    private static final String SOURCE_LAYER = I18N.getInstance().get("ui.GenericNames.Source-Layer");
    private static final String TARGET_LAYER = I18N.getInstance().get("ui.GenericNames.Target-Layer");
    private static final String CELL_SIZE = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.cell.size");
    public static final Icon ICON = IconLoader.icon("rasterize.png");
    private static final String RASTERIZE_VECTOR = I18N.getInstance().get("ui.plugin.tools.generate.RasterizePlugIn.Name");
    private static final String RASTERIZING_VECTOR = I18N.getInstance().get("ui.plugin.tools.generate.RasterizePlugIn.rasterizing-layer");
    private static final String PREPARING_VECTOR = I18N.getInstance().get("ui.plugin.tools.generate.RasterizePlugIn.preparing-layer");
    private static final String USE_EXTERNAL_EXTENT = I18N.getInstance().get("ui.plugin.tools.generate.RasterizePlugIn.use-extent");
    private static final String DESCRIPTION = I18N.getInstance().get("ui.plugin.tools.generate.RasterizePlugIn.description");
    private static final String EXPAND_ONE_CELL = I18N.getInstance().get("ui.plugin.tools.generate.RasterizePlugIn.expand-one-cell");
    private static final String EXPAND_ONE_CELL_TIP = I18N.getInstance().get("ui.plugin.tools.generate.RasterizePlugIn.expand-one-cell-tip");
    private static final String LOAD_RASTER_INTO_VIEW = I18N.getInstance().get("ui.plugin.tools.generate.RasterizePlugIn.load-raster");
    private final EnableCheck[] saveCheck = new EnableCheck[]{new EnableCheck(){

        @Override
        public String check(JComponent component) {
            return RasterizePlugIn.this.jTextField_RasterOut.getText().isEmpty() ? RasterizePlugIn.this.CHECK.concat(": ").concat(RasterizePlugIn.this.OUTPUT_FILE) : null;
        }
    }};
    Envelope envWanted;
    Envelope fix;

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.initDialog(dialog, context);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    @Override
    public String getName() {
        return RASTERIZE_VECTOR;
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createTaskWindowMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    private void initDialog(final MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(DESCRIPTION);
        this.selectLayerComboBox = dialog.addLayerComboBox(SOURCE_LAYER, context.getCandidateLayer(0), context.getLayerManager());
        this.selectLayerComboBox.setSize(240, this.selectLayerComboBox.getPreferredSize().height);
        List<String> list = AttributeTypeFilter.NUMERIC_FILTER.filter(context.getCandidateLayer(0));
        String val = list.size() > 0 ? list.get(0) : null;
        this.jcb_attribute = dialog.addComboBox(this.ATTRIBUTE, val, list, this.ATTRIBUTE);
        this.cellYextFiels = dialog.addDoubleField(CELL_SIZE, 5.0, 10);
        this.cellYextFiels.setSize(this.jcb_attribute.getWidth(), this.jcb_attribute.getPreferredSize().height);
        this.externalLayerCheck = dialog.addCheckBox(USE_EXTERNAL_EXTENT, false);
        ArrayList<Layerable> layerables = new ArrayList<Layerable>();
        for (Layerable layerable : JUMPWorkbench.getInstance().getContext().getLayerManager().getLayerables(Layerable.class)) {
            if (!(layerable instanceof Layer) && !(layerable instanceof RasterImageLayer)) continue;
            layerables.add(layerable);
        }
        this.layerableExtentComboBox = dialog.addLayerableComboBox(TARGET_LAYER, context.getCandidateLayer(0), null, layerables);
        this.layerListCellRenderer = new LayerNameRenderer();
        this.layerListCellRenderer.setCheckBoxVisible(false);
        this.layerListCellRenderer.setProgressIconLabelVisible(false);
        this.layerableExtentComboBox.setRenderer(this.layerListCellRenderer);
        this.layerableExtentComboBox.setEnabled(false);
        this.layerableExtentComboBox.setSize(240, this.layerableExtentComboBox.getPreferredSize().height);
        this.expandCheck = dialog.addCheckBox(EXPAND_ONE_CELL, false, EXPAND_ONE_CELL_TIP);
        this.expandCheck.setEnabled(false);
        this.selectLayerComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<String> list = AttributeTypeFilter.NUMERIC_FILTER.filter(dialog.getLayer(SOURCE_LAYER));
                RasterizePlugIn.this.jcb_attribute.setModel(new DefaultComboBoxModel<String>(list.toArray(new String[0])));
                RasterizePlugIn.this.expandCheck.setEnabled(RasterizePlugIn.this.externalLayerCheck.isSelected());
            }
        });
        this.externalLayerCheck.addActionListener(e -> this.layerableExtentComboBox.setEnabled(this.externalLayerCheck.isSelected()));
        this.layerableExtentComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Layerable slayer = (Layerable)RasterizePlugIn.this.layerableExtentComboBox.getSelectedItem();
                if (slayer instanceof RasterImageLayer) {
                    RasterizePlugIn.this.cellYextFiels.setText("" + ((RasterImageLayer)slayer).getMetadata().getOriginalCellSize());
                }
            }
        });
        FileNameExtensionFilter filter = new FileNameExtensionFilter("TIF", "tif");
        dialog.addRow("Save", new JLabel(this.OUTPUT_FILE + ":"), this.createOutputFilePanel(filter), this.saveCheck, null);
        this.loadCheck = dialog.addCheckBox(LOAD_RASTER_INTO_VIEW, true);
        GUIUtil.centreOnWindow(dialog);
    }

    private void getCroppedEnvelope(Layer layer) {
        Envelope env = null;
        if (this.externalLayerCheck.isSelected()) {
            this.envWanted = new Envelope();
            Layerable slayer = (Layerable)this.layerableExtentComboBox.getSelectedItem();
            if (slayer instanceof Layer) {
                env = ((Layer)slayer).getFeatureCollectionWrapper().getEnvelope().intersection(layer.getFeatureCollectionWrapper().getEnvelope());
            } else if (slayer instanceof RasterImageLayer) {
                env = ((RasterImageLayer)slayer).getWholeImageEnvelope().intersection(layer.getFeatureCollectionWrapper().getEnvelope());
            }
            this.envWanted = this.expandCheck.isSelected() ? new Envelope(env.getMinX() - this.cellValue, env.getMaxX() + 2.0 * this.cellValue, env.getMinY() - this.cellValue, env.getMaxY() + this.cellValue) : env;
        } else {
            this.envWanted = this.sourceLayer.getFeatureCollectionWrapper().getEnvelope();
        }
        this.fix = this.envWanted;
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.sourceLayer = dialog.getLayer(SOURCE_LAYER);
        this.cellValue = dialog.getDouble(CELL_SIZE);
        selAttribute = dialog.getText(this.ATTRIBUTE);
        this.path = this.getOutputFilePath();
        int i = this.path.lastIndexOf(46);
        if (i > 0) {
            this.path = this.path.substring(0, this.path.length() - this.path.length() + i);
        }
        this.getCroppedEnvelope(this.sourceLayer);
    }

    public String getOutputFilePath() {
        return this.jTextField_RasterOut.getText();
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        FeatureCollectionWrapper fc = this.sourceLayer.getFeatureCollectionWrapper();
        File outFile = FileUtil.addExtensionIfNone(new File(this.path), "tif");
        monitor.report(RASTERIZING_VECTOR + "...");
        RasterizeAlgorithm rasterize = new RasterizeAlgorithm(this.fix, fc, selAttribute, this.cellValue);
        rasterize.process();
        rasterize.saveToFile(outFile);
        String catName = StandardCategoryNames.WORKING;
        try {
            catName = ((Category)context.getLayerNamePanel().getSelectedCategories().toArray()[0]).getName();
        }
        catch (RuntimeException e1) {
            Logger.error(e1);
        }
        if (this.loadCheck.isSelected()) {
            RasterizePlugIn.load(outFile, context, catName);
        }
    }

    public JPanel createOutputFilePanel(final FileNameExtensionFilter filter) {
        JPanel jPanel = new JPanel();
        this.jTextField_RasterOut = new JTextField();
        JButton jButton_Dir = new JButton();
        this.jTextField_RasterOut.setText("");
        jButton_Dir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUIUtil.FileChooserWithOverwritePrompting chooser = new GUIUtil.FileChooserWithOverwritePrompting();
                chooser.setDialogTitle(RasterizePlugIn.this.getName());
                chooser.setFileSelectionMode(0);
                ((JFileChooser)chooser).setSelectedFile(FileOperations.lastVisitedFolder);
                chooser.setDialogType(1);
                GUIUtil.removeChoosableFileFilters(chooser);
                chooser.setFileFilter(filter);
                int ret = chooser.showOpenDialog(null);
                if (ret == 0) {
                    File outputPathFile = FileUtil.removeExtensionIfAny(((JFileChooser)chooser).getSelectedFile());
                    RasterizePlugIn.this.jTextField_RasterOut.setText(outputPathFile.getPath().concat(".tif"));
                    FileOperations.lastVisitedFolder = outputPathFile;
                }
            }
        });
        this.jTextField_RasterOut.setEditable(true);
        jButton_Dir.setIcon(this.icon16);
        this.jTextField_RasterOut.setPreferredSize(new Dimension(200, 20));
        FormUtils.addRowInGBL(jPanel, 3, 0, this.jTextField_RasterOut);
        FormUtils.addRowInGBL((JComponent)jPanel, 3, 1, (JComponent)jButton_Dir, true, true);
        return jPanel;
    }

    public static void load(File file, PlugInContext context, String category) throws Exception {
        RasterImageIO rasterImageIO = new RasterImageIO();
        Viewport viewport = context.getWorkbenchContext().getLayerViewPanel().getViewport();
        Resolution requestedRes = RasterImageIO.calcRequestedResolution(viewport);
        ImageAndMetadata imageAndMetadata = rasterImageIO.loadImage(file.getAbsolutePath(), null, viewport.getEnvelopeInModelCoordinates(), requestedRes);
        Point point = RasterImageIO.getImageDimensions(file.getAbsolutePath());
        Envelope env = RasterImageIO.getGeoReferencing(file.getAbsolutePath(), true, point);
        RasterImageLayer ril = new RasterImageLayer(file.getName(), context.getWorkbenchContext().getLayerManager(), file.getAbsolutePath(), imageAndMetadata.getImage(), env);
        try {
            category = ((Category)context.getLayerNamePanel().getSelectedCategories().toArray()[0]).getName();
        }
        catch (RuntimeException e1) {
            Logger.error(e1);
        }
        context.getLayerManager().addLayerable(category, ril);
    }
}

