/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools.analysis.twolayers;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.locationtech.jts.algorithm.distance.DiscreteHausdorffDistance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.operation.distance.DistanceOp;

public class CalculateDistancesPlugIn
extends ThreadedBasePlugIn {
    private String sidebartext = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.CalculateDistancesPlugIn.Calculates-distances-description");
    private String sSRC_LAYER = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.CalculateDistancesPlugIn.layer-with-origins");
    private String sSRC_UniqueIdAttrib = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.CalculateDistancesPlugIn.select-unique-attribute-for-origin-identification");
    private String sTGT_LAYER = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.CalculateDistancesPlugIn.layer-with destinations");
    private String sTGT_UniqueIdAttrib = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.CalculateDistancesPlugIn.select-unique-attribute-for-destination-identification");
    private String sDIST_OP = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.CalculateDistancesPlugIn.select-distance-operation-for-non-point-geometries");
    private String distresult = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.CalculateDistancesPlugIn.distances-result");
    private String notimplemented = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.CalculateDistancesPlugIn.not-implemented");
    private String sMonitorMsg = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.CalculateDistancesPlugIn.origins-evaluated");
    private String sCalcCentroidDist = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.CalculateDistancesPlugIn.calculate-centroid-distance");
    private String sCalcHausdorffDsit = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.CalculateDistancesPlugIn.calculate-Hausdorff-distance-a-maximal-distance");
    private String sGenerateLines = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.CalculateDistancesPlugIn.generate-line-distance-geometries-to-first-destination");
    private Layer orgLayer = null;
    private Layer destLayer = null;
    private String orgAttrName = "";
    private String destAttrName = "";
    public boolean calcCentroidDistance = true;
    public boolean calcHausdorffDistance = true;
    public boolean displayLineGeoms = true;
    private MultiInputDialog dialog;
    private PlugInContext pcontext = null;
    private JComboBox layerboxAOrg;
    private JComboBox layerboxBDest;
    private JComboBox attribboxAOrg;
    private JComboBox attribboxBDest;
    private Object attrValueOrg = null;
    private Object attrValueDest = null;
    private ArrayList attCollOrg = new ArrayList();
    private ArrayList attCollDest = new ArrayList();

    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_ANALYSIS}, this.getName() + "...", false, null, CalculateDistancesPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.tools.CalculateDistancesPlugIn.Calculate-Distances");
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(2));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(this.dialog, context);
        GUIUtil.centreOnWindow(this.dialog);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getdialogValues(this.dialog);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        this.pcontext = context;
        FeatureCollectionWrapper originFeatures = this.orgLayer.getFeatureCollectionWrapper();
        FeatureCollectionWrapper destinationFeatures = this.destLayer.getFeatureCollectionWrapper();
        FeatureDataset results = this.calcDistances(originFeatures, destinationFeatures, this.orgAttrName, this.destAttrName, this.calcCentroidDistance, this.calcHausdorffDistance, this.displayLineGeoms, monitor);
        if (results.size() > 0) {
            context.addLayer(StandardCategoryNames.RESULT, this.distresult, results);
        } else {
            context.getWorkbenchFrame().warnUser(this.notimplemented);
        }
    }

    private FeatureDataset calcDistances(FeatureCollection originFeatures, FeatureCollection destinationFeatures, String orgAttrName, String destAttrName, boolean calcCentroidDist, boolean calcHausdorffDist, boolean displayLines, TaskMonitor monitor) {
        monitor.allowCancellationRequests();
        int numDest = destinationFeatures.size();
        int numOrigins = originFeatures.size();
        FeatureSchema newFs = new FeatureSchema();
        newFs.addAttribute("geometry", AttributeType.GEOMETRY);
        newFs.addAttribute(orgAttrName, originFeatures.getFeatureSchema().getAttributeType(orgAttrName));
        for (Feature destF : destinationFeatures) {
            Object destFid = destF.getAttribute(destAttrName);
            newFs.addAttribute("sd_" + destFid.toString(), AttributeType.DOUBLE);
            if (calcCentroidDist) {
                newFs.addAttribute("sdc_" + destFid.toString(), AttributeType.DOUBLE);
            }
            if (!calcHausdorffDist) continue;
            newFs.addAttribute("sdh_" + destFid.toString(), AttributeType.DOUBLE);
        }
        FeatureDataset resultDistFeatures = new FeatureDataset(newFs);
        GeometryFactory gf = new GeometryFactory();
        int numItemsProcessed = 0;
        for (Feature orgF : originFeatures) {
            monitor.report(numItemsProcessed, numDest, this.sMonitorMsg);
            BasicFeature newFeature = new BasicFeature(newFs);
            newFeature.setAttribute(orgAttrName, orgF.getAttribute(orgAttrName));
            GeometryCollection multiline = gf.createGeometryCollection(null);
            newFeature.setGeometry((Geometry)multiline);
            LineString sdline = null;
            LineString sdcline = null;
            LineString sdhline = null;
            int counter = 1;
            for (Feature destF : destinationFeatures) {
                Coordinate[] coords;
                Object destfid = destF.getAttribute(destAttrName);
                double objectDist = 0.0;
                try {
                    DistanceOp dops = new DistanceOp(orgF.getGeometry(), destF.getGeometry());
                    objectDist = dops.distance();
                    if (displayLines && counter == 1) {
                        Coordinate[] coords2 = dops.nearestPoints();
                        sdline = gf.createLineString(coords2);
                    }
                }
                catch (Exception e) {
                    objectDist = Double.NaN;
                }
                newFeature.setAttribute("sd_" + destfid.toString(), (Object)objectDist);
                if (calcCentroidDist) {
                    double centroidDist = 0.0;
                    try {
                        DistanceOp dopc = new DistanceOp((Geometry)orgF.getGeometry().getCentroid(), (Geometry)destF.getGeometry().getCentroid());
                        centroidDist = dopc.distance();
                        if (displayLines && counter == 1) {
                            coords = dopc.nearestPoints();
                            sdcline = gf.createLineString(coords);
                        }
                    }
                    catch (Exception e) {
                        centroidDist = Double.NaN;
                    }
                    newFeature.setAttribute("sdc_" + destfid.toString(), (Object)centroidDist);
                }
                if (calcHausdorffDist) {
                    double hausdDist = 0.0;
                    try {
                        DiscreteHausdorffDistance doph = new DiscreteHausdorffDistance(orgF.getGeometry(), destF.getGeometry());
                        hausdDist = doph.distance();
                        if (this.displayLineGeoms && counter == 1) {
                            coords = doph.getCoordinates();
                            sdhline = gf.createLineString(coords);
                        }
                    }
                    catch (Exception e) {
                        hausdDist = Double.NaN;
                    }
                    newFeature.setAttribute("sdh_" + destfid.toString(), (Object)hausdDist);
                }
                if (counter == 1 && this.displayLineGeoms) {
                    int arraySize = 1;
                    if (sdcline != null) {
                        ++arraySize;
                    }
                    if (sdhline != null) {
                        ++arraySize;
                    }
                    LineString[] lineStringArray = new LineString[arraySize];
                    int idx = 0;
                    lineStringArray[idx] = sdline;
                    if (sdcline != null) {
                        lineStringArray[++idx] = sdcline;
                    }
                    if (sdhline != null) {
                        lineStringArray[++idx] = sdhline;
                    }
                    multiline = gf.createMultiLineString(lineStringArray);
                    newFeature.setGeometry((Geometry)multiline);
                }
                ++counter;
            }
            resultDistFeatures.add(newFeature);
            ++numItemsProcessed;
        }
        return resultDistFeatures;
    }

    private void setDialogValues(MultiInputDialog selectTypeDialog2, PlugInContext context) {
        this.dialog.setSideBarDescription(this.sidebartext);
        if (this.orgLayer == null) {
            this.orgLayer = context.getCandidateLayer(0);
        }
        this.layerboxAOrg = this.dialog.addLayerComboBox(this.sSRC_LAYER, this.orgLayer, "", context.getLayerManager());
        this.layerboxAOrg.addItemListener(new MethodItemListenerOrg());
        this.attribboxAOrg = this.dialog.addComboBox(this.sSRC_UniqueIdAttrib, this.attrValueOrg, this.attCollOrg, "");
        this.updateUIForAttributesOrg();
        if (this.destLayer == null) {
            this.destLayer = context.getCandidateLayer(0);
        }
        this.layerboxBDest = this.dialog.addLayerComboBox(this.sTGT_LAYER, this.destLayer, "", context.getLayerManager());
        this.layerboxBDest.addItemListener(new MethodItemListenerDest());
        this.attribboxBDest = this.dialog.addComboBox(this.sTGT_UniqueIdAttrib, this.attrValueDest, this.attCollDest, "");
        this.updateUIForAttributesDest();
        this.dialog.addSeparator();
        this.dialog.addLabel(this.sDIST_OP + ":");
        this.dialog.addCheckBox(this.sCalcCentroidDist, this.calcCentroidDistance);
        this.dialog.addCheckBox(this.sCalcHausdorffDsit, this.calcHausdorffDistance);
        this.dialog.addSeparator();
        this.dialog.addCheckBox(this.sGenerateLines, this.displayLineGeoms);
    }

    private void updateUIForAttributesOrg() {
        this.orgLayer = this.dialog.getLayer(this.sSRC_LAYER);
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (int i = 0; i < this.orgLayer.getFeatureCollectionWrapper().getFeatureSchema().getAttributeCount(); ++i) {
            if (i == this.orgLayer.getFeatureCollectionWrapper().getFeatureSchema().getGeometryIndex()) continue;
            model.addElement(this.orgLayer.getFeatureCollectionWrapper().getFeatureSchema().getAttributeName(i));
        }
        this.attribboxAOrg.setModel(model);
        if (model.getSize() == 0) {
            // empty if block
        }
        this.dialog.validate();
    }

    private void updateUIForAttributesDest() {
        this.destLayer = this.dialog.getLayer(this.sTGT_LAYER);
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (int i = 0; i < this.destLayer.getFeatureCollectionWrapper().getFeatureSchema().getAttributeCount(); ++i) {
            if (i == this.destLayer.getFeatureCollectionWrapper().getFeatureSchema().getGeometryIndex()) continue;
            model.addElement(this.destLayer.getFeatureCollectionWrapper().getFeatureSchema().getAttributeName(i));
        }
        this.attribboxBDest.setModel(model);
        if (model.getSize() == 0) {
            // empty if block
        }
        this.dialog.validate();
    }

    private void getdialogValues(MultiInputDialog dialog) {
        this.orgLayer = dialog.getLayer(this.sSRC_LAYER);
        this.destLayer = dialog.getLayer(this.sTGT_LAYER);
        this.orgAttrName = (String)this.attribboxAOrg.getSelectedItem();
        this.destAttrName = (String)this.attribboxBDest.getSelectedItem();
        this.calcCentroidDistance = dialog.getBoolean(this.sCalcCentroidDist);
        this.calcHausdorffDistance = dialog.getBoolean(this.sCalcHausdorffDsit);
        this.displayLineGeoms = dialog.getBoolean(this.sGenerateLines);
    }

    private class MethodItemListenerDest
    implements ItemListener {
        private MethodItemListenerDest() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            CalculateDistancesPlugIn.this.updateUIForAttributesDest();
        }
    }

    private class MethodItemListenerOrg
    implements ItemListener {
        private MethodItemListenerOrg() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            CalculateDistancesPlugIn.this.updateUIForAttributesOrg();
        }
    }
}

