/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools.aggregate;

import com.vividsolutions.jump.feature.AttributeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.locationtech.jts.operation.overlayng.OverlayNGRobust;
import org.locationtech.jts.operation.overlayng.UnaryUnionNG;
import org.openjump.core.ui.plugin.tools.aggregate.AbstractAggregator;
import org.openjump.core.ui.plugin.tools.aggregate.Aggregator;

public class Aggregators {
    private static final Map<AttributeType, Map<String, Aggregator<?>>> aggregatorsByType = new HashMap();
    private static final Map<String, Aggregator<?>> aggregatorsByName = new HashMap();

    public static Aggregator<?> getAggregator(String name) {
        return aggregatorsByName.get(name);
    }

    public static Map<String, Aggregator<?>> getAggregators(AttributeType type) {
        return aggregatorsByType.get(type);
    }

    private static void addAggregator(AttributeType inputType, Aggregator<?> aggregator) {
        aggregatorsByName.put(aggregator.getName(), aggregator);
        Map<String, Aggregator<?>> map = aggregatorsByType.get(inputType);
        if (map == null) {
            map = new HashMap();
            aggregatorsByType.put(inputType, map);
        }
        map.put(aggregator.getName(), aggregator);
    }

    static {
        Aggregators.addAggregator(AttributeType.STRING, new Count(false));
        Aggregators.addAggregator(AttributeType.BOOLEAN, new Count(false));
        Aggregators.addAggregator(AttributeType.INTEGER, new Count(false));
        Aggregators.addAggregator(AttributeType.LONG, new Count(false));
        Aggregators.addAggregator(AttributeType.DOUBLE, new Count(false));
        Aggregators.addAggregator(AttributeType.DATE, new Count(false));
        Aggregators.addAggregator(AttributeType.GEOMETRY, new Count(false));
        Aggregators.addAggregator(AttributeType.OBJECT, new Count(false));
        Aggregators.addAggregator(AttributeType.GEOMETRY, new Collect());
        Aggregators.addAggregator(AttributeType.GEOMETRY, new Union());
        Aggregators.addAggregator(AttributeType.STRING, new Concatenate(false));
        Aggregators.addAggregator(AttributeType.STRING, new ConcatenateUnique(false));
        Aggregators.addAggregator(AttributeType.INTEGER, new IntSum());
        Aggregators.addAggregator(AttributeType.INTEGER, new LongSum());
        Aggregators.addAggregator(AttributeType.LONG, new LongSum());
        Aggregators.addAggregator(AttributeType.DOUBLE, new LongSum());
        Aggregators.addAggregator(AttributeType.INTEGER, new DoubleSum());
        Aggregators.addAggregator(AttributeType.LONG, new DoubleSum());
        Aggregators.addAggregator(AttributeType.DOUBLE, new DoubleSum());
        Aggregators.addAggregator(AttributeType.INTEGER, new IntMin());
        Aggregators.addAggregator(AttributeType.LONG, new LongMin());
        Aggregators.addAggregator(AttributeType.DOUBLE, new DoubleMin());
        Aggregators.addAggregator(AttributeType.STRING, new StringMin());
        Aggregators.addAggregator(AttributeType.DATE, new DateMin());
        Aggregators.addAggregator(AttributeType.INTEGER, new IntMax());
        Aggregators.addAggregator(AttributeType.LONG, new LongMax());
        Aggregators.addAggregator(AttributeType.DOUBLE, new DoubleMax());
        Aggregators.addAggregator(AttributeType.STRING, new StringMax());
        Aggregators.addAggregator(AttributeType.DATE, new DateMax());
        Aggregators.addAggregator(AttributeType.INTEGER, new IntMean(true));
        Aggregators.addAggregator(AttributeType.LONG, new LongMean(true));
        Aggregators.addAggregator(AttributeType.DOUBLE, new DoubleMean(true));
        Aggregators.addAggregator(AttributeType.DATE, new DateMean(true));
        Aggregators.addAggregator(AttributeType.INTEGER, new IntMedian());
        Aggregators.addAggregator(AttributeType.LONG, new LongMedian());
        Aggregators.addAggregator(AttributeType.DOUBLE, new DoubleMedian());
        Aggregators.addAggregator(AttributeType.DATE, new DateMedian());
        Aggregators.addAggregator(AttributeType.STRING, new StringMajority(true));
        Aggregators.addAggregator(AttributeType.BOOLEAN, new BooleanMajority(true));
    }

    public static class BooleanMajority
    extends AbstractAggregator<Boolean> {
        public BooleanMajority(boolean ignoreNull) {
            super(AttributeType.BOOLEAN, ignoreNull, new Object[0]);
        }

        @Override
        public BooleanMajority clone() {
            return new BooleanMajority(this.ignoreNull());
        }

        @Override
        public Boolean getResult() {
            int countTrue = 0;
            int countFalse = 0;
            for (Boolean b : this.getValues()) {
                if (b == null) {
                    ++countFalse;
                    continue;
                }
                if (b.booleanValue()) {
                    ++countTrue;
                    continue;
                }
                ++countFalse;
            }
            return countTrue >= countFalse;
        }
    }

    public static class StringMajority
    extends AbstractAggregator<String> {
        public StringMajority(boolean ignoreNull) {
            super(AttributeType.STRING, ignoreNull, new Object[0]);
        }

        @Override
        public StringMajority clone() {
            return new StringMajority(this.ignoreNull());
        }

        @Override
        public String getResult() {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (Object value : this.getValues()) {
                String v = value == null ? null : value.toString();
                Integer i = (Integer)map.get(v);
                if (i == null) {
                    i = 0;
                }
                i = i + 1;
                map.put(v, i);
            }
            String maj = null;
            int majNumber = 0;
            for (Map.Entry entry : map.entrySet()) {
                if ((Integer)entry.getValue() <= majNumber) continue;
                majNumber = (Integer)entry.getValue();
                maj = (String)entry.getKey();
            }
            return maj;
        }
    }

    public static class DateMedian
    extends AbstractAggregator<Date> {
        public DateMedian() {
            super(AttributeType.DATE, true, new Object[0]);
        }

        @Override
        public DateMedian clone() {
            return new DateMedian();
        }

        @Override
        public Date getResult() {
            ArrayList sortedList = new ArrayList(this.getValues());
            if (sortedList.size() == 0) {
                return null;
            }
            Collections.sort(sortedList);
            return (Date)sortedList.get(sortedList.size() / 2);
        }
    }

    public static class DoubleMedian
    extends AbstractAggregator<Double> {
        public DoubleMedian() {
            super(AttributeType.DOUBLE, true, new Object[0]);
        }

        @Override
        public DoubleMedian clone() {
            return new DoubleMedian();
        }

        @Override
        public Double getResult() {
            ArrayList sortedList = new ArrayList(this.getValues());
            if (sortedList.size() == 0) {
                return null;
            }
            Collections.sort(sortedList);
            return (Double)sortedList.get(sortedList.size() / 2);
        }
    }

    public static class LongMedian
    extends AbstractAggregator<Long> {
        public LongMedian() {
            super(AttributeType.LONG, true, new Object[0]);
        }

        @Override
        public LongMedian clone() {
            return new LongMedian();
        }

        @Override
        public Long getResult() {
            ArrayList sortedList = new ArrayList(this.getValues());
            if (sortedList.size() == 0) {
                return null;
            }
            Collections.sort(sortedList);
            return (Long)sortedList.get(sortedList.size() / 2);
        }
    }

    public static class IntMedian
    extends AbstractAggregator<Integer> {
        public IntMedian() {
            super(AttributeType.INTEGER, true, new Object[0]);
        }

        @Override
        public IntMedian clone() {
            return new IntMedian();
        }

        @Override
        public Integer getResult() {
            ArrayList sortedList = new ArrayList(this.getValues());
            if (sortedList.size() == 0) {
                return null;
            }
            Collections.sort(sortedList);
            return (Integer)sortedList.get(sortedList.size() / 2);
        }
    }

    public static class DateMean
    extends AbstractAggregator<Date> {
        public DateMean(boolean ignoreNull) {
            super(AttributeType.DATE, ignoreNull, new Object[0]);
        }

        @Override
        public DateMean clone() {
            return new DateMean(this.ignoreNull());
        }

        @Override
        public Date getResult() {
            long sum = 0L;
            for (Date value : this.getValues()) {
                if (value == null) continue;
                sum += value.getTime();
            }
            if (this.getValues().size() == 0) {
                return null;
            }
            return new Date(sum / (long)this.getValues().size());
        }
    }

    public static class DoubleMean
    extends AbstractAggregator<Double> {
        public DoubleMean(boolean ignoreNull) {
            super(AttributeType.DOUBLE, ignoreNull, new Object[0]);
        }

        @Override
        public DoubleMean clone() {
            return new DoubleMean(this.ignoreNull());
        }

        @Override
        public Double getResult() {
            double sum = 0.0;
            for (Double value : this.getValues()) {
                if (value == null) continue;
                sum += value.doubleValue();
            }
            if (this.getValues().size() == 0) {
                return null;
            }
            return sum / (double)this.getValues().size();
        }
    }

    public static class LongMean
    extends AbstractAggregator<Long> {
        public LongMean(boolean ignoreNull) {
            super(AttributeType.LONG, ignoreNull, new Object[0]);
        }

        @Override
        public LongMean clone() {
            return new LongMean(this.ignoreNull());
        }

        @Override
        public Long getResult() {
            long sum = 0L;
            for (Long value : this.getValues()) {
                if (value == null) continue;
                sum += value.longValue();
            }
            if (this.getValues().size() == 0) {
                return null;
            }
            return sum / (long)this.getValues().size();
        }
    }

    public static class IntMean
    extends AbstractAggregator<Integer> {
        public IntMean(boolean ignoreNull) {
            super(AttributeType.INTEGER, ignoreNull, new Object[0]);
        }

        @Override
        public IntMean clone() {
            return new IntMean(this.ignoreNull());
        }

        @Override
        public Integer getResult() {
            long sum = 0L;
            for (Integer value : this.getValues()) {
                if (value == null) continue;
                sum += (long)value.intValue();
            }
            if (this.getValues().size() == 0) {
                return null;
            }
            return (int)(sum / (long)this.getValues().size());
        }
    }

    public static class DateMax
    extends AbstractAggregator<Date> {
        public DateMax() {
            super(AttributeType.DATE, true, new Object[0]);
        }

        @Override
        public DateMax clone() {
            return new DateMax();
        }

        @Override
        public Date getResult() {
            Date max = null;
            for (Date value : this.getValues()) {
                if (max != null && (value == null || !value.after(max))) continue;
                max = value;
            }
            return max;
        }
    }

    public static class StringMax
    extends AbstractAggregator<String> {
        public StringMax() {
            super(AttributeType.STRING, true, new Object[0]);
        }

        @Override
        public StringMax clone() {
            return new StringMax();
        }

        @Override
        public String getResult() {
            String max = null;
            for (String value : this.getValues()) {
                if (max != null && (value == null || value.compareToIgnoreCase(max) <= 0)) continue;
                max = value;
            }
            return max;
        }
    }

    public static class DoubleMax
    extends AbstractAggregator<Double> {
        public DoubleMax() {
            super(AttributeType.DOUBLE, true, new Object[0]);
        }

        @Override
        public DoubleMax clone() {
            return new DoubleMax();
        }

        @Override
        public Double getResult() {
            Double max = null;
            for (Double value : this.getValues()) {
                if (max != null && (value == null || !(value > max))) continue;
                max = value;
            }
            return max;
        }
    }

    public static class LongMax
    extends AbstractAggregator<Long> {
        public LongMax() {
            super(AttributeType.LONG, true, new Object[0]);
        }

        @Override
        public LongMax clone() {
            return new LongMax();
        }

        @Override
        public Long getResult() {
            Long max = null;
            for (Long value : this.getValues()) {
                if (max != null && (value == null || value <= max)) continue;
                max = value;
            }
            return max;
        }
    }

    public static class IntMax
    extends AbstractAggregator<Integer> {
        public IntMax() {
            super(AttributeType.INTEGER, true, new Object[0]);
        }

        @Override
        public IntMax clone() {
            return new IntMax();
        }

        @Override
        public Integer getResult() {
            Integer max = null;
            for (Integer value : this.getValues()) {
                if (max != null && (value == null || value <= max)) continue;
                max = value;
            }
            return max;
        }
    }

    public static class DateMin
    extends AbstractAggregator<Date> {
        public DateMin() {
            super(AttributeType.DATE, true, new Object[0]);
        }

        @Override
        public DateMin clone() {
            return new DateMin();
        }

        @Override
        public Date getResult() {
            Date min = null;
            for (Date value : this.getValues()) {
                if (min != null && (value == null || !value.before(min))) continue;
                min = value;
            }
            return min;
        }
    }

    public static class StringMin
    extends AbstractAggregator<String> {
        public StringMin() {
            super(AttributeType.STRING, true, new Object[0]);
        }

        @Override
        public StringMin clone() {
            return new StringMin();
        }

        @Override
        public String getResult() {
            String min = null;
            for (String value : this.getValues()) {
                if (min != null && (value == null || value.compareToIgnoreCase(min) >= 0)) continue;
                min = value;
            }
            return min;
        }
    }

    public static class DoubleMin
    extends AbstractAggregator<Double> {
        public DoubleMin() {
            super(AttributeType.DOUBLE, true, new Object[0]);
        }

        @Override
        public DoubleMin clone() {
            return new DoubleMin();
        }

        @Override
        public Double getResult() {
            Double min = null;
            for (Double value : this.getValues()) {
                if (min != null && (value == null || !(value < min))) continue;
                min = value;
            }
            return min;
        }
    }

    public static class LongMin
    extends AbstractAggregator<Long> {
        public LongMin() {
            super(AttributeType.LONG, true, new Object[0]);
        }

        @Override
        public LongMin clone() {
            return new LongMin();
        }

        @Override
        public Long getResult() {
            Long min = null;
            for (Long value : this.getValues()) {
                if (min != null && (value == null || value >= min)) continue;
                min = value;
            }
            return min;
        }
    }

    public static class IntMin
    extends AbstractAggregator<Integer> {
        public IntMin() {
            super(AttributeType.INTEGER, true, new Object[0]);
        }

        @Override
        public IntMin clone() {
            return new IntMin();
        }

        @Override
        public Integer getResult() {
            Integer min = null;
            for (Integer value : this.getValues()) {
                if (min != null && (value == null || value >= min)) continue;
                min = value;
            }
            return min;
        }
    }

    public static class DoubleSum
    extends AbstractAggregator<Number> {
        public DoubleSum() {
            super(AttributeType.DOUBLE, true, new Object[0]);
        }

        @Override
        public DoubleSum clone() {
            return new DoubleSum();
        }

        @Override
        public Double getResult() {
            double sum = 0.0;
            for (Number value : this.getValues()) {
                if (value == null) continue;
                sum += value.doubleValue();
            }
            return sum;
        }
    }

    public static class LongSum
    extends AbstractAggregator<Number> {
        public LongSum() {
            super(AttributeType.LONG, true, new Object[0]);
        }

        @Override
        public LongSum clone() {
            return new LongSum();
        }

        @Override
        public Long getResult() {
            long sum = 0L;
            for (Number value : this.getValues()) {
                if (value == null) continue;
                sum += value.longValue();
            }
            return sum;
        }
    }

    public static class IntSum
    extends AbstractAggregator<Integer> {
        public IntSum() {
            super(AttributeType.INTEGER, true, new Object[0]);
        }

        @Override
        public IntSum clone() {
            return new IntSum();
        }

        @Override
        public Integer getResult() {
            int sum = 0;
            for (Integer value : this.getValues()) {
                if (value == null) continue;
                sum += value.intValue();
            }
            return sum;
        }
    }

    public static class Union
    extends AbstractAggregator<Geometry> {
        public Union() {
            super(AttributeType.GEOMETRY, true, new Object[0]);
        }

        @Override
        public Union clone() {
            Union clone = new Union();
            for (String key : this.getParameters()) {
                clone.setParameter(key, this.getParameter(key));
            }
            return clone;
        }

        public Geometry getResult() {
            GeometryFactory gf = this.getValues().size() == 0 ? new GeometryFactory() : ((Geometry)this.getValues().get(0)).getFactory();
            Geometry collected = gf.buildGeometry((Collection)this.getValues());
            if (this.getValues().size() == 0) {
                return collected;
            }
            ArrayList<Geometry> points = new ArrayList<Geometry>();
            ArrayList<Geometry> lineStrings = new ArrayList<Geometry>();
            ArrayList<Geometry> polygons = new ArrayList<Geometry>();
            this.decompose(collected, points, lineStrings, polygons);
            LineMerger merger = new LineMerger();
            merger.add(lineStrings);
            ArrayList<Geometry> geometries = new ArrayList<Geometry>();
            geometries.addAll(points);
            geometries.addAll(merger.getMergedLineStrings());
            Geometry mpoly = this.getParameter("precision") == null || this.getParameter("precision").equals(0.0) ? OverlayNGRobust.union(polygons) : UnaryUnionNG.union(polygons, (PrecisionModel)new PrecisionModel(((Double)this.getParameter("precision")).doubleValue()));
            if (mpoly != null) {
                for (int i = 0; i < mpoly.getNumGeometries(); ++i) {
                    geometries.add(mpoly.getGeometryN(i));
                }
            }
            return gf.buildGeometry(geometries);
        }

        private void decompose(Geometry geometry, List<Geometry> dim0, List<Geometry> dim1, List<Geometry> dim2) {
            if (geometry instanceof GeometryCollection) {
                for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                    this.decompose(geometry.getGeometryN(i), dim0, dim1, dim2);
                }
            } else if (geometry.getDimension() == 2) {
                dim2.add(geometry);
            } else if (geometry.getDimension() == 1) {
                dim1.add(geometry);
            } else if (geometry.getDimension() == 0) {
                dim0.add(geometry);
            } else assert (false) : "Should never reach here";
        }
    }

    public static class Collect
    extends AbstractAggregator<Geometry> {
        public Collect() {
            super(AttributeType.GEOMETRY, true, new Object[0]);
        }

        @Override
        public Collect clone() {
            return new Collect();
        }

        public Geometry getResult() {
            return new GeometryFactory().buildGeometry((Collection)this.getValues());
        }
    }

    public static class ConcatenateUnique
    extends AbstractAggregator<Object> {
        public ConcatenateUnique(boolean ignoreNull) {
            super(AttributeType.STRING, ignoreNull, new Object[0]);
            this.setParameter("Separator", ",");
        }

        @Override
        public ConcatenateUnique clone() {
            ConcatenateUnique concatenate = new ConcatenateUnique(this.ignoreNull());
            concatenate.setParameter("Separator", this.getParameter("Separator"));
            return concatenate;
        }

        @Override
        public String getResult() {
            StringBuilder sb = new StringBuilder();
            List values = this.getValues();
            for (int i = 0; i < values.size(); ++i) {
                if (values.get(i) != null) continue;
                values.set(i, "<NULL>");
            }
            TreeSet set = new TreeSet(values);
            for (Object value : set) {
                if (sb.length() == 0) {
                    sb.append(value);
                    continue;
                }
                sb.append(this.getParameter("Separator")).append(value);
            }
            return sb.toString();
        }
    }

    public static class Concatenate
    extends AbstractAggregator<Object> {
        public Concatenate(boolean ignoreNull) {
            super(AttributeType.STRING, ignoreNull, new Object[0]);
            this.setParameter("Separator", ",");
        }

        @Override
        public Concatenate clone() {
            Concatenate concatenate = new Concatenate(this.ignoreNull());
            concatenate.setParameter("Separator", this.getParameter("Separator"));
            return concatenate;
        }

        @Override
        public String getResult() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.getValues().size(); ++i) {
                String v;
                String string = v = this.getValues().get(i) == null ? "<NULL>" : this.getValues().get(i).toString();
                if (i == 0) {
                    sb.append(v);
                    continue;
                }
                sb.append(this.getParameter("Separator")).append(v);
            }
            return sb.toString();
        }
    }

    public static class Count
    extends AbstractAggregator<Object> {
        public Count(boolean ignoreNull) {
            super(AttributeType.INTEGER, ignoreNull, new Object[0]);
        }

        @Override
        public Count clone() {
            return new Count(this.ignoreNull());
        }

        @Override
        public Integer getResult() {
            return this.getValues().size();
        }
    }
}

