/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureDatasetFactory;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.triangulate.ConformingDelaunayTriangulationBuilder;
import org.openjump.core.ui.images.IconLoader;
import org.openjump.core.ui.plugin.AbstractThreadedUiPlugIn;

public class TriangulationPlugIn
extends AbstractThreadedUiPlugIn {
    public static String TRIANGULATE = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.TriangulationPlugIn.triangulate");
    public static String TRIANGULATED = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.TriangulationPlugIn.triangulated");
    public static String SITES_LAYER = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.TriangulationPlugIn.sites-layer");
    public static String CONSTRAINTS_LAYER = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.TriangulationPlugIn.constraints-layer");
    public static String INTERIOR_ONLY = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.TriangulationPlugIn.polygon-interior-only");
    public static String TOLERANCE = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.TriangulationPlugIn.tolerance");
    public static String DESCRIPTION = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.TriangulationPlugIn.description");
    public static Layer NO_CONSTRAINT;
    String sitesLayer;
    String constraintsLayer = null;
    boolean polygonInteriorOnly = false;
    double tolerance = 0.0;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_GENERATE}, this.getName() + "...", false, IconLoader.icon("triangulation.png"), TriangulationPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        if (NO_CONSTRAINT == null) {
            NO_CONSTRAINT = new Layer(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.TriangulationPlugIn.no-constraint"), Color.BLACK, new FeatureDataset(new FeatureSchema()), new LayerManager());
        }
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    public void setSitesLayer(String sitesLayer) {
        this.sitesLayer = sitesLayer;
    }

    public void setConstraintsLayer(String constraintsLayer) {
        this.constraintsLayer = constraintsLayer;
    }

    public void setPolygonInteriorOnly(boolean polygonInteriorOnly) {
        this.polygonInteriorOnly = polygonInteriorOnly;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(DESCRIPTION);
        if (this.sitesLayer == null || context.getLayerManager().getLayer(this.sitesLayer) == null) {
            this.sitesLayer = context.getCandidateLayer(0).getName();
        }
        dialog.addLayerComboBox(SITES_LAYER, context.getLayerManager().getLayer(this.sitesLayer), null, context.getLayerManager());
        final JComboBox<Layer> jcbConstraint = dialog.addLayerComboBox(CONSTRAINTS_LAYER, NO_CONSTRAINT, null, this.getConstraintCandidateLayers(context));
        final JCheckBox jcbInteriordialog = dialog.addCheckBox(INTERIOR_ONLY, this.polygonInteriorOnly);
        jcbInteriordialog.setEnabled(jcbConstraint.getSelectedItem() != NO_CONSTRAINT);
        jcbConstraint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                jcbInteriordialog.setEnabled(jcbConstraint.getSelectedItem() != NO_CONSTRAINT);
            }
        });
        dialog.addDoubleField(TOLERANCE, this.tolerance, 12);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.sitesLayer = dialog.getLayer(SITES_LAYER).getName();
        this.constraintsLayer = dialog.getLayer(CONSTRAINTS_LAYER) != NO_CONSTRAINT ? dialog.getLayer(CONSTRAINTS_LAYER).getName() : null;
        this.polygonInteriorOnly = dialog.getBoolean(INTERIOR_ONLY);
        this.tolerance = dialog.getDouble(TOLERANCE);
    }

    private List<Layer> getConstraintCandidateLayers(PlugInContext context) {
        Layer[] layers = context.getLayerManager().getLayers().toArray(new Layer[0]);
        ArrayList<Layer> linearLayers = new ArrayList<Layer>();
        linearLayers.add(NO_CONSTRAINT);
        for (Layer layer : layers) {
            FeatureCollectionWrapper fc = layer.getFeatureCollectionWrapper();
            if (fc.isEmpty() || fc.iterator().next().getGeometry().getDimension() <= 0) continue;
            linearLayers.add(layer);
        }
        return linearLayers;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.report(TRIANGULATE);
        Geometry sites = this.getSites(context.getLayerManager().getLayer(this.sitesLayer).getFeatureCollectionWrapper());
        ConformingDelaunayTriangulationBuilder triangulationBuilder = new ConformingDelaunayTriangulationBuilder();
        triangulationBuilder.setSites(sites);
        triangulationBuilder.setTolerance(this.tolerance);
        if (this.constraintsLayer != null) {
            triangulationBuilder.setConstraints(this.getConstraints(context.getLayerManager().getLayer(this.constraintsLayer).getFeatureCollectionWrapper()));
        }
        Geometry g = triangulationBuilder.getTriangles(new GeometryFactory());
        List<Geometry> geometries = new ArrayList<Geometry>();
        for (int i = 0; i < g.getNumGeometries(); ++i) {
            geometries.add(g.getGeometryN(i));
        }
        if (this.polygonInteriorOnly && this.constraintsLayer != null) {
            geometries = this.removeTrianglesOutOfPolygons(geometries, this.getPolygons(context.getLayerManager().getLayer(this.constraintsLayer).getFeatureCollectionWrapper()));
        }
        FeatureCollection result = FeatureDatasetFactory.createFromGeometry(geometries);
        context.getLayerManager().addLayer(StandardCategoryNames.RESULT, this.sitesLayer + "-" + TRIANGULATED, result);
    }

    private List<Geometry> removeTrianglesOutOfPolygons(List<Geometry> geometries, List<Polygon> polygons) {
        STRtree index = new STRtree();
        ArrayList<Geometry> result = new ArrayList<Geometry>();
        for (Polygon p : polygons) {
            index.insert(p.getEnvelopeInternal(), (Object)p);
        }
        block1: for (Geometry g : geometries) {
            Point p = g.getInteriorPoint();
            List candidates = index.query(p.getEnvelopeInternal());
            for (Object o : candidates) {
                if (!((Geometry)o).contains((Geometry)p)) continue;
                result.add(g);
                continue block1;
            }
        }
        return result;
    }

    private Geometry getSites(FeatureCollection fcSites) {
        GeometryFactory gf;
        ArrayList<Point> sites = new ArrayList<Point>();
        if (fcSites.isEmpty()) {
            gf = new GeometryFactory();
        } else {
            gf = fcSites.iterator().next().getGeometry().getFactory();
            for (Feature o : fcSites.getFeatures()) {
                this.addSite(o.getGeometry(), sites, gf);
            }
        }
        return gf.createMultiPoint(sites.toArray(new Point[sites.size()]));
    }

    private void addSite(Geometry g, List<Point> sites, GeometryFactory gf) {
        if (g instanceof Point) {
            sites.add((Point)g);
        } else {
            for (Coordinate c : g.getCoordinates()) {
                sites.add(gf.createPoint(c));
            }
        }
    }

    private Geometry getConstraints(FeatureCollection fcConstraints) {
        GeometryFactory gf;
        ArrayList<LineString> constraints = new ArrayList<LineString>();
        if (fcConstraints.isEmpty()) {
            gf = new GeometryFactory();
        } else {
            gf = fcConstraints.iterator().next().getGeometry().getFactory();
            for (Feature o : fcConstraints.getFeatures()) {
                this.addConstraints(o.getGeometry(), constraints, gf);
            }
        }
        return gf.createMultiLineString(constraints.toArray(new LineString[constraints.size()]));
    }

    private void addConstraints(Geometry g, List<LineString> constraints, GeometryFactory gf) {
        if (g instanceof GeometryCollection) {
            for (int i = 0; i < g.getNumGeometries(); ++i) {
                this.addConstraints(g.getGeometryN(i), constraints, gf);
            }
        } else if (g instanceof Polygon) {
            constraints.add((LineString)((Polygon)g).getExteriorRing());
            for (int i = 0; i < ((Polygon)g).getNumInteriorRing(); ++i) {
                constraints.add((LineString)((Polygon)g).getInteriorRingN(i));
            }
        } else if (g instanceof LineString) {
            constraints.add((LineString)g);
        }
    }

    private List<Polygon> getPolygons(FeatureCollection fcConstraints) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        if (!fcConstraints.isEmpty()) {
            GeometryFactory gf = fcConstraints.iterator().next().getGeometry().getFactory();
            for (Feature o : fcConstraints.getFeatures()) {
                this.addPolygons(o.getGeometry(), polygons, gf);
            }
        }
        return polygons;
    }

    private void addPolygons(Geometry g, List<Polygon> polygons, GeometryFactory gf) {
        if (g instanceof GeometryCollection) {
            for (int i = 0; i < g.getNumGeometries(); ++i) {
                this.addPolygons(g.getGeometryN(i), polygons, gf);
            }
        } else if (g instanceof Polygon) {
            polygons.add((Polygon)g);
        }
    }
}

