/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JComponent;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.openjump.core.geomutils.Arc;
import org.openjump.core.geomutils.MathVector;

public class JoinWithArcPlugIn
extends AbstractPlugIn {
    private WorkbenchContext workbenchContext;
    private static final String sJoinWithArc = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinWithArcPlugIn.Join-With-Arc");
    private static final String sNew = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinWithArcPlugIn.New");
    private static final String sTheArcRadius = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinWithArcPlugIn.The-arc-radius");
    private static final String sBetween = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinWithArcPlugIn.Between");
    private static final String sAnd = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinWithArcPlugIn.and");
    private static final String sFeaturesMustBeSelected = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinWithArcPlugIn.features-must-be-selected");
    private static final String RADIUS = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinWithArcPlugIn.Radius");
    private double arcRadius = 50.0;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.workbenchContext = context.getWorkbenchContext();
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_GEOMETRY}, this.getName(), false, null, this.createEnableCheck(this.workbenchContext));
    }

    @Override
    public String getName() {
        return sJoinWithArc;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        Collection<Feature> selectedFeatures = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        LinearRing fillet = null;
        if (selectedFeatures.size() == 1) {
            Geometry geo = selectedFeatures.iterator().next().getGeometry();
            if (geo instanceof LinearRing) {
                fillet = this.filletLinearRing((LinearRing)geo);
            } else if (geo instanceof LineString) {
                fillet = this.filletOneLineString((LineString)geo);
            } else if (geo instanceof Polygon) {
                fillet = this.filletPolygon((Polygon)geo);
            }
        } else if (selectedFeatures.size() == 2) {
            Iterator<Feature> i = selectedFeatures.iterator();
            Feature feature1 = i.next();
            Feature feature2 = i.next();
            Geometry geo1 = feature1.getGeometry();
            Geometry geo2 = feature2.getGeometry();
            if (geo1 instanceof LineString && geo2 instanceof LineString) {
                fillet = this.filletTwoLineStrings((LineString)geo1, (LineString)geo2);
            }
        }
        if (fillet != null) {
            Feature currFeature = selectedFeatures.iterator().next();
            Feature newFeature = currFeature.clone(true);
            newFeature.setGeometry((Geometry)fillet);
            Collection<Category> selectedCategories = context.getLayerNamePanel().getSelectedCategories();
            LayerManager layerManager = context.getLayerManager();
            FeatureDataset newFeatures = new FeatureDataset(currFeature.getSchema());
            newFeatures.add(newFeature);
            layerManager.addLayer(selectedCategories.isEmpty() ? StandardCategoryNames.WORKING : ((Object)selectedCategories.iterator().next()).toString(), layerManager.uniqueLayerName(sNew), newFeatures);
            layerManager.getLayer(0).setFeatureCollectionModified(true);
            layerManager.getLayer(0).setEditable(true);
        }
        return true;
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.addDoubleField(RADIUS, this.arcRadius, 6, sTheArcRadius);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.arcRadius = dialog.getDouble(RADIUS);
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createOnlyOneLayerMayHaveSelectedFeaturesCheck()).add(this.createBetweenNAndMFeaturesMustBeSelectedCheck(1, 2)).add(checkFactory.createAtLeastNFeaturesMustHaveSelectedItemsCheck(1));
    }

    private EnableCheck createBetweenNAndMFeaturesMustBeSelectedCheck(final int n, final int m) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                int numSelected = JoinWithArcPlugIn.this.workbenchContext.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems().size();
                return numSelected > m || numSelected < n ? sBetween + " " + n + " " + sAnd + " " + m + " " + sFeaturesMustBeSelected : null;
            }
        };
    }

    private Coordinate Intersect(Coordinate P1, Coordinate P2, Coordinate P3, Coordinate P4) {
        Coordinate V = new Coordinate(P2.x - P1.x, P2.y - P1.y);
        Coordinate W = new Coordinate(P4.x - P3.x, P4.y - P3.y);
        double n = W.y * (P3.x - P1.x) - W.x * (P3.y - P1.y);
        double d = W.y * V.x - W.x * V.y;
        if (d != 0.0) {
            double t1 = n / d;
            return new Coordinate(P1.x + V.x * t1, P1.y + V.y * t1);
        }
        return null;
    }

    private LineString MakeRoundCorner(Coordinate A, Coordinate B, Coordinate C, Coordinate D, double r, boolean arcOnly) {
        Coordinate E = this.Intersect(A, B, C, D);
        if (E != null) {
            Coordinate temp;
            MathVector Ev = new MathVector(E);
            if (E.distance(B) > E.distance(A)) {
                temp = A;
                A = B;
                B = temp;
            }
            if (E.distance(D) > E.distance(C)) {
                temp = C;
                C = D;
                D = temp;
            }
            MathVector Av = new MathVector(A);
            MathVector Cv = new MathVector(C);
            double alpha = Av.vectorBetween(Ev).angleRad(Cv.vectorBetween(Ev)) / 2.0;
            double h1 = Math.abs(r / Math.sin(alpha));
            if (h1 * h1 - r * r >= 0.0) {
                double d1 = Math.sqrt(h1 * h1 - r * r);
                double theta = 1.5707963267948966 - alpha;
                theta *= 2.0;
                MathVector Gv = Ev.add(Av.vectorBetween(Ev).unit().scale(d1));
                MathVector Hv = Ev.add(Cv.vectorBetween(Ev).unit().scale(d1));
                MathVector Fv = Ev.add(Gv.vectorBetween(Ev).rotateRad(alpha).unit().scale(h1));
                if (Math.abs(Fv.distance(Hv) - Fv.distance(Gv)) > 1.0) {
                    Fv = Ev.add(Gv.vectorBetween(Ev).rotateRad(-alpha).unit().scale(h1));
                    theta = -theta;
                }
                CoordinateList coordinates = new CoordinateList();
                if (!arcOnly) {
                    coordinates.add((Object)C);
                }
                Arc arc = new Arc(Fv.getCoord(), Hv.getCoord(), Math.toDegrees(theta));
                LineString lineString = arc.getLineString();
                coordinates.add(lineString.getCoordinates(), false);
                if (!arcOnly) {
                    coordinates.add((Object)A);
                }
                return new GeometryFactory().createLineString(coordinates.toCoordinateArray());
            }
        }
        return null;
    }

    private LineString filletTwoLineStrings(LineString ls1, LineString ls2) {
        Coordinate D;
        Coordinate C;
        Coordinate B;
        Coordinate A = ls1.getCoordinateN(0);
        LineString lineString = this.MakeRoundCorner(A, B = ls1.getCoordinateN(1), C = ls2.getCoordinateN(0), D = ls2.getCoordinateN(1), this.arcRadius, false);
        if (lineString != null) {
            CoordinateList coordinates = new CoordinateList();
            coordinates.add(lineString.getCoordinates(), false);
            return new GeometryFactory().createLineString(coordinates.toCoordinateArray());
        }
        return null;
    }

    private LineString filletOneLineString(LineString ls) {
        if (ls.getNumPoints() > 2) {
            CoordinateList filletCoordinates = new CoordinateList();
            filletCoordinates.add((Object)ls.getCoordinateN(0));
            for (int i = 0; i <= ls.getNumPoints() - 3; ++i) {
                Coordinate D;
                Coordinate C;
                Coordinate B;
                Coordinate A = ls.getCoordinateN(i);
                LineString lineString = this.MakeRoundCorner(A, B = ls.getCoordinateN(i + 1), C = ls.getCoordinateN(i + 1), D = ls.getCoordinateN(i + 2), this.arcRadius, true);
                if (lineString == null || lineString.isEmpty()) continue;
                filletCoordinates.add(lineString.getCoordinates(), false, false);
            }
            filletCoordinates.add((Object)ls.getCoordinateN(ls.getNumPoints() - 1));
            return new GeometryFactory().createLineString(filletCoordinates.toCoordinateArray());
        }
        return null;
    }

    private Polygon filletPolygon(Polygon poly) {
        Coordinate D;
        Coordinate C;
        Coordinate B;
        LinearRing ls = poly.getExteriorRing();
        CoordinateList filletCoordinates = new CoordinateList();
        for (int i = 0; i <= ls.getNumPoints() - 3; ++i) {
            Coordinate D2;
            Coordinate C2;
            Coordinate B2;
            Coordinate A = ls.getCoordinateN(i);
            LineString lineString = this.MakeRoundCorner(A, B2 = ls.getCoordinateN(i + 1), C2 = ls.getCoordinateN(i + 1), D2 = ls.getCoordinateN(i + 2), this.arcRadius, true);
            if (lineString == null) continue;
            filletCoordinates.add(lineString.getCoordinates(), false, false);
        }
        Coordinate A = ls.getCoordinateN(ls.getNumPoints() - 2);
        LineString lineString = this.MakeRoundCorner(A, B = ls.getCoordinateN(0), C = ls.getCoordinateN(0), D = ls.getCoordinateN(1), this.arcRadius, true);
        if (lineString != null) {
            filletCoordinates.add(lineString.getCoordinates(), false, false);
            filletCoordinates.add((Object)filletCoordinates.getCoordinate(0));
        }
        return new GeometryFactory().createPolygon(new GeometryFactory().createLinearRing(filletCoordinates.toCoordinateArray()), null);
    }

    private LinearRing filletLinearRing(LinearRing ring) {
        Coordinate D;
        Coordinate C;
        Coordinate B;
        CoordinateList filletCoordinates = new CoordinateList();
        for (int i = 0; i <= ring.getNumPoints() - 3; ++i) {
            Coordinate D2;
            Coordinate C2;
            Coordinate B2;
            Coordinate A = ring.getCoordinateN(i);
            LineString lineString = this.MakeRoundCorner(A, B2 = ring.getCoordinateN(i + 1), C2 = ring.getCoordinateN(i + 1), D2 = ring.getCoordinateN(i + 2), this.arcRadius, true);
            if (lineString == null) continue;
            filletCoordinates.add(lineString.getCoordinates(), false, false);
        }
        Coordinate A = ring.getCoordinateN(ring.getNumPoints() - 2);
        LineString lineString = this.MakeRoundCorner(A, B = ring.getCoordinateN(0), C = ring.getCoordinateN(0), D = ring.getCoordinateN(1), this.arcRadius, true);
        if (lineString != null) {
            filletCoordinates.add(lineString.getCoordinates(), false, false);
            filletCoordinates.add((Object)filletCoordinates.getCoordinate(0));
        }
        return new GeometryFactory().createLinearRing(filletCoordinates.toCoordinateArray());
    }
}

