/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.util.GeometryFixer;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.locationtech.jts.operation.overlayng.OverlayNGRobust;
import org.locationtech.jts.operation.overlayng.UnaryUnionNG;
import org.openjump.core.ui.plugin.AbstractThreadedUiPlugIn;

public class DissolvePlugIn
extends AbstractThreadedUiPlugIn {
    private final String LAYER = I18N.JUMP.get("ui.plugin.analysis.DissolvePlugIn.source-layer");
    private final String DESCRIPTION = I18N.JUMP.get("ui.plugin.analysis.DissolvePlugIn.description");
    private final String ATTRIBUTES = I18N.JUMP.get("ui.plugin.analysis.DissolvePlugIn.attributes");
    private final String MERGE_LINESTRINGS = I18N.JUMP.get("ui.plugin.analysis.DissolvePlugIn.merge-linestrings");
    private final String SIMPLE_GEOMETRIES = I18N.JUMP.get("ui.plugin.analysis.DissolvePlugIn.decompose-multi-geometries");
    private final String REMOVE_UNUSED_ATT = I18N.JUMP.get("ui.plugin.analysis.DissolvePlugIn.remove-unused-attributes");
    private final String FLOATING_PRECISION_MODEL = I18N.JUMP.get("jts.use-floating-point-precision-model");
    private final String FLOATING_PRECISION_MODEL_TT = I18N.JUMP.get("jts.use-floating-point-precision-model-tt");
    private final String FIXED_PRECISION_MODEL = I18N.JUMP.get("jts.use-fixed-precision-model");
    private final String FIXED_PRECISION_MODEL_TT = I18N.JUMP.get("jts.use-fixed-precision-model-tt");
    private final String PRECISION = I18N.JUMP.get("jts.fixed-precision");
    private final String PRECISION_TT = I18N.JUMP.get("jts.fixed-precision-tt");
    private Layer layer;
    private boolean floatingPrecision = true;
    private boolean fixedPrecision = false;
    private double precision = 1000.0;
    private boolean merge_linestrings = true;
    private boolean simple_geometries = false;
    private boolean remove_unused_att = true;
    private final List<String> attributes = new ArrayList<String>();
    private JPanel attributePanel;

    @Override
    public String getName() {
        return I18N.getInstance().get("ui.plugin.analysis.DissolvePlugIn");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_ANALYSIS}, this.getName() + "...", false, IconLoader.icon("dissolve_layer_icon.gif"), DissolvePlugIn.createEnableCheck(context.getWorkbenchContext()), -1);
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createTaskWindowMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustBeSelectedCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.initDialog(dialog, context);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    private void initDialog(final MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(I18N.getInstance().get(this.DESCRIPTION));
        final JComboBox<Layer> layerComboBox = dialog.addLayerComboBox(this.LAYER, context.getCandidateLayer(0), context.getLayerManager());
        JRadioButton floatingPrecisionRB = dialog.addRadioButton(this.FLOATING_PRECISION_MODEL, "MODEL", this.floatingPrecision, this.FLOATING_PRECISION_MODEL_TT);
        JRadioButton fixedPrecisionRB = dialog.addRadioButton(this.FIXED_PRECISION_MODEL, "MODEL", this.fixedPrecision, this.FIXED_PRECISION_MODEL_TT);
        dialog.addDoubleField(this.PRECISION, this.precision, 12, this.PRECISION_TT);
        floatingPrecisionRB.addActionListener(e -> this.updateControls(dialog));
        fixedPrecisionRB.addActionListener(e -> this.updateControls(dialog));
        dialog.addSubTitle(I18N.getInstance().get(this.ATTRIBUTES));
        this.attributePanel = new JPanel();
        this.attributePanel.setLayout(new BoxLayout(this.attributePanel, 1));
        JScrollPane scrollableAttributeChecks = new JScrollPane(this.attributePanel);
        scrollableAttributeChecks.setPreferredSize(new Dimension(320, 160));
        scrollableAttributeChecks.setMinimumSize(new Dimension(320, 160));
        dialog.addRow(scrollableAttributeChecks);
        dialog.addSeparator();
        JCheckBox mergeLineStringsCheckBox = dialog.addCheckBox(this.MERGE_LINESTRINGS, this.merge_linestrings, I18N.getInstance().get("ui.plugin.analysis.DissolvePlugIn.merge-linestrings-tooltip"));
        JCheckBox simpleGeometriesCheckBox = dialog.addCheckBox(this.SIMPLE_GEOMETRIES, this.simple_geometries, I18N.getInstance().get("ui.plugin.analysis.DissolvePlugIn.decompose-multi-geometries-tooltip"));
        JCheckBox removeUnusedAttCheckBox = dialog.addCheckBox(this.REMOVE_UNUSED_ATT, this.remove_unused_att, I18N.getInstance().get("ui.plugin.analysis.DissolvePlugIn.remove-unused-attributes-tooltip"));
        this.updateControls(dialog);
        layerComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ActionListener listener : layerComboBox.getActionListeners()) {
                    if (listener == this) continue;
                    listener.actionPerformed(e);
                }
                DissolvePlugIn.this.updateControls(dialog);
            }
        });
        GUIUtil.centreOnWindow(dialog);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.layer = dialog.getLayer(this.LAYER);
        this.attributes.clear();
        this.floatingPrecision = dialog.getBoolean(this.FLOATING_PRECISION_MODEL);
        this.fixedPrecision = dialog.getBoolean(this.FIXED_PRECISION_MODEL);
        this.precision = dialog.getDouble(this.PRECISION);
        for (int i = 0; i < this.attributePanel.getComponentCount(); ++i) {
            if (!(this.attributePanel.getComponent(i) instanceof JCheckBox)) continue;
            String name = ((JCheckBox)this.attributePanel.getComponent(i)).getText();
            boolean checked = ((JCheckBox)this.attributePanel.getComponent(i)).isSelected();
            if (!checked) continue;
            this.attributes.add(name);
        }
        this.merge_linestrings = dialog.getBoolean(this.MERGE_LINESTRINGS);
        this.simple_geometries = dialog.getBoolean(this.SIMPLE_GEOMETRIES);
        this.remove_unused_att = dialog.getBoolean(this.REMOVE_UNUSED_ATT);
    }

    private void updateControls(MultiInputDialog dialog) {
        this.getDialogValues(dialog);
        FeatureSchema schema = this.layer.getFeatureCollectionWrapper().getFeatureSchema();
        this.attributePanel.removeAll();
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            if (schema.getGeometryIndex() == i) continue;
            this.attributePanel.add(new JCheckBox(schema.getAttributeName(i), false));
        }
        dialog.setFieldEnabled(this.PRECISION, dialog.getBoolean(this.FIXED_PRECISION_MODEL));
        dialog.pack();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        FeatureSchema newSchema;
        monitor.allowCancellationRequests();
        List<Feature> inputC = this.layer.getFeatureCollectionWrapper().getFeatures();
        FeatureSchema schema = this.layer.getFeatureCollectionWrapper().getFeatureSchema();
        FeatureDataset inputFC = new FeatureDataset(inputC, schema);
        if (inputFC.getFeatures().size() < 2) {
            context.getWorkbenchFrame().warnUser(I18N.getInstance().get("ui.plugin.analysis.DissolvePlugIn.needs-two-features-or-more"));
            return;
        }
        if (this.remove_unused_att) {
            newSchema = new FeatureSchema();
            newSchema.addAttribute(schema.getAttributeName(schema.getGeometryIndex()), AttributeType.GEOMETRY);
            for (String string : this.attributes) {
                newSchema.addAttribute(string, schema.getAttributeType(string));
            }
        } else {
            newSchema = schema;
        }
        HashMap<Object, FeatureDataset> map = new HashMap<Object, FeatureDataset>();
        monitor.report(I18N.getInstance().get("ui.plugin.analysis.DissolvePlugIn"));
        for (Feature f : inputFC.getFeatures()) {
            List<Object> key = this.computeKeyFromAttributes(f, this.attributes);
            if (!map.containsKey(key)) {
                FeatureDataset fd = new FeatureDataset(inputFC.getFeatureSchema());
                fd.add(f);
                map.put(key, fd);
                continue;
            }
            ((FeatureCollection)map.get(key)).add(f);
        }
        boolean bl = true;
        FeatureDataset resultfc = new FeatureDataset(newSchema);
        for (List key : map.keySet()) {
            void var8_11;
            monitor.report(I18N.getInstance().get("ui.plugin.analysis.DissolvePlugIn.computing-union") + " (" + (int)(++var8_11) + "/" + map.size() + ")");
            FeatureCollection fca = (FeatureCollection)map.get(key);
            if (fca.size() <= 0) continue;
            List<Geometry> geometries = this.union(context, monitor, fca);
            for (Geometry geom : geometries) {
                BasicFeature newFeature = new BasicFeature(newSchema);
                newFeature.setGeometry(geom);
                for (int i = 0; i < this.attributes.size(); ++i) {
                    newFeature.setAttribute(this.attributes.get(i), key.get(i));
                }
                resultfc.add(newFeature);
            }
        }
        context.getLayerManager().addCategory(StandardCategoryNames.RESULT);
        String newLayerName = this.layer.getName() + "-dissolve";
        context.addLayer(StandardCategoryNames.RESULT, newLayerName, resultfc);
    }

    private List<Object> computeKeyFromAttributes(Feature feature, List<String> attributes) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (String attribute : attributes) {
            list.add(feature.getAttribute(attribute));
        }
        return list;
    }

    private List<Geometry> union(PlugInContext context, TaskMonitor monitor, FeatureCollection fc) {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        for (Feature f : fc.getFeatures()) {
            Geometry g = f.getGeometry();
            for (int i = 0; i < g.getNumGeometries(); ++i) {
                Geometry component = g.getGeometryN(i);
                if (component.isValid()) {
                    geometries.add(g.getGeometryN(i));
                    continue;
                }
                geometries.add(GeometryFixer.fix((Geometry)component));
            }
        }
        Geometry unioned = this.floatingPrecision ? OverlayNGRobust.union(geometries) : UnaryUnionNG.union(geometries, (PrecisionModel)new PrecisionModel(this.precision));
        if (this.merge_linestrings) {
            geometries.clear();
            ArrayList<Geometry> points = new ArrayList<Geometry>();
            ArrayList<Geometry> lineStrings = new ArrayList<Geometry>();
            ArrayList<Geometry> polygons = new ArrayList<Geometry>();
            this.decompose(unioned, points, lineStrings, polygons);
            LineMerger merger = new LineMerger();
            merger.add(lineStrings);
            geometries.addAll(points);
            geometries.addAll(merger.getMergedLineStrings());
            geometries.addAll(polygons);
            unioned = unioned.getFactory().buildGeometry(geometries);
        }
        geometries.clear();
        if (this.simple_geometries) {
            for (int i = 0; i < unioned.getNumGeometries(); ++i) {
                geometries.add(unioned.getGeometryN(i));
            }
        } else {
            geometries.add(unioned);
        }
        return geometries;
    }

    private void decompose(Geometry geometry, List<Geometry> dim0, List<Geometry> dim1, List<Geometry> dim2) {
        if (geometry instanceof GeometryCollection) {
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                this.decompose(geometry.getGeometryN(i), dim0, dim1, dim2);
            }
        } else if (geometry.getDimension() == 2) {
            dim2.add(geometry);
        } else if (geometry.getDimension() == 1) {
            dim1.add(geometry);
        } else if (geometry.getDimension() == 0) {
            dim0.add(geometry);
        } else assert (false) : "Should never reach here";
    }
}

