/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn;

public class BlendLineStringsPlugIn
extends AbstractPlugIn {
    private final String THE_BLEND_TOLERANCE_TOOLTIP = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.BlendLineStringsPlugIn.The-blend-tolerance");
    private final String NEW_LAYER = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.BlendLineStringsPlugIn.New");
    private final String TOLERANCE = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.BlendLineStringsPlugIn.Tolerance");
    private final String PLUGIN_NAME = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.BlendLineStringsPlugIn");
    private final String REMOVE_SOURCE_LINES = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.BlendLineStringsPlugIn.remove-source-lines");
    private final String REMOVE_SOURCE_LINES_TOOLTIP = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.BlendLineStringsPlugIn.The-source-lines-will-be-removed");
    private final String TRANSFER_FIRST_ATTRIBUTES_TO_ALL_RESULTING_LINE_STRINGS = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.BlendLineStringsPlugIn.transfer-first-attributes-to-all-resulting-linesstrings");
    private final String TRANSFER_FIRST_ATTRIBUTES_TO_ALL_RESULTING_LINE_STRINGS_TOOLTIP = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.BlendLineStringsPlugIn.the-attributes-of-the-first-linestring-will-be-transfered");
    private String CREATE_NEW_LAYER = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.BlendLineStringsPlugIn.Create-a-new-layer-for-the-results");
    private final String CREATE_NEW_LAYER_TOOLTIP = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.BlendLineStringsPlugIn.A-new-layer-will-be-created-for-the-results");
    private double blendTolerance = 0.1;
    private boolean removeSourceLines = false;
    private boolean transferFirstAttributesToAllResultingLineStrings = false;
    private boolean createNewLayer = false;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_GEOMETRY}, this.PLUGIN_NAME, false, null, this.createEnableCheck(context.getWorkbenchContext()));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        Layer selectedLayer = context.getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems().iterator().next();
        Collection<Feature> selectedFeatures = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
        Feature currFeature = selectedFeatures.iterator().next();
        ArrayList<Feature> inputLines = new ArrayList<Feature>();
        ArrayList<Feature> removeFeatures = new ArrayList<Feature>(selectedFeatures.size());
        Quadtree quadtree = new Quadtree();
        for (Feature f : selectedFeatures) {
            if (!(f.getGeometry() instanceof LineString)) continue;
            inputLines.add(f);
            removeFeatures.add(f);
            quadtree.insert(f.getGeometry().getEnvelopeInternal(), (Object)f);
        }
        while (inputLines.size() > 0) {
            Feature currentFeature = (Feature)inputLines.get(0);
            CoordinateList blendedCoords = new CoordinateList(currentFeature.getGeometry().getCoordinates());
            ArrayList<Feature> remove = new ArrayList<Feature>();
            boolean blended = true;
            while (blended) {
                Envelope search_env = currentFeature.getGeometry().getEnvelopeInternal();
                search_env.expandBy(this.blendTolerance);
                List candidates = quadtree.query(search_env);
                candidates.remove(currentFeature);
                Feature bestCandidate = this.nearest(blendedCoords.getCoordinate(0), blendedCoords.getCoordinate(blendedCoords.size() - 1), candidates);
                if (bestCandidate != null) {
                    Feature blendedFeature = this.transferFirstAttributesToAllResultingLineStrings ? currFeature.clone(false) : currentFeature.clone(false);
                    CoordinateList lsCoords = new CoordinateList(bestCandidate.getGeometry().getCoordinates());
                    if (!this.blended(blendedCoords, lsCoords)) continue;
                    quadtree.remove(currentFeature.getGeometry().getEnvelopeInternal(), (Object)currentFeature);
                    quadtree.remove(bestCandidate.getGeometry().getEnvelopeInternal(), (Object)bestCandidate);
                    remove.add(currentFeature);
                    remove.add(bestCandidate);
                    blendedFeature.setGeometry((Geometry)new GeometryFactory().createLineString(blendedCoords.toCoordinateArray()));
                    quadtree.insert(blendedFeature.getGeometry().getEnvelopeInternal(), (Object)blendedFeature);
                    currentFeature = blendedFeature;
                    continue;
                }
                blended = false;
            }
            inputLines.remove(0);
            inputLines.removeAll(remove);
        }
        if (this.createNewLayer) {
            LayerManager layerManager = context.getLayerManager();
            Collection<Category> selectedCategories = context.getLayerNamePanel().getSelectedCategories();
            FeatureDataset newFeatures = new FeatureDataset(currFeature.getSchema());
            newFeatures.addAll(quadtree.queryAll());
            layerManager.addLayer(selectedCategories.isEmpty() ? StandardCategoryNames.WORKING : ((Object)selectedCategories.iterator().next()).toString(), layerManager.uniqueLayerName(this.NEW_LAYER), newFeatures);
        } else {
            this.updateLayer(selectedLayer, removeFeatures, quadtree.queryAll());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLayer(final Layer layer, final List<Feature> remove, final List<Feature> newFeatures) {
        layer.getLayerManager().getUndoableEditReceiver().startReceiving();
        try {
            UndoableCommand command = new UndoableCommand(I18N.getInstance().get(AutoAssignAttributePlugIn.class.getName())){

                @Override
                public void execute() {
                    if (BlendLineStringsPlugIn.this.removeSourceLines) {
                        layer.getFeatureCollectionWrapper().removeAll(remove);
                        layer.getLayerManager().fireFeaturesChanged(remove, FeatureEventType.DELETED, layer);
                    }
                    layer.getFeatureCollectionWrapper().addAll(newFeatures);
                    layer.getLayerManager().fireFeaturesChanged(newFeatures, FeatureEventType.ADDED, layer);
                }

                @Override
                public void unexecute() {
                    layer.getFeatureCollectionWrapper().removeAll(newFeatures);
                    layer.getLayerManager().fireFeaturesChanged(newFeatures, FeatureEventType.DELETED, layer);
                    if (BlendLineStringsPlugIn.this.removeSourceLines) {
                        layer.getFeatureCollectionWrapper().addAll(remove);
                        layer.getLayerManager().fireFeaturesChanged(remove, FeatureEventType.ADDED, layer);
                    }
                }
            };
            command.execute();
            layer.getLayerManager().getUndoableEditReceiver().receive(command.toUndoableEdit());
        }
        finally {
            layer.getLayerManager().getUndoableEditReceiver().stopReceiving();
        }
    }

    private Feature nearest(Coordinate start0, Coordinate end0, List<Feature> candidates) {
        Feature best = null;
        double max = this.blendTolerance;
        for (Feature c : candidates) {
            Coordinate[] cc = c.getGeometry().getCoordinates();
            if (cc.length == 0) continue;
            Coordinate start1 = cc[0];
            Coordinate end1 = cc[cc.length - 1];
            double d00 = start0.distance(start1);
            double d01 = start0.distance(end1);
            double d10 = end0.distance(start1);
            double d11 = end0.distance(end1);
            if (d00 == 0.0 || d01 == 0.0 || d10 == 0.0 || d11 == 0.0) {
                return c;
            }
            if (d00 <= max) {
                max = d00;
                best = c;
            }
            if (d01 <= max) {
                max = d01;
                best = c;
            }
            if (d10 <= max) {
                max = d10;
                best = c;
            }
            if (!(d11 <= max)) continue;
            max = d11;
            best = c;
        }
        return best;
    }

    private boolean blended(CoordinateList blendedCoords, CoordinateList lsCoords) {
        int result;
        block9: {
            block11: {
                block10: {
                    block8: {
                        Coordinate start = blendedCoords.getCoordinate(0);
                        Coordinate end = blendedCoords.getCoordinate(blendedCoords.size() - 1);
                        Coordinate first = lsCoords.getCoordinate(0);
                        Coordinate last = lsCoords.getCoordinate(lsCoords.size() - 1);
                        double d00 = start.distance(first);
                        double d01 = start.distance(last);
                        double d10 = end.distance(first);
                        double d11 = end.distance(last);
                        double max = this.blendTolerance;
                        result = -1;
                        if (d00 <= max) {
                            max = d00;
                            result = 0;
                        }
                        if (d01 <= max) {
                            max = d01;
                            result = 1;
                        }
                        if (d10 <= max) {
                            max = d10;
                            result = 2;
                        }
                        if (d11 <= max) {
                            result = 3;
                        }
                        if (result != 0) break block8;
                        for (int i = 1; i < lsCoords.size(); ++i) {
                            blendedCoords.add(0, (Object)lsCoords.getCoordinate(i));
                        }
                        break block9;
                    }
                    if (result != 1) break block10;
                    for (int i = lsCoords.size() - 2; i >= 0; --i) {
                        blendedCoords.add(0, (Object)lsCoords.getCoordinate(i));
                    }
                    break block9;
                }
                if (result != 2) break block11;
                for (int i = 1; i < lsCoords.size(); ++i) {
                    blendedCoords.add((Object)lsCoords.getCoordinate(i));
                }
                break block9;
            }
            if (result != 3) break block9;
            for (int i = lsCoords.size() - 2; i >= 0; --i) {
                blendedCoords.add((Object)lsCoords.getCoordinate(i));
            }
        }
        return result > -1;
    }

    private void setDialogValues(MultiInputDialog dialog) {
        dialog.addDoubleField(this.TOLERANCE, this.blendTolerance, 6, this.THE_BLEND_TOLERANCE_TOOLTIP);
        final JCheckBox removeCheckBox = dialog.addCheckBox(this.REMOVE_SOURCE_LINES, this.removeSourceLines, this.REMOVE_SOURCE_LINES_TOOLTIP);
        removeCheckBox.setEnabled(!this.createNewLayer);
        dialog.addCheckBox(this.TRANSFER_FIRST_ATTRIBUTES_TO_ALL_RESULTING_LINE_STRINGS, this.transferFirstAttributesToAllResultingLineStrings, this.TRANSFER_FIRST_ATTRIBUTES_TO_ALL_RESULTING_LINE_STRINGS_TOOLTIP);
        JCheckBox newLayerCheckBox = dialog.addCheckBox(this.CREATE_NEW_LAYER, this.createNewLayer, this.CREATE_NEW_LAYER_TOOLTIP);
        newLayerCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                removeCheckBox.setEnabled(!((JCheckBox)e.getSource()).isSelected());
            }
        });
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.blendTolerance = dialog.getDouble(this.TOLERANCE);
        this.removeSourceLines = dialog.getBoolean(this.REMOVE_SOURCE_LINES);
        this.transferFirstAttributesToAllResultingLineStrings = dialog.getBoolean(this.TRANSFER_FIRST_ATTRIBUTES_TO_ALL_RESULTING_LINE_STRINGS);
        this.createNewLayer = dialog.getBoolean(this.CREATE_NEW_LAYER);
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createOnlyOneLayerMayHaveSelectedFeaturesCheck()).add(checkFactory.createAtLeastNFeaturesMustHaveSelectedItemsCheck(2));
    }
}

