/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.task;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.HTMLPanel;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.MultiTabInputDialog;
import com.vividsolutions.jump.workbench.ui.SuggestTreeComboBox;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.xml.namespace.QName;
import org.locationtech.jts.geom.Envelope;
import org.openjump.core.ccordsys.utils.SRSInfo;
import org.openjump.core.ccordsys.utils.SridLookupTable;
import org.openjump.core.ui.plugin.task.Utils;
import org.saig.core.gui.swing.sldeditor.util.FormUtils;

public class TaskPropertiesPlugIn
extends AbstractPlugIn {
    public static String NAME = I18N.getInstance().get("org.openjump.core.ui.plugin.file.ProjectInfoPlugIn.name");
    public static String PROJ_METADATA = I18N.getInstance().get("org.openjump.core.ui.plugin.file.ProjectInfoPlugIn.proj-metadata");
    public static String PROJ_STATUS = I18N.getInstance().get("org.openjump.core.ui.plugin.file.ProjectInfoPlugIn.proj-status");
    public static String NOT_SAVED = I18N.getInstance().get("org.openjump.core.ui.plugin.file.ProjectInfoPlugIn.not-saved");
    public static String NOT_SET = I18N.getInstance().get("org.openjump.core.ui.plugin.file.ProjectInfoPlugIn.not-set");
    public static String LAST_MODIFICATION = I18N.getInstance().get("org.openjump.core.ui.plugin.file.ProjectInfoPlugIn.last-modification");
    public static String PROJ_DESCRIPTION = I18N.getInstance().get("org.openjump.core.ui.plugin.file.ProjectInfoPlugIn.srs-description");
    public static String SEARCH_SRID = I18N.getInstance().get("org.openjump.core.ui.plugin.file.ProjectInfoPlugIn.search-srid");
    public static String NUMBER_LAYERS = I18N.getInstance().get("org.openjump.core.ui.plugin.file.ProjectInfoPlugIn.number-of-layers");
    public static String EDIT_METADATA = I18N.getInstance().get("org.openjump.core.ui.plugin.file.ProjectInfoPlugIn.edit-metadata");
    public static String TOOLTIP = I18N.getInstance().get("org.openjump.core.ui.plugin.file.ProjectInfoPlugIn.tooltip");
    public static String UNIT = I18N.getInstance().get("org.openjump.core.ui.plugin.file.ProjectInfoPlugIn.unit");
    public static String MODIFIED_LAYERS = "(*)" + I18N.getInstance().get("ui.GenericNames.MODIFIED-LAYERS");
    public static String TEMPORARY_LAYERS = "(**)" + I18N.getInstance().get("ui.GenericNames.TEMPORARY-LAYERS");
    private boolean editInfo = false;
    public static String FILE = I18N.getInstance().get("ui.MenuNames.FILE");
    public static String INFO = I18N.getInstance().get("ui.AboutDialog.info");
    public static String XMIN = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.xmin");
    public static String YMIN = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.ymin");
    public static String XMAX = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.xmax");
    public static String YMAX = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.ymax");
    public static String EXTENT = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.extent");
    public static String SOURCE_PATH = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Source-Path");
    public static String DATASOURCE_CLASS = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.DataSource-Class");
    private static String LAYER_NAME = I18N.getInstance().get("jump.workbench.ui.plugin.datastore.ConnectionDescriptorPanel.Name");
    public static String SRS = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.SRS");
    JLabel fileT = new JLabel(FILE);
    JLabel sridLabel = new JLabel(SEARCH_SRID);
    JLabel dateT = new JLabel(LAST_MODIFICATION);
    JLabel metadataT = new JLabel(INFO);
    JLabel descriptionT = new JLabel(PROJ_DESCRIPTION);
    JLabel extensionT = new JLabel(EXTENT);
    JLabel layersT = new JLabel(NUMBER_LAYERS);
    JLabel unitLabel = new JLabel(UNIT);
    private JTextArea projArea;
    private JTextArea fileArea;
    private JTextArea infoArea;
    private JTextField textFieldXMin;
    private JTextField textFieldYMin;
    private JTextField textFieldXMax;
    private JTextField textFieldYMax;
    private JTextField textFielddate;
    private JTextField textFieldnumLyr;
    private JTextField textFieldUnit;
    private MultiTabInputDialog dialog;
    String[] codes;
    public static SuggestTreeComboBox localSuggestTreeComboBox;
    private LayersPanel layersPanel;
    String srs = "";
    String srsCode = "";
    String info = "";
    String srsDescription = NOT_SET;
    private String xmax = "";
    private String xmin = "";
    private String ymax = "";
    private String ymin = "";
    private final String bgColor1 = "\"#EAEAEA\"";
    private final String bgColor3 = "\"#FBFFE1\"";
    private final Font currentFont = new JLabel().getFont();
    private final String fontName = this.currentFont.getFontName();

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuPlugin(this, new String[]{MenuNames.EDIT});
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("information_16x16.png");
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck());
    }

    @Override
    public boolean execute(final PlugInContext context) throws Exception {
        String file;
        Task selectedTask = context.getTask();
        this.dialog = new MultiTabInputDialog((Frame)context.getWorkbenchFrame(), this.getName(), PROJ_METADATA, true);
        this.dialog.setSize(new Dimension(400, 270));
        this.dialog.setMinimumSize(new Dimension(400, 270));
        this.dialog.setCancelVisible(false);
        this.dialog.setResizable(true);
        this.codes = Utils.mapSRIDasString();
        localSuggestTreeComboBox = new SuggestTreeComboBox(this.codes, 40);
        this.srsCode = selectedTask.getProperties().containsKey(new QName("Project SRS ID")) ? selectedTask.getProperty(new QName("Project SRS ID")).toString() : "0";
        UIManager.put("ComboBox.disabledForeground", Color.black);
        localSuggestTreeComboBox.setSelectedItem(this.srsCode);
        localSuggestTreeComboBox.setPreferredSize(new Dimension(150, 20));
        localSuggestTreeComboBox.setEditable(false);
        localSuggestTreeComboBox.setEnabled(false);
        localSuggestTreeComboBox.setBackground(this.dialog.getBackground());
        Utils.removeButton(localSuggestTreeComboBox);
        localSuggestTreeComboBox.setPrototypeDisplayValue("abcdefghijklmnpqrstuvwxyz/0123456789");
        try {
            file = selectedTask.getProjectFile().getAbsolutePath();
        }
        catch (Exception ex) {
            file = NOT_SAVED;
        }
        SRSInfo srid = SridLookupTable.getSrsAndUnitFromCode(localSuggestTreeComboBox.getSelectedItem().toString());
        srid.complete();
        this.srsDescription = srid.toString();
        this.dialog.addRow("source", this.fileT, this.filePanel(file), new EnableCheck[0], "");
        this.textFielddate = new JTextField();
        this.textFielddate.setToolTipText("");
        this.textFielddate.setMinimumSize(new Dimension(50, 20));
        this.textFielddate.setPreferredSize(new Dimension(150, 20));
        this.textFielddate.setText(this.dateString(selectedTask));
        this.textFielddate.setEditable(false);
        this.dialog.addRow("source", this.dateT, this.textFielddate, new EnableCheck[0], "");
        String numLyr = "" + Utils.getNamesOfLayerableList(context).size();
        this.textFieldnumLyr = new JTextField(numLyr);
        this.textFieldnumLyr.setToolTipText("");
        this.textFieldnumLyr.setPreferredSize(new Dimension(150, 20));
        this.textFieldnumLyr.setEditable(false);
        this.dialog.addRow("source", this.layersT, this.textFieldnumLyr, new EnableCheck[0], "");
        this.dialog.addRow("source", this.extensionPanel(context), new EnableCheck[0], "");
        this.dialog.addRow("source", this.infoPanel(context), new EnableCheck[0], TOOLTIP);
        this.dialog.addRow("source", this.srsPanel(context), new EnableCheck[0], TOOLTIP);
        this.dialog.addCheckBox(EDIT_METADATA, this.editInfo, TOOLTIP);
        this.dialog.getCheckBox(EDIT_METADATA).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskPropertiesPlugIn.this.updateControls(context, TaskPropertiesPlugIn.this.dialog);
                TaskPropertiesPlugIn.this.dialog.repaint();
            }
        });
        this.layersPanel = new LayersPanel(context);
        this.layersPanel.setPreferredSize(new Dimension(400, 400));
        this.dialog.addPane(PROJ_STATUS);
        this.dialog.addRow(this.layersPanel);
        this.dialog.pack();
        this.dialog.addOKCancelApplyPanelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskPropertiesPlugIn.this.applyModifications(context, TaskPropertiesPlugIn.this.dialog);
            }
        });
        GUIUtil.centreOnWindow(this.dialog);
        this.dialog.setVisible(true);
        return true;
    }

    protected void updateControls(PlugInContext context, MultiInputDialog dialog) {
        if (dialog.getCheckBox(EDIT_METADATA).isSelected()) {
            dialog.setApplyVisible(true);
            dialog.setCancelVisible(true);
            dialog.setOKEnabled(false);
            localSuggestTreeComboBox.setEnabled(true);
            localSuggestTreeComboBox.setEditable(true);
            localSuggestTreeComboBox.setBackground(Color.WHITE);
            this.infoArea.setEditable(true);
            this.infoArea.setBackground(Color.WHITE);
            this.infoArea.repaint();
            dialog.repaint();
        } else {
            dialog.setApplyVisible(false);
            dialog.setCancelVisible(false);
            dialog.setOKEnabled(true);
            UIManager.put("ComboBox.disabledForeground", Color.black);
            localSuggestTreeComboBox.setSelectedItem(localSuggestTreeComboBox.getSelectedItem().toString());
            localSuggestTreeComboBox.setEditable(false);
            localSuggestTreeComboBox.setEnabled(false);
            localSuggestTreeComboBox.setBackground(dialog.getBackground());
            this.infoArea.setBackground(dialog.getBackground());
            this.infoArea.repaint();
            localSuggestTreeComboBox.repaint();
            dialog.repaint();
        }
    }

    protected void applyModifications(PlugInContext context, MultiInputDialog dialog) {
        if (dialog.wasApplyPressed()) {
            try {
                SRSInfo sridTableInfo = SridLookupTable.getSrsAndUnitFromCode(localSuggestTreeComboBox.getSelectedItem().toString());
                sridTableInfo.complete();
                String proj = sridTableInfo.toString();
                int endIndex = proj.lastIndexOf("[");
                this.srsDescription = proj.substring(0, endIndex);
                this.projArea.setText(this.srsDescription);
                this.textFieldUnit.setText(sridTableInfo.getUnit().toString());
                String epsg = localSuggestTreeComboBox.getSelectedItem().toString();
                String unit = sridTableInfo.getUnit().toString();
                Task selectedTask = context.getTask();
                selectedTask.setProperty(new QName("Project SRS ID"), epsg);
                selectedTask.setProperty(new QName("Project Unit"), unit);
                selectedTask.setProperty(new QName("Project Commet"), this.infoArea.getText());
                TaskFrame taskFrame = context.getWorkbenchFrame().getActiveTaskFrame();
                taskFrame.updateTitle();
                dialog.getCheckBox(EDIT_METADATA).setSelected(false);
                this.updateControls(context, dialog);
                dialog.pack();
                dialog.repaint();
            }
            catch (Exception e1) {
                dialog.repaint();
                e1.printStackTrace();
            }
        }
    }

    private JPanel srsPanel(PlugInContext context) throws IOException {
        JPanel srsPanel = new JPanel(new GridBagLayout());
        srsPanel.setBorder(BorderFactory.createTitledBorder("SRS"));
        this.codes = Utils.mapSRIDasString();
        localSuggestTreeComboBox = new SuggestTreeComboBox(this.codes, 40);
        Task selectedTask = context.getTask();
        this.srsCode = selectedTask.getProperties().containsKey(new QName("Project SRS ID")) ? selectedTask.getProperty(new QName("Project SRS ID")).toString() : "0";
        UIManager.put("ComboBox.disabledForeground", Color.black);
        localSuggestTreeComboBox.setSelectedItem(this.srsCode);
        localSuggestTreeComboBox.setPreferredSize(new Dimension(150, 20));
        localSuggestTreeComboBox.setEditable(false);
        localSuggestTreeComboBox.setEnabled(false);
        localSuggestTreeComboBox.setBackground(this.dialog.getBackground());
        Utils.removeButton(localSuggestTreeComboBox);
        localSuggestTreeComboBox.setPrototypeDisplayValue("abcdefghijklmnpqrstuvwxyz/0123456789");
        SRSInfo srid = SridLookupTable.getSrsAndUnitFromCode(localSuggestTreeComboBox.getSelectedItem().toString());
        srid.complete();
        String proj = srid.toString();
        int endIndex = proj.lastIndexOf("[");
        this.srsDescription = proj.substring(0, endIndex);
        this.textFieldUnit = new JTextField();
        this.textFieldUnit.setToolTipText("");
        this.textFieldUnit.setMinimumSize(new Dimension(50, 20));
        this.textFieldUnit.setPreferredSize(new Dimension(150, 20));
        this.textFieldUnit.setText(srid.getUnit().toString());
        this.textFieldUnit.setEditable(false);
        FormUtils.addRowInGBL((JComponent)srsPanel, 1, 0, this.sridLabel, (JComponent)localSuggestTreeComboBox, false);
        FormUtils.addRowInGBL((JComponent)srsPanel, 2, 0, this.descriptionT, (JComponent)this.projectionPanel(this.srsDescription), false);
        FormUtils.addRowInGBL((JComponent)srsPanel, 4, 0, this.unitLabel, (JComponent)this.textFieldUnit, false);
        return srsPanel;
    }

    private String dateString(Task selectedTask) {
        String time;
        block5: {
            try {
                File f = new File(selectedTask.getProjectFile().getAbsolutePath());
                if (selectedTask.getProperties().containsKey(new QName("Project Date"))) {
                    time = selectedTask.getProperty(new QName("Project Date")).toString();
                    break block5;
                }
                Path path = f.toPath();
                BasicFileAttributes attr = null;
                try {
                    attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                dateFormat.format(attr.creationTime().toMillis());
                time = dateFormat.format(attr.creationTime().toMillis());
            }
            catch (Exception ex) {
                time = "---";
            }
        }
        return time;
    }

    private JPanel infoPanel(PlugInContext context) {
        this.infoArea = new JTextArea();
        JPanel infoPanel = new JPanel(new GridBagLayout());
        infoPanel.setBorder(BorderFactory.createTitledBorder(EXTENT));
        Task selectedTask = context.getTask();
        this.info = selectedTask.getProperty(new QName("Project Commet"), "").toString();
        this.infoArea.setBackground(this.dialog.getBackground());
        this.infoArea.setText(this.info);
        this.infoArea.setCaretPosition(0);
        this.infoArea.setFont(new JLabel().getFont());
        this.infoArea.setEditable(false);
        this.infoArea.setLineWrap(true);
        this.infoArea.setWrapStyleWord(true);
        this.infoArea.setColumns(45);
        this.infoArea.setRows(7);
        JScrollPane layerPane = new JScrollPane(this.infoArea, 20, 31);
        infoPanel.setBorder(BorderFactory.createTitledBorder(INFO));
        infoPanel.add(layerPane);
        return infoPanel;
    }

    private JPanel extensionPanel(PlugInContext context) {
        Task selectedeTask = context.getTask();
        Envelope env = selectedeTask.getLayerManager().getEnvelopeOfAllLayers();
        JPanel extensionPanel = new JPanel(new GridBagLayout());
        extensionPanel.setBorder(BorderFactory.createTitledBorder(EXTENT));
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        DecimalFormat formatter = (DecimalFormat)nf;
        formatter.applyPattern("##0.##");
        if (env != null) {
            this.xmax = formatter.format(env.getMaxX());
            this.xmin = formatter.format(env.getMinX());
            this.ymax = formatter.format(env.getMaxY());
            this.ymin = formatter.format(env.getMinY());
        }
        this.textFieldXMin = new JTextField();
        this.textFieldXMin.setMinimumSize(new Dimension(75, 20));
        this.textFieldXMin.setPreferredSize(new Dimension(90, 20));
        this.textFieldXMin.setText(this.xmin);
        this.textFieldXMin.setEditable(false);
        this.textFieldYMin = new JTextField();
        this.textFieldYMin.setMinimumSize(new Dimension(75, 20));
        this.textFieldYMin.setPreferredSize(new Dimension(90, 20));
        this.textFieldYMin.setText(this.ymin);
        this.textFieldYMin.setEditable(false);
        this.textFieldXMax = new JTextField();
        this.textFieldXMax.setMinimumSize(new Dimension(75, 20));
        this.textFieldXMax.setPreferredSize(new Dimension(90, 20));
        this.textFieldXMax.setText(this.xmax);
        this.textFieldXMax.setEditable(false);
        this.textFieldYMax = new JTextField();
        this.textFieldYMax.setMinimumSize(new Dimension(75, 20));
        this.textFieldYMax.setPreferredSize(new Dimension(90, 20));
        this.textFieldYMax.setText(this.ymax);
        this.textFieldYMax.setEditable(false);
        FormUtils.addRowInGBL((JComponent)extensionPanel, 0, 30, new JLabel(YMAX + ":"), (JComponent)this.textFieldYMax, false);
        FormUtils.addRowInGBL((JComponent)extensionPanel, 1, 0, new JLabel(XMIN + ":"), (JComponent)this.textFieldXMin, false);
        FormUtils.addFiller(extensionPanel, 1, 2);
        FormUtils.addRowInGBL((JComponent)extensionPanel, 1, 61, (JComponent)this.textFieldXMax, false, false);
        FormUtils.addRowInGBL((JComponent)extensionPanel, 1, 60, (JComponent)new JLabel(XMAX + ":"), false, false);
        FormUtils.addRowInGBL((JComponent)extensionPanel, 2, 30, new JLabel(YMIN + ":"), (JComponent)this.textFieldYMin, false);
        return extensionPanel;
    }

    private JScrollPane projectionPanel(String projection) {
        JPanel pan = new JPanel(new GridBagLayout());
        this.projArea = new JTextArea();
        this.projArea.setBackground(this.dialog.getBackground());
        this.projArea.setCaretPosition(0);
        this.projArea.setLineWrap(true);
        this.projArea.setWrapStyleWord(true);
        this.projArea.setToolTipText("");
        this.projArea.setRows(2);
        this.projArea.setColumns(40);
        this.projArea.setFont(pan.getFont());
        this.projArea.setText(projection);
        this.projArea.setEditable(false);
        JScrollPane areaScrollPane = new JScrollPane(this.projArea);
        return areaScrollPane;
    }

    private JScrollPane filePanel(String projection) {
        JPanel pan = new JPanel(new GridBagLayout());
        this.fileArea = new JTextArea();
        this.fileArea.setBackground(this.dialog.getBackground());
        this.fileArea.setCaretPosition(0);
        this.fileArea.setLineWrap(true);
        this.fileArea.setWrapStyleWord(true);
        this.fileArea.setToolTipText("");
        this.fileArea.setRows(2);
        this.fileArea.setColumns(40);
        this.fileArea.setFont(pan.getFont());
        this.fileArea.setText(projection);
        this.fileArea.setEditable(false);
        JScrollPane areaScrollPane = new JScrollPane(this.fileArea);
        return areaScrollPane;
    }

    public String header(String layer, String type, String path, String proj) {
        String head = "  <tr valign=\"top\">     <td width=\"550\" height=\"12\" bgcolor=\"#EAEAEA\"align=\"center\"><font face=" + this.fontName + " size=\"2\" align=\"right\"><b>" + layer + "</b></font></td>     <td width=\"550\" height=\"12\" bgcolor=" + "\"#EAEAEA\"" + "align=\"center\"><font face=" + this.fontName + " size=\"2\"><b>" + type + "</b></font></td>     <td width=\"550\" height=\"12\" bgcolor=" + "\"#EAEAEA\"" + "align=\"center\"><font face=" + this.fontName + " size=\"2\"><b>" + path + "</b></font></td>  </tr>";
        return head;
    }

    public String text(String layer, String type, String path, String proj) {
        String prop = "  <tr valign=\"top\">     <td width=\"550\" height=\"12\" bgcolor=\"#FBFFE1\"align=\"right\"><font face=" + this.fontName + " size=\"2\" align=\"right\">" + layer + "</font></td>     <td width=\"550\" height=\"12\" bgcolor=" + "\"#FBFFE1\"" + "align=\"left\"><font face=" + this.fontName + " size=\"2\" >" + type + "</font></td>     <td width=\"550\" height=\"12\" bgcolor=" + "\"#FBFFE1\"" + "align=\"left\"><font face=" + this.fontName + " size=\"2\" >" + path + "</font></td>  </tr>";
        return prop;
    }

    public String text2(String type) {
        String prop = "  <tr valign=\"top\">     <td width=\"550\" height=\"12\" bgcolor=\"#FBFFE1\"align=\"right\"><font face=" + this.fontName + " size=\"2\" align=\"right\"></font></td>     <td width=\"1586\" height=\"12\" bgcolor=" + "\"#FBFFE1\"" + "align=\"left\"><font face=" + this.fontName + " size=\"2\" ><i></i></font></td>     <td width=\"1586\" height=\"12\" bgcolor=" + "\"#FBFFE1\"" + "align=\"left\"><font face=" + this.fontName + " size=\"2\" ><i><font color=\"red\">" + type + "</i></font></td>  </tr>";
        return prop;
    }

    private class LayersPanel
    extends HTMLPanel {
        private static final long serialVersionUID = 1L;

        private LayersPanel(PlugInContext context) throws Exception {
            String info = "";
            info = info + TaskPropertiesPlugIn.this.header(LAYER_NAME, DATASOURCE_CLASS, SOURCE_PATH, SRS);
            List<Layerable> layerables = context.getTask().getLayerManager().getLayerables(Layerable.class);
            for (Layerable layer : layerables) {
                info = info + TaskPropertiesPlugIn.this.text(Utils.getLayerableName(layer), Utils.getLayerableType(layer), Utils.getLayerablePath(layer), "");
            }
            String a = "<table width=\"450\" bgcolor=\"#000000\" cellpadding=\"10\" cellspacing=\"1\">";
            String b = "</table>";
            String layers = a + info + b;
            String temp = "";
            if (Utils.checkTemporaryLayerables(context)) {
                temp = "<table border='0.1'>" + TaskPropertiesPlugIn.this.text2(TEMPORARY_LAYERS) + "</table>";
                layers = layers + temp;
            }
            String mod = "";
            if (Utils.checkModifiedLayers(context)) {
                mod = "<table border='0.1'>" + TaskPropertiesPlugIn.this.text2(MODIFIED_LAYERS) + "</table>";
                layers = layers + mod;
            }
            String infotext = "<html>" + layers + "</html>";
            this.getRecordPanel().removeAll();
            this.getSaveButton().setVisible(false);
            this.createNewDocument();
            this.append(infotext);
        }
    }
}

