/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.raster.color;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import java.awt.Color;
import java.awt.geom.NoninvertibleTransformException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.RasterSymbology;
import org.openjump.core.ui.color.ColorGenerator;

public class RasterColorEditor {
    private RasterImageLayer layer;
    private ColorGenerator colorGenerator;

    public RasterColorEditor(RasterImageLayer Rlayer) {
        this.setRasterLayer(Rlayer);
    }

    public void setRasterLayer(RasterImageLayer Rlayer) {
        this.layer = Rlayer;
    }

    public RasterImageLayer getRasterImageLayer() {
        return this.layer;
    }

    public void changeColors(WorkbenchContext context, Color[] colors, Color noDataColor, double min, double max) throws NoninvertibleTransformException, IOException {
        if (colors == null || colors.length == 0) {
            this.layer.setNeedToKeepImage(false);
            this.layer.flushImages(true);
            context.getLayerViewPanel().getViewport().update();
            return;
        }
        this.colorGenerator = new ColorGenerator(35, colors);
        RasterSymbology symbology = new RasterSymbology("RAMP");
        min = this.layer.getMetadata().getStats().getMin(0);
        max = this.layer.getMetadata().getStats().getMax(0);
        double interval = (max - min) / (double)this.colorGenerator.getSteps();
        symbology.addColorMapEntry(this.layer.getNoDataValue(), noDataColor);
        for (int c = 0; c < this.colorGenerator.getSteps(); ++c) {
            Color color = this.colorGenerator.getColor(c);
            double value = this.layer.getMetadata().getStats().getMin(0) + (double)c * interval;
            symbology.addColorMapEntry(value, color);
        }
        Collection<RasterImageLayer> selectedNodes = context.getLayerableNamePanel().selectedNodes(RasterImageLayer.class);
        Iterator<RasterImageLayer> iterator = selectedNodes.iterator();
        while (iterator.hasNext()) {
            RasterImageLayer node;
            RasterImageLayer rasterImageLayer = node = iterator.next();
            rasterImageLayer.setSymbology(symbology);
        }
    }
}

