/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.raster;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.ui.HTMLFrame;
import com.vividsolutions.jump.workbench.ui.HTMLPanel;
import com.vividsolutions.jump.workbench.ui.JTablePanel;
import com.vividsolutions.jump.workbench.ui.TableFrame;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.math.plot.plotObjects.Line;
import org.math.plot.plotObjects.Plotable;
import org.math.plot.plots.Plot;
import org.math.plot.render.AbstractDrawer;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.ui.plot.Plot2DPanelOJ;
import org.openjump.core.ui.plugin.raster.ProfileGraphAlgorithms;
import org.openjump.core.ui.plugin.raster.ProfileGraphPlugIn;
import org.openjump.sextante.core.ObjectAndDescription;
import org.openjump.sextante.gui.additionalResults.AdditionalResults;
import org.openjump.sextante.gui.additionalResults.AdditionalResultsFrame;

public class ProfileGraphGUI {
    private static final String NAME = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphPlugIn.Profile-Graph");
    public final String LAYER_NAME = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.layer_name");
    public static final String MIN = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.minimum");
    public static final String MEAN = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.StatisticOverViewTableModel.mean-mode");
    public static final String MAX = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.maximum");
    public static final String SUM = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.sum");
    public static final String CELL_SIZE = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.dimension_cell");
    public static final String PLOT = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.Profile-Plot");
    public static final String PROFILEPTS = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.profile-pts");
    public static final String PROFILE_INFO = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Info");
    public static final String PROFILE_LENGTH = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.Profile-length");
    public static final String STARTING_POINT = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.starting-point");
    public static final String ENDING_POINT = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.ending-point");
    public static final String MEAN_SLOPE = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.mean-slope");
    public static final String TIMES = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.Travel-time");
    public static final String SLOPE = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.Slope");
    public static final String DEGREES = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.degrees");
    public static final String TABLE_VIEW = I18N.getInstance().get("org.openjump.core.ui.plugin.queries.SimpleQuery.display-the-table");
    public static final String RELATIVE_SLOPE = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.Relative-slope");
    public static final String ABSOLUTE_SLOPE = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.Absolute-slope");
    public static final String TYPE_SLOPE = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.Choose-slope-profile");
    public static final String HOURS = I18N.getInstance().get("ui.GenericNames.hours");
    public static final String MINUTES = I18N.getInstance().get("ui.GenericNames.minutes");
    public static final String FLAT = I18N.getInstance().get("ui.GenericNames.flat");
    public static final String UPHILL = I18N.getInstance().get("ui.GenericNames.uphill");
    public static final String DOWNHILL = I18N.getInstance().get("ui.GenericNames.downhill");
    public static final String CALCULATE_TIMES = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.calculate-travel-time");
    public static final String UNIT = I18N.getInstance().get("org.openjump.core.ui.plugin.file.ProjectInfoPlugIn.srs-unit");
    public static final String TIMES_TOOLTIP = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.travel-time-tooltip");
    public static WorkbenchFrame wFrame = JUMPWorkbench.getInstance().getFrame();
    public static GeometryFactory gf = new GeometryFactory();
    public static FeatureCollection resultFC = null;
    public static FeatureSchema resultFSchema = null;
    public static String htmlString;
    public static double dDist;
    public static double dHorzDist;
    public static double dSlope;
    public static double dY;
    public static double m_dLastX;
    public static double m_dLastY;
    public static double m_dLastZ;
    public static int nPoints;
    public static int n;
    public static ArrayList<Coordinate> coordinates;
    public static String layerUnit;
    public static String unit;
    public static String speedUnit;
    public static double unitConvert;
    protected static Font darkLabelFont;
    public static String HEIGHT;
    public static String WIDTH;
    public static double[][] datas2;

    public static RasterImageLayer getLayer() {
        return ProfileGraphPlugIn.dialog.getRasterLayer(ProfileGraphPlugIn.CLAYER);
    }

    public static int getBand() {
        return ProfileGraphPlugIn.numband;
    }

    public static void calculateProfile(Coordinate[] coords) throws IOException, RasterImageLayer.RasterDataNotFoundException {
        RasterImageLayer rLayer = ProfileGraphGUI.getLayer();
        layerUnit = ProfileGraphPlugIn.UNIT;
        if (layerUnit.equals("foot") || layerUnit.equals("US survey foot")) {
            speedUnit = " [mi/h]";
            unitConvert = 5280.0;
            unit = " [ft]";
        } else if (layerUnit.equals("metre")) {
            speedUnit = " [km/h]";
            unitConvert = 1000.0;
            unit = " [m]";
        } else if (layerUnit.equals("Unknown")) {
            speedUnit = " ?[km/h]";
            unitConvert = 1000.0;
            unit = " ?[m]";
        } else if (layerUnit.equals("degree")) {
            speedUnit = " [arc-second/h]";
            unitConvert = 2.7777777E-4;
            unit = " [deg]";
        } else {
            speedUnit = " [layerUnit]/h]";
            unitConvert = 0.0;
            unit = " [layerUnit]";
        }
        HEIGHT = ProfileGraphPlugIn.HEIGHT;
        WIDTH = ProfileGraphPlugIn.WIDTH;
        LineString line = gf.createLineString(coords);
        if (line.within(rLayer.getWholeImageEnvelopeAsGeometry())) {
            Random rand = new Random();
            n = rand.nextInt(100) + 1;
            ProfileGraphGUI.processLine((Geometry)line);
            if (resultFC != null && resultFC.size() > 0) {
                FeatureDataset fd = new FeatureDataset(resultFSchema);
                fd.addAll(resultFC.getFeatures());
                wFrame.getContext().getLayerManager().addLayer(StandardCategoryNames.RESULT, PLOT + "-" + n + " " + PROFILEPTS, fd);
            }
            AdditionalResults.addAdditionalResultAndShow(PLOT + "-" + n, (Object)ProfileGraphGUI.getPlotPanel(resultFC, "" + n));
        } else {
            wFrame.getContext().getLayerViewPanel().getContext().warnUser("Query outside the extension of selected Raster layer");
        }
    }

    protected static Coordinate[] toArray(List<Coordinate> coordinates) {
        return coordinates.toArray(new Coordinate[0]);
    }

    public static void processSegment(double x, double y, double x2, double y2) throws RasterImageLayer.RasterDataNotFoundException, IOException {
        double dx = Math.abs(x2 - x);
        double dy = Math.abs(y2 - y);
        if (dx > 0.0 || dy > 0.0) {
            double n;
            if (dx > dy) {
                n = dx /= ProfileGraphGUI.getLayer().getMetadata().getOriginalCellSize();
                dy /= dx;
                dx = ProfileGraphGUI.getLayer().getMetadata().getOriginalCellSize();
            } else {
                n = dy /= ProfileGraphGUI.getLayer().getMetadata().getOriginalCellSize();
                dx /= dy;
                dy = ProfileGraphGUI.getLayer().getMetadata().getOriginalCellSize();
            }
            if (x2 < x) {
                dx = -dx;
            }
            if (y2 < y) {
                dy = -dy;
            }
            double d = 0.0;
            while (d <= n) {
                ProfileGraphGUI.addPoint(x, y);
                d += 1.0;
                x += dx;
                y += dy;
            }
        }
    }

    public static void processLine(Geometry line) throws IOException, RasterImageLayer.RasterDataNotFoundException {
        Coordinate[] coords = line.getCoordinates();
        for (int i = 0; i < coords.length - 1; ++i) {
            double x = coords[i].x;
            double y = coords[i].y;
            double x2 = coords[i + 1].x;
            double y2 = coords[i + 1].y;
            ProfileGraphGUI.processSegment(x, y, x2, y2);
        }
        ProfileGraphGUI.addPoint(coords[coords.length - 1].x, coords[coords.length - 1].y);
    }

    public static void addPoint(double x, double y) throws RasterImageLayer.RasterDataNotFoundException, IOException {
        if (resultFSchema == null) {
            resultFSchema = new FeatureSchema();
            resultFSchema.addAttribute("geometry", AttributeType.GEOMETRY);
            resultFSchema.addAttribute("X", AttributeType.DOUBLE);
            resultFSchema.addAttribute("Y", AttributeType.DOUBLE);
            resultFSchema.addAttribute("Z", AttributeType.DOUBLE);
            resultFSchema.addAttribute("PlaneDist", AttributeType.DOUBLE);
            resultFSchema.addAttribute("TerrainDist", AttributeType.DOUBLE);
            resultFC = new FeatureDataset(resultFSchema);
        }
        double z = ProfileGraphGUI.getLayer().getCellValue(x, y, ProfileGraphGUI.getBand());
        if (nPoints == 0) {
            dDist = 0.0;
            dHorzDist = 0.0;
        } else {
            double dDX = x - m_dLastX;
            double dDY = y - m_dLastY;
            double dDZ = z == ProfileGraphGUI.getLayer().getNoDataValue() || m_dLastZ == ProfileGraphGUI.getLayer().getNoDataValue() ? 0.0 : z - m_dLastZ;
            dDist += Math.sqrt(dDX * dDX + dDY * dDY);
            dHorzDist += Math.sqrt(dDX * dDX + dDY * dDY + dDZ * dDZ);
        }
        m_dLastX = x;
        m_dLastY = y;
        m_dLastZ = z;
        ++nPoints;
        Point geometry = new GeometryFactory().createPoint(new Coordinate(x, y));
        BasicFeature fpoint = new BasicFeature(resultFSchema);
        fpoint.setGeometry((Geometry)geometry);
        fpoint.setAttribute("X", (Object)new Double(x));
        fpoint.setAttribute("Y", (Object)new Double(y));
        fpoint.setAttribute("Z", (Object)new Double(z));
        fpoint.setAttribute("PlaneDist", (Object)new Double(dDist));
        fpoint.setAttribute("TerrainDist", (Object)new Double(dHorzDist));
        Coordinate coord = new Coordinate(new Double(z).doubleValue(), new Double(dHorzDist).doubleValue());
        coordinates.add(coord);
        resultFC.add(fpoint);
    }

    public static Plot2DPanelOJ getPlotPanel(FeatureCollection fc, String name) {
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JLabel jLabel0 = new JLabel(CALCULATE_TIMES + speedUnit + ": ");
        jLabel0.setToolTipText("<HTML><BODY><DIV style=\"width: 400px; text-justification: justify;\">" + TIMES_TOOLTIP + "</DIV></BODY></HTML>");
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        final JTextField jTextField_VelFlat = new JTextField();
        final JTextField jTextField_VelUp = new JTextField();
        final JTextField jTextField_VelDown = new JTextField();
        jTextField_VelDown.setPreferredSize(new Dimension(50, 20));
        jTextField_VelUp.setPreferredSize(new Dimension(50, 20));
        jTextField_VelFlat.setPreferredSize(new Dimension(50, 20));
        jTextField_VelDown.setMaximumSize(new Dimension(50, 20));
        jTextField_VelUp.setMaximumSize(new Dimension(50, 20));
        jTextField_VelFlat.setMaximumSize(new Dimension(50, 20));
        jTextField_VelFlat.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char vChar = e.getKeyChar();
                if (!Character.isDigit(vChar) && vChar != '.' && vChar != '\b' && vChar != '\u007f') {
                    e.consume();
                }
            }
        });
        jTextField_VelUp.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char vChar = e.getKeyChar();
                if (!Character.isDigit(vChar) && vChar != '.' && vChar != '\b' && vChar != '\u007f') {
                    e.consume();
                }
            }
        });
        jTextField_VelDown.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char vChar = e.getKeyChar();
                if (!Character.isDigit(vChar) && vChar != '.' && vChar != '\b' && vChar != '\u007f') {
                    e.consume();
                }
            }
        });
        jLabel1.setText(FLAT);
        jLabel2.setText(UPHILL);
        jLabel3.setText(DOWNHILL);
        jLabel4.setText(UNIT + unit);
        jTextField_VelFlat.setText("6");
        jTextField_VelUp.setText("3");
        jTextField_VelDown.setText("8");
        FlowLayout layout = new FlowLayout();
        jPanel2.setLayout(layout);
        layout.setAlignment(3);
        jPanel2.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        jPanel2.add(jLabel0);
        jPanel2.add(jLabel1);
        jPanel2.add(jTextField_VelFlat);
        jPanel2.add(jLabel2);
        jPanel2.add(jTextField_VelUp);
        jPanel2.add(jLabel3);
        jPanel2.add(jTextField_VelDown);
        final Plot2DPanelOJ plot2dA = new Plot2DPanelOJ();
        plot2dA.setName(name);
        plot2dA.removeAllPlots();
        plot2dA.plotToolBar.remove(5);
        plot2dA.plotToolBar.remove(4);
        double[][] datas1 = new double[fc.size()][2];
        for (int j = 0; j < fc.size(); ++j) {
            Feature f = fc.getFeatures().get(j);
            datas1[j][0] = (Double)f.getAttribute("PlaneDist");
            datas1[j][1] = (Double)f.getAttribute("Z");
        }
        plot2dA.addLinePlot("Profile", datas1);
        plot2dA.setAxisLabel(0, WIDTH + unit);
        if (!layerUnit.equals("degree")) {
            plot2dA.setAxisLabel(1, HEIGHT + unit);
        } else {
            plot2dA.setAxisLabel(1, HEIGHT);
        }
        plot2dA.getAxis(0).setLabelPosition(new double[]{0.5, -0.15});
        plot2dA.getAxis(1).setLabelPosition(new double[]{-0.15, 0.5});
        plot2dA.getAxis(1).setLabelAngle(-1.5707963267948966);
        double[][] dataTableDouble = null;
        for (Plot plot2 : plot2dA.getPlots()) {
            dataTableDouble = plot2.getData();
        }
        final ProfileGraphAlgorithms profile = new ProfileGraphAlgorithms();
        profile.calculateValues(dataTableDouble);
        final double[] doubleZ = profile.getZData();
        final double[] doublePlanet = profile.getPlanetData();
        final double[] doubleTerrain = profile.getTerrainData();
        final double[] doubleRelativeSlope = profile.getRelativeSlopeData();
        final double[] doubleAbsoluteSlope = profile.getAbsoluteSlopeData();
        JButton tableBtn = new JButton(IconLoader.icon("Row_16.gif"));
        tableBtn.setToolTipText(TABLE_VIEW);
        tableBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableFrame freqFrame = new TableFrame();
                freqFrame.setDefaultCloseOperation(2);
                JInternalFrame[] frames = wFrame.getInternalFrames();
                ArrayList<JInternalFrame> list = new ArrayList<JInternalFrame>();
                for (JInternalFrame iFrame : frames) {
                    if (!(iFrame instanceof TableFrame)) continue;
                    list.add(iFrame);
                }
                if (list.size() == 1) {
                    freqFrame.toFront();
                } else {
                    Object[] slopeData = ProfileGraphGUI.doubleToObject(doubleRelativeSlope);
                    Object[] absoluteSlopeData = ProfileGraphGUI.doubleToObject(doubleAbsoluteSlope);
                    Object[] zData = ProfileGraphGUI.doubleToObject(doubleZ);
                    Object[] planetDistData = ProfileGraphGUI.doubleToObject(doublePlanet);
                    Object[] terrainDistData = ProfileGraphGUI.doubleToObject(doubleTerrain);
                    freqFrame.setLayout(new BorderLayout());
                    freqFrame.setResizable(true);
                    freqFrame.setClosable(true);
                    freqFrame.setIconifiable(true);
                    freqFrame.setMaximizable(true);
                    freqFrame.setPreferredSize(new Dimension(900, 450));
                    freqFrame.setSize(900, 450);
                    freqFrame.setLayer(JLayeredPane.MODAL_LAYER);
                    freqFrame.setTitle(PLOT + "-" + n);
                    JTable jTable = new JTable();
                    DefaultTableModel dtm = (DefaultTableModel)jTable.getModel();
                    dtm.addColumn((Object)"Z", zData);
                    dtm.addColumn((Object)"PlaneDist", planetDistData);
                    dtm.addColumn((Object)"TerrainDist", terrainDistData);
                    dtm.addColumn((Object)(RELATIVE_SLOPE + " (\ufffd)"), slopeData);
                    dtm.addColumn((Object)(ABSOLUTE_SLOPE + " (\ufffd)"), absoluteSlopeData);
                    JTablePanel jTablePanel = new JTablePanel(dtm);
                    jTablePanel.getCommandPanel().setVisible(false);
                    freqFrame.add(jTablePanel);
                    wFrame.getContext().getWorkbench().getFrame().addInternalFrame(freqFrame, true, true);
                }
            }
        });
        JButton slopeBtn = new JButton(IconLoader.icon("profileSlope.png"));
        slopeBtn.setToolTipText(SLOPE);
        slopeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JInternalFrame[] frames = wFrame.getInternalFrames();
                ArrayList<JInternalFrame> list = new ArrayList<JInternalFrame>();
                for (JInternalFrame iFrame : frames) {
                    if (!(iFrame instanceof AdditionalResultsFrame)) continue;
                    list.add(iFrame);
                }
                if (list.size() > 1) {
                    ProfileGraphGUI.mosaicFrames();
                } else {
                    String type = "";
                    double[][] slopedt = new double[doubleZ.length][2];
                    Object[] options = new String[]{RELATIVE_SLOPE, ABSOLUTE_SLOPE};
                    int x = JOptionPane.showOptionDialog(null, TYPE_SLOPE, NAME, -1, 1, null, options, options[0]);
                    if (x == -1) {
                        return;
                    }
                    Plot2DPanelOJ plotSlope = new Plot2DPanelOJ();
                    switch (x) {
                        case 0: {
                            int j;
                            for (j = 0; j < doubleZ.length; ++j) {
                                slopedt[j][0] = doublePlanet[j];
                                slopedt[j][1] = doubleRelativeSlope[j];
                            }
                            type = RELATIVE_SLOPE;
                            break;
                        }
                        case 1: {
                            int j;
                            for (j = 0; j < doubleZ.length; ++j) {
                                slopedt[j][0] = doublePlanet[j];
                                slopedt[j][1] = doubleAbsoluteSlope[j];
                            }
                            type = ABSOLUTE_SLOPE;
                        }
                    }
                    plotSlope.plotToolBar.remove(5);
                    plotSlope.plotToolBar.remove(4);
                    plotSlope.setName(SLOPE);
                    plotSlope.addLinePlot(SLOPE, Color.red, slopedt);
                    plotSlope.setAxisLabel(0, WIDTH + unit);
                    plotSlope.setAxisLabel(1, type + " [" + DEGREES + "]");
                    plotSlope.getAxis(0).setLabelPosition(new double[]{0.5, -0.15});
                    plotSlope.getAxis(1).setLabelPosition(new double[]{-0.15, 0.5});
                    plotSlope.getAxis(1).setLabelAngle(-1.5707963267948966);
                    plotSlope.setFixedBounds(0, 0.0, profile.getPlanetLength());
                    plotSlope.getAxis(0).setOrigin(new double[]{plotSlope.plotCanvas.base.getMinBounds()[0], 0.0});
                    plotSlope.addPlotable((Plotable)new Line(Color.gray, new double[]{plotSlope.plotCanvas.base.getMinBounds()[0], 0.0}, new double[]{plotSlope.plotCanvas.base.getMaxBounds()[0], 0.0}));
                    ArrayList<ObjectAndDescription> m_Components = new ArrayList<ObjectAndDescription>();
                    ObjectAndDescription ob = new ObjectAndDescription(SLOPE, (Object)plotSlope);
                    m_Components.add(ob);
                    AdditionalResultsFrame slopeFrame = new AdditionalResultsFrame(m_Components);
                    slopeFrame.setTitle(PLOT + "-" + n + " " + SLOPE);
                    slopeFrame.setName(SLOPE);
                    slopeFrame.pack();
                    if (list.size() == 1) {
                        slopeFrame.setSize(plot2dA.getWidth(), plot2dA.getHeight());
                        wFrame.getContext().getWorkbench().getFrame().addInternalFrame(slopeFrame, true, true);
                    } else {
                        slopeFrame.toFront();
                    }
                    ProfileGraphGUI.mosaicFrames();
                }
            }
        });
        JButton infoBtn = new JButton(IconLoader.icon("information_16x16.png"));
        infoBtn.setToolTipText(PROFILE_INFO);
        infoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String velFlatString;
                HTMLFrame frame = new HTMLFrame();
                JInternalFrame[] frames = JUMPWorkbench.getInstance().getFrame().getInternalFrames();
                ArrayList<JInternalFrame> list = new ArrayList<JInternalFrame>();
                for (JInternalFrame iFrame : frames) {
                    if (!(iFrame instanceof HTMLFrame)) continue;
                    list.add(iFrame);
                }
                if (list.size() == 1) {
                    frame.dispose();
                }
                if ((velFlatString = jTextField_VelFlat.getText()).isEmpty()) {
                    velFlatString = "0";
                }
                double velFlat = Double.valueOf(velFlatString);
                String velUpString = jTextField_VelUp.getText();
                if (velUpString.isEmpty()) {
                    velUpString = "0";
                }
                double velUp = Double.valueOf(velUpString);
                String velDownString = jTextField_VelDown.getText();
                if (velDownString.isEmpty()) {
                    velDownString = "0";
                }
                double velDown = Double.valueOf(velDownString);
                double totTime = 0.0;
                for (int i = 0; i < doubleRelativeSlope.length; ++i) {
                    if (doubleRelativeSlope[i] < 1.7184 && doubleRelativeSlope[i] > -1.7184 && doubleTerrain[i] != 0.0) {
                        totTime += (doubleTerrain[i] - doubleTerrain[i - 1]) / unitConvert * (1.0 / velFlat);
                        continue;
                    }
                    if (doubleRelativeSlope[i] > 1.7184 && doubleTerrain[i] != 0.0) {
                        totTime += (doubleTerrain[i] - doubleTerrain[i - 1]) / unitConvert * (1.0 / velUp);
                        continue;
                    }
                    if (!(doubleRelativeSlope[i] < 1.7184) || doubleTerrain[i] == 0.0) continue;
                    totTime += (doubleTerrain[i] - doubleTerrain[i - 1]) / unitConvert * (1.0 / velDown);
                }
                HTMLPanel out = new HTMLPanel();
                DecimalFormat df = new DecimalFormat("##.###");
                String totTimeHM = (int)totTime + " " + HOURS + " " + (int)((totTime - (double)((int)totTime)) * 60.0) + " " + MINUTES;
                double min1 = profile.getZMin();
                double max1 = profile.getZMax();
                double lenght = profile.getTerrainLength();
                double width1 = profile.getPlanetLength();
                double height1 = Math.abs(max1 - min1);
                double slope1 = profile.getSlope();
                htmlString = "<HTML><BODY>";
                htmlString = htmlString + "<h2 align=\"left\">" + PROFILE_INFO + "-" + n + "</h2>";
                htmlString = htmlString + "<b><font face=\"" + darkLabelFont + "\">" + MIN + ": </b>" + df.format(min1) + "<br>";
                htmlString = htmlString + "<b><font face=\"" + darkLabelFont + "\">" + MAX + ": </b>" + df.format(max1) + "<br>";
                htmlString = htmlString + "<b><font face=\"" + darkLabelFont + "\">" + PROFILE_LENGTH + ": </b>" + df.format(lenght) + "<br>";
                htmlString = htmlString + "<b><font face=\"" + darkLabelFont + "\">" + WIDTH + ": </b>" + df.format(width1) + "<br>";
                htmlString = htmlString + "<b><font face=\"" + darkLabelFont + "\">" + HEIGHT + ": </b>" + df.format(height1) + "<br>";
                htmlString = htmlString + "<b><font face=\"" + darkLabelFont + "\">" + MEAN_SLOPE + ": </b>" + df.format(slope1) + "\ufffd<br>";
                if (!layerUnit.equals("degree") || !layerUnit.equals("UnKnown")) {
                    htmlString = htmlString + "<b><font face=\"" + darkLabelFont + "\">" + UNIT + " </b>" + layerUnit + "<br>";
                    htmlString = htmlString + "<b><font face=\"" + darkLabelFont + "\">" + FLAT + ": </b>" + velFlat + " " + speedUnit + "<br>";
                    htmlString = htmlString + "<b><font face=\"" + darkLabelFont + "\">" + UPHILL + ": </b>" + velUp + " " + speedUnit + "<br>";
                    htmlString = htmlString + "<b><font face=\"" + darkLabelFont + "\">" + DOWNHILL + ": </b>" + velDown + " " + speedUnit + "<br>";
                    htmlString = htmlString + "<b><font face=\"" + darkLabelFont + "\">" + TIMES + ": </b>" + totTimeHM + "<br>";
                }
                htmlString = htmlString + "</DIV></BODY></HTML>";
                out.getRecordPanel().removeAll();
                out.createNewDocument();
                out.setBackground(Color.lightGray);
                out.append(htmlString);
                frame.setTitle(PLOT + "-" + n + " " + PROFILE_INFO);
                frame.add(out);
                frame.setClosable(true);
                frame.setResizable(true);
                frame.setMaximizable(true);
                frame.setSize(230, 360);
                frame.setVisible(true);
                wFrame.getContext().getWorkbench().getFrame().addInternalFrame(frame, true, true);
            }
        });
        plot2dA.plotToolBar.addSeparator(new Dimension(16, 16));
        plot2dA.plotToolBar.add((Component)tableBtn);
        plot2dA.plotToolBar.add((Component)slopeBtn);
        plot2dA.plotToolBar.addSeparator(new Dimension(16, 16));
        plot2dA.plotToolBar.add((Component)jLabel4);
        plot2dA.plotToolBar.addSeparator(new Dimension(16, 16));
        plot2dA.plotToolBar.add((Component)infoBtn);
        if (!layerUnit.equals("degree") || !layerUnit.equals("UnKnown")) {
            plot2dA.plotToolBar.add((Component)jPanel2);
            plot2dA.plotToolBar.addSeparator(new Dimension(16, 16));
            plot2dA.plotToolBar.add((Component)jPanel3);
        }
        plot2dA.setFixedBounds(0, 0.0, profile.getPlanetLength());
        return plot2dA;
    }

    private static void mosaicFrames() {
        boolean xpos = false;
        int ypos = 0;
        Dimension deskDim = wFrame.getContext().getWorkbench().getFrame().getDesktopPane().getSize();
        int deskWidth = deskDim.width;
        int deskHeight = deskDim.height;
        int frameWidth = deskWidth = deskDim.width;
        int frameHeight = deskHeight / 2;
        for (JInternalFrame iFrame : JUMPWorkbench.getInstance().getFrame().getInternalFrames()) {
            if (!(iFrame instanceof AdditionalResultsFrame)) continue;
            ((AdditionalResultsFrame)iFrame).reshape(0, ypos, frameWidth, frameHeight);
            ((AdditionalResultsFrame)iFrame).setLocation(0, ypos);
            ((AdditionalResultsFrame)iFrame).getSplitPanel().setDividerLocation(0);
            ((AdditionalResultsFrame)iFrame).moveToFront();
            ypos += frameHeight;
        }
    }

    public static Object[] doubleToObject(double[] data) {
        Object[] column = new Object[data.length];
        for (int i = 0; i < column.length; ++i) {
            column[i] = data[i];
        }
        return column;
    }

    static {
        dDist = 0.0;
        dHorzDist = 0.0;
        dSlope = 0.0;
        dY = 0.0;
        nPoints = 0;
        n = 0;
        coordinates = new ArrayList();
        layerUnit = "";
        unit = "";
        speedUnit = "";
        darkLabelFont = AbstractDrawer.DEFAULT_FONT;
    }
}

