/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.mousemenu;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.io.WKTReader;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.CollectionOfFeaturesTransferable;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.PasteItemsPlugIn;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.StringReader;
import java.util.Collection;
import java.util.List;
import javax.swing.ImageIcon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Geometry;
import org.openjump.core.ui.images.IconLoader;

public class PasteItemsAtPlugIn
extends PasteItemsPlugIn {
    public static ImageIcon ICON = IconLoader.icon("items_paste_here.png");
    WKTReader reader = new WKTReader();
    private static final String PASTE_ITEMS_AT_POINT = I18N.getInstance().get("org.openjump.core.ui.plugin.mousemenu.PasteItemsAtPlugIn.Paste-Items-At-Point");

    public PasteItemsAtPlugIn() {
        super(PASTE_ITEMS_AT_POINT);
        this.setShortcutKeys(86);
        this.setShortcutModifiers(3);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        Transferable transferable = GUIUtil.getContents(Toolkit.getDefaultToolkit().getSystemClipboard());
        List<Feature> features = transferable.isDataFlavorSupported(CollectionOfFeaturesTransferable.COLLECTION_OF_FEATURES_FLAVOR) ? (List<Feature>)GUIUtil.getContents(Toolkit.getDefaultToolkit().getSystemClipboard()).getTransferData(CollectionOfFeaturesTransferable.COLLECTION_OF_FEATURES_FLAVOR) : this.reader.read(new StringReader((String)transferable.getTransferData(DataFlavor.stringFlavor))).getFeatures();
        final SelectionManager selectionManager = context.getLayerViewPanel().getSelectionManager();
        final Layer layer = context.getSelectedLayer(0);
        final Collection featureCopies = PasteItemsAtPlugIn.conform(features, layer.getFeatureCollectionWrapper().getFeatureSchema());
        Feature feature = (Feature)featureCopies.iterator().next();
        Coordinate firstPoint = feature.getGeometry().getCoordinate();
        Coordinate cursorPt = context.getLayerViewPanel().getViewport().toModelCoordinate(context.getLayerViewPanel().getLastMouseLocation());
        Coordinate displacement = CoordUtil.subtract(cursorPt, firstPoint);
        this.moveAll(featureCopies, displacement);
        this.execute(new UndoableCommand(this.getName()){

            @Override
            public void execute() {
                layer.getFeatureCollectionWrapper().addAll(featureCopies);
                selectionManager.clear();
                selectionManager.getFeatureSelection().selectItems(layer, featureCopies);
            }

            @Override
            public void unexecute() {
                layer.getFeatureCollectionWrapper().removeAll(featureCopies);
            }
        }, context);
        return true;
    }

    private void moveAll(Collection featureCopies, Coordinate displacement) {
        for (Feature item : featureCopies) {
            this.move(item.getGeometry(), displacement);
            item.getGeometry().geometryChanged();
        }
    }

    private void move(Geometry geometry, final Coordinate displacement) {
        geometry.apply(new CoordinateFilter(){

            public void filter(Coordinate coordinate) {
                coordinate.x += displacement.x;
                coordinate.y += displacement.y;
            }
        });
    }

    @Override
    public ImageIcon getIcon() {
        return ICON;
    }
}

