/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.mousemenu;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import com.vividsolutions.jump.workbench.ui.SelectionManagerProxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ImageIcon;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.locationtech.jts.operation.union.UnaryUnionOp;
import org.openjump.core.ui.images.IconLoader;

public class MergeSelectedFeaturesPlugIn
extends AbstractPlugIn {
    private static final ImageIcon ICON = IconLoader.icon("features_merge.png");

    public MergeSelectedFeaturesPlugIn() {
        this.setShortcutKeys(77);
        this.setShortcutModifiers(2);
    }

    @Override
    public ImageIcon getIcon() {
        return ICON;
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustHaveSelectedItemsCheck(1)).add(checkFactory.createAtLeastNItemsMustBeSelectedCheck(2)).add(checkFactory.createSelectedItemsLayersMustBeEditableCheck());
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        SelectionManager smgr = ((SelectionManagerProxy)((Object)context.getActiveInternalFrame())).getSelectionManager();
        final Collection<Feature> features = smgr.getFeaturesWithSelectedItems();
        Layer layer = smgr.getLayersWithSelectedItems().iterator().next();
        ArrayList points = new ArrayList();
        Collection linestrings = new ArrayList();
        ArrayList polygons = new ArrayList();
        for (Feature feature : features) {
            this.distribute(feature.getGeometry(), points, linestrings, polygons);
        }
        LineMerger merger = new LineMerger();
        merger.add(linestrings);
        linestrings = merger.getMergedLineStrings();
        ArrayList geometries = new ArrayList(polygons);
        geometries.addAll(linestrings);
        geometries.addAll(points);
        Geometry geometry = UnaryUnionOp.union(geometries);
        Iterator<Feature> iterator = features.iterator();
        final Feature mergedFeature = iterator.next().clone();
        mergedFeature.setGeometry(geometry);
        this.execute(new UndoableCommand(this.getName(), layer){

            @Override
            public void execute() {
                this.getLayer().getFeatureCollectionWrapper().removeAll(features);
                this.getLayer().getFeatureCollectionWrapper().add(mergedFeature);
            }

            @Override
            public void unexecute() {
                this.getLayer().getFeatureCollectionWrapper().remove(mergedFeature);
                this.getLayer().getFeatureCollectionWrapper().addAll(features);
            }
        }, context);
        context.getWorkbenchContext().getLayerViewPanel().getSelectionManager().clear();
        context.getWorkbenchContext().getLayerViewPanel().getSelectionManager().getFeatureSelection().selectItems(layer, mergedFeature);
        return true;
    }

    private void distribute(Geometry geometry, Collection points, Collection linestrings, Collection polygons) {
        if (geometry instanceof Point) {
            points.add(geometry);
        } else if (geometry instanceof LineString) {
            linestrings.add(geometry);
        } else if (geometry instanceof Polygon) {
            polygons.add(geometry);
        } else if (geometry instanceof GeometryCollection) {
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                this.distribute(geometry.getGeometryN(i), points, linestrings, polygons);
            }
        }
    }
}

