/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer.pirolraster;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import javax.swing.ImageIcon;
import org.locationtech.jts.geom.Envelope;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.rasterimage.RasterImageLayer;

public class ZoomToRasterImagePlugIn
extends AbstractPlugIn {
    public static final ImageIcon ICON = IconLoader.icon("zoom.gif");

    public String getIconString() {
        return null;
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.layer.pirolraster.ZoomToRasterImagePlugIn.Zoom-To-Raster-Image");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        RasterImageLayer rLayer = (RasterImageLayer)LayerTools.getSelectedLayerable(context, RasterImageLayer.class);
        WorkbenchContext wbcontext = context.getWorkbenchContext();
        Envelope envelope = new Envelope();
        if (rLayer == null) {
            context.getWorkbenchFrame().warnUser(I18N.getInstance().get("pirol.plugIns.EditAttributeByFormulaPlugIn.no-layer-selected"));
            return false;
        }
        for (RasterImageLayer layer : wbcontext.getLayerNamePanel().selectedNodes(RasterImageLayer.class)) {
            envelope.expandToInclude(layer.getWholeImageEnvelope());
        }
        context.getLayerViewPanel().getViewport().zoom(EnvelopeUtil.bufferByFraction(envelope, 0.03));
        return true;
    }
}

