/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.openjump.core.ui.plugin.AbstractThreadedUiPlugIn;

public class ExtractLayersByGeometry
extends AbstractThreadedUiPlugIn {
    private static final String EXTRACT_LAYERS_BY_GEOMETRY_TYPE = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.Extract-Layers-by-Geometry-Type");
    private static final String EXTRACT_BY_GEOMETRY_TYPE = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.Extract-by-Geometry-Type");
    private static final String EXTRACT_BY_GEOMETRY_TYPE_TT = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.Extract-by-Geometry-Type-Tooltip");
    private static final String EXTRACT_BY_SHAPEFILE_TYPE = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.Extract-by-Shapefile-Type");
    private static final String EXTRACT_BY_SHAPEFILE_TYPE_TT = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.Extract-by-Shapefile-Type-Tooltip");
    private static final String EXTRACT_BY_GEOMETRY_DIMENSION = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.Extract-by-Geometry-Dimension");
    private static final String EXTRACT_BY_GEOMETRY_DIMENSION_TT = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.Extract-by-Geometry-Dimension-Tooltip");
    private static final String KEEP_EMPTY_GEOMETRIES_APPART = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.Keep-Empty-Geometries-Appart");
    private static final String DO_NOT_EXPLODE_GEOMETRY_COLLECTIONS = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.Do-Not-Explode-GeometryCollections");
    private static final String EXPLODE_ALL_GEOMETRY_COLLECTIONS = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.Explode-All-GeometryCollections");
    private static final String EXPLODE_PURE_GEOMETRY_COLLECTIONS = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.Explode-Pure-GeometryCollections");
    private static final String ONLY_ONE_GEOMETRY_TYPE_FOUND = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.Only-one-geometry-type-found");
    private static final String EMPTY = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.empty");
    private static final String POINT = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.point");
    private static final String MULTIPOINT = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.multipoint");
    private static final String ZERODIM = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.point");
    private static final String LINESTRING = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.linestring");
    private static final String MULTILINESTRING = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.multilinestring");
    private static final String POLYLINE = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.polyline");
    private static final String ONEDIM = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.line");
    private static final String POLYGON = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.polygon");
    private static final String MULTIPOLYGON = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.multipolygon");
    private static final String TWODIM = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.area");
    private static final String GEOMETRYCOLLECTION = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ExtractLayersByGeometry.geometrycollection");
    private static final String LAYER = GenericNames.SELECT_LAYER;
    public Layer layer = null;
    private boolean extractByGeometryType = true;
    private boolean extractByShapefileType = false;
    private boolean extractByGeometryDimension = false;
    private boolean doNotExplodeGeometryCollections = true;
    private boolean explodePureGeometryCollections = false;
    private boolean explodeAllGeometryCollections = false;
    private boolean keepEmptyGeometryAppart = true;
    public static final ImageIcon ICON = IconLoader.icon("extract.gif");

    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenu(new String[]{MenuNames.EDIT}, MenuNames.EXTRACT);
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.EDIT, MenuNames.EXTRACT}, this.getName(), false, ICON, ExtractLayersByGeometry.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithSelectionManagerMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.layer = context.getCandidateLayer(0);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        if (this.layer != null) {
            this.splitLayer(monitor, context, this.layer);
        }
    }

    @Override
    public String getName() {
        return EXTRACT_LAYERS_BY_GEOMETRY_TYPE + "...";
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(EXTRACT_LAYERS_BY_GEOMETRY_TYPE);
        dialog.addLayerComboBox(LAYER, this.layer, context.getLayerManager());
        dialog.addRadioButton(EXTRACT_BY_GEOMETRY_TYPE, "GROUPBY", this.extractByGeometryType, EXTRACT_BY_GEOMETRY_TYPE_TT);
        dialog.addRadioButton(EXTRACT_BY_SHAPEFILE_TYPE, "GROUPBY", this.extractByShapefileType, EXTRACT_BY_SHAPEFILE_TYPE_TT);
        dialog.addRadioButton(EXTRACT_BY_GEOMETRY_DIMENSION, "GROUPBY", this.extractByGeometryDimension, EXTRACT_BY_GEOMETRY_DIMENSION_TT);
        dialog.addSeparator();
        dialog.addRadioButton(DO_NOT_EXPLODE_GEOMETRY_COLLECTIONS, "GC", this.doNotExplodeGeometryCollections, DO_NOT_EXPLODE_GEOMETRY_COLLECTIONS);
        dialog.addRadioButton(EXPLODE_PURE_GEOMETRY_COLLECTIONS, "GC", this.explodePureGeometryCollections, EXPLODE_PURE_GEOMETRY_COLLECTIONS);
        dialog.addRadioButton(EXPLODE_ALL_GEOMETRY_COLLECTIONS, "GC", this.explodeAllGeometryCollections, EXPLODE_ALL_GEOMETRY_COLLECTIONS);
        dialog.addSeparator();
        dialog.addCheckBox(KEEP_EMPTY_GEOMETRIES_APPART, true, KEEP_EMPTY_GEOMETRIES_APPART);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.layer = dialog.getLayer(LAYER);
        this.extractByGeometryType = dialog.getBoolean(EXTRACT_BY_GEOMETRY_TYPE);
        this.extractByShapefileType = dialog.getBoolean(EXTRACT_BY_SHAPEFILE_TYPE);
        this.extractByGeometryDimension = dialog.getBoolean(EXTRACT_BY_GEOMETRY_DIMENSION);
        this.doNotExplodeGeometryCollections = dialog.getBoolean(DO_NOT_EXPLODE_GEOMETRY_COLLECTIONS);
        this.explodePureGeometryCollections = dialog.getBoolean(EXPLODE_PURE_GEOMETRY_COLLECTIONS);
        this.explodeAllGeometryCollections = dialog.getBoolean(EXPLODE_ALL_GEOMETRY_COLLECTIONS);
        this.keepEmptyGeometryAppart = dialog.getBoolean(KEEP_EMPTY_GEOMETRIES_APPART);
    }

    private void splitLayer(TaskMonitor monitor, PlugInContext context, Layer layer) {
        FeatureSchema schema = layer.getFeatureCollectionWrapper().getFeatureSchema();
        FeatureDataset emptyFeatures = new FeatureDataset(schema);
        FeatureDataset pointFeatures = new FeatureDataset(schema);
        FeatureDataset multiPointFeatures = new FeatureDataset(schema);
        FeatureDataset zeroDimFeatures = new FeatureDataset(schema);
        FeatureDataset lineFeatures = new FeatureDataset(schema);
        FeatureDataset multiLineFeatures = new FeatureDataset(schema);
        FeatureDataset polyLineFeatures = new FeatureDataset(schema);
        FeatureDataset oneDimFeatures = new FeatureDataset(schema);
        FeatureDataset polygonFeatures = new FeatureDataset(schema);
        FeatureDataset multiPolyFeatures = new FeatureDataset(schema);
        FeatureDataset twoDimFeatures = new FeatureDataset(schema);
        FeatureDataset geometryCollectionFeatures = new FeatureDataset(schema);
        HashMap<String, FeatureCollection> map = new HashMap<String, FeatureCollection>();
        map.put(EMPTY, emptyFeatures);
        map.put(POINT, pointFeatures);
        map.put(MULTIPOINT, multiPointFeatures);
        map.put(ZERODIM, zeroDimFeatures);
        map.put(LINESTRING, lineFeatures);
        map.put(MULTILINESTRING, multiLineFeatures);
        map.put(POLYLINE, polyLineFeatures);
        map.put(ONEDIM, oneDimFeatures);
        map.put(POLYGON, polygonFeatures);
        map.put(MULTIPOLYGON, multiPolyFeatures);
        map.put(TWODIM, twoDimFeatures);
        map.put(GEOMETRYCOLLECTION, geometryCollectionFeatures);
        FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
        for (Feature feature : featureCollection.getFeatures()) {
            if (monitor.isCancelRequested()) break;
            this.extractByGeomType(feature, map);
        }
        int nbList = 0;
        for (FeatureCollection featureCollection2 : map.values()) {
            if (featureCollection2.size() <= 0) continue;
            ++nbList;
        }
        if (nbList < 2) {
            context.getWorkbenchFrame().warnUser(ONLY_ONE_GEOMETRY_TYPE_FOUND);
        } else {
            for (Map.Entry entry : map.entrySet()) {
                if (((FeatureCollection)entry.getValue()).size() == 0) continue;
                Layer lyr = context.addLayer(StandardCategoryNames.RESULT, layer.getName() + " - " + (String)entry.getKey(), (FeatureCollection)entry.getValue());
                lyr.setStyles(layer.cloneStyles());
            }
            context.getLayerViewPanel().repaint();
        }
    }

    private void extractByGeomType(Feature feature, Map<String, FeatureCollection> map) {
        Geometry geometry = feature.getGeometry();
        Feature f = feature.clone(false, true);
        f.setGeometry(geometry);
        if (this.keepEmptyGeometryAppart && geometry.isEmpty()) {
            map.get(EMPTY).add(f);
        } else if (geometry instanceof GeometryCollection && (this.explodePureGeometryCollections && geometry.getGeometryType().equals("GeometryCollection") || this.explodeAllGeometryCollections)) {
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                Geometry g = geometry.getGeometryN(i);
                Feature f2 = feature.clone(false, true);
                f2.setGeometry(g);
                this.extractByGeomType(f2, map);
            }
        } else if (geometry.getGeometryType().equals("Point")) {
            if (this.extractByGeometryType) {
                map.get(POINT).add(f);
            } else if (this.extractByShapefileType) {
                map.get(POINT).add(f);
            } else if (this.extractByGeometryDimension) {
                map.get(ZERODIM).add(f);
            }
        } else if (geometry.getGeometryType().equals("MultiPoint")) {
            if (this.extractByGeometryType) {
                map.get(MULTIPOINT).add(f);
            } else if (this.extractByShapefileType) {
                map.get(MULTIPOINT).add(f);
            } else if (this.extractByGeometryDimension) {
                map.get(ZERODIM).add(f);
            }
        } else if (geometry.getGeometryType().equals("LineString")) {
            if (this.extractByGeometryType) {
                map.get(LINESTRING).add(f);
            } else if (this.extractByShapefileType) {
                map.get(POLYLINE).add(f);
            } else if (this.extractByGeometryDimension) {
                map.get(ONEDIM).add(f);
            }
        } else if (geometry.getGeometryType().equals("MultiLineString")) {
            if (this.extractByGeometryType) {
                map.get(MULTILINESTRING).add(f);
            } else if (this.extractByShapefileType) {
                map.get(POLYLINE).add(f);
            } else if (this.extractByGeometryDimension) {
                map.get(ONEDIM).add(f);
            }
        } else if (geometry.getGeometryType().equals("Polygon")) {
            if (this.extractByGeometryType) {
                map.get(POLYGON).add(f);
            } else if (this.extractByShapefileType) {
                map.get(POLYGON).add(f);
            } else if (this.extractByGeometryDimension) {
                map.get(TWODIM).add(f);
            }
        } else if (geometry.getGeometryType().equals("MultiPolygon")) {
            if (this.extractByGeometryType) {
                map.get(MULTIPOLYGON).add(f);
            } else if (this.extractByShapefileType) {
                map.get(POLYGON).add(f);
            } else if (this.extractByGeometryDimension) {
                map.get(TWODIM).add(f);
            }
        } else if (geometry.getGeometryType().equals("GeometryCollection")) {
            map.get(GEOMETRYCOLLECTION).add(f);
        }
    }
}

