/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file.open;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.io.CompressedFile;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.ui.ErrorHandler;
import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.openjump.core.ui.io.file.DataSourceFileLayerLoader;
import org.openjump.core.ui.io.file.FileLayerLoader;
import org.openjump.core.ui.io.file.Option;
import org.openjump.core.ui.plugin.file.InstallDummyReaderPlugIn;
import org.openjump.core.ui.plugin.file.open.SelectFileLoaderPanel;
import org.openjump.core.ui.plugin.file.open.SelectFileOptionsPanel;
import org.openjump.core.ui.plugin.file.open.SelectFilesPanel;
import org.openjump.util.UriUtil;

public class OpenFileWizardState {
    public static final String KEY = OpenFileWizardState.class.getName();
    private String currentPanel;
    private FileLayerLoader fileLayerLoader;
    public static FileLayerLoader IGNORELOADER = new DataSourceFileLayerLoader(JUMPWorkbench.getInstance().getContext(), InstallDummyReaderPlugIn.DummyDataSource.class, I18N.getInstance().get(OpenFileWizardState.class.getName() + ".dummy-loader-description"), Arrays.asList("*"));
    private Map<String, Set<FileLayerLoader>> extensionLoaderMap = new HashMap<String, Set<FileLayerLoader>>();
    private Map<URI, FileLayerLoader> fileLoaderMap = new HashMap<URI, FileLayerLoader>();
    private Map<FileLayerLoader, Set<URI>> fileLoaderFiles = new HashMap<FileLayerLoader, Set<URI>>();
    private Map<String, Set<URI>> multiLoaderFiles = new TreeMap<String, Set<URI>>();
    private Map<URI, Map<String, Object>> fileOptions = new HashMap<URI, Map<String, Object>>();
    private ErrorHandler errorHandler;

    public OpenFileWizardState(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public FileLayerLoader getFileLoader() {
        return this.fileLayerLoader;
    }

    public void setupFileLoaders(File[] files, FileLayerLoader fileLayerLoader) {
        TreeSet<File> fileSet = new TreeSet<File>(Arrays.asList(files));
        this.multiLoaderFiles.clear();
        this.fileLoaderFiles.clear();
        if (fileLayerLoader != null) {
            this.fileLoaderMap.clear();
            for (File file : fileSet) {
                this.setFileLoader(file.toURI(), fileLayerLoader);
            }
        } else {
            this.fileLoaderMap.clear();
            for (File file : files) {
                if (CompressedFile.isArchive(file.toURI())) {
                    try {
                        List<URI> entries = CompressedFile.listEntries(file);
                        for (URI entryUri : entries) {
                            String entryExt = UriUtil.getFileExtension(entryUri);
                            this.addFile(entryExt, entryUri);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        this.errorHandler.handleThrowable(e);
                        continue;
                    }
                }
                if (CompressedFile.hasCompressedFileExtension(file.getName())) {
                    String[] parts = file.getName().split("\\.");
                    if (parts.length <= 2) continue;
                    this.addFile(parts[parts.length - 2], file.toURI());
                    continue;
                }
                URI fileUri = file.toURI();
                this.addFile(FileUtil.getExtension(file), fileUri);
            }
        }
    }

    private void addFile(String extension, URI fileUrl) {
        Set<FileLayerLoader> loaders = this.getFileLoaders(extension);
        if (loaders.size() < 1) {
            loaders = this.getFileLoaders("*");
        }
        if (loaders.size() == 1) {
            FileLayerLoader loader = loaders.iterator().next();
            this.setFileLoader(fileUrl, loader);
        } else if (!loaders.isEmpty()) {
            Set<URI> extensionFiles = this.multiLoaderFiles.get(extension);
            if (extensionFiles == null) {
                extensionFiles = new TreeSet<URI>();
                this.multiLoaderFiles.put(extension, extensionFiles);
            }
            extensionFiles.add(fileUrl);
        }
    }

    public void setFileLoader(String extension, FileLayerLoader fileLayerLoader) {
        Set<URI> files = this.multiLoaderFiles.get(extension);
        for (URI file : files) {
            this.setFileLoader(file, fileLayerLoader);
        }
    }

    public void setFileLoader(URI file, FileLayerLoader fileLayerLoader) {
        Set<URI> files;
        FileLayerLoader oldFileLoader = this.fileLoaderMap.get(file);
        if (oldFileLoader != null && (files = this.fileLoaderFiles.get(oldFileLoader)) != null) {
            files.remove(file);
        }
        this.fileLoaderMap.put(file, fileLayerLoader);
        files = this.fileLoaderFiles.get(fileLayerLoader);
        if (files == null) {
            files = new HashSet<URI>();
            this.fileLoaderFiles.put(fileLayerLoader, files);
        }
        files.add(file);
    }

    public void addFileLoader(FileLayerLoader fileLayerLoader) {
        for (String extension : fileLayerLoader.getFileExtensions()) {
            Set<FileLayerLoader> state_extensionLoaders = this.getFileLoaders(extension);
            state_extensionLoaders.add(fileLayerLoader);
        }
    }

    public Set<FileLayerLoader> getFileLoaders(String extension) {
        Set<FileLayerLoader> loaders = this.extensionLoaderMap.get(extension);
        if (loaders == null) {
            loaders = new HashSet<FileLayerLoader>();
            this.extensionLoaderMap.put(extension, loaders);
        }
        return loaders;
    }

    public String getCurrentPanel() {
        return this.currentPanel;
    }

    public void setCurrentPanel(String currentPanel) {
        this.currentPanel = currentPanel;
    }

    public String getNextPanel(String currentPanel) {
        if (currentPanel.equals(SelectFilesPanel.KEY)) {
            if (this.fileLayerLoader == null && !this.multiLoaderFiles.isEmpty()) {
                return SelectFileLoaderPanel.class.getName();
            }
            return this.getNextPanel(SelectFileLoaderPanel.class.getName());
        }
        if (currentPanel.equals(SelectFileLoaderPanel.KEY)) {
            for (Map.Entry<FileLayerLoader, Set<URI>> entries : this.fileLoaderFiles.entrySet()) {
                FileLayerLoader fileLayerLoader = entries.getKey();
                if (entries.getValue().isEmpty() || fileLayerLoader.getOptionMetadata().isEmpty()) continue;
                return SelectFileOptionsPanel.KEY;
            }
            return this.getNextPanel(SelectFileOptionsPanel.KEY);
        }
        return null;
    }

    public Map<String, Set<FileLayerLoader>> getExtensionLoaderMap() {
        return this.extensionLoaderMap;
    }

    public void setExtensionLoaderMap(Map<String, Set<FileLayerLoader>> extensionLoaderMap) {
        this.extensionLoaderMap = extensionLoaderMap;
    }

    public Map<String, Set<URI>> getMultiLoaderFiles() {
        return Collections.unmodifiableMap(this.multiLoaderFiles);
    }

    public Map<URI, FileLayerLoader> getFileLoaders() {
        return Collections.unmodifiableMap(this.fileLoaderMap);
    }

    public Map<FileLayerLoader, Set<URI>> getFileLoaderFiles() {
        return Collections.unmodifiableMap(this.fileLoaderFiles);
    }

    public FileLayerLoader getFileLoader(URI file) {
        return this.fileLoaderMap.get(file);
    }

    public void setOption(FileLayerLoader loader, String label, Object value) {
        Set<URI> files = this.fileLoaderFiles.get(loader);
        for (URI file : files) {
            this.setOption(file, label, value);
        }
    }

    public void setOption(URI file, String label, Object value) {
        Map<String, Object> options = this.getOptions(file);
        options.put(label, value);
    }

    public Map<String, Object> getOptions(URI file) {
        Map<String, Object> options = this.fileOptions.get(file);
        if (options == null) {
            options = new HashMap<String, Object>();
            this.fileOptions.put(file, options);
        }
        return options;
    }

    public boolean hasSelectedFiles() {
        return !this.fileLoaderFiles.isEmpty() || !this.multiLoaderFiles.isEmpty();
    }

    public boolean hasRequiredOptions() {
        for (Map.Entry<FileLayerLoader, Set<URI>> entries : this.fileLoaderFiles.entrySet()) {
            FileLayerLoader fileLayerLoader = entries.getKey();
            Set<URI> files = entries.getValue();
            if (files.isEmpty()) continue;
            List<Option> optionMetadata = fileLayerLoader.getOptionMetadata();
            for (URI file : files) {
                Map<String, Object> options = this.getOptions(file);
                for (Option option : optionMetadata) {
                    if (!option.isRequired() || options.get(option.getName()) != null) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public String getFileName(URI uri) {
        String path = uri.getPath();
        int slashIndex = path.lastIndexOf(47);
        if (slashIndex > -1) {
            return path.substring(slashIndex + 1);
        }
        return path;
    }
}

