/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file;

import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.ErrorHandler;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TooManyListenersException;
import javax.swing.BorderFactory;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import org.openjump.core.ui.plugin.AbstractUiPlugIn;
import org.openjump.core.ui.plugin.file.OpenFilePlugIn;
import org.openjump.core.ui.plugin.file.OpenProjectPlugIn;

public class FileDragDropPlugin
extends AbstractUiPlugIn
implements DropTargetListener {
    public static final Set<String> PROJECT_EXTENSIONS = new HashSet<String>(Arrays.asList("jmp", "jcs"));
    private static final String ZERO_CHAR_STRING = "\u0000";
    private WorkbenchFrame frame;
    private Border border = BorderFactory.createMatteBorder(2, 2, 2, 2, new Color(0.0f, 0.0f, 1.0f, 0.25f));
    private Border savedBorder;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        JUMPWorkbench workbench = this.workbenchContext.getWorkbench();
        this.frame = workbench.getFrame();
        this.makeDropTarget(this.frame, true);
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        if (this.isDragOk(event)) {
            JRootPane rootPane = this.frame.getRootPane();
            this.savedBorder = rootPane.getBorder();
            rootPane.setBorder(this.border);
            event.acceptDrag(1);
        } else {
            event.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent event) {
        JRootPane rootPane = this.frame.getRootPane();
        rootPane.setBorder(this.savedBorder);
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(DropTargetDropEvent event) {
        ErrorHandler errorHandler;
        try {
            Transferable tr = event.getTransferable();
            ArrayList<File> files = null;
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                event.acceptDrop(1);
                files = (ArrayList<File>)tr.getTransferData(DataFlavor.javaFileListFlavor);
            } else {
                DataFlavor[] flavors = tr.getTransferDataFlavors();
                boolean handled = false;
                for (DataFlavor flavor : flavors) {
                    if (!flavor.isRepresentationClassReader()) continue;
                    event.acceptDrop(1);
                    BufferedReader reader = new BufferedReader(flavor.getReaderForText(tr));
                    handled = true;
                    files = new ArrayList<File>();
                    String fileName = null;
                    while ((fileName = reader.readLine()) != null) {
                        try {
                            if (ZERO_CHAR_STRING.equals(fileName)) continue;
                            File file = new File(new URI(fileName));
                            files.add(file);
                        }
                        catch (URISyntaxException e) {
                            ErrorHandler errorHandler2 = this.workbenchContext.getErrorHandler();
                            errorHandler2.handleThrowable(e);
                        }
                    }
                }
                if (!handled) {
                    event.rejectDrop();
                    return;
                }
            }
            if (files != null) {
                ArrayList<File> projectFiles = new ArrayList<File>();
                ArrayList<File> dataFiles = new ArrayList<File>();
                for (File file : files) {
                    String extension = GUIUtil.getExtension(file);
                    if (PROJECT_EXTENSIONS.contains(extension)) {
                        projectFiles.add(file);
                        continue;
                    }
                    dataFiles.add(file);
                }
                if (!dataFiles.isEmpty()) {
                    OpenFilePlugIn filePlugin = new OpenFilePlugIn(this.workbenchContext, dataFiles.toArray(new File[0]));
                    filePlugin.actionPerformed(new ActionEvent(this, 0, ""));
                }
                if (!projectFiles.isEmpty()) {
                    OpenProjectPlugIn projectPlugin = new OpenProjectPlugIn(this.workbenchContext, projectFiles.toArray(new File[0]));
                    projectPlugin.actionPerformed(new ActionEvent(this, 0, ""));
                }
            }
            event.getDropTargetContext().dropComplete(true);
        }
        catch (UnsupportedFlavorException e) {
            errorHandler = this.workbenchContext.getErrorHandler();
            errorHandler.handleThrowable(e);
        }
        catch (IOException e) {
            errorHandler = this.workbenchContext.getErrorHandler();
            errorHandler.handleThrowable(e);
        }
        finally {
            JRootPane rootPane = this.frame.getRootPane();
            rootPane.setBorder(this.savedBorder);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
        if (this.isDragOk(event)) {
            event.acceptDrag(1);
        } else {
            event.rejectDrag();
        }
    }

    private boolean isDragOk(DropTargetDragEvent event) {
        DataFlavor[] flavors;
        for (DataFlavor flavor : flavors = event.getCurrentDataFlavors()) {
            if (!flavor.equals(DataFlavor.javaFileListFlavor) && !flavor.isRepresentationClassReader()) continue;
            return true;
        }
        return false;
    }

    private void makeDropTarget(final Component component, boolean recursive) {
        DropTarget target = new DropTarget();
        try {
            target.addDropTargetListener(this);
        }
        catch (TooManyListenersException e) {
            ErrorHandler errorHandler = this.workbenchContext.getErrorHandler();
            errorHandler.handleThrowable(e);
        }
        component.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent evt) {
                Container parent = component.getParent();
                if (parent == null) {
                    component.setDropTarget(null);
                } else {
                    new DropTarget(component, FileDragDropPlugin.this);
                }
            }
        });
        if (component.getParent() != null) {
            new DropTarget(component, this);
        }
        if (recursive && component instanceof Container) {
            Component[] comps;
            Container cont = (Container)component;
            for (Component child : comps = cont.getComponents()) {
                this.makeDropTarget(child, recursive);
            }
        }
    }
}

