/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.cursortools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.DragTool;
import com.vividsolutions.jump.workbench.ui.cursortool.QuasimodeTool;
import com.vividsolutions.jump.workbench.ui.cursortool.ShortcutsDescriptor;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.openjump.core.geomutils.GeoUtils;
import org.openjump.core.geomutils.MathVector;

public class RotateSelectedItemTool
extends DragTool
implements ShortcutsDescriptor {
    static final String rotateSelectedItem = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.RotateSelectedItemTool.Rotate-Selected-Item");
    static final String angleST = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.angle");
    static final String degrees = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.degrees");
    static final Map shortcuts = new HashMap();
    private KeyListener cursorSwitcher;
    private EnableCheckFactory checkFactory;
    private Shape selectedFeatureShape;
    private Coordinate centerCoord;
    protected boolean clockwise;
    private double fullAngle;
    private Cursor rotateCursor;
    private Cursor crosshairCursor;
    protected static GeometryFactory geomFac = new GeometryFactory();

    public RotateSelectedItemTool(WorkbenchContext context) {
        super(context);
        shortcuts.put(new QuasimodeTool.ModifierKeySpec(new int[]{16}), I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.RotateSelectedItemTool.Set-Rotation-Center"));
        this.cursorSwitcher = new KeyListener(){
            boolean shift = false;

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.shift = e.isShiftDown() && e.getKeyCode() != 16;
                this.setCursor();
            }

            @Override
            public void keyPressed(KeyEvent e) {
                this.shift = e.isShiftDown() || e.getKeyCode() == 16;
                this.setCursor();
            }

            private void setCursor() {
                LayerViewPanel panel = RotateSelectedItemTool.this.getPanel();
                if (panel != null) {
                    panel.setCursor(this.shift ? RotateSelectedItemTool.this.crosshairCursor : RotateSelectedItemTool.this.rotateCursor);
                }
            }
        };
        this.clockwise = true;
        this.fullAngle = 0.0;
        this.rotateCursor = RotateSelectedItemTool.createCursor(new ImageIcon(this.getClass().getResource("RotateSelCursor.gif")).getImage());
        this.crosshairCursor = Cursor.getPredefinedCursor(1);
        this.checkFactory = EnableCheckFactory.getInstance(context);
    }

    @Override
    public void activate(LayerViewPanel layerViewPanel) {
        this.centerCoord = null;
        super.activate(layerViewPanel);
        JUMPWorkbench.getInstance().getFrame().addEasyKeyListener(this.cursorSwitcher);
    }

    @Override
    public void deactivate() {
        super.deactivate();
        JUMPWorkbench.getInstance().getFrame().removeEasyKeyListener(this.cursorSwitcher);
    }

    @Override
    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        if (!this.check(this.checkFactory.createAtLeastNItemsMustBeSelectedCheck(1))) {
            return;
        }
        ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
        for (Layer layerWithSelectedItems : this.getPanel().getSelectionManager().getLayersWithSelectedItems()) {
            transactions.add(this.createTransaction(layerWithSelectedItems));
        }
        EditTransaction.commit(transactions);
    }

    private EditTransaction createTransaction(Layer layer) {
        EditTransaction transaction = EditTransaction.createTransactionOnSelection(new EditTransaction.SelectionEditor(){

            public Geometry edit(Geometry geometryWithSelectedItems, Collection selectedItems) {
                for (Geometry item : selectedItems) {
                    RotateSelectedItemTool.this.rotate(item);
                }
                return geometryWithSelectedItems;
            }
        }, this.getPanel(), this.getPanel().getContext(), this.getName(), layer, this.isRollingBackInvalidEdits(), false);
        return transaction;
    }

    private void rotate(Geometry geometry) {
        geometry.apply(new CoordinateFilter(){

            public void filter(Coordinate coordinate) {
                double cosAngle = Math.cos(RotateSelectedItemTool.this.fullAngle);
                double sinAngle = Math.sin(RotateSelectedItemTool.this.fullAngle);
                double x = coordinate.x - ((RotateSelectedItemTool)RotateSelectedItemTool.this).centerCoord.x;
                double y = coordinate.y - ((RotateSelectedItemTool)RotateSelectedItemTool.this).centerCoord.y;
                coordinate.x = ((RotateSelectedItemTool)RotateSelectedItemTool.this).centerCoord.x + x * cosAngle + y * sinAngle;
                coordinate.y = ((RotateSelectedItemTool)RotateSelectedItemTool.this).centerCoord.y + y * cosAngle - x * sinAngle;
            }
        });
    }

    @Override
    public Cursor getCursor() {
        return this.rotateCursor;
    }

    @Override
    public Icon getIcon() {
        return new ImageIcon(this.getClass().getResource("RotateSel.gif"));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
    }

    @Override
    public String getName() {
        return rotateSelectedItem;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        try {
            if (!this.check(this.checkFactory.createSelectedItemsLayersMustBeEditableCheck())) {
                return;
            }
            if (e.isShiftDown()) {
                this.centerCoord = this.getPanel().getViewport().toModelCoordinate(e.getPoint());
            } else {
                if (!this.check(this.checkFactory.createAtLeastNItemsMustBeSelectedCheck(1))) {
                    return;
                }
                this.selectedFeatureShape = this.createSelectedItemsShape();
                super.mousePressed(e);
            }
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    private Shape createSelectedItemsShape() throws NoninvertibleTransformException {
        Collection<Geometry> selectedGeos = this.getPanel().getSelectionManager().getSelectedItems();
        Point p = geomFac.createPoint(this.centerCoord);
        selectedGeos.add((Geometry)p);
        Geometry geo = selectedGeos.iterator().next();
        Geometry[] allGeoms = new Geometry[selectedGeos.size()];
        int i = 0;
        Iterator<Geometry> j = selectedGeos.iterator();
        while (j.hasNext()) {
            allGeoms[i++] = j.next();
        }
        GeometryFactory geoFac = new GeometryFactory();
        geo = geoFac.createGeometryCollection(allGeoms);
        if (this.centerCoord == null) {
            this.centerCoord = geo.getCentroid().getCoordinate();
        }
        Shape shap = this.getPanel().getJava2DConverter().toShape(geo);
        return shap;
    }

    @Override
    protected Shape getShape() throws Exception {
        boolean ccwQuad;
        AffineTransform transform = new AffineTransform();
        Point2D centerPt = this.getPanel().getViewport().toViewPoint(new Point2D.Double(this.centerCoord.x, this.centerCoord.y));
        Point2D initialPt = this.getViewSource();
        Point2D currPt = this.getViewDestination();
        MathVector center = new MathVector(centerPt.getX(), centerPt.getY());
        MathVector initial = new MathVector(initialPt.getX(), initialPt.getY());
        MathVector curr = new MathVector(currPt.getX(), currPt.getY());
        MathVector initVec = initial.vectorBetween(center);
        MathVector currVec = curr.vectorBetween(center);
        double arcAngle = initVec.angleRad(currVec);
        Coordinate initialCoord = this.getPanel().getViewport().toModelCoordinate(initialPt);
        Coordinate currCoord = this.getPanel().getViewport().toModelCoordinate(currPt);
        boolean toRight = GeoUtils.pointToRight(currCoord, this.centerCoord, initialCoord);
        boolean cwQuad = this.fullAngle >= 0.0 && this.fullAngle <= 90.0 && this.clockwise;
        boolean bl = ccwQuad = this.fullAngle < 0.0 && this.fullAngle >= -90.0 && !this.clockwise;
        if (arcAngle <= 90.0 && (cwQuad || ccwQuad)) {
            this.clockwise = toRight;
        }
        this.fullAngle = this.fullAngle > 90.0 || this.fullAngle < -90.0 ? (this.clockwise && !toRight || !this.clockwise && toRight ? 360.0 - arcAngle : arcAngle) : arcAngle;
        if (!this.clockwise) {
            this.fullAngle = -this.fullAngle;
        }
        DecimalFormat df2 = new DecimalFormat("##0.0#");
        this.getPanel().getContext().setStatusMessage(angleST + ": " + df2.format(Math.toDegrees(this.fullAngle)) + " " + degrees);
        transform.rotate(this.fullAngle, centerPt.getX(), centerPt.getY());
        return transform.createTransformedShape(this.selectedFeatureShape);
    }

    public final Map describeShortcuts() {
        return shortcuts;
    }
}

