/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.cursortools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.valid.IsValidOp;
import org.openjump.core.geomutils.Circle;
import org.openjump.core.ui.plugin.edittoolbox.cursortools.ConstrainedMultiClickTool;

public class DrawConstrainedCircleTool
extends ConstrainedMultiClickTool {
    private FeatureDrawingUtil featureDrawingUtil;
    static final String drawConstrainedCircle = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.DrawConstrainedCircleTool.Draw-Constrained-Circle");
    static final String theCircleMustHaveAtLeast2Points = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.DrawConstrainedCircleTool.The-circle-must-have-at-least-2-points");
    static final String sArea = I18N.getInstance().get("ui.cursortool.CoordinateListMetrics.Area");

    private DrawConstrainedCircleTool(WorkbenchContext context, FeatureDrawingUtil featureDrawingUtil) {
        super(context);
        this.drawClosed = true;
        this.featureDrawingUtil = featureDrawingUtil;
    }

    public static CursorTool create(WorkbenchContext context) {
        FeatureDrawingUtil featureDrawingUtil = new FeatureDrawingUtil(context);
        return featureDrawingUtil.prepare(new DrawConstrainedCircleTool(context, featureDrawingUtil), true);
    }

    @Override
    public String getName() {
        return drawConstrainedCircle;
    }

    @Override
    public Icon getIcon() {
        return new ImageIcon(this.getClass().getResource("DrawCircleConstrained.gif"));
    }

    @Override
    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        this.getPanel().setViewportInitialized(true);
        if (!this.checkCircle()) {
            return;
        }
        this.execute(this.featureDrawingUtil.createAddCommand((Geometry)this.getCircle(), this.isRollingBackInvalidEdits(), this.getPanel(), this), true);
    }

    protected Polygon getCircle() throws NoninvertibleTransformException {
        double angle = 360.0;
        ArrayList points = new ArrayList(this.getCoordinates());
        if (this.getCoordinates().size() == 2) {
            Circle circle = new Circle((Coordinate)points.get(0), ((Coordinate)points.get(0)).distance((Coordinate)points.get(1)));
            return circle.getPoly();
        }
        Coordinate a = (Coordinate)points.get(0);
        Coordinate b = (Coordinate)points.get(1);
        Coordinate c = (Coordinate)points.get(2);
        return this.getCircle3points(a, b, c);
    }

    private Polygon getCircle3points(Coordinate a, Coordinate b, Coordinate c) {
        double A = b.x - a.x;
        double B = b.y - a.y;
        double C = c.x - a.x;
        double D = c.y - a.y;
        double E = A * (a.x + b.x) + B * (a.y + b.y);
        double F = C * (a.x + c.x) + D * (a.y + c.y);
        double G = 2.0 * (A * (c.y - b.y) - B * (c.x - b.x));
        if (G != 0.0) {
            double px = (D * E - B * F) / G;
            double py = (A * F - C * E) / G;
            Coordinate center = new Coordinate(px, py);
            double radius = Math.sqrt((a.x - px) * (a.x - px) + (a.y - py) * (a.y - py));
            Circle circle = new Circle(center, radius);
            return circle.getPoly();
        }
        Circle circle = new Circle(b, b.distance(c));
        return circle.getPoly();
    }

    protected boolean checkCircle() throws NoninvertibleTransformException {
        if (this.getCoordinates().size() < 2) {
            this.getPanel().getContext().warnUser(theCircleMustHaveAtLeast2Points);
            return false;
        }
        IsValidOp isValidOp = new IsValidOp((Geometry)this.getCircle());
        if (!isValidOp.isValid()) {
            this.getPanel().getContext().warnUser(isValidOp.getValidationError().getMessage());
            if (PersistentBlackboardPlugIn.get(this.getWorkbench().getContext()).get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false)) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected Shape getShape() throws NoninvertibleTransformException {
        if (this.coordinates.size() > 1) {
            GeneralPath shape = new GeneralPath();
            Coordinate a = (Coordinate)this.coordinates.get(0);
            Coordinate b = (Coordinate)this.coordinates.get(1);
            Coordinate c = this.tentativeCoordinate;
            Polygon polygon = this.getCircle3points(a, b, c);
            Coordinate[] polygonCoordinates = polygon.getCoordinates();
            Coordinate firstCoordinate = polygonCoordinates[0];
            Point2D firstPoint = this.getPanel().getViewport().toViewPoint(firstCoordinate);
            shape.moveTo((float)firstPoint.getX(), (float)firstPoint.getY());
            int n = polygonCoordinates.length;
            for (int i = 1; i < n; ++i) {
                Point2D nextPoint = this.getPanel().getViewport().toViewPoint(polygonCoordinates[i]);
                shape.lineTo((int)nextPoint.getX(), (int)nextPoint.getY());
            }
            return shape;
        }
        return super.getShape();
    }

    @Override
    public void mouseLocationChanged(MouseEvent e) {
        try {
            if (this.isShapeOnScreen()) {
                this.redrawShape();
            }
            super.mouseLocationChanged(e);
            if (this.getCoordinates().size() == 0) {
                // empty if block
            }
            if (this.getCoordinates().size() > 0) {
                ArrayList<Coordinate> currentCoordinates = new ArrayList<Coordinate>(this.getCoordinates());
                currentCoordinates.add(this.getPanel().getViewport().toModelCoordinate(e.getPoint()));
                this.display(currentCoordinates, this.getPanel());
            }
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    private void display(List<Coordinate> coordinates, LayerViewPanel panel) throws NoninvertibleTransformException {
        if (this.getCoordinates().size() > 0) {
            Polygon polygon;
            Coordinate b;
            Coordinate a;
            if (this.getCoordinates().size() == 1) {
                a = coordinates.get(0);
                b = this.tentativeCoordinate;
                Circle circle = new Circle(a, a.distance(b));
                polygon = circle.getPoly();
            } else {
                a = coordinates.get(0);
                b = coordinates.get(1);
                Coordinate c = this.tentativeCoordinate;
                polygon = this.getCircle3points(a, b, c);
            }
            DecimalFormat df3 = new DecimalFormat("###,###,##0.0##");
            double area = polygon.getArea();
            double radius = Math.sqrt(area / Math.PI);
            double circum = Math.PI * 2 * radius;
            this.getPanel().getContext().setStatusMessage("radius: " + df3.format(radius) + ";  " + lengthST + ": " + df3.format(circum) + ";  " + sArea + ": " + df3.format(polygon.getArea()));
        }
    }
}

