/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.cursortools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import com.vividsolutions.jump.workbench.ui.cursortool.CoordinateListMetrics;
import com.vividsolutions.jump.workbench.ui.cursortool.MultiClickTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.LinearComponentExtracter;
import org.locationtech.jts.operation.polygonize.Polygonizer;
import org.locationtech.jts.operation.union.UnaryUnionOp;
import org.locationtech.jts.operation.valid.IsValidOp;

public class CutFeaturesTool
extends MultiClickTool {
    public CutFeaturesTool(WorkbenchContext context) {
        super(context);
        this.setColor(Color.red);
        this.setStroke(new BasicStroke(1.5f, 2, 1, 10.0f, new float[]{10.0f, 5.0f}, 0.0f));
        this.allowSnapping();
        this.setMetricsDisplay(new CoordinateListMetrics());
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("splitPolygon.png");
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.tools.CutFeaturesTool");
    }

    @Override
    public Cursor getCursor() {
        return CutFeaturesTool.createCursor(IconLoader.icon("splitPolygonCursor.png").getImage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void gestureFinished() throws Exception {
        WorkbenchContext context = this.getWorkbench().getContext();
        this.reportNothingToUndoYet();
        SelectionManager selectionManager = context.getLayerViewPanel().getSelectionManager();
        for (Layer activeLayer : selectionManager.getLayersWithSelectedItems()) {
            if (activeLayer.isEditable()) continue;
            JOptionPane.showMessageDialog(null, I18N.getInstance().get("plugin.EnableCheckFactory.selected-items-layers-must-be-editable", 1), I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.Information"), 1);
            return;
        }
        for (Layer activeLayer : selectionManager.getLayersWithSelectedItems()) {
            activeLayer.getLayerManager().getUndoableEditReceiver().startReceiving();
            try {
                ArrayList<Feature> addedFeatures = new ArrayList<Feature>();
                ArrayList<Feature> removedFeatures = new ArrayList<Feature>();
                if (!activeLayer.isEditable()) continue;
                Collection<Feature> selectedFeatures = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(activeLayer);
                for (Feature featureSelected : selectedFeatures) {
                    Feature featureIntersect;
                    List<Geometry> div;
                    Geometry geomSelected = featureSelected.getGeometry();
                    LineString cuttingLine = this.getLineString();
                    if (geomSelected.isEmpty() || geomSelected.contains((Geometry)cuttingLine)) continue;
                    if (geomSelected.getClass().getSimpleName().equals("GeometryCollection")) {
                        context.getWorkbench().getFrame().warnUser(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.CutFeaturesTool.geometryCollection-cannot-be-processed"));
                        continue;
                    }
                    if (!cuttingLine.intersects(geomSelected)) continue;
                    if (geomSelected instanceof Polygon || geomSelected instanceof MultiPolygon) {
                        removedFeatures.add(featureSelected);
                        div = CutFeaturesTool.splitPolygon((Geometry)cuttingLine, geomSelected);
                        for (Geometry geom : div) {
                            featureIntersect = featureSelected.clone(true);
                            FeatureUtil.copyAttributes(featureSelected, featureIntersect);
                            featureIntersect.setGeometry(geom);
                            addedFeatures.add(featureIntersect);
                        }
                        continue;
                    }
                    if (!(geomSelected instanceof LineString) && !(geomSelected instanceof MultiLineString)) continue;
                    removedFeatures.add(featureSelected);
                    div = CutFeaturesTool.splitLines((Geometry)cuttingLine, geomSelected);
                    for (Geometry geom : div) {
                        featureIntersect = featureSelected.clone(true);
                        FeatureUtil.copyAttributes(featureSelected, featureIntersect);
                        featureIntersect.setGeometry(geom);
                        addedFeatures.add(featureIntersect);
                    }
                }
                context.getLayerViewPanel().getSelectionManager().unselectItems(activeLayer);
                UndoableCommand command = this.createCommand(activeLayer, removedFeatures, addedFeatures);
                command.execute();
                activeLayer.getLayerManager().getUndoableEditReceiver().receive(command.toUndoableEdit());
            }
            finally {
                activeLayer.getLayerManager().getUndoableEditReceiver().stopReceiving();
            }
        }
    }

    private UndoableCommand createCommand(final Layer layer, final Collection<Feature> removedFeatures, final Collection<Feature> addedFeatures) {
        return new UndoableCommand(this.getName()){

            @Override
            public void execute() {
                layer.getFeatureCollectionWrapper().removeAll(removedFeatures);
                layer.getFeatureCollectionWrapper().addAll(addedFeatures);
            }

            @Override
            public void unexecute() {
                layer.getFeatureCollectionWrapper().removeAll(addedFeatures);
                layer.getFeatureCollectionWrapper().addAll(removedFeatures);
            }
        };
    }

    protected boolean isRollingBackInvalidEdits(WorkbenchContext context) {
        return PersistentBlackboardPlugIn.get(context).get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false);
    }

    protected boolean checkLineString() throws NoninvertibleTransformException {
        if (this.getCoordinates().size() < 2) {
            this.getPanel().getContext().warnUser(I18N.getInstance().get("ui.cursortool.editing.DrawLineString.the-linestring-must-have-at-least-2-points"));
            return false;
        }
        IsValidOp isValidOp = new IsValidOp((Geometry)this.getLineString());
        if (!isValidOp.isValid()) {
            this.getPanel().getContext().warnUser(isValidOp.getValidationError().getMessage());
            if (PersistentBlackboardPlugIn.get(this.getWorkbench().getContext()).get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false)) {
                return false;
            }
        }
        return true;
    }

    private LineString getLineString() throws NoninvertibleTransformException {
        return new GeometryFactory().createLineString(this.toArray(this.getCoordinates()));
    }

    public static List<Geometry> splitPolygon(Geometry digitizedGeometry, Geometry geomSel) throws Exception {
        ArrayList linearNetwork = new ArrayList();
        linearNetwork.addAll(LinearComponentExtracter.getLines((Geometry)digitizedGeometry));
        linearNetwork.addAll(LinearComponentExtracter.getLines((Geometry)geomSel));
        Geometry nodedLinearNetwork = UnaryUnionOp.union(linearNetwork);
        Polygonizer polygonizer = new Polygonizer();
        polygonizer.add(nodedLinearNetwork);
        Collection polys = polygonizer.getPolygons();
        Envelope env = geomSel.getEnvelopeInternal();
        double maxAbsX = Math.max(Math.abs(env.getMaxX()), Math.abs(env.getMinX()));
        double maxAbsY = Math.max(Math.abs(env.getMaxY()), Math.abs(env.getMinY()));
        Geometry buffer = geomSel.buffer(Math.ulp(Math.max(maxAbsX, maxAbsY)) * 1000.0);
        Iterator it = polys.iterator();
        ArrayList<Geometry> result = new ArrayList<Geometry>();
        while (it.hasNext()) {
            Geometry geometry = (Geometry)it.next();
            if (!buffer.contains(geometry)) continue;
            result.add(geometry);
        }
        if (result.size() == 1) {
            result.clear();
            result.add(geomSel);
        }
        return result;
    }

    public static List<Geometry> splitLines(Geometry digitizedGeometry, Geometry geomSel) throws Exception {
        ArrayList linearNetwork = new ArrayList();
        linearNetwork.addAll(LinearComponentExtracter.getLines((Geometry)digitizedGeometry));
        linearNetwork.addAll(LinearComponentExtracter.getLines((Geometry)geomSel));
        Geometry nodedLinearNetwork = UnaryUnionOp.union(linearNetwork);
        Envelope env = geomSel.getEnvelopeInternal();
        double maxAbsX = Math.max(Math.abs(env.getMaxX()), Math.abs(env.getMinX()));
        double maxAbsY = Math.max(Math.abs(env.getMaxY()), Math.abs(env.getMinY()));
        Geometry buffer = geomSel.buffer(Math.ulp(Math.max(maxAbsX, maxAbsY)) * 1000.0);
        ArrayList<Geometry> result = new ArrayList<Geometry>();
        for (int i = 0; i < nodedLinearNetwork.getNumGeometries(); ++i) {
            Geometry geometry = nodedLinearNetwork.getGeometryN(i);
            if (!buffer.contains(geometry)) continue;
            result.add(geometry);
        }
        return result;
    }

    public Layer getSelectedLayer() {
        Collection<Layer> editableLayers = this.getPanel().getLayerManager().getEditableLayers();
        if (editableLayers.isEmpty()) {
            return null;
        }
        return editableLayers.iterator().next();
    }
}

