/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edit.helpclassesselection;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.PolygonTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import org.openjump.core.ui.plugin.edit.helpclassesselection.FenceDrawingUtil;

public class DrawFenceTool
extends PolygonTool {
    private FenceDrawingUtil myfDrawingUtil;

    protected DrawFenceTool(WorkbenchContext context, FenceDrawingUtil featureDrawingUtil) {
        super(context);
        this.myfDrawingUtil = featureDrawingUtil;
    }

    public static CursorTool create(WorkbenchContext context) {
        FenceDrawingUtil fDUtil = new FenceDrawingUtil(context);
        return fDUtil.prepare(new DrawFenceTool(context, fDUtil), false);
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("");
    }

    @Override
    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        if (!this.checkPolygon()) {
            return;
        }
        int count = 0;
        PlugInContext context = this.getWorkbenchContext().createPlugInContext();
        Layer[] selectedLayers = context.getLayerNamePanel().getSelectedLayers();
        for (int i = 0; i < selectedLayers.length; ++i) {
            Layer actualLayer = selectedLayers[i];
            FeatureCollection fc = context.getSelectedLayer(i).getFeatureCollectionWrapper().getWrappee();
            ArrayList<Feature> features = new ArrayList<Feature>();
            for (Feature element : fc) {
                if (this.getPolygon().disjoint(element.getGeometry())) continue;
                features.add(element);
                ++count;
            }
            context.getLayerViewPanel().getSelectionManager().getFeatureSelection().selectItems(actualLayer, features);
        }
        Collection<Feature> myf = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
        context.getWorkbenchFrame().setTimeMessage(I18N.getInstance().get("org.openjump.core.ui.plugin.edit.helpclassesselection.DrawFenceTool.layer-items") + ": " + count + ", " + I18N.getInstance().get("org.openjump.core.ui.plugin.edit.helpclassesselection.DrawFenceTool.selected-items") + ": " + myf.size());
        Enumeration<AbstractButton> buttons = context.getWorkbenchContext().getWorkbench().getFrame().getToolBar().getButtonGroup().getElements();
        AbstractButton myButton = buttons.nextElement();
        int j = 0;
        while (buttons.hasMoreElements()) {
            myButton = buttons.nextElement();
            if (++j != 1) continue;
            myButton.doClick();
        }
    }
}

