/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.datastore.postgis;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.datastore.SQLUtil;
import com.vividsolutions.jump.datastore.postgis.PostgisDSConnection;
import com.vividsolutions.jump.datastore.postgis.PostgisDataStoreDriver;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesDSConnection;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesDSMetadata;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.DataStoreQueryDataSource;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.swing.JOptionPane;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;

public class SaveToPostGISDataSource
extends DataStoreQueryDataSource {
    public static final String TABLE_KEY = "Table";
    public static final String SAVE_METHOD_KEY = "Save method";
    public static final String SAVE_METHOD_CREATE = "Create";
    public static final String SAVE_METHOD_REPLACE = "Replace";
    public static final String SAVE_METHOD_INSERT = "Insert";
    public static final String SAVE_METHOD_UPDATE = "Update";
    public static final String SAVE_METHOD_DELETE = "Delete";
    public static final String PRIMARY_KEY = "Primary Key";
    public static final String USE_DB_PRIMARY_KEY = "Use DB Primary Key";
    public static final String SRID_KEY = "SRID";
    private static final String DEFAULT_PK_NAME = "dbid";

    public SaveToPostGISDataSource() {
    }

    public SaveToPostGISDataSource(WorkbenchContext context) {
        super(context);
    }

    public SaveToPostGISDataSource(String tableName, String geometryColumnName, ConnectionDescriptor connectionDescriptor, WorkbenchContext context) {
        this.setProperties(CollectionUtil.createMap(new Object[]{TABLE_KEY, tableName, "Connection Descriptor", connectionDescriptor}));
        this.setWorkbenchContext(context);
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public com.vividsolutions.jump.io.datasource.Connection getConnection() {
        return new com.vividsolutions.jump.io.datasource.Connection(){

            @Override
            public FeatureCollection executeQuery(String query, Collection<Throwable> exceptions, TaskMonitor monitor) {
                try {
                    return SaveToPostGISDataSource.this.createFeatureCollection();
                }
                catch (Exception e) {
                    exceptions.add(e);
                    return null;
                }
            }

            @Override
            public FeatureCollection executeQuery(String query, TaskMonitor monitor) throws Exception {
                ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
                FeatureCollection featureCollection = this.executeQuery(query, exceptions, monitor);
                if (!exceptions.isEmpty()) {
                    throw (Exception)exceptions.iterator().next();
                }
                return featureCollection;
            }

            @Override
            public void executeUpdate(String query, FeatureCollection featureCollection, TaskMonitor monitor) throws Exception {
                String method = (String)SaveToPostGISDataSource.this.getProperties().get(SaveToPostGISDataSource.SAVE_METHOD_KEY);
                ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)SaveToPostGISDataSource.this.getProperties().get("Connection Descriptor");
                String table = (String)SaveToPostGISDataSource.this.getProperties().get(SaveToPostGISDataSource.TABLE_KEY);
                String[] dbSchemaTable = SQLUtil.splitTableName(table);
                String schemaName = SQLUtil.unquote(dbSchemaTable[0]);
                String tableName = SQLUtil.unquote(dbSchemaTable[1]);
                boolean normalizedColumnNames = false;
                String primary_key = (String)SaveToPostGISDataSource.this.getProperties().get(SaveToPostGISDataSource.PRIMARY_KEY);
                boolean createPrimaryKey = (Boolean)SaveToPostGISDataSource.this.getProperties().get(SaveToPostGISDataSource.USE_DB_PRIMARY_KEY);
                int srid = SaveToPostGISDataSource.this.getProperties().get(SaveToPostGISDataSource.SRID_KEY) == null ? -1 : (Integer)SaveToPostGISDataSource.this.getProperties().get(SaveToPostGISDataSource.SRID_KEY);
                int dim = SaveToPostGISDataSource.getGeometryDimension(featureCollection, 3);
                PostgisDSConnection conn = (PostgisDSConnection)new PostgisDataStoreDriver().createConnection(connectionDescriptor.getParameterList());
                Connection jdbcConn = conn.getJdbcConnection();
                String geomName = featureCollection.getFeatureSchema().getAttributeName(featureCollection.getFeatureSchema().getGeometryIndex());
                if (normalizedColumnNames) {
                    geomName = geomName.toLowerCase();
                }
                if (!method.equals(SaveToPostGISDataSource.SAVE_METHOD_CREATE)) {
                    dim = conn.getMetadata().getCoordinateDimension(table, geomName);
                }
                if (method.equals(SaveToPostGISDataSource.SAVE_METHOD_CREATE)) {
                    boolean exists = SaveToPostGISDataSource.this.tableExists(conn, schemaName, tableName);
                    if (exists && !SaveToPostGISDataSource.this.confirmOverwrite()) {
                        return;
                    }
                    jdbcConn.setAutoCommit(false);
                    if (exists) {
                        SaveToPostGISDataSource.this.deleteTableQuery(conn, schemaName, tableName);
                    }
                    SaveToPostGISDataSource.this.createAndPopulateTable(conn, featureCollection, schemaName, tableName, srid, "geometry", dim, normalizedColumnNames);
                    if (createPrimaryKey) {
                        SaveToPostGISDataSource.this.addDBPrimaryKey(conn, schemaName, tableName, SaveToPostGISDataSource.DEFAULT_PK_NAME);
                    }
                    jdbcConn.commit();
                    jdbcConn.setAutoCommit(true);
                    if (createPrimaryKey) {
                        SaveToPostGISDataSource.this.reloadDataFromDataStore(this, connectionDescriptor, schemaName, tableName, SaveToPostGISDataSource.DEFAULT_PK_NAME, monitor);
                    }
                    jdbcConn.createStatement().execute("VACUUM ANALYZE " + SQLUtil.compose(schemaName, tableName));
                }
                if (method.equals(SaveToPostGISDataSource.SAVE_METHOD_REPLACE)) {
                    jdbcConn.setAutoCommit(false);
                    FeatureSchema featureSchema = featureCollection.getFeatureSchema();
                    if (conn.getCompatibleSchemaSubset(schemaName, tableName, featureSchema, normalizedColumnNames).length < featureSchema.getAttributeCount() && !SaveToPostGISDataSource.this.confirmWriteDespiteDifferentSchemas()) {
                        return;
                    }
                    SaveToPostGISDataSource.this.truncateTable(conn, schemaName, tableName);
                    SaveToPostGISDataSource.this.insertInTable(conn, featureCollection, schemaName, tableName, primary_key, srid, dim, normalizedColumnNames);
                    jdbcConn.commit();
                    jdbcConn.setAutoCommit(true);
                    if (featureSchema.getExternalPrimaryKeyIndex() > -1) {
                        SaveToPostGISDataSource.this.reloadDataFromDataStore(this, connectionDescriptor, schemaName, tableName, primary_key, monitor);
                    }
                }
                if (method.equals(SaveToPostGISDataSource.SAVE_METHOD_INSERT)) {
                    jdbcConn.setAutoCommit(false);
                    FeatureSchema featureSchema = featureCollection.getFeatureSchema();
                    if (primary_key != null) {
                        featureSchema.setExternalPrimaryKeyIndex(featureSchema.getAttributeIndex(primary_key));
                    }
                    if (conn.getCompatibleSchemaSubset(schemaName, tableName, featureSchema, normalizedColumnNames).length < featureSchema.getAttributeCount() && !SaveToPostGISDataSource.this.confirmWriteDespiteDifferentSchemas()) {
                        return;
                    }
                    SaveToPostGISDataSource.this.insertInTable(conn, featureCollection, schemaName, tableName, primary_key, srid, dim, normalizedColumnNames);
                    jdbcConn.commit();
                    jdbcConn.setAutoCommit(true);
                    if (featureSchema.getExternalPrimaryKeyIndex() > -1) {
                        SaveToPostGISDataSource.this.reloadDataFromDataStore(this, connectionDescriptor, schemaName, tableName, primary_key, monitor);
                    }
                }
                if (method.equals(SaveToPostGISDataSource.SAVE_METHOD_UPDATE)) {
                    jdbcConn.setAutoCommit(false);
                    FeatureSchema featureSchema = featureCollection.getFeatureSchema();
                    if (primary_key != null) {
                        featureSchema.setExternalPrimaryKeyIndex(featureSchema.getAttributeIndex(primary_key));
                    }
                    if (conn.getCompatibleSchemaSubset(schemaName, tableName, featureSchema, normalizedColumnNames).length < featureSchema.getAttributeCount() && !SaveToPostGISDataSource.this.confirmWriteDespiteDifferentSchemas()) {
                        return;
                    }
                    SaveToPostGISDataSource.this.insertUpdateTable(conn, featureCollection, schemaName, tableName, primary_key, srid, dim, normalizedColumnNames);
                    jdbcConn.commit();
                    jdbcConn.setAutoCommit(true);
                    if (featureSchema.getExternalPrimaryKeyIndex() > -1) {
                        SaveToPostGISDataSource.this.reloadDataFromDataStore(this, connectionDescriptor, schemaName, tableName, primary_key, monitor);
                    }
                }
                if (method.equals(SaveToPostGISDataSource.SAVE_METHOD_DELETE)) {
                    jdbcConn.setAutoCommit(false);
                    FeatureSchema featureSchema = featureCollection.getFeatureSchema();
                    if (conn.getCompatibleSchemaSubset(schemaName, tableName, featureSchema, normalizedColumnNames).length < featureSchema.getAttributeCount() && !SaveToPostGISDataSource.this.confirmWriteDespiteDifferentSchemas()) {
                        return;
                    }
                    SaveToPostGISDataSource.this.deleteNotExistingFeaturesFromTable(conn, featureCollection, schemaName, tableName, primary_key);
                    SaveToPostGISDataSource.this.insertUpdateTable(conn, featureCollection, schemaName, tableName, primary_key, srid, dim, normalizedColumnNames);
                    jdbcConn.commit();
                }
            }

            @Override
            public void close() {
            }
        };
    }

    private boolean confirmOverwrite() {
        int opt = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getWorkbench().getFrame(), I18N.getInstance().get("org.openjump.core.ui.plugin.datastore.postgis.SaveToPostGISDataSource.overwrite-dialog-message"), I18N.getInstance().get("org.openjump.core.ui.plugin.datastore.postgis.SaveToPostGISDataSource.overwrite-dialog-title"), 0);
        return opt != 1;
    }

    private boolean confirmWriteDespiteDifferentSchemas() {
        int opt = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getWorkbench().getFrame(), I18N.getInstance().get("org.openjump.core.ui.plugin.datastore.postgis.SaveToPostGISDataSource.schema-mismatch-dialog-message"), I18N.getInstance().get("org.openjump.core.ui.plugin.datastore.postgis.SaveToPostGISDataSource.schema-mismatch-dialog-title"), 0);
        return opt != 1;
    }

    private boolean tableExists(SpatialDatabasesDSConnection conn, String dbSchema, String dbTable) throws SQLException {
        DatabaseMetaData metadata = conn.getJdbcConnection().getMetaData();
        return metadata.getTables(null, dbSchema, dbTable, new String[]{"TABLE"}).next();
    }

    private void deleteTableQuery(SpatialDatabasesDSConnection conn, String schemaName, String tableName) throws SQLException {
        try {
            if (schemaName == null) {
                conn.getJdbcConnection().createStatement().execute("SELECT DropGeometryTable( '" + tableName + "' );");
            } else {
                conn.getJdbcConnection().createStatement().execute("SELECT DropGeometryTable( '" + schemaName + "' , '" + tableName + "' );");
            }
        }
        catch (SQLException e) {
            conn.getJdbcConnection().createStatement().execute("DROP TABLE " + SQLUtil.compose(schemaName, tableName) + ";");
        }
    }

    private void truncateTable(SpatialDatabasesDSConnection conn, String schemaName, String tableName) throws SQLException {
        String tableQName = SQLUtil.compose(schemaName, tableName);
        try {
            conn.getJdbcConnection().createStatement().execute("TRUNCATE TABLE " + tableQName);
        }
        catch (SQLException sqle) {
            throw new SQLException("Error executing query: TRUNCATE TABLE " + tableQName, sqle);
        }
    }

    private void createAndPopulateTable(SpatialDatabasesDSConnection conn, FeatureCollection fc, String schemaName, String tableName, int srid, String geometryType, int dim, boolean normalizeColumnNames) throws Exception {
        FeatureSchema schema = fc.getFeatureSchema();
        String geometryColumn = schema.getAttributeName(schema.getGeometryIndex());
        SpatialDatabasesDSMetadata metadata = conn.getMetadata();
        try {
            conn.getJdbcConnection().createStatement().execute(conn.getMetadata().getCreateTableStatement(fc.getFeatureSchema(), schemaName, tableName, false));
        }
        catch (SQLException sqle) {
            throw new SQLException("Error executing query: " + metadata.getCreateTableStatement(fc.getFeatureSchema(), schemaName, tableName, false), sqle);
        }
        try {
            conn.getJdbcConnection().createStatement().execute(metadata.getAddGeometryColumnStatement(schemaName, tableName, geometryColumn, srid, geometryType, dim));
        }
        catch (SQLException sqle) {
            throw new SQLException("Error executing query: " + metadata.getAddGeometryColumnStatement(schemaName, tableName, geometryColumn, srid, geometryType, dim), sqle);
        }
        this.populateTable(conn, fc, schemaName, tableName, null, srid, dim, normalizeColumnNames);
        try {
            conn.getJdbcConnection().createStatement().execute(metadata.getAddSpatialIndexStatement(schemaName, tableName, geometryColumn));
        }
        catch (SQLException sqle) {
            throw new SQLException("Error executing query: " + metadata.getAddSpatialIndexStatement(schemaName, tableName, geometryColumn), sqle);
        }
    }

    private void addDBPrimaryKey(SpatialDatabasesDSConnection conn, String dbSchema, String dbTable, String primaryKey) throws SQLException {
        boolean sequence_already_exists;
        String sql_create_dbid;
        String sql_create_seq;
        String sql_test_seq;
        String tableFullName = SQLUtil.compose(dbSchema, dbTable);
        if (dbSchema == null) {
            sql_test_seq = "SELECT * FROM information_schema.sequences\n    WHERE sequence_name = 'openjump_dbid_sequence';";
            sql_create_seq = "CREATE SEQUENCE openjump_dbid_sequence;";
            sql_create_dbid = "ALTER TABLE " + tableFullName + " ADD COLUMN \"" + primaryKey + "\" BIGINT DEFAULT nextval('openjump_dbid_sequence') PRIMARY KEY;";
        } else {
            sql_test_seq = "SELECT * FROM information_schema.sequences\n    WHERE sequence_schema = '" + dbSchema + "' AND sequence_name = 'openjump_dbid_sequence';";
            sql_create_seq = "CREATE SEQUENCE \"" + dbSchema + "\".openjump_dbid_sequence;";
            sql_create_dbid = "ALTER TABLE " + tableFullName + " ADD COLUMN \"" + primaryKey + "\" BIGINT DEFAULT nextval('\"" + dbSchema + "\".openjump_dbid_sequence') PRIMARY KEY;";
        }
        try {
            sequence_already_exists = conn.getJdbcConnection().createStatement().executeQuery(sql_test_seq).next();
        }
        catch (SQLException sqle) {
            throw new SQLException("Error executing query: " + sql_test_seq, sqle);
        }
        if (!sequence_already_exists) {
            try {
                conn.getJdbcConnection().createStatement().execute(sql_create_seq);
            }
            catch (SQLException sqle) {
                throw new SQLException(sql_create_seq, sqle);
            }
        }
        try {
            conn.getJdbcConnection().createStatement().execute(sql_create_dbid);
        }
        catch (SQLException sqle) {
            throw new SQLException(sql_create_dbid, sqle);
        }
    }

    private void populateTable(SpatialDatabasesDSConnection conn, FeatureCollection fc, String dbSchema, String dbTable, String primaryKey, int srid, int dim, boolean normalizedColumnNames) throws SQLException {
        PreparedStatement statement = this.insertStatement(conn, fc.getFeatureSchema(), dbSchema, dbTable, primaryKey, srid, dim, normalizedColumnNames);
        int count = 0;
        for (Feature f : fc) {
            statement = this.setAttributeValues(statement, f, primaryKey, srid, dim);
            statement.addBatch();
            if (count++ % 10000 != 0) continue;
            statement.executeBatch();
            statement.clearBatch();
        }
        statement.executeBatch();
        statement.clearBatch();
    }

    private void insertInTable(SpatialDatabasesDSConnection conn, FeatureCollection fc, String schemaName, String tableName, String primaryKey, int srid, int dim, boolean normalizeColumnNames) throws SQLException {
        PreparedStatement statement = this.insertStatement(conn, fc.getFeatureSchema(), schemaName, tableName, primaryKey, srid, dim, normalizeColumnNames);
        int count = 0;
        for (Feature f : fc) {
            statement = this.setAttributeValues(statement, f, primaryKey, srid, dim);
            statement.addBatch();
            if (count++ % 10000 != 0) continue;
            statement.executeBatch();
            statement.clearBatch();
        }
        statement.executeBatch();
        statement.clearBatch();
    }

    private void insertUpdateTable(SpatialDatabasesDSConnection conn, FeatureCollection fc, String dbSchema, String dbTable, String primaryKey, int srid, int dim, boolean normalizedColumnNames) throws Exception {
        PreparedStatement statementI = this.insertStatement(conn, fc.getFeatureSchema(), dbSchema, dbTable, primaryKey, srid, dim, normalizedColumnNames);
        PreparedStatement statementU = this.updateStatement(conn, fc.getFeatureSchema(), dbSchema, dbTable, primaryKey, srid, dim, normalizedColumnNames);
        int countInsert = 0;
        int countUpdate = 0;
        String tableQName = SQLUtil.compose(dbSchema, dbTable);
        for (Feature f : fc) {
            int count;
            Object fid = f.getAttribute(primaryKey);
            String sFid = fid instanceof String ? "'" + fid + "'" : "" + fid;
            ResultSet rs = conn.getJdbcConnection().createStatement().executeQuery("SELECT count(*) AS count FROM " + tableQName + " WHERE \"" + primaryKey + "\" = " + sFid);
            int n = count = rs.next() ? rs.getInt("count") : 0;
            if (count == 0) {
                this.setAttributeValues(statementI, f, primaryKey, srid, dim);
                statementI.addBatch();
                if (countInsert++ % 10000 != 0) continue;
                statementI.executeBatch();
                statementI.clearBatch();
                continue;
            }
            this.setAttributeValues(statementU, f, primaryKey, srid, dim);
            this.setPrimaryKeyValue(statementU, f, primaryKey);
            statementU.addBatch();
            if (countUpdate++ % 10000 != 0) continue;
            statementU.executeBatch();
            statementU.clearBatch();
        }
        statementI.executeBatch();
        statementI.clearBatch();
        statementU.executeBatch();
        statementU.clearBatch();
    }

    private void deleteNotExistingFeaturesFromTable(SpatialDatabasesDSConnection conn, FeatureCollection fc, String schemaName, String tableName, String primaryKey) throws SQLException {
        StringBuilder sb = new StringBuilder();
        boolean numeric = false;
        if (fc.getFeatureSchema().getAttributeType(primaryKey) == AttributeType.INTEGER) {
            numeric = true;
        }
        if (fc.getFeatureSchema().getAttributeType(primaryKey) == AttributeType.LONG) {
            numeric = true;
        } else if (fc.getFeatureSchema().getAttributeType(primaryKey) == AttributeType.OBJECT && fc.size() > 0) {
            for (Feature f : fc.getFeatures()) {
                Object o = f.getAttribute(primaryKey);
                if (o == null || !(o instanceof Integer) && !(o instanceof Long) && !(o instanceof BigInteger)) continue;
                numeric = true;
                break;
            }
        }
        boolean first = true;
        Iterator<Feature> it = fc.iterator();
        while (it.hasNext()) {
            Object pk = it.next().getAttribute(primaryKey);
            if (pk == null) continue;
            if (!first) {
                sb.append(",");
            }
            if (numeric) {
                sb.append(pk);
            } else {
                sb.append("'").append(pk).append("'");
            }
            first = false;
        }
        try {
            conn.getJdbcConnection().createStatement().execute("DELETE FROM " + SQLUtil.compose(schemaName, tableName) + " WHERE \"" + primaryKey + "\" not in (" + sb.toString() + ")");
        }
        catch (SQLException sqle) {
            throw new SQLException("Error executing query: DELETE FROM " + SQLUtil.compose(schemaName, tableName) + " WHERE \"" + primaryKey + "\" not in (" + sb.toString() + ")", sqle);
        }
    }

    private PreparedStatement insertStatement(SpatialDatabasesDSConnection conn, FeatureSchema schema, String schemaName, String tableName, String primaryKey, int srid, int dim, boolean normalizedColumnNames) throws SQLException {
        SpatialDatabasesDSMetadata metadata = conn.getMetadata();
        String tableQName = SQLUtil.compose(schemaName, tableName);
        StringBuilder sb = new StringBuilder("INSERT INTO " + tableQName + "(");
        sb.append(metadata.createColumnList(schema, false, true, false, false, normalizedColumnNames)).append(") VALUES(");
        boolean first = true;
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            if (schema.getExternalPrimaryKeyIndex() == i || schema.isAttributeReadOnly(i)) continue;
            sb.append(first ? "?" : ",?");
            first = false;
        }
        sb.append(")");
        return conn.getJdbcConnection().prepareStatement(sb.toString());
    }

    private PreparedStatement updateStatement(SpatialDatabasesDSConnection conn, FeatureSchema schema, String dbSchema, String dbTable, String primaryKey, int srid, int dim, boolean normalizedColumnNames) throws SQLException {
        String tableQName = SQLUtil.compose(dbSchema, dbTable);
        StringBuilder sb = new StringBuilder("UPDATE " + tableQName + " SET (");
        sb.append(conn.getMetadata().createColumnList(schema, false, true, false, false, normalizedColumnNames)).append(") = ROW(");
        boolean first = true;
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            if (schema.getExternalPrimaryKeyIndex() == i) continue;
            sb.append(first ? "?" : ",?");
            first = false;
        }
        sb.append(") WHERE \"").append(primaryKey).append("\" = ? ;");
        return conn.getJdbcConnection().prepareStatement(sb.toString());
    }

    private PreparedStatement setAttributeValues(PreparedStatement pstmt, Feature feature, String primaryKey, int srid, int dim) throws SQLException {
        FeatureSchema schema = feature.getSchema();
        int shift = 1;
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            if (schema.getExternalPrimaryKeyIndex() == i || schema.isAttributeReadOnly(i)) {
                --shift;
                continue;
            }
            AttributeType type = schema.getAttributeType(i);
            if (feature.getAttribute(i) == null) {
                pstmt.setObject(i + shift, null);
                continue;
            }
            if (type == AttributeType.STRING) {
                pstmt.setString(i + shift, feature.getString(i));
                continue;
            }
            if (type == AttributeType.GEOMETRY) {
                pstmt.setBytes(i + shift, SQLUtil.getByteArrayFromGeometry((Geometry)feature.getAttribute(i), srid, dim));
                continue;
            }
            if (type == AttributeType.INTEGER) {
                pstmt.setInt(i + shift, feature.getInteger(i));
                continue;
            }
            if (type == AttributeType.LONG) {
                pstmt.setLong(i + shift, (Long)feature.getAttribute(i));
                continue;
            }
            if (type == AttributeType.DOUBLE) {
                pstmt.setDouble(i + shift, feature.getDouble(i));
                continue;
            }
            if (type == AttributeType.BOOLEAN) {
                pstmt.setBoolean(i + shift, (Boolean)feature.getAttribute(i));
                continue;
            }
            if (type == AttributeType.DATE) {
                pstmt.setTimestamp(i + shift, new Timestamp(((Date)feature.getAttribute(i)).getTime()));
                continue;
            }
            if (type == AttributeType.OBJECT) {
                pstmt.setBytes(i + shift, feature.getAttribute(i).toString().getBytes(StandardCharsets.UTF_8));
                continue;
            }
            throw new IllegalArgumentException("" + type + " is an unknown AttributeType !");
        }
        return pstmt;
    }

    private PreparedStatement setPrimaryKeyValue(PreparedStatement pstmt, Feature feature, String primaryKey) throws SQLException {
        try {
            pstmt.setObject(pstmt.getParameterMetaData().getParameterCount(), feature.getAttribute(primaryKey));
            return pstmt;
        }
        catch (SQLException e) {
            throw new SQLException("Erreur dans le PreparedStatement\n" + pstmt + "(setObject(?," + feature.getAttribute(primaryKey) + ")\n" + e.getMessage());
        }
    }

    private void reloadDataFromDataStore(com.vividsolutions.jump.io.datasource.Connection conn, ConnectionDescriptor connectionDescriptor, String schemaName, String tableName, String dbid, TaskMonitor monitor) throws Exception {
        String tableQName = SQLUtil.compose(schemaName, tableName);
        this.setProperties(CollectionUtil.createMap(new Object[]{TABLE_KEY, tableQName, PRIMARY_KEY, dbid, "SQL Query", "SELECT * FROM " + tableQName, "Connection Descriptor", connectionDescriptor}));
        Layer[] selectedLayers = JUMPWorkbench.getInstance().getContext().getLayerNamePanel().getSelectedLayers();
        if (selectedLayers != null && selectedLayers.length == 1) {
            selectedLayers[0].setFeatureCollection(conn.executeQuery(null, monitor));
            selectedLayers[0].getFeatureCollectionWrapper().getFeatureSchema().setExternalPrimaryKeyIndex(selectedLayers[0].getFeatureCollectionWrapper().getFeatureSchema().getAttributeIndex(dbid));
        }
    }

    public static int getGeometryDimension(FeatureCollection coll, int defaultDim) {
        if (coll.size() > 0) {
            int step = 1 + coll.size() / 1000;
            int count = 0;
            Iterator<Feature> it = coll.iterator();
            while (it.hasNext()) {
                if (count % step == 0 && SaveToPostGISDataSource.getGeometryDimension(it.next().getGeometry()) == 3) {
                    return 3;
                }
                ++count;
            }
            return 2;
        }
        return defaultDim;
    }

    private static int getGeometryDimension(Geometry g) {
        Coordinate[] cc;
        for (Coordinate c : cc = g.getCoordinates()) {
            if (Double.isNaN(c.z)) continue;
            return 3;
        }
        return 2;
    }
}

