/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.datastore.h2;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.datastore.SQLUtil;
import com.vividsolutions.jump.datastore.h2.H2DataStoreDriver;
import com.vividsolutions.jump.datastore.h2.H2ServerDataStoreDriver;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.datasource.DataSourceQueryChooser;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openjump.core.ccordsys.srid.SRIDStyle;
import org.openjump.core.ui.plugin.datastore.SaveToDataStoreDataSourceQuery;
import org.openjump.core.ui.plugin.datastore.WritableDataStoreDataSource;
import org.openjump.core.ui.plugin.datastore.h2.H2DataStoreDataSource;
import org.openjump.core.ui.plugin.datastore.h2.H2SaveDriverPanel;

public class H2SaveDataSourceQueryChooser
implements DataSourceQueryChooser {
    public static final String KEY = H2SaveDataSourceQueryChooser.class.getName();
    static final String ERROR = I18N.getInstance().get(KEY + ".error");
    static final String NO_CONNECTION_CHOOSEN = I18N.getInstance().get(KEY + ".no-connection-choosen");
    static final String NO_TABLE_CHOOSEN = I18N.getInstance().get(KEY + ".no-table-choosen");
    static final String CONNECTION_IS_NOT_H2 = I18N.getInstance().get(KEY + ".selected-connection-is-not-h2");
    static final String GID_ALREADY_EXISTS = I18N.getInstance().get(KEY + ".gid-already-exists");
    private PlugInContext context;
    private H2SaveDriverPanel panel;
    private WritableDataStoreDataSource dataSource;
    private Map<String, Object> properties;

    public H2SaveDataSourceQueryChooser(WritableDataStoreDataSource dataSource, PlugInContext context) {
        this.dataSource = dataSource;
        this.context = context;
        this.panel = new H2SaveDriverPanel(context);
        this.properties = new HashMap<String, Object>();
    }

    @Override
    public Component getComponent() {
        return this.panel;
    }

    public Collection getDataSourceQueries() {
        String updateQuery = (String)this.properties.get("Dataset Name");
        SaveToDataStoreDataSourceQuery query = new SaveToDataStoreDataSourceQuery(new H2DataStoreDataSource(this.context.getWorkbenchContext()), updateQuery, (String)this.properties.get("Dataset Name"));
        query.setProperties(this.getProperties());
        ((WritableDataStoreDataSource)query.getDataSource()).setTableAlreadyCreated(false);
        query.getDataSource().getProperties().put("Normalized Column Names", this.panel.isNormalizedColumnNames());
        ArrayList<SaveToDataStoreDataSourceQuery> queries = new ArrayList<SaveToDataStoreDataSourceQuery>();
        queries.add(query);
        return queries;
    }

    @Override
    public boolean isInputValid() {
        FeatureSchema schema;
        if (this.panel.getConnectionDescriptor() == null) {
            JOptionPane.showMessageDialog(this.panel, NO_CONNECTION_CHOOSEN, ERROR, 0);
            return false;
        }
        if (!this.panel.getConnectionDescriptor().getDataStoreDriverClassName().equals(H2DataStoreDriver.class.getName()) && !this.panel.getConnectionDescriptor().getDataStoreDriverClassName().equals(H2ServerDataStoreDriver.class.getName())) {
            JOptionPane.showMessageDialog(null, CONNECTION_IS_NOT_H2, ERROR, 0);
            return false;
        }
        if (this.panel.getTableName() == null || this.panel.getTableName().trim().length() == 0) {
            JOptionPane.showMessageDialog(this.panel, NO_TABLE_CHOOSEN, ERROR, 0);
            return false;
        }
        Layer[] layers = this.context.getWorkbenchContext().getLayerNamePanel().getSelectedLayers();
        if (layers.length == 1 && (schema = layers[0].getFeatureCollectionWrapper().getFeatureSchema()).hasAttribute("gid") && this.panel.isCreatePrimaryKeyColumnSelected()) {
            JOptionPane.showMessageDialog(this.panel, GID_ALREADY_EXISTS, ERROR, 0);
            return false;
        }
        this.properties.put("Dataset Name", this.panel.getTableName());
        this.properties.put("Create PK", this.panel.isCreatePrimaryKeyColumnSelected());
        return true;
    }

    protected Map getProperties() {
        Layer[] layers;
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put("Connection Descriptor", this.panel.getConnectionDescriptor());
        this.properties.put("Dataset Name", this.panel.getTableName());
        this.properties.put("Create PK", this.panel.isCreatePrimaryKeyColumnSelected());
        this.properties.put("Dimension", this.panel.writeCreate3dGeometriesSelected() ? 3 : 2);
        this.properties.put("NaN Z to value", this.panel.nanZToValue());
        if (this.panel.isCreatePrimaryKeyColumnSelected()) {
            this.properties.put("External PK", "gid");
        }
        if ((layers = this.context.getWorkbenchContext().getLayerNamePanel().getSelectedLayers()).length == 1) {
            FeatureSchema schema = layers[0].getFeatureCollectionWrapper().getFeatureSchema();
            this.properties.put("Geometry Attribute Name", this.panel.isNormalizedColumnNames() ? SQLUtil.normalize(schema.getAttributeName(schema.getGeometryIndex())) : schema.getAttributeName(schema.getGeometryIndex()));
            SRIDStyle sridStyle = (SRIDStyle)layers[0].getStyle(SRIDStyle.class);
            this.properties.put("SRID", sridStyle.getSRID());
            this.properties.put("Normalized Column Names", this.panel.isNormalizedColumnNames());
        }
        this.properties.put("Limited To View", false);
        this.properties.put("Max Features", Integer.MAX_VALUE);
        this.properties.put("Where Clause", "");
        this.properties.put("Manage conflicts", true);
        return this.properties;
    }

    protected WritableDataStoreDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public String toString() {
        return I18N.getInstance().get(KEY + ".H2-Table");
    }
}

