/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.datastore;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.wizard.AbstractWizardPanel;
import com.vividsolutions.jump.workbench.ui.wizard.CancelNextException;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openjump.core.ui.plugin.datastore.DataStoreSaveDriverPanel;

public class SaveToDataStorePanel
extends AbstractWizardPanel {
    public static final String KEY = SaveToDataStorePanel.class.getName();
    private static final String TITLE = I18N.getInstance().get(KEY);
    private static final String INSTRUCTIONS = I18N.getInstance().get(KEY + ".instructions");
    private static final String LASTCONNECTION = SaveToDataStorePanel.class.getName() + " - LAST CONNECTION";
    private WorkbenchContext workbenchContext;
    private DataStoreSaveDriverPanel dataStoreSaveDriverPanel;

    public SaveToDataStorePanel(WorkbenchContext workbenchContext) {
        super(KEY, TITLE, INSTRUCTIONS);
        this.workbenchContext = workbenchContext;
        this.setLayout(new BorderLayout());
        this.dataStoreSaveDriverPanel = new DataStoreSaveDriverPanel(workbenchContext.createPlugInContext());
        this.add(this.dataStoreSaveDriverPanel);
        this.dataStoreSaveDriverPanel.connectionPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaveToDataStorePanel.this.updateWizardDialog();
            }
        });
        this.dataStoreSaveDriverPanel.tableComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SaveToDataStorePanel.this.updateWizardDialog();
            }
        });
        ((JTextComponent)this.dataStoreSaveDriverPanel.tableComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SaveToDataStorePanel.this.updateWizardDialog();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SaveToDataStorePanel.this.updateWizardDialog();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SaveToDataStorePanel.this.updateWizardDialog();
            }
        });
    }

    private void updateWizardDialog() {
        Container c = this.dataStoreSaveDriverPanel;
        while ((c = c.getParent()) != null) {
            if (!(c instanceof WizardPanel)) continue;
            ((SaveToDataStorePanel)c).selectionChanged();
            break;
        }
    }

    public void selectionChanged() {
        this.fireInputChanged();
    }

    @Override
    public boolean isInputValid() {
        String errorMessage = this.dataStoreSaveDriverPanel.getValidationError();
        if (this.dataStoreSaveDriverPanel.tableComboBox.getEditor().getItem().toString().trim().equals("")) {
            errorMessage = I18N.getInstance().get("org.openjump.core.ui.plugin.datastore.postgis.PostGISSaveDataSourceQueryChooser.no-table-choosen");
        }
        return null == errorMessage;
    }

    @Override
    public void enteredFromLeft(Map dataMap) {
        super.enteredFromLeft(dataMap);
        Blackboard blackboard = PersistentBlackboardPlugIn.get(this.workbenchContext);
        Object connectionDescriptor = blackboard.get(LASTCONNECTION);
        if (connectionDescriptor != null) {
            this.dataStoreSaveDriverPanel.setConnectionDescriptor((ConnectionDescriptor)connectionDescriptor);
        }
        this.dataStoreSaveDriverPanel.getTableName();
        dataMap.put("Connection Descriptor", this.dataStoreSaveDriverPanel.getConnectionDescriptor());
    }

    @Override
    public void exitingToRight() throws Exception {
        if (!this.dataStoreSaveDriverPanel.isInputValid()) {
            throw new CancelNextException();
        }
        Blackboard blackboard = PersistentBlackboardPlugIn.get(this.workbenchContext);
        this.getData().put("Connection Descriptor", this.dataStoreSaveDriverPanel.getConnectionDescriptor());
        this.getData().put("Dataset Name", this.dataStoreSaveDriverPanel.getTableName());
        this.getData().put("Dimension", this.dataStoreSaveDriverPanel.writeCreate3dGeometriesSelected() ? 3 : 2);
        this.getData().put("NaN Z to value", this.dataStoreSaveDriverPanel.nanZToValue());
        this.getData().put("Narrow geometry type", this.dataStoreSaveDriverPanel.isNarrowGeometryType());
        this.getData().put("Convert to multigeometry", this.dataStoreSaveDriverPanel.isConvertToMultiGeometry());
        this.getData().put("Create PK", this.dataStoreSaveDriverPanel.isCreatePrimaryKeyColumnSelected());
        this.getData().put("Normalized Column Names", this.dataStoreSaveDriverPanel.isNormalizedColumnNames());
        blackboard.put(LASTCONNECTION, this.dataStoreSaveDriverPanel.getConnectionDescriptor());
    }
}

