/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.datastore;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.coordsys.CoordinateSystemRegistry;
import com.vividsolutions.jump.datastore.DataStoreLayer;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDSLayer;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.datasource.Connection;
import com.vividsolutions.jump.io.datasource.DataSource;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.AddNewLayerPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.AddDatastoreLayerPanel;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.DataStoreDataSource;
import com.vividsolutions.jump.workbench.ui.wizard.WizardDialog;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import org.openjump.core.ccordsys.srid.SRIDStyle;
import org.openjump.core.ui.plugin.datastore.AddDataStoreLayerWizardPanel;
import org.openjump.core.ui.plugin.file.open.ChooseProjectPanel;
import org.openjump.core.ui.swing.wizard.AbstractWizardGroup;

public class AddDataStoreLayerWizard
extends AbstractWizardGroup {
    private static final String KEY = AddDataStoreLayerWizard.class.getName();
    private final AddDataStoreLayerWizardPanel dataStoreWizardPanel;
    private final WorkbenchContext workbenchContext;
    private final ChooseProjectPanel chooseProjectPanel;

    public AddDataStoreLayerWizard(WorkbenchContext workbenchContext) {
        super(I18N.getInstance().get(KEY), IconLoader.icon("database_add.png"), AddDataStoreLayerWizardPanel.class.getName());
        this.workbenchContext = workbenchContext;
        this.dataStoreWizardPanel = new AddDataStoreLayerWizardPanel(workbenchContext);
        this.addPanel(this.dataStoreWizardPanel);
        this.chooseProjectPanel = new ChooseProjectPanel(workbenchContext, this.dataStoreWizardPanel.getID());
        this.addPanel(this.chooseProjectPanel);
    }

    @Override
    public String getFirstId() {
        String firstId = super.getFirstId();
        if (!this.chooseProjectPanel.hasActiveTaskFrame() && this.chooseProjectPanel.hasTaskFrames()) {
            this.chooseProjectPanel.setNextID(firstId);
            return this.chooseProjectPanel.getID();
        }
        return firstId;
    }

    @Override
    public void run(WizardDialog dialog, TaskMonitor monitor) throws Exception {
        this.chooseProjectPanel.activateSelectedProject();
        try {
            AddDatastoreLayerPanel dataStorePanel = this.dataStoreWizardPanel.getDataStorePanel();
            if (dataStorePanel.validateInput() != null) {
                throw new Exception(dataStorePanel.validateInput());
            }
            final List<Layer> layers = this.createLayers(dataStorePanel, monitor);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (Layer layer : layers) {
                        Collection<Category> selectedCategories = AddDataStoreLayerWizard.this.workbenchContext.getLayerableNamePanel().getSelectedCategories();
                        LayerManager layerManager = AddDataStoreLayerWizard.this.workbenchContext.getLayerManager();
                        String categoryName = StandardCategoryNames.WORKING;
                        if (!selectedCategories.isEmpty()) {
                            categoryName = selectedCategories.iterator().next().getName();
                        }
                        try {
                            AddDataStoreLayerWizard.this.workbenchContext.getLayerViewPanel().getViewport().update();
                        }
                        catch (Exception e) {
                            Logger.warn("Exception thrown by AddDataStoreLayerWizard during LayerViewPanel update", e);
                        }
                        try {
                            layerManager.addLayerable(categoryName, layer);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            Logger.warn("Exception thrown by AddDataStoreLayerWizard while adding the layer to the LayerManager", e);
                        }
                    }
                }
            });
            this.workbenchContext.getLayerViewPanel().getViewport().update();
        }
        catch (Exception e) {
            monitor.report(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Layer createLayer(DataStoreLayer dsLayer, ConnectionDescriptor connectionDescriptor, TaskMonitor monitor) throws Exception {
        LayerManager layerManager = this.workbenchContext.getLayerManager();
        Color fillColor = layerManager.generateLayerFillColor();
        FeatureCollection featureCollection = AddNewLayerPlugIn.createBlankFeatureCollection();
        SpatialDSLayer layer = new SpatialDSLayer(dsLayer.getFullName(), fillColor, featureCollection, layerManager, this.workbenchContext);
        String geometryAttributeName = dsLayer.getGeoCol().getName();
        String whereClause = dsLayer.getWhereClause();
        int limit = dsLayer.getLimit();
        boolean caching = dsLayer.isCaching();
        DataStoreDataSource ds = new DataStoreDataSource(dsLayer.getFullName(), geometryAttributeName, whereClause, limit, connectionDescriptor, caching, this.workbenchContext);
        DataSourceQuery dsq = new DataSourceQuery(ds, null, dsLayer.getFullName());
        boolean isFiringEvents = layerManager.isFiringEvents();
        layerManager.setFiringEvents(false);
        layer.setDataSourceQuery(dsq);
        CoordinateSystemRegistry crsRegistry = CoordinateSystemRegistry.instance(this.workbenchContext.getBlackboard());
        try {
            AddDataStoreLayerWizard.load(layer, crsRegistry, monitor);
            SRIDStyle sridStyle = new SRIDStyle();
            sridStyle.setSRID(dsLayer.getGeoCol().getSRID());
            layer.addStyle(sridStyle);
            layerManager.setFiringEvents(true);
        }
        finally {
            layerManager.setFiringEvents(isFiringEvents);
        }
        return layer;
    }

    private List<Layer> createLayers(AddDatastoreLayerPanel panel, TaskMonitor monitor) throws Exception {
        ArrayList<Layer> ret = new ArrayList<Layer>();
        List<DataStoreLayer> dsLayers = panel.getDatasetLayers();
        ConnectionDescriptor connectionDescriptor = panel.getConnectionDescriptor();
        for (DataStoreLayer dsl : dsLayers) {
            ret.add(this.createLayer(dsl, connectionDescriptor, monitor));
        }
        return ret;
    }

    public static void load(Layer layer, CoordinateSystemRegistry registry, TaskMonitor monitor) throws Exception {
        layer.setFeatureCollection(AddDataStoreLayerWizard.executeQuery(layer.getDataSourceQuery().getQuery(), layer.getDataSourceQuery().getDataSource(), registry, monitor));
        layer.setFeatureCollectionModified(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FeatureCollection executeQuery(String query, DataSource dataSource, CoordinateSystemRegistry registry, TaskMonitor monitor) throws Exception {
        try (Connection connection = dataSource.getConnection();){
            FeatureCollection featureCollection = dataSource.installCoordinateSystem(connection.executeQuery(query, monitor), registry);
            return featureCollection;
        }
    }
}

