/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.io.file;

import com.vividsolutions.jump.workbench.model.Prioritized;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openjump.core.ui.io.file.FileLayerLoader;
import org.openjump.core.ui.io.file.Option;

public abstract class AbstractFileLayerLoader
implements FileLayerLoader {
    private String description;
    boolean unsorted = true;
    private List<String> extensions = new ArrayList<String>();
    private List<Option> optionMetadata = new ArrayList<Option>();
    public static final Comparator PRIO_COMPARATOR = new Comparator<FileLayerLoader>(){

        @Override
        public int compare(FileLayerLoader f1, FileLayerLoader f2) {
            int result = Prioritized.COMPARATOR.compare(f1, f2);
            if (result != 0) {
                return result;
            }
            return f1.getDescription().compareToIgnoreCase(f2.getDescription());
        }
    };

    public AbstractFileLayerLoader() {
    }

    public AbstractFileLayerLoader(String description, List<String> extensions) {
        this.description = description;
        this.addFileExtensions(extensions);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Collection<String> getFileExtensions() {
        if (this.unsorted) {
            Collections.sort(this.extensions);
            this.unsorted = false;
        }
        return new ArrayList<String>(this.extensions);
    }

    public boolean addFileExtensions(List<String> newexts) {
        this.unsorted = true;
        return this.extensions.addAll(newexts);
    }

    public void addOption(String name, String type, boolean required) {
        this.optionMetadata.add(new Option(name, type, required));
    }

    public void addOption(String name, String type, Object defaultValue, boolean required) {
        this.optionMetadata.add(new Option(name, type, defaultValue, required));
    }

    public boolean removeOption(String name, String type, boolean required) {
        return this.optionMetadata.remove(new Option(name, type, required));
    }

    public boolean removeOption(String name, String type, Object defaultValue, boolean required) {
        return this.optionMetadata.remove(new Option(name, type, defaultValue, required));
    }

    @Override
    public List<Option> getOptionMetadata() {
        return this.optionMetadata;
    }

    public String toString() {
        return this.description;
    }
}

