/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage.styler.ui;

import com.vividsolutions.jump.workbench.Logger;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.openjump.core.rasterimage.styler.ColorMapEntry;
import org.openjump.core.rasterimage.styler.ColorUtils;
import org.openjump.core.rasterimage.styler.ui.ColorEditor;
import org.openjump.core.rasterimage.styler.ui.ColorsTablePanel;
import org.openjump.core.rasterimage.styler.ui.GUIUtils;

public class GradientTablePanel
extends ColorsTablePanel
implements TableModelListener {
    private final JPanel panel;
    private final JTable table;
    private boolean updateGradient = true;

    public GradientTablePanel(Component parent, ColorsTablePanel.TableType tableType, ColorMapEntry[] colorMapEntries, Double noDataValue, boolean integerValues, JPanel panel) {
        super(parent, tableType, colorMapEntries, noDataValue, integerValues);
        this.panel = panel;
        this.table = this.getTable();
        this.table.setDefaultEditor(Color.class, new ColorEditor(parent));
        this.table.getModel().addTableModelListener(this);
    }

    @Override
    public void addRows() {
        this.updateGradient = false;
        try {
            int[] selRows = this.table.getSelectedRows();
            if (selRows.length > 0) {
                Double value;
                Color endColor;
                Color startColor;
                if (selRows[0] == 0) {
                    startColor = (Color)this.table.getValueAt(selRows[0], 1);
                    endColor = (Color)this.table.getValueAt(selRows[0], 1);
                    value = (Double)this.table.getValueAt(selRows[0], 0);
                    if (value != 0.0) {
                        value = GUIUtils.round((Double)this.table.getValueAt(selRows[0], 0) / 2.0, 2);
                    }
                } else {
                    startColor = (Color)this.table.getValueAt(selRows[0] - 1, 1);
                    endColor = (Color)this.table.getValueAt(selRows[0], 1);
                    value = GUIUtils.round(((Double)this.table.getValueAt(selRows[0] - 1, 0) + (Double)this.table.getValueAt(selRows[0], 0)) / 2.0, 2);
                }
                ColorUtils colorUtils = new ColorUtils();
                Color newColor = colorUtils.interpolateColor(startColor, endColor, 0.5);
                ((DefaultTableModel)this.table.getModel()).insertRow(selRows[0], new Object[]{value, newColor});
            } else {
                Color startColor = (Color)this.table.getValueAt(this.table.getRowCount() - 1, 1);
                Color endColor = (Color)this.table.getValueAt(this.table.getRowCount() - 1, 1);
                ColorUtils colorUtils = new ColorUtils();
                Color newColor = colorUtils.interpolateColor(startColor, endColor, 0.5);
                Double value = (Double)this.table.getValueAt(this.table.getRowCount() - 1, 0);
                ((DefaultTableModel)this.table.getModel()).addRow(new Object[]{value, newColor});
                int lastRow = this.table.getRowCount() - 1;
                this.table.getSelectionModel().setSelectionInterval(lastRow, lastRow);
                this.table.scrollRectToVisible(this.table.getCellRect(lastRow, 1, true));
            }
        }
        catch (Exception ex) {
            this.updateGradient = true;
            Logger.error(ex);
        }
        this.updateGradient = true;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int rows = this.table.getRowCount();
        if (this.updateGradient && rows > 0) {
            Color[] colors = new Color[rows];
            Double[] values = new Double[rows];
            for (int n = 0; n < rows; ++n) {
                colors[n] = (Color)this.table.getValueAt(n, 1);
                values[n] = (Double)this.table.getValueAt(n, 0);
            }
            double tempValue = values[0];
            for (int v = 1; v < values.length; ++v) {
                if (values[v] <= tempValue || values[v] > 1.0) {
                    return;
                }
                tempValue = values[v];
            }
            if (values.length < 2) {
                return;
            }
            ArrayList<ColorMapEntry> cme_list = new ArrayList<ColorMapEntry>();
            for (int n = 0; n < rows; ++n) {
                if (values[n] == null) continue;
                cme_list.add(new ColorMapEntry(values[n], colors[n]));
            }
            ColorMapEntry[] cme = cme_list.toArray(new ColorMapEntry[cme_list.size()]);
            GUIUtils gui = new GUIUtils();
            gui.setGradientPanel(this.panel, cme);
            this.updateUI();
        }
    }
}

